package ch.viseon.openOrca.client.impl

import ch.viseon.openOrca.share.JsonArray
import ch.viseon.openOrca.share.JsonFactory
import ch.viseon.openOrca.share.JsonObj
import kotlin.js.Json
import kotlin.js.json

class JsonFactoryJs: JsonFactory {

  override fun newJson(block: JsonObj.() -> Unit): JsonObj {
    return JsonObjJs(block)
  }

  override fun parse(content: String): JsonArray<JsonObj> {
    return JsonArray(JSON.parse<Array<Json>>(content).map(::JsonObjJs))
  }
}

class JsonObjJs(val json: Json = json()) : JsonObj {

  constructor(block: JsonObj.() -> Unit) : this() {
    block()
  }

  override fun boolean(key: String): Boolean {
    return json[key] as Boolean
  }

  override fun <T> pArray(key: String): JsonArray<T> {
    val array = (json[key] as Array<T>)
    return JsonArray(array.asIterable())
  }

  override fun oArray(key: String): JsonArray<JsonObj> {
    val values: MutableList<JsonObj> = (json[key] as Array<Json>).map { JsonObjJs(it) }.toMutableList()
    return JsonArray(values)
  }

  override fun string(key: String): String {
    return json[key] as String
  }

  override fun getObject(key: String): JsonObj {
    @Suppress("UNCHECKED_CAST_TO_NATIVE_INTERFACE")
    return JsonObjJs(json[key] as Json)
  }

  override fun set(key: String, value: String) {
    json[key] = value
  }

  override fun set(key: String, value: Boolean) {
    json[key] = value
  }

  override operator fun set(key: String, value: JsonObj) {
    json[key] = (value as JsonObjJs).json
  }

  override fun set(key: String, value: JsonArray<JsonObj>) {
    json[key] = value.map { (it as JsonObjJs).json }
  }

  override fun set(key: String, value: Iterable<String>) {
    json[key] = value
  }

  override fun set(key: String, block: JsonObj.() -> Unit) {
    val subJsonObj = JsonObjJs()
    subJsonObj.block()
    json[key] = subJsonObj.json
  }

  override fun toJsonString(): String {
    return JSON.stringify(json)
  }


}

