/*
 * Copyright 2017 viseon gmbh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import * as Rx from "rxjs";
export as namespace openOrca

export namespace ch {
    export namespace viseon {
        export namespace openOrca {
            export namespace client {

                import JsonCodec = ch.viseon.openOrca.share.JsonCodec;
                import JsonFactory = ch.viseon.openOrca.share.JsonFactory;
                import ModelId = ch.viseon.openOrca.share.ModelId;
                import ModelType = ch.viseon.openOrca.share.ModelType;
                import ModelStoreChangeEvent = ch.viseon.openOrca.share.ModelStoreChangeEvent;
                import PropertyChangeEvent = ch.viseon.openOrca.share.PropertyChangeEvent;
                import ValueChangeEvent = ch.viseon.openOrca.share.ValueChangeEvent;
                import ActionEvent = ch.viseon.openOrca.share.ActionEvent;
                import PresentationModel = ch.viseon.openOrca.share.PresentationModel;
                import CommandData = ch.viseon.openOrca.share.CommandData;
                import PropertyName = ch.viseon.openOrca.share.PropertyName;

                export class ClientCommandListExecutor {
                    constructor();
                }

                export interface ClientOrca {

                    observeModelStore(): Rx.Observable<ModelStoreChangeEvent>;

                    observeModelById(modelId: ModelId): Rx.Observable<PropertyChangeEvent>;

                    observeModelByType(modelType: ModelType): Rx.Observable<PropertyChangeEvent>;

                    observeProperty(modelId: ModelId, propertyName: PropertyName): Rx.Observable<ValueChangeEvent>;

                    getModelById(modelId: ModelId): PresentationModel;

                    getModelByType(modelType: ModelType): Array<PresentationModel>;

                    registerNamedCommand(): Rx.Observable<ActionEvent>;

                    //Process and send a series of commands.
                    executeCommands(commands: Array<CommandData>);

                    containsModelById(): boolean

                    containsModelByType(): boolean

                    getAllModels(): Array<PresentationModel>
                }

                export class ClientOrcaImpl implements ClientOrca {
                    constructor(commandListExecutor: ClientCommandListExecutor, transmitter: XMLHttpRequestTransmitter)

                    observeModelStore(): Rx.Observable<ModelStoreChangeEvent>;

                    observeModelById(modelId: ch.viseon.openOrca.share.ModelId): Rx.Observable<PropertyChangeEvent>;

                    observeModelByType(modelType: ch.viseon.openOrca.share.ModelType): Rx.Observable<PropertyChangeEvent>;

                    observeProperty(modelId: ModelId, propertyName: PropertyName): Rx.Observable<ValueChangeEvent>;

                    getModelById(modelId: ch.viseon.openOrca.share.ModelId): PresentationModel;

                    getModelByType(modelType: ch.viseon.openOrca.share.ModelType): Array<PresentationModel>;

                    registerNamedCommand(): Rx.Observable<ActionEvent>;

                    executeCommands(commands: Array<any>);

                    containsModelById(): boolean;

                    containsModelByType(): boolean;

                    getAllModels(): Array<ch.viseon.openOrca.share.PresentationModel>;
                }

                export class XMLHttpRequestTransmitter {
                    constructor(url: string, codec: JsonCodec)
                }


                export class JsonFactoryJs extends JsonFactory {
                    constructor();
                }

            }

            export namespace share {

                export class Source {
                    static readonly REQUEST: Source;
                    static readonly RESPONSE: Source;

                    isRequest(): boolean;

                    isResponse(): boolean;
                }

                export class PresentationModelBuilder {
                    constructor(modelId: ModelId, modelType: ModelType, block)

                    build_9e13n0$(source: Source)
                }

                export interface JsonFactory {

                }

                export class JsonCodec {
                    constructor(jsonFactory: JsonFactory)
                }

                export class PresentationModel {
                    id: ModelId;
                    type: ModelType;

                    getProperties(): Array<Property>
                    get_lqljjj$(propertyName: PropertyName): Property
                }

                export class ModelId {
                    constructor(stringId: string)

                    stringId: string;
                }

                export class ModelType {
                    constructor(stringId: string)

                    stringId: string;
                }

                export class PropertyName {
                    constructor(name: string)

                    name: string;
                }

                export class Source {
                    name: string;
                }

                export class Property {
                    constructor()

                    name: PropertyName;

                    getValues(): Array<PropertyValue>
                    get_61zpoe$(valueType: string): PropertyValue
                }

                export interface PropertyValue {
                }

                export class LabelPropertyValue implements PropertyValue {
                    constructor(value: string)

                    value: string
                }

                export interface ValuePropertyValue {
                    value: any
                }

                export class StringValue implements ValuePropertyValue {
                    constructor(value: string)

                    value: string
                }

                export class IntegerValue implements ValuePropertyValue {
                    constructor(value: number)

                    value: number
                }

                export class BooleanValue implements ValuePropertyValue {
                    constructor(value: boolean)

                    value: boolean
                }

                export interface CommandData {
                    source: Source
                }

                export class ChangeValueCommandData implements CommandData {
                    constructor(source: Source, modelId: ModelId, propertyName: PropertyName, value: PropertyValue);

                    source: Source;
                    modelId: ModelId;
                    propertyName: PropertyName;
                    value: PropertyValue;
                }

                export class CreateModelCommandData implements CommandData {
                    constrcutor(source: Source, modelId: ModelId, modelType: ModelType, properties: Array<Property>)

                    source: Source;
                    modelId: ModelId;
                    modelType: ModelType;
                    properties: Array<Property>;
                }

                export class RemoveModelCommandData implements CommandData {
                    constructor(source: Source, modelId: ModelId)

                    source: Source;
                    modelId: ModelId;
                }

                export class ActionCommandData implements CommandData {
                    constructor(source: Source,actionName: string, modelIds: Array<ModelId>);

                    source: Source;
                    actionName: String;
                    modelIds: Array<ModelId>;
                }

                /**
                 * Removes all models of a certain type.
                 */
                export class RemoveModelByTypeCommandData implements CommandData {
                    constructor(source: Source, modelType: ModelType)

                    source: Source;
                    modelType: ModelType;
                }

                /**
                 * Copy one model onto another.
                 */
                export class SyncModelCommandData implements CommandData {
                    constructor(source: Source, sourceModel: ModelId, destinationModel: ModelId)

                    source: Source;
                    sourceModel: ModelId;
                    destinationModel: ModelId;
                }

                export interface Event {
                    source: Source
                }

                export class ModelStoreChangeEvent implements Event {
                    source: Source;
                    modelId: ModelId;
                    modelType: ModelType;
                    eventType: ModelStoreChangeEventType;
                }

                export class ModelStoreChangeEventType {
                    isAdd(): boolean

                    isRemove(): boolean
                }

                export class PropertyChangeEvent implements Event {
                    source: Source;
                    modelId: ModelId;
                    modelType: ModelType;
                    valueChangeEvent: ValueChangeEvent
                }

                export class ValueChangeEvent implements Event {
                    source: Source;
                    property: PropertyName;
                    oldValue: PropertyValue;
                    newValue: PropertyValue;

                    isValueChange(): boolean;
                    isLabelChange(): boolean;
                    isToolTipChange(): boolean;
                }

                export class ActionEvent implements Event {
                    source: Source;
                    actionName: String;
                    pmIds: Array<ModelId>
                }
            } //End share
        }
    }
}



