(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'rxjs/Rx', 'kodando-rxjs'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('rxjs/Rx'), require('kodando-rxjs'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'openorca-js-client'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'openorca-js-client'.");
    }
    if (typeof Rx === 'undefined') {
      throw new Error("Error loading module 'openorca-js-client'. Its dependency 'rxjs/Rx' was not found. Please, check whether 'rxjs/Rx' is loaded prior to 'openorca-js-client'.");
    }
    if (typeof this['kodando-rxjs'] === 'undefined') {
      throw new Error("Error loading module 'openorca-js-client'. Its dependency 'kodando-rxjs' was not found. Please, check whether 'kodando-rxjs' is loaded prior to 'openorca-js-client'.");
    }
    root['openorca-js-client'] = factory(typeof this['openorca-js-client'] === 'undefined' ? {} : this['openorca-js-client'], kotlin, Rx, this['kodando-rxjs']);
  }
}(this, function (_, Kotlin, $module$rxjs_Rx, $module$kodando_rxjs) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Enum = Kotlin.kotlin.Enum;
  var Rx$Observable$Companion = $module$rxjs_Rx.Observable;
  var Rx$Subject = $module$rxjs_Rx.Subject;
  var RuntimeException = Kotlin.kotlin.RuntimeException;
  var Exception = Kotlin.kotlin.Exception;
  var toInt = Kotlin.kotlin.text.toInt_pdl1vz$;
  var toLong = Kotlin.kotlin.text.toLong_pdl1vz$;
  var toDouble = Kotlin.kotlin.text.toDouble_pdl1vz$;
  var asIterable = Kotlin.kotlin.collections.asIterable_us0mfu$;
  var toMutableList = Kotlin.kotlin.collections.toMutableList_4c7yge$;
  var json = Kotlin.kotlin.js.json_pyyo18$;
  var Error_0 = Kotlin.kotlin.Error;
  var Rx$Observable = $module$rxjs_Rx.Observable;
  var IllegalArgumentException = Kotlin.kotlin.IllegalArgumentException;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var mapOf = Kotlin.kotlin.collections.mapOf_qfcya0$;
  var asSequence = Kotlin.kotlin.collections.asSequence_7wnvza$;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  var filter = Kotlin.kotlin.sequences.filter_euau3h$;
  var map = Kotlin.kotlin.sequences.map_z5avom$;
  var flatMap = Kotlin.kotlin.sequences.flatMap_49vfel$;
  var toList = Kotlin.kotlin.sequences.toList_veqyi0$;
  var Iterable = Kotlin.kotlin.collections.Iterable;
  var joinToString = Kotlin.kotlin.sequences.joinToString_853xkz$;
  var Pair = Kotlin.kotlin.Pair;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var HashMap_init = Kotlin.kotlin.collections.HashMap_init_q3lmfv$;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  RequestEvent.prototype = Object.create(Enum.prototype);
  RequestEvent.prototype.constructor = RequestEvent;
  ApplyPolicy.prototype = Object.create(Enum.prototype);
  ApplyPolicy.prototype.constructor = ApplyPolicy;
  ModelStoreChangeEventType.prototype = Object.create(Enum.prototype);
  ModelStoreChangeEventType.prototype.constructor = ModelStoreChangeEventType;
  Source.prototype = Object.create(Enum.prototype);
  Source.prototype.constructor = Source;
  function ClientOrca() {
  }
  ClientOrca.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'ClientOrca',
    interfaces: []
  };
  function RequestEvent(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function RequestEvent_initFields() {
    RequestEvent_initFields = function () {
    };
    RequestEvent$START_instance = new RequestEvent('START', 0);
    RequestEvent$END_instance = new RequestEvent('END', 1);
  }
  var RequestEvent$START_instance;
  function RequestEvent$START_getInstance() {
    RequestEvent_initFields();
    return RequestEvent$START_instance;
  }
  var RequestEvent$END_instance;
  function RequestEvent$END_getInstance() {
    RequestEvent_initFields();
    return RequestEvent$END_instance;
  }
  RequestEvent.prototype.isStart = function () {
    return this === RequestEvent$START_getInstance();
  };
  RequestEvent.prototype.isEnd = function () {
    return this === RequestEvent$END_getInstance();
  };
  RequestEvent.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'RequestEvent',
    interfaces: [Enum]
  };
  function RequestEvent$values() {
    return [RequestEvent$START_getInstance(), RequestEvent$END_getInstance()];
  }
  RequestEvent.values = RequestEvent$values;
  function RequestEvent$valueOf(name) {
    switch (name) {
      case 'START':
        return RequestEvent$START_getInstance();
      case 'END':
        return RequestEvent$END_getInstance();
      default:Kotlin.throwISE('No enum constant ch.viseon.openOrca.client.RequestEvent.' + name);
    }
  }
  RequestEvent.valueOf_61zpoe$ = RequestEvent$valueOf;
  function ClientOrcaImpl(commandListExecutor, transmitter) {
    this.commandListExecutor = commandListExecutor;
    this.transmitter = transmitter;
    this.clientModelStore = new DefaultPresentationModelStore();
    this.eventSubject_0 = new Rx$Subject();
    this.requestTrackerSubject_0 = new Rx$Subject();
  }
  function ClientOrcaImpl$executeCommands$lambda(closure$eventsFromInputCommands, closure$commandsToSend) {
    return function (it) {
      if (it.applied) {
        closure$eventsFromInputCommands.add_11rb$(it.events);
      }
      if (it.applied || it.commandData.policy.isForceSend()) {
        closure$commandsToSend.add_11rb$(it.commandData);
      }
    };
  }
  function ClientOrcaImpl$executeCommands$lambda_0(it) {
    return it.applied;
  }
  function ClientOrcaImpl$executeCommands$lambda_1(it) {
    return it.events;
  }
  function ClientOrcaImpl$executeCommands$lambda_2(this$ClientOrcaImpl) {
    return function (events) {
      var tmp$;
      tmp$ = events.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        this$ClientOrcaImpl.eventSubject_0.next(element);
      }
    };
  }
  function ClientOrcaImpl$executeCommands$lambda_3(it) {
  }
  function ClientOrcaImpl$executeCommands$lambda_4(this$ClientOrcaImpl) {
    return function () {
      this$ClientOrcaImpl.requestTrackerSubject_0.next(RequestEvent$END_getInstance());
    };
  }
  ClientOrcaImpl.prototype.executeCommands = function (commands) {
    var appliedCommands = this.commandListExecutor.execute_nhty4f$(this.clientModelStore, Rx$Observable$Companion.from(commands));
    var commandsToSend = Kotlin.kotlin.collections.ArrayList_init_ww73n8$();
    var eventsFromInputCommands = Kotlin.kotlin.collections.ArrayList_init_ww73n8$();
    appliedCommands.subscribe(ClientOrcaImpl$executeCommands$lambda(eventsFromInputCommands, commandsToSend));
    var responseCommands = this.transmitter.sendCommands_6il2lv$(commandsToSend);
    var responseEvents = this.commandListExecutor.execute_nhty4f$(this.clientModelStore, responseCommands);
    var finalObservable = Rx$Observable$Companion.merge(Rx$Observable$Companion.from(Kotlin.kotlin.collections.copyToArray(eventsFromInputCommands)), responseEvents.filter(ClientOrcaImpl$executeCommands$lambda_0).map(ClientOrcaImpl$executeCommands$lambda_1));
    this.requestTrackerSubject_0.next(RequestEvent$START_getInstance());
    finalObservable.subscribe(ClientOrcaImpl$executeCommands$lambda_2(this), ClientOrcaImpl$executeCommands$lambda_3, ClientOrcaImpl$executeCommands$lambda_4(this));
  };
  function ClientOrcaImpl$observeModelStore$lambda(it) {
    return Kotlin.isType(it, ModelStoreChangeEvent);
  }
  function ClientOrcaImpl$observeModelStore$lambda_0(it) {
    var tmp$;
    return Kotlin.isType(tmp$ = it, ModelStoreChangeEvent) ? tmp$ : Kotlin.throwCCE();
  }
  ClientOrcaImpl.prototype.observeModelStore = function () {
    return this.eventSubject_0.filter(ClientOrcaImpl$observeModelStore$lambda).map(ClientOrcaImpl$observeModelStore$lambda_0);
  };
  function ClientOrcaImpl$observeModel$lambda(closure$modelId) {
    return function (it) {
      var tmp$;
      return (tmp$ = it.modelId) != null ? tmp$.equals(closure$modelId) : null;
    };
  }
  ClientOrcaImpl.prototype.observeModelById = function (modelId) {
    return this.eventStreamAsPropertyChangeEvent_0().filter(ClientOrcaImpl$observeModel$lambda(modelId));
  };
  function ClientOrcaImpl$observeModel$lambda_0(closure$modelType) {
    return function (it) {
      var tmp$;
      return (tmp$ = it.modelType) != null ? tmp$.equals(closure$modelType) : null;
    };
  }
  ClientOrcaImpl.prototype.observeModelByType = function (modelType) {
    return this.eventStreamAsPropertyChangeEvent_0().filter(ClientOrcaImpl$observeModel$lambda_0(modelType));
  };
  function ClientOrcaImpl$observeProperty$lambda(closure$modelId) {
    return function (it) {
      var tmp$;
      return (tmp$ = it.modelId) != null ? tmp$.equals(closure$modelId) : null;
    };
  }
  function ClientOrcaImpl$observeProperty$lambda_0(closure$propertyName) {
    return function (it) {
      var tmp$;
      return (tmp$ = it.valueChangeEvent.property) != null ? tmp$.equals(closure$propertyName) : null;
    };
  }
  function ClientOrcaImpl$observeProperty$lambda_1(it) {
    return it.valueChangeEvent;
  }
  ClientOrcaImpl.prototype.observeProperty = function (modelId, propertyName) {
    return this.eventStreamAsPropertyChangeEvent_0().filter(ClientOrcaImpl$observeProperty$lambda(modelId)).filter(ClientOrcaImpl$observeProperty$lambda_0(propertyName)).map(ClientOrcaImpl$observeProperty$lambda_1);
  };
  function ClientOrcaImpl$eventStreamAsPropertyChangeEvent$lambda(it) {
    return Kotlin.isType(it, PropertyChangeEvent);
  }
  function ClientOrcaImpl$eventStreamAsPropertyChangeEvent$lambda_0(it) {
    var tmp$;
    return Kotlin.isType(tmp$ = it, PropertyChangeEvent) ? tmp$ : Kotlin.throwCCE();
  }
  ClientOrcaImpl.prototype.eventStreamAsPropertyChangeEvent_0 = function () {
    return this.eventSubject_0.filter(ClientOrcaImpl$eventStreamAsPropertyChangeEvent$lambda).map(ClientOrcaImpl$eventStreamAsPropertyChangeEvent$lambda_0);
  };
  function ClientOrcaImpl$registerNamedCommand$lambda(it) {
    return Kotlin.isType(it, ActionEvent);
  }
  function ClientOrcaImpl$registerNamedCommand$lambda_0(it) {
    var tmp$;
    return Kotlin.isType(tmp$ = it, ActionEvent) ? tmp$ : Kotlin.throwCCE();
  }
  function ClientOrcaImpl$registerNamedCommand$lambda_1(closure$actionName) {
    return function (it) {
      return Kotlin.equals(it.actionName, closure$actionName);
    };
  }
  ClientOrcaImpl.prototype.registerNamedCommand = function (actionName) {
    return this.eventSubject_0.filter(ClientOrcaImpl$registerNamedCommand$lambda).map(ClientOrcaImpl$registerNamedCommand$lambda_0).filter(ClientOrcaImpl$registerNamedCommand$lambda_1(actionName));
  };
  ClientOrcaImpl.prototype.getModelByType = function (modelType) {
    var $receiver = this.clientModelStore.get_4tsc7m$(modelType);
    return Kotlin.kotlin.collections.copyToArray($receiver);
  };
  ClientOrcaImpl.prototype.getModelById = function (modelId) {
    return this.clientModelStore.get_accdal$(modelId);
  };
  ClientOrcaImpl.prototype.containsModelById = function (modelId) {
    return this.clientModelStore.contains_accdal$(modelId);
  };
  ClientOrcaImpl.prototype.containsModelByType = function (modelId) {
    return this.clientModelStore.contains_4tsc7m$(modelId);
  };
  ClientOrcaImpl.prototype.getAllModels = function () {
    var $receiver = this.clientModelStore.getAllModels();
    return Kotlin.kotlin.collections.copyToArray($receiver);
  };
  ClientOrcaImpl.prototype.observeRequest = function () {
    return this.requestTrackerSubject_0;
  };
  ClientOrcaImpl.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ClientOrcaImpl',
    interfaces: [ClientOrca]
  };
  function CommandListExecutor() {
  }
  CommandListExecutor.prototype.execute_sy5qnb$ = function (modelStore, commandData) {
    return this.execute_nhty4f$(modelStore, just(commandData));
  };
  CommandListExecutor.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'CommandListExecutor',
    interfaces: []
  };
  function ClientCommandListExecutor() {
  }
  function ClientCommandListExecutor$execute$lambda(closure$modelStore, this$ClientCommandListExecutor) {
    return function (it) {
      return this$ClientCommandListExecutor.applyCommand_0(closure$modelStore, it);
    };
  }
  ClientCommandListExecutor.prototype.execute_nhty4f$ = function (modelStore, commandData) {
    return commandData.flatMap(ClientCommandListExecutor$execute$lambda(modelStore, this));
  };
  ClientCommandListExecutor.prototype.applyCommand_0 = function (modelStore, it) {
    try {
      return Rx$Observable$Companion.of(CommandApplier_getInstance().apply_mq2q7b$(Source$REQUEST_getInstance(), modelStore, it));
    }
     catch (e) {
      if (Kotlin.isType(e, Exception)) {
        throw new RuntimeException('Error during application of command ' + it + '.' + '\n' + ' Original error: ' + e);
      }
       else
        throw e;
    }
  };
  ClientCommandListExecutor.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ClientCommandListExecutor',
    interfaces: [CommandListExecutor]
  };
  function JsonFactoryJs() {
  }
  JsonFactoryJs.prototype.newJson_1j20nt$ = function (block) {
    return JsonObjJs_init(block);
  };
  JsonFactoryJs.prototype.parse_61zpoe$ = function (content) {
    var $receiver = JSON.parse(content);
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$($receiver.length);
    var tmp$;
    for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
      var item = $receiver[tmp$];
      destination.add_11rb$(new JsonObjJs(item));
    }
    return new JsonArray(destination);
  };
  JsonFactoryJs.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'JsonFactoryJs',
    interfaces: [JsonFactory]
  };
  function JsonObjJs(json_0) {
    if (json_0 === void 0)
      json_0 = json([]);
    this.json = json_0;
  }
  JsonObjJs.prototype.integer_61zpoe$ = function (key) {
    return toInt(Kotlin.toString(this.json[key]));
  };
  JsonObjJs.prototype.long_61zpoe$ = function (key) {
    return toLong(Kotlin.toString(this.json[key]));
  };
  JsonObjJs.prototype.float_61zpoe$ = function (key) {
    var $receiver = Kotlin.toString(this.json[key]);
    return Kotlin.kotlin.text.toDouble_pdl1vz$($receiver);
  };
  JsonObjJs.prototype.double_61zpoe$ = function (key) {
    return toDouble(Kotlin.toString(this.json[key]));
  };
  JsonObjJs.prototype.boolean_61zpoe$ = function (key) {
    return Kotlin.equals(this.json[key], 'true');
  };
  JsonObjJs.prototype.pArray_ytbaoo$ = function (key) {
    var tmp$;
    var array = Array.isArray(tmp$ = this.json[key]) ? tmp$ : Kotlin.throwCCE();
    return new JsonArray(asIterable(array));
  };
  JsonObjJs.prototype.oArray_61zpoe$ = function (key) {
    var tmp$;
    var $receiver = Array.isArray(tmp$ = this.json[key]) ? tmp$ : Kotlin.throwCCE();
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$($receiver.length);
    var tmp$_0;
    for (tmp$_0 = 0; tmp$_0 !== $receiver.length; ++tmp$_0) {
      var item = $receiver[tmp$_0];
      destination.add_11rb$(new JsonObjJs(item));
    }
    var values = toMutableList(destination);
    return new JsonArray(values);
  };
  JsonObjJs.prototype.string_61zpoe$ = function (key) {
    var tmp$;
    return typeof (tmp$ = this.json[key]) === 'string' ? tmp$ : Kotlin.throwCCE();
  };
  JsonObjJs.prototype.optionalString_61zpoe$ = function (key) {
    var tmp$;
    return (tmp$ = this.json[key]) == null || typeof tmp$ === 'string' ? tmp$ : Kotlin.throwCCE();
  };
  JsonObjJs.prototype.optionalBoolean_61zpoe$ = function (key) {
    var tmp$;
    return (tmp$ = this.json[key]) == null || typeof tmp$ === 'boolean' ? tmp$ : Kotlin.throwCCE();
  };
  JsonObjJs.prototype.getObject_61zpoe$ = function (key) {
    var tmp$;
    return new JsonObjJs(Kotlin.isType(tmp$ = this.json[key], Object) ? tmp$ : Kotlin.throwCCE());
  };
  JsonObjJs.prototype.set_puj7f4$ = function (key, value) {
    this.json[key] = value;
  };
  JsonObjJs.prototype.set_ivxn3r$ = function (key, value) {
    this.json[key] = value;
  };
  JsonObjJs.prototype.set_6xncmk$ = function (key, value) {
    var tmp$;
    this.json[key] = (Kotlin.isType(tmp$ = value, JsonObjJs) ? tmp$ : Kotlin.throwCCE()).json;
  };
  JsonObjJs.prototype.set_jqxvxq$ = function (key, value) {
    var tmp$ = this.json;
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$(value, 10));
    var tmp$_0;
    tmp$_0 = value.iterator();
    while (tmp$_0.hasNext()) {
      var item = tmp$_0.next();
      var tmp$_1;
      destination.add_11rb$((Kotlin.isType(tmp$_1 = item, JsonObjJs) ? tmp$_1 : Kotlin.throwCCE()).json);
    }
    tmp$[key] = destination;
  };
  JsonObjJs.prototype.set_poujtz$ = function (key, value) {
    this.json[key] = value;
  };
  JsonObjJs.prototype.set_8wy9ij$ = function (key, block) {
    var subJsonObj = new JsonObjJs();
    block(subJsonObj);
    this.json[key] = subJsonObj.json;
  };
  JsonObjJs.prototype.toJsonString = function () {
    return JSON.stringify(this.json);
  };
  JsonObjJs.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'JsonObjJs',
    interfaces: [JsonObj]
  };
  function JsonObjJs_init(block, $this) {
    $this = $this || Object.create(JsonObjJs.prototype);
    JsonObjJs.call($this);
    block($this);
    return $this;
  }
  function just(t) {
    return Rx$Observable$Companion.of(t);
  }
  function Transmitter() {
  }
  Transmitter.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'Transmitter',
    interfaces: []
  };
  function XMLHttpRequestTransmitter(url, codec) {
    this.url = url;
    this.codec = codec;
    this.commandQueue_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$();
    this.request_0 = new XMLHttpRequest();
    this.alreadySending_0 = false;
  }
  function XMLHttpRequestTransmitter$CommandSubjectPair(commands) {
    this.commands = commands;
    this.subject = new Rx$Subject();
  }
  XMLHttpRequestTransmitter$CommandSubjectPair.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'CommandSubjectPair',
    interfaces: []
  };
  function XMLHttpRequestTransmitter$sendCommands$lambda$lambda(closure$observer) {
    return function (it) {
      closure$observer.next(it);
    };
  }
  function XMLHttpRequestTransmitter$sendCommands$lambda$lambda_0(closure$observer) {
    return function (error) {
      var tmp$, tmp$_0;
      tmp$_0 = Kotlin.isType(tmp$ = error, Error_0) ? tmp$ : Kotlin.throwCCE();
      closure$observer.error(tmp$_0);
    };
  }
  function XMLHttpRequestTransmitter$sendCommands$lambda$lambda_1(closure$observer, this$XMLHttpRequestTransmitter) {
    return function () {
      closure$observer.complete();
      this$XMLHttpRequestTransmitter.sendComplete_0();
    };
  }
  function XMLHttpRequestTransmitter$sendCommands$lambda(closure$commands, this$XMLHttpRequestTransmitter) {
    return function (observer) {
      var pair = new XMLHttpRequestTransmitter$CommandSubjectPair(closure$commands);
      this$XMLHttpRequestTransmitter.commandQueue_0.add_11rb$(pair);
      var result = pair.subject.subscribe(XMLHttpRequestTransmitter$sendCommands$lambda$lambda(observer), XMLHttpRequestTransmitter$sendCommands$lambda$lambda_0(observer), XMLHttpRequestTransmitter$sendCommands$lambda$lambda_1(observer, this$XMLHttpRequestTransmitter));
      this$XMLHttpRequestTransmitter.send_0();
      return result;
    };
  }
  XMLHttpRequestTransmitter.prototype.sendCommands_6il2lv$ = function (commands) {
    return new Rx$Observable(XMLHttpRequestTransmitter$sendCommands$lambda(commands, this));
  };
  XMLHttpRequestTransmitter.prototype.send_0 = function () {
    if (this.alreadySending_0) {
      return;
    }
    if (this.commandQueue_0.isEmpty()) {
      return;
    }
    this.alreadySending_0 = true;
    var pair = this.commandQueue_0.removeAt_za3lpa$(0);
    var handler = new Handler(pair.subject, this.request_0, this.codec);
    this.request_0.onreadystatechange = Kotlin.getCallableRef('readyStateHandler', function ($receiver, event) {
      return $receiver.readyStateHandler_9ojx7i$(event);
    }.bind(null, handler));
    this.request_0.onerror = Kotlin.getCallableRef('onErrorHandler', function ($receiver, event) {
      return $receiver.onErrorHandler_9ojx7i$(event);
    }.bind(null, handler));
    this.request_0.open('POST', this.url, true);
    this.request_0.withCredentials = true;
    this.request_0.setRequestHeader('Content-Type', this.codec.mimeType + '; charset=' + this.codec.encoding);
    this.request_0.send(this.codec.encode_6il2lv$(pair.commands));
  };
  XMLHttpRequestTransmitter.prototype.sendComplete_0 = function () {
    this.alreadySending_0 = false;
    this.send_0();
  };
  XMLHttpRequestTransmitter.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'XMLHttpRequestTransmitter',
    interfaces: [Transmitter]
  };
  function Handler(subject, request, codec) {
    this.subject = subject;
    this.request = request;
    this.codec = codec;
  }
  Handler.prototype.onErrorHandler_9ojx7i$ = function (event) {
    this.subject.error(new Error_0('Error received: ' + event));
  };
  Handler.prototype.readyStateHandler_9ojx7i$ = function (event) {
    if (this.request.readyState !== XMLHttpRequest.DONE) {
      return;
    }
    if (this.request.status !== Kotlin.toShort(200)) {
      this.subject.error(new Error_0("Incorrect status received '" + this.request.status + "', expected 200."));
      return;
    }
    var $receiver = this.request.responseText;
    var tmp$;
    var responseText = Kotlin.kotlin.text.trim_gw00vp$(Kotlin.isCharSequence(tmp$ = $receiver) ? tmp$ : Kotlin.throwCCE()).toString();
    try {
      var responseCommands = this.codec.decode_2azfem$(Source$RESPONSE_getInstance(), responseText);
      this.onDone_0(responseCommands);
    }
     catch (exception) {
      if (Kotlin.isType(exception, Exception)) {
        console.log('Error occurred parsing responseText: ' + exception);
        this.subject.error(new Error_0('Response text in wrong format: ' + responseText));
      }
       else
        throw exception;
    }
  };
  Handler.prototype.onDone_0 = function (commands) {
    var tmp$;
    tmp$ = commands.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      this.subject.next(element);
    }
    this.subject.complete();
  };
  Handler.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'Handler',
    interfaces: []
  };
  function StringCodec() {
  }
  StringCodec.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'StringCodec',
    interfaces: []
  };
  function CommandApplication(applied, events, commandData) {
    CommandApplication$Companion_getInstance();
    this.applied = applied;
    this.events = events;
    this.commandData = commandData;
  }
  function CommandApplication$Companion() {
    CommandApplication$Companion_instance = this;
  }
  CommandApplication$Companion.prototype.applied_16dypu$ = function (events, commandData) {
    return new CommandApplication(true, events, commandData);
  };
  CommandApplication$Companion.prototype.rejected_anzskc$ = function (commandData) {
    return new CommandApplication(false, Kotlin.kotlin.collections.emptyList_287e2$(), commandData);
  };
  CommandApplication$Companion.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CommandApplication$Companion_instance = null;
  function CommandApplication$Companion_getInstance() {
    if (CommandApplication$Companion_instance === null) {
      new CommandApplication$Companion();
    }
    return CommandApplication$Companion_instance;
  }
  CommandApplication.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'CommandApplication',
    interfaces: []
  };
  CommandApplication.prototype.component1 = function () {
    return this.applied;
  };
  CommandApplication.prototype.component2 = function () {
    return this.events;
  };
  CommandApplication.prototype.component3 = function () {
    return this.commandData;
  };
  CommandApplication.prototype.copy_tjfin$ = function (applied, events, commandData) {
    return new CommandApplication(applied === void 0 ? this.applied : applied, events === void 0 ? this.events : events, commandData === void 0 ? this.commandData : commandData);
  };
  CommandApplication.prototype.toString = function () {
    return 'CommandApplication(applied=' + Kotlin.toString(this.applied) + (', events=' + Kotlin.toString(this.events)) + (', commandData=' + Kotlin.toString(this.commandData)) + ')';
  };
  CommandApplication.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.applied) | 0;
    result = result * 31 + Kotlin.hashCode(this.events) | 0;
    result = result * 31 + Kotlin.hashCode(this.commandData) | 0;
    return result;
  };
  CommandApplication.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.applied, other.applied) && Kotlin.equals(this.events, other.events) && Kotlin.equals(this.commandData, other.commandData)))));
  };
  function CommandApplier() {
    CommandApplier_instance = this;
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    this.executors_0 = mapOf([to((tmp$ = Kotlin.getKClass(CreateModelCommandData).simpleName) != null ? tmp$ : Kotlin.throwNPE(), CreateModelExecutor_getInstance()), to((tmp$_0 = Kotlin.getKClass(RemoveModelCommandData).simpleName) != null ? tmp$_0 : Kotlin.throwNPE(), RemoveModelExecutor_getInstance()), to((tmp$_1 = Kotlin.getKClass(ActionCommandData).simpleName) != null ? tmp$_1 : Kotlin.throwNPE(), ActionExecutor_getInstance()), to((tmp$_2 = Kotlin.getKClass(ChangeValueCommandData).simpleName) != null ? tmp$_2 : Kotlin.throwNPE(), ChangeValueExecutor_getInstance()), to((tmp$_3 = Kotlin.getKClass(RemoveModelByTypeCommandData).simpleName) != null ? tmp$_3 : Kotlin.throwNPE(), RemoveModelByTypeExecutor_getInstance()), to((tmp$_4 = Kotlin.getKClass(SyncModelCommandData).simpleName) != null ? tmp$_4 : Kotlin.throwNPE(), SyncModelExecutor_getInstance())]);
  }
  CommandApplier.prototype.apply_mq2q7b$ = function (source, modelStore, commandData) {
    var tmp$, tmp$_0;
    tmp$_0 = this.executors_0.get_11rb$((tmp$ = Kotlin.getKClassFromExpression(commandData).simpleName) != null ? tmp$ : Kotlin.throwNPE());
    if (tmp$_0 == null) {
      throw new IllegalArgumentException("No executor found for commandData: '" + commandData + "'");
    }
    var executor = tmp$_0;
    try {
      return executor.execute_mq2q7b$(source, modelStore, commandData);
    }
     catch (e) {
      if (Kotlin.isType(e, Exception)) {
        throw new RuntimeException("Failed to apply command: '" + commandData + "'. Original error message: '" + Kotlin.toString(e.message) + "'");
      }
       else
        throw e;
    }
  };
  CommandApplier.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'CommandApplier',
    interfaces: []
  };
  var CommandApplier_instance = null;
  function CommandApplier_getInstance() {
    if (CommandApplier_instance === null) {
      new CommandApplier();
    }
    return CommandApplier_instance;
  }
  function CommandExecutor() {
  }
  CommandExecutor.prototype.forceApply_ls2jj0$ = function (ourSource, commandData) {
    return commandData.policy.isForceApply() || (ourSource !== commandData.source && commandData.policy.isForceSend());
  };
  CommandExecutor.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'CommandExecutor',
    interfaces: []
  };
  function CreateModelExecutor() {
    CreateModelExecutor_instance = this;
  }
  CreateModelExecutor.prototype.execute_mq2q7b$ = function (source, modelStore, commandData) {
    var tmp$;
    var it = Kotlin.isType(tmp$ = commandData, CreateModelCommandData) ? tmp$ : Kotlin.throwCCE();
    if (!this.forceApply_ls2jj0$(source, it) && modelStore.contains_accdal$(commandData.modelId)) {
      return CommandApplication$Companion_getInstance().rejected_anzskc$(commandData);
    }
    var model = new DefaultPresentationModel(it.modelId, it.modelType, asSequence(it.properties));
    modelStore.addModel_pl55oe$(model);
    return CommandApplication$Companion_getInstance().applied_16dypu$(listOf(new ModelStoreChangeEvent(it.source, model.id, model.type, ModelStoreChangeEventType$ADD_getInstance())), commandData);
  };
  CreateModelExecutor.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'CreateModelExecutor',
    interfaces: [CommandExecutor]
  };
  var CreateModelExecutor_instance = null;
  function CreateModelExecutor_getInstance() {
    if (CreateModelExecutor_instance === null) {
      new CreateModelExecutor();
    }
    return CreateModelExecutor_instance;
  }
  function ChangeValueExecutor() {
    ChangeValueExecutor_instance = this;
  }
  ChangeValueExecutor.prototype.execute_mq2q7b$ = function (source, modelStore, commandData) {
    var tmp$;
    var it = Kotlin.isType(tmp$ = commandData, ChangeValueCommandData) ? tmp$ : Kotlin.throwCCE();
    var tmp$_0 = !this.forceApply_ls2jj0$(source, it);
    if (tmp$_0) {
      var it_0 = modelStore.get_accdal$(commandData.modelId).get_lqljjj$(commandData.propertyName);
      tmp$_0 = (it_0.hasValue_ol557t$(commandData.tag) && Kotlin.equals(it_0.get_ol557t$(commandData.tag), commandData.value));
    }
    if (tmp$_0) {
      return CommandApplication$Companion_getInstance().rejected_anzskc$(commandData);
    }
    var model = modelStore.get_accdal$(it.modelId);
    var oldValue = model.get_lqljjj$(it.propertyName).set_jcm6gy$(it.tag, it.value);
    return CommandApplication$Companion_getInstance().applied_16dypu$(listOf(new PropertyChangeEvent(it.source, model.id, model.type, new ValueChangeEvent(it.source, it.propertyName, it.tag, oldValue, it.value))), commandData);
  };
  ChangeValueExecutor.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'ChangeValueExecutor',
    interfaces: [CommandExecutor]
  };
  var ChangeValueExecutor_instance = null;
  function ChangeValueExecutor_getInstance() {
    if (ChangeValueExecutor_instance === null) {
      new ChangeValueExecutor();
    }
    return ChangeValueExecutor_instance;
  }
  function ActionExecutor() {
    ActionExecutor_instance = this;
  }
  ActionExecutor.prototype.execute_mq2q7b$ = function (source, modelStore, commandData) {
    var tmp$;
    var it = Kotlin.isType(tmp$ = commandData, ActionCommandData) ? tmp$ : Kotlin.throwCCE();
    return CommandApplication$Companion_getInstance().applied_16dypu$(listOf(new ActionEvent(it.source, it.actionName, it.modelIds)), commandData);
  };
  ActionExecutor.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'ActionExecutor',
    interfaces: [CommandExecutor]
  };
  var ActionExecutor_instance = null;
  function ActionExecutor_getInstance() {
    if (ActionExecutor_instance === null) {
      new ActionExecutor();
    }
    return ActionExecutor_instance;
  }
  function RemoveModelExecutor() {
    RemoveModelExecutor_instance = this;
  }
  RemoveModelExecutor.prototype.execute_mq2q7b$ = function (source, modelStore, commandData) {
    var tmp$;
    var it = Kotlin.isType(tmp$ = commandData, RemoveModelCommandData) ? tmp$ : Kotlin.throwCCE();
    if (!this.forceApply_ls2jj0$(source, it) && !modelStore.contains_accdal$(it.modelId)) {
      return CommandApplication$Companion_getInstance().rejected_anzskc$(commandData);
    }
    if (modelStore.contains_accdal$(it.modelId))
      modelStore.removeModel_accdal$(it.modelId);
    return CommandApplication$Companion_getInstance().applied_16dypu$(listOf(new ModelStoreChangeEvent(it.source, it.modelId, it.modelType, ModelStoreChangeEventType$REMOVE_getInstance())), commandData);
  };
  RemoveModelExecutor.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'RemoveModelExecutor',
    interfaces: [CommandExecutor]
  };
  var RemoveModelExecutor_instance = null;
  function RemoveModelExecutor_getInstance() {
    if (RemoveModelExecutor_instance === null) {
      new RemoveModelExecutor();
    }
    return RemoveModelExecutor_instance;
  }
  function RemoveModelByTypeExecutor() {
    RemoveModelByTypeExecutor_instance = this;
  }
  RemoveModelByTypeExecutor.prototype.execute_mq2q7b$ = function (source, modelStore, commandData) {
    var tmp$;
    var it = Kotlin.isType(tmp$ = commandData, RemoveModelByTypeCommandData) ? tmp$ : Kotlin.throwCCE();
    if (!this.forceApply_ls2jj0$(source, it) && !modelStore.contains_4tsc7m$(it.modelType)) {
      return CommandApplication$Companion_getInstance().rejected_anzskc$(commandData);
    }
    var tmp$_0 = CommandApplication$Companion_getInstance();
    var $receiver = modelStore.removeModels_4tsc7m$(it.modelType);
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$($receiver, 10));
    var tmp$_1;
    tmp$_1 = $receiver.iterator();
    while (tmp$_1.hasNext()) {
      var item = tmp$_1.next();
      destination.add_11rb$(new ModelStoreChangeEvent(it.source, item.id, item.type, ModelStoreChangeEventType$REMOVE_getInstance()));
    }
    return tmp$_0.applied_16dypu$(destination, commandData);
  };
  RemoveModelByTypeExecutor.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'RemoveModelByTypeExecutor',
    interfaces: [CommandExecutor]
  };
  var RemoveModelByTypeExecutor_instance = null;
  function RemoveModelByTypeExecutor_getInstance() {
    if (RemoveModelByTypeExecutor_instance === null) {
      new RemoveModelByTypeExecutor();
    }
    return RemoveModelByTypeExecutor_instance;
  }
  function SyncModelExecutor() {
    SyncModelExecutor_instance = this;
  }
  function SyncModelExecutor$execute$lambda(closure$destinationPm) {
    return function (property) {
      return closure$destinationPm.hasProperty_lqljjj$(property.name);
    };
  }
  function SyncModelExecutor$execute$lambda$lambda(closure$destinationPm, closure$property, closure$data) {
    return function (pair) {
      var tmp$ = pair;
      var tag = tmp$.component1()
      , value = tmp$.component2();
      var oldValue = closure$destinationPm.get_lqljjj$(closure$property.name).set_jcm6gy$(tag, value);
      return new PropertyChangeEvent(closure$data.source, closure$destinationPm.id, closure$destinationPm.type, new ValueChangeEvent(closure$data.source, closure$property.name, tag, oldValue, value));
    };
  }
  function SyncModelExecutor$execute$lambda_0(closure$destinationPm, closure$data) {
    return function (property) {
      return map(property.getValues(), SyncModelExecutor$execute$lambda$lambda(closure$destinationPm, property, closure$data));
    };
  }
  SyncModelExecutor.prototype.execute_mq2q7b$ = function (source, modelStore, commandData) {
    var tmp$;
    var data = Kotlin.isType(tmp$ = commandData, SyncModelCommandData) ? tmp$ : Kotlin.throwCCE();
    var sourcePm = modelStore.get_accdal$(data.sourceModel);
    var destinationPm = modelStore.get_accdal$(data.destinationModel);
    var events = toList(flatMap(filter(sourcePm.getProperties(), SyncModelExecutor$execute$lambda(destinationPm)), SyncModelExecutor$execute$lambda_0(destinationPm, data)));
    return CommandApplication$Companion_getInstance().applied_16dypu$(events, commandData);
  };
  SyncModelExecutor.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'SyncModelExecutor',
    interfaces: [CommandExecutor]
  };
  var SyncModelExecutor_instance = null;
  function SyncModelExecutor_getInstance() {
    if (SyncModelExecutor_instance === null) {
      new SyncModelExecutor();
    }
    return SyncModelExecutor_instance;
  }
  function ApplyPolicy(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function ApplyPolicy_initFields() {
    ApplyPolicy_initFields = function () {
    };
    ApplyPolicy$DEFAULT_instance = new ApplyPolicy('DEFAULT', 0);
    ApplyPolicy$FORCE_SEND_instance = new ApplyPolicy('FORCE_SEND', 1);
    ApplyPolicy$FORCE_APPLY_instance = new ApplyPolicy('FORCE_APPLY', 2);
  }
  var ApplyPolicy$DEFAULT_instance;
  function ApplyPolicy$DEFAULT_getInstance() {
    ApplyPolicy_initFields();
    return ApplyPolicy$DEFAULT_instance;
  }
  var ApplyPolicy$FORCE_SEND_instance;
  function ApplyPolicy$FORCE_SEND_getInstance() {
    ApplyPolicy_initFields();
    return ApplyPolicy$FORCE_SEND_instance;
  }
  var ApplyPolicy$FORCE_APPLY_instance;
  function ApplyPolicy$FORCE_APPLY_getInstance() {
    ApplyPolicy_initFields();
    return ApplyPolicy$FORCE_APPLY_instance;
  }
  ApplyPolicy.prototype.isForceSend = function () {
    return this === ApplyPolicy$FORCE_SEND_getInstance() || this.isForceApply();
  };
  ApplyPolicy.prototype.isForceApply = function () {
    return this === ApplyPolicy$FORCE_APPLY_getInstance();
  };
  ApplyPolicy.prototype.isDefault = function () {
    return this === ApplyPolicy$DEFAULT_getInstance();
  };
  ApplyPolicy.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ApplyPolicy',
    interfaces: [Enum]
  };
  function ApplyPolicy$values() {
    return [ApplyPolicy$DEFAULT_getInstance(), ApplyPolicy$FORCE_SEND_getInstance(), ApplyPolicy$FORCE_APPLY_getInstance()];
  }
  ApplyPolicy.values = ApplyPolicy$values;
  function ApplyPolicy$valueOf(name) {
    switch (name) {
      case 'DEFAULT':
        return ApplyPolicy$DEFAULT_getInstance();
      case 'FORCE_SEND':
        return ApplyPolicy$FORCE_SEND_getInstance();
      case 'FORCE_APPLY':
        return ApplyPolicy$FORCE_APPLY_getInstance();
      default:Kotlin.throwISE('No enum constant ch.viseon.openOrca.share.ApplyPolicy.' + name);
    }
  }
  ApplyPolicy.valueOf_61zpoe$ = ApplyPolicy$valueOf;
  function CommandData() {
  }
  CommandData.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'CommandData',
    interfaces: []
  };
  function ChangeValueCommandData(source, modelId, propertyName, tag, value, policy) {
    if (policy === void 0)
      policy = ApplyPolicy$DEFAULT_getInstance();
    this.source_avhejv$_0 = source;
    this.modelId = modelId;
    this.propertyName = propertyName;
    this.tag = tag;
    this.value = value;
    this.policy_avhejv$_0 = policy;
  }
  Object.defineProperty(ChangeValueCommandData.prototype, 'source', {
    get: function () {
      return this.source_avhejv$_0;
    }
  });
  Object.defineProperty(ChangeValueCommandData.prototype, 'policy', {
    get: function () {
      return this.policy_avhejv$_0;
    }
  });
  ChangeValueCommandData.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ChangeValueCommandData',
    interfaces: [CommandData]
  };
  ChangeValueCommandData.prototype.component1 = function () {
    return this.source;
  };
  ChangeValueCommandData.prototype.component2 = function () {
    return this.modelId;
  };
  ChangeValueCommandData.prototype.component3 = function () {
    return this.propertyName;
  };
  ChangeValueCommandData.prototype.component4 = function () {
    return this.tag;
  };
  ChangeValueCommandData.prototype.component5 = function () {
    return this.value;
  };
  ChangeValueCommandData.prototype.component6 = function () {
    return this.policy;
  };
  ChangeValueCommandData.prototype.copy_p1l631$ = function (source, modelId, propertyName, tag, value, policy) {
    return new ChangeValueCommandData(source === void 0 ? this.source : source, modelId === void 0 ? this.modelId : modelId, propertyName === void 0 ? this.propertyName : propertyName, tag === void 0 ? this.tag : tag, value === void 0 ? this.value : value, policy === void 0 ? this.policy : policy);
  };
  ChangeValueCommandData.prototype.toString = function () {
    return 'ChangeValueCommandData(source=' + Kotlin.toString(this.source) + (', modelId=' + Kotlin.toString(this.modelId)) + (', propertyName=' + Kotlin.toString(this.propertyName)) + (', tag=' + Kotlin.toString(this.tag)) + (', value=' + Kotlin.toString(this.value)) + (', policy=' + Kotlin.toString(this.policy)) + ')';
  };
  ChangeValueCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelId) | 0;
    result = result * 31 + Kotlin.hashCode(this.propertyName) | 0;
    result = result * 31 + Kotlin.hashCode(this.tag) | 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    result = result * 31 + Kotlin.hashCode(this.policy) | 0;
    return result;
  };
  ChangeValueCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.modelId, other.modelId) && Kotlin.equals(this.propertyName, other.propertyName) && Kotlin.equals(this.tag, other.tag) && Kotlin.equals(this.value, other.value) && Kotlin.equals(this.policy, other.policy)))));
  };
  function CreateModelCommandData(source, modelId, modelType, properties, policy) {
    if (policy === void 0)
      policy = ApplyPolicy$DEFAULT_getInstance();
    this.source_5h0uf5$_0 = source;
    this.modelId = modelId;
    this.modelType = modelType;
    this.properties = properties;
    this.policy_5h0uf5$_0 = policy;
  }
  Object.defineProperty(CreateModelCommandData.prototype, 'source', {
    get: function () {
      return this.source_5h0uf5$_0;
    }
  });
  Object.defineProperty(CreateModelCommandData.prototype, 'policy', {
    get: function () {
      return this.policy_5h0uf5$_0;
    }
  });
  CreateModelCommandData.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'CreateModelCommandData',
    interfaces: [CommandData]
  };
  CreateModelCommandData.prototype.component1 = function () {
    return this.source;
  };
  CreateModelCommandData.prototype.component2 = function () {
    return this.modelId;
  };
  CreateModelCommandData.prototype.component3 = function () {
    return this.modelType;
  };
  CreateModelCommandData.prototype.component4 = function () {
    return this.properties;
  };
  CreateModelCommandData.prototype.component5 = function () {
    return this.policy;
  };
  CreateModelCommandData.prototype.copy_lg99t$ = function (source, modelId, modelType, properties, policy) {
    return new CreateModelCommandData(source === void 0 ? this.source : source, modelId === void 0 ? this.modelId : modelId, modelType === void 0 ? this.modelType : modelType, properties === void 0 ? this.properties : properties, policy === void 0 ? this.policy : policy);
  };
  CreateModelCommandData.prototype.toString = function () {
    return 'CreateModelCommandData(source=' + Kotlin.toString(this.source) + (', modelId=' + Kotlin.toString(this.modelId)) + (', modelType=' + Kotlin.toString(this.modelType)) + (', properties=' + Kotlin.toString(this.properties)) + (', policy=' + Kotlin.toString(this.policy)) + ')';
  };
  CreateModelCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelId) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelType) | 0;
    result = result * 31 + Kotlin.hashCode(this.properties) | 0;
    result = result * 31 + Kotlin.hashCode(this.policy) | 0;
    return result;
  };
  CreateModelCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.modelId, other.modelId) && Kotlin.equals(this.modelType, other.modelType) && Kotlin.equals(this.properties, other.properties) && Kotlin.equals(this.policy, other.policy)))));
  };
  function RemoveModelCommandData(source, modelId, modelType, policy) {
    if (policy === void 0)
      policy = ApplyPolicy$DEFAULT_getInstance();
    this.source_ij9do9$_0 = source;
    this.modelId = modelId;
    this.modelType = modelType;
    this.policy_ij9do9$_0 = policy;
  }
  Object.defineProperty(RemoveModelCommandData.prototype, 'source', {
    get: function () {
      return this.source_ij9do9$_0;
    }
  });
  Object.defineProperty(RemoveModelCommandData.prototype, 'policy', {
    get: function () {
      return this.policy_ij9do9$_0;
    }
  });
  RemoveModelCommandData.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'RemoveModelCommandData',
    interfaces: [CommandData]
  };
  RemoveModelCommandData.prototype.component1 = function () {
    return this.source;
  };
  RemoveModelCommandData.prototype.component2 = function () {
    return this.modelId;
  };
  RemoveModelCommandData.prototype.component3 = function () {
    return this.modelType;
  };
  RemoveModelCommandData.prototype.component4 = function () {
    return this.policy;
  };
  RemoveModelCommandData.prototype.copy_23g25s$ = function (source, modelId, modelType, policy) {
    return new RemoveModelCommandData(source === void 0 ? this.source : source, modelId === void 0 ? this.modelId : modelId, modelType === void 0 ? this.modelType : modelType, policy === void 0 ? this.policy : policy);
  };
  RemoveModelCommandData.prototype.toString = function () {
    return 'RemoveModelCommandData(source=' + Kotlin.toString(this.source) + (', modelId=' + Kotlin.toString(this.modelId)) + (', modelType=' + Kotlin.toString(this.modelType)) + (', policy=' + Kotlin.toString(this.policy)) + ')';
  };
  RemoveModelCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelId) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelType) | 0;
    result = result * 31 + Kotlin.hashCode(this.policy) | 0;
    return result;
  };
  RemoveModelCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.modelId, other.modelId) && Kotlin.equals(this.modelType, other.modelType) && Kotlin.equals(this.policy, other.policy)))));
  };
  function ActionCommandData(source, actionName, modelIds, policy) {
    if (modelIds === void 0) {
      modelIds = Kotlin.kotlin.collections.emptyList_287e2$();
    }
    if (policy === void 0)
      policy = ApplyPolicy$DEFAULT_getInstance();
    this.source_ftpbjg$_0 = source;
    this.actionName = actionName;
    this.modelIds = modelIds;
    this.policy_ftpbjg$_0 = policy;
  }
  Object.defineProperty(ActionCommandData.prototype, 'source', {
    get: function () {
      return this.source_ftpbjg$_0;
    }
  });
  Object.defineProperty(ActionCommandData.prototype, 'policy', {
    get: function () {
      return this.policy_ftpbjg$_0;
    }
  });
  ActionCommandData.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ActionCommandData',
    interfaces: [CommandData]
  };
  ActionCommandData.prototype.component1 = function () {
    return this.source;
  };
  ActionCommandData.prototype.component2 = function () {
    return this.actionName;
  };
  ActionCommandData.prototype.component3 = function () {
    return this.modelIds;
  };
  ActionCommandData.prototype.component4 = function () {
    return this.policy;
  };
  ActionCommandData.prototype.copy_oa3o1h$ = function (source, actionName, modelIds, policy) {
    return new ActionCommandData(source === void 0 ? this.source : source, actionName === void 0 ? this.actionName : actionName, modelIds === void 0 ? this.modelIds : modelIds, policy === void 0 ? this.policy : policy);
  };
  ActionCommandData.prototype.toString = function () {
    return 'ActionCommandData(source=' + Kotlin.toString(this.source) + (', actionName=' + Kotlin.toString(this.actionName)) + (', modelIds=' + Kotlin.toString(this.modelIds)) + (', policy=' + Kotlin.toString(this.policy)) + ')';
  };
  ActionCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.actionName) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelIds) | 0;
    result = result * 31 + Kotlin.hashCode(this.policy) | 0;
    return result;
  };
  ActionCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.actionName, other.actionName) && Kotlin.equals(this.modelIds, other.modelIds) && Kotlin.equals(this.policy, other.policy)))));
  };
  function RemoveModelByTypeCommandData(source, modelType, policy) {
    if (policy === void 0)
      policy = ApplyPolicy$DEFAULT_getInstance();
    this.source_vd4yfe$_0 = source;
    this.modelType = modelType;
    this.policy_vd4yfe$_0 = policy;
  }
  Object.defineProperty(RemoveModelByTypeCommandData.prototype, 'source', {
    get: function () {
      return this.source_vd4yfe$_0;
    }
  });
  Object.defineProperty(RemoveModelByTypeCommandData.prototype, 'policy', {
    get: function () {
      return this.policy_vd4yfe$_0;
    }
  });
  RemoveModelByTypeCommandData.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'RemoveModelByTypeCommandData',
    interfaces: [CommandData]
  };
  RemoveModelByTypeCommandData.prototype.component1 = function () {
    return this.source;
  };
  RemoveModelByTypeCommandData.prototype.component2 = function () {
    return this.modelType;
  };
  RemoveModelByTypeCommandData.prototype.component3 = function () {
    return this.policy;
  };
  RemoveModelByTypeCommandData.prototype.copy_73wdex$ = function (source, modelType, policy) {
    return new RemoveModelByTypeCommandData(source === void 0 ? this.source : source, modelType === void 0 ? this.modelType : modelType, policy === void 0 ? this.policy : policy);
  };
  RemoveModelByTypeCommandData.prototype.toString = function () {
    return 'RemoveModelByTypeCommandData(source=' + Kotlin.toString(this.source) + (', modelType=' + Kotlin.toString(this.modelType)) + (', policy=' + Kotlin.toString(this.policy)) + ')';
  };
  RemoveModelByTypeCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelType) | 0;
    result = result * 31 + Kotlin.hashCode(this.policy) | 0;
    return result;
  };
  RemoveModelByTypeCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.modelType, other.modelType) && Kotlin.equals(this.policy, other.policy)))));
  };
  function SyncModelCommandData(source, sourceModel, destinationModel, policy) {
    if (policy === void 0)
      policy = ApplyPolicy$DEFAULT_getInstance();
    this.source_1wmcxu$_0 = source;
    this.sourceModel = sourceModel;
    this.destinationModel = destinationModel;
    this.policy_1wmcxu$_0 = policy;
  }
  Object.defineProperty(SyncModelCommandData.prototype, 'source', {
    get: function () {
      return this.source_1wmcxu$_0;
    }
  });
  Object.defineProperty(SyncModelCommandData.prototype, 'policy', {
    get: function () {
      return this.policy_1wmcxu$_0;
    }
  });
  SyncModelCommandData.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'SyncModelCommandData',
    interfaces: [CommandData]
  };
  SyncModelCommandData.prototype.component1 = function () {
    return this.source;
  };
  SyncModelCommandData.prototype.component2 = function () {
    return this.sourceModel;
  };
  SyncModelCommandData.prototype.component3 = function () {
    return this.destinationModel;
  };
  SyncModelCommandData.prototype.component4 = function () {
    return this.policy;
  };
  SyncModelCommandData.prototype.copy_rms6zz$ = function (source, sourceModel, destinationModel, policy) {
    return new SyncModelCommandData(source === void 0 ? this.source : source, sourceModel === void 0 ? this.sourceModel : sourceModel, destinationModel === void 0 ? this.destinationModel : destinationModel, policy === void 0 ? this.policy : policy);
  };
  SyncModelCommandData.prototype.toString = function () {
    return 'SyncModelCommandData(source=' + Kotlin.toString(this.source) + (', sourceModel=' + Kotlin.toString(this.sourceModel)) + (', destinationModel=' + Kotlin.toString(this.destinationModel)) + (', policy=' + Kotlin.toString(this.policy)) + ')';
  };
  SyncModelCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.sourceModel) | 0;
    result = result * 31 + Kotlin.hashCode(this.destinationModel) | 0;
    result = result * 31 + Kotlin.hashCode(this.policy) | 0;
    return result;
  };
  SyncModelCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.sourceModel, other.sourceModel) && Kotlin.equals(this.destinationModel, other.destinationModel) && Kotlin.equals(this.policy, other.policy)))));
  };
  function Event() {
  }
  Event.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'Event',
    interfaces: []
  };
  function ModelStoreChangeEventType(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function ModelStoreChangeEventType_initFields() {
    ModelStoreChangeEventType_initFields = function () {
    };
    ModelStoreChangeEventType$ADD_instance = new ModelStoreChangeEventType('ADD', 0);
    ModelStoreChangeEventType$REMOVE_instance = new ModelStoreChangeEventType('REMOVE', 1);
  }
  var ModelStoreChangeEventType$ADD_instance;
  function ModelStoreChangeEventType$ADD_getInstance() {
    ModelStoreChangeEventType_initFields();
    return ModelStoreChangeEventType$ADD_instance;
  }
  var ModelStoreChangeEventType$REMOVE_instance;
  function ModelStoreChangeEventType$REMOVE_getInstance() {
    ModelStoreChangeEventType_initFields();
    return ModelStoreChangeEventType$REMOVE_instance;
  }
  ModelStoreChangeEventType.prototype.isAdd = function () {
    return this === ModelStoreChangeEventType$ADD_getInstance();
  };
  ModelStoreChangeEventType.prototype.isRemove = function () {
    return this === ModelStoreChangeEventType$REMOVE_getInstance();
  };
  ModelStoreChangeEventType.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ModelStoreChangeEventType',
    interfaces: [Enum]
  };
  function ModelStoreChangeEventType$values() {
    return [ModelStoreChangeEventType$ADD_getInstance(), ModelStoreChangeEventType$REMOVE_getInstance()];
  }
  ModelStoreChangeEventType.values = ModelStoreChangeEventType$values;
  function ModelStoreChangeEventType$valueOf(name) {
    switch (name) {
      case 'ADD':
        return ModelStoreChangeEventType$ADD_getInstance();
      case 'REMOVE':
        return ModelStoreChangeEventType$REMOVE_getInstance();
      default:Kotlin.throwISE('No enum constant ch.viseon.openOrca.share.ModelStoreChangeEventType.' + name);
    }
  }
  ModelStoreChangeEventType.valueOf_61zpoe$ = ModelStoreChangeEventType$valueOf;
  function ModelStoreChangeEvent(source, modelId, modelType, eventType) {
    this.source_xc4rc7$_0 = source;
    this.modelId = modelId;
    this.modelType = modelType;
    this.eventType = eventType;
  }
  Object.defineProperty(ModelStoreChangeEvent.prototype, 'source', {
    get: function () {
      return this.source_xc4rc7$_0;
    }
  });
  ModelStoreChangeEvent.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ModelStoreChangeEvent',
    interfaces: [Event]
  };
  ModelStoreChangeEvent.prototype.component1 = function () {
    return this.source;
  };
  ModelStoreChangeEvent.prototype.component2 = function () {
    return this.modelId;
  };
  ModelStoreChangeEvent.prototype.component3 = function () {
    return this.modelType;
  };
  ModelStoreChangeEvent.prototype.component4 = function () {
    return this.eventType;
  };
  ModelStoreChangeEvent.prototype.copy_2b8mmc$ = function (source, modelId, modelType, eventType) {
    return new ModelStoreChangeEvent(source === void 0 ? this.source : source, modelId === void 0 ? this.modelId : modelId, modelType === void 0 ? this.modelType : modelType, eventType === void 0 ? this.eventType : eventType);
  };
  ModelStoreChangeEvent.prototype.toString = function () {
    return 'ModelStoreChangeEvent(source=' + Kotlin.toString(this.source) + (', modelId=' + Kotlin.toString(this.modelId)) + (', modelType=' + Kotlin.toString(this.modelType)) + (', eventType=' + Kotlin.toString(this.eventType)) + ')';
  };
  ModelStoreChangeEvent.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelId) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelType) | 0;
    result = result * 31 + Kotlin.hashCode(this.eventType) | 0;
    return result;
  };
  ModelStoreChangeEvent.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.modelId, other.modelId) && Kotlin.equals(this.modelType, other.modelType) && Kotlin.equals(this.eventType, other.eventType)))));
  };
  function PropertyChangeEvent(source, modelId, modelType, valueChangeEvent) {
    this.source_64kfm2$_0 = source;
    this.modelId = modelId;
    this.modelType = modelType;
    this.valueChangeEvent = valueChangeEvent;
  }
  Object.defineProperty(PropertyChangeEvent.prototype, 'source', {
    get: function () {
      return this.source_64kfm2$_0;
    }
  });
  PropertyChangeEvent.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'PropertyChangeEvent',
    interfaces: [Event]
  };
  PropertyChangeEvent.prototype.component1 = function () {
    return this.source;
  };
  PropertyChangeEvent.prototype.component2 = function () {
    return this.modelId;
  };
  PropertyChangeEvent.prototype.component3 = function () {
    return this.modelType;
  };
  PropertyChangeEvent.prototype.component4 = function () {
    return this.valueChangeEvent;
  };
  PropertyChangeEvent.prototype.copy_2p61p3$ = function (source, modelId, modelType, valueChangeEvent) {
    return new PropertyChangeEvent(source === void 0 ? this.source : source, modelId === void 0 ? this.modelId : modelId, modelType === void 0 ? this.modelType : modelType, valueChangeEvent === void 0 ? this.valueChangeEvent : valueChangeEvent);
  };
  PropertyChangeEvent.prototype.toString = function () {
    return 'PropertyChangeEvent(source=' + Kotlin.toString(this.source) + (', modelId=' + Kotlin.toString(this.modelId)) + (', modelType=' + Kotlin.toString(this.modelType)) + (', valueChangeEvent=' + Kotlin.toString(this.valueChangeEvent)) + ')';
  };
  PropertyChangeEvent.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelId) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelType) | 0;
    result = result * 31 + Kotlin.hashCode(this.valueChangeEvent) | 0;
    return result;
  };
  PropertyChangeEvent.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.modelId, other.modelId) && Kotlin.equals(this.modelType, other.modelType) && Kotlin.equals(this.valueChangeEvent, other.valueChangeEvent)))));
  };
  function ValueChangeEvent(source, property, tag, oldValue, newValue) {
    this.source_s4spyo$_0 = source;
    this.property = property;
    this.tag = tag;
    this.oldValue = oldValue;
    this.newValue = newValue;
  }
  Object.defineProperty(ValueChangeEvent.prototype, 'source', {
    get: function () {
      return this.source_s4spyo$_0;
    }
  });
  ValueChangeEvent.prototype.isValueChange = function () {
    var tmp$;
    return (tmp$ = this.tag) != null ? tmp$.equals(Tag$Companion_getInstance().VALUE) : null;
  };
  ValueChangeEvent.prototype.isLabelChange = function () {
    var tmp$;
    return (tmp$ = this.tag) != null ? tmp$.equals(Tag$Companion_getInstance().LABEL) : null;
  };
  ValueChangeEvent.prototype.isToolTipChange = function () {
    var tmp$;
    return (tmp$ = this.tag) != null ? tmp$.equals(Tag$Companion_getInstance().TOOL_TIP) : null;
  };
  ValueChangeEvent.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ValueChangeEvent',
    interfaces: [Event]
  };
  ValueChangeEvent.prototype.component1 = function () {
    return this.source;
  };
  ValueChangeEvent.prototype.component2 = function () {
    return this.property;
  };
  ValueChangeEvent.prototype.component3 = function () {
    return this.tag;
  };
  ValueChangeEvent.prototype.component4 = function () {
    return this.oldValue;
  };
  ValueChangeEvent.prototype.component5 = function () {
    return this.newValue;
  };
  ValueChangeEvent.prototype.copy_kjdt0t$ = function (source, property, tag, oldValue, newValue) {
    return new ValueChangeEvent(source === void 0 ? this.source : source, property === void 0 ? this.property : property, tag === void 0 ? this.tag : tag, oldValue === void 0 ? this.oldValue : oldValue, newValue === void 0 ? this.newValue : newValue);
  };
  ValueChangeEvent.prototype.toString = function () {
    return 'ValueChangeEvent(source=' + Kotlin.toString(this.source) + (', property=' + Kotlin.toString(this.property)) + (', tag=' + Kotlin.toString(this.tag)) + (', oldValue=' + Kotlin.toString(this.oldValue)) + (', newValue=' + Kotlin.toString(this.newValue)) + ')';
  };
  ValueChangeEvent.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.property) | 0;
    result = result * 31 + Kotlin.hashCode(this.tag) | 0;
    result = result * 31 + Kotlin.hashCode(this.oldValue) | 0;
    result = result * 31 + Kotlin.hashCode(this.newValue) | 0;
    return result;
  };
  ValueChangeEvent.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.property, other.property) && Kotlin.equals(this.tag, other.tag) && Kotlin.equals(this.oldValue, other.oldValue) && Kotlin.equals(this.newValue, other.newValue)))));
  };
  function ActionEvent(source, actionName, pmIds) {
    this.source_awcbd3$_0 = source;
    this.actionName = actionName;
    this.pmIds = pmIds;
  }
  Object.defineProperty(ActionEvent.prototype, 'source', {
    get: function () {
      return this.source_awcbd3$_0;
    }
  });
  ActionEvent.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ActionEvent',
    interfaces: [Event]
  };
  ActionEvent.prototype.component1 = function () {
    return this.source;
  };
  ActionEvent.prototype.component2 = function () {
    return this.actionName;
  };
  ActionEvent.prototype.component3 = function () {
    return this.pmIds;
  };
  ActionEvent.prototype.copy_y2nfqq$ = function (source, actionName, pmIds) {
    return new ActionEvent(source === void 0 ? this.source : source, actionName === void 0 ? this.actionName : actionName, pmIds === void 0 ? this.pmIds : pmIds);
  };
  ActionEvent.prototype.toString = function () {
    return 'ActionEvent(source=' + Kotlin.toString(this.source) + (', actionName=' + Kotlin.toString(this.actionName)) + (', pmIds=' + Kotlin.toString(this.pmIds)) + ')';
  };
  ActionEvent.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.actionName) | 0;
    result = result * 31 + Kotlin.hashCode(this.pmIds) | 0;
    return result;
  };
  ActionEvent.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.actionName, other.actionName) && Kotlin.equals(this.pmIds, other.pmIds)))));
  };
  function ModelId(stringId) {
    this.stringId = stringId;
  }
  ModelId.prototype.asValue = function () {
    return this;
  };
  ModelId.prototype.toString = function () {
    return this.stringId;
  };
  ModelId.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ModelId',
    interfaces: []
  };
  ModelId.prototype.component1 = function () {
    return this.stringId;
  };
  ModelId.prototype.copy_61zpoe$ = function (stringId) {
    return new ModelId(stringId === void 0 ? this.stringId : stringId);
  };
  ModelId.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.stringId) | 0;
    return result;
  };
  ModelId.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.stringId, other.stringId))));
  };
  function ModelType(stringId) {
    this.stringId = stringId;
  }
  ModelType.prototype.asValue = function () {
    return this.stringId;
  };
  ModelType.prototype.toString = function () {
    return this.stringId;
  };
  ModelType.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ModelType',
    interfaces: []
  };
  ModelType.prototype.component1 = function () {
    return this.stringId;
  };
  ModelType.prototype.copy_61zpoe$ = function (stringId) {
    return new ModelType(stringId === void 0 ? this.stringId : stringId);
  };
  ModelType.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.stringId) | 0;
    return result;
  };
  ModelType.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.stringId, other.stringId))));
  };
  function PropertyName(name) {
    this.name = name;
  }
  PropertyName.prototype.asValue = function () {
    return this.name;
  };
  PropertyName.prototype.toString = function () {
    return this.name;
  };
  PropertyName.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'PropertyName',
    interfaces: []
  };
  PropertyName.prototype.component1 = function () {
    return this.name;
  };
  PropertyName.prototype.copy_61zpoe$ = function (name) {
    return new PropertyName(name === void 0 ? this.name : name);
  };
  PropertyName.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    return result;
  };
  PropertyName.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.name, other.name))));
  };
  function JsonArray(values) {
    this.values = values;
  }
  JsonArray.prototype.iterator = function () {
    return this.values.iterator();
  };
  JsonArray.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'JsonArray',
    interfaces: [Iterable]
  };
  function JsonObj() {
  }
  JsonObj.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'JsonObj',
    interfaces: []
  };
  function JsonFactory() {
  }
  JsonFactory.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'JsonFactory',
    interfaces: []
  };
  function JsonCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
    this.mimeType_r8rzer$_0 = 'application/json';
    this.encoding_r8rzer$_0 = 'UTF-8';
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    this.commandCodecs_0 = mapOf([to((tmp$ = Kotlin.getKClass(ActionCommandData).simpleName) != null ? tmp$ : Kotlin.throwNPE(), new ActionCommandCodec(this.jsonFactory_0)), to((tmp$_0 = Kotlin.getKClass(RemoveModelCommandData).simpleName) != null ? tmp$_0 : Kotlin.throwNPE(), new RemoveModelCommandCodec(this.jsonFactory_0)), to((tmp$_1 = Kotlin.getKClass(RemoveModelByTypeCommandData).simpleName) != null ? tmp$_1 : Kotlin.throwNPE(), new RemoveModelByTypeCodec(this.jsonFactory_0)), to((tmp$_2 = Kotlin.getKClass(ChangeValueCommandData).simpleName) != null ? tmp$_2 : Kotlin.throwNPE(), new ChangeValueCommandCodec(this.jsonFactory_0)), to((tmp$_3 = Kotlin.getKClass(CreateModelCommandData).simpleName) != null ? tmp$_3 : Kotlin.throwNPE(), new CreateModelCommandCodec(this.jsonFactory_0)), to((tmp$_4 = Kotlin.getKClass(SyncModelCommandData).simpleName) != null ? tmp$_4 : Kotlin.throwNPE(), new SyncModelCommandCodec(this.jsonFactory_0))]);
  }
  Object.defineProperty(JsonCodec.prototype, 'mimeType', {
    get: function () {
      return this.mimeType_r8rzer$_0;
    }
  });
  Object.defineProperty(JsonCodec.prototype, 'encoding', {
    get: function () {
      return this.encoding_r8rzer$_0;
    }
  });
  JsonCodec.prototype.decode_2azfem$ = function (source, data) {
    var json = this.jsonFactory_0.parse_61zpoe$(data);
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$(json, 10));
    var tmp$;
    tmp$ = json.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      var tmp$_0 = destination.add_11rb$;
      var tmp$_1;
      var type = item.string_61zpoe$('type');
      tmp$_0.call(destination, ((tmp$_1 = this.commandCodecs_0.get_11rb$(type)) != null ? tmp$_1 : Kotlin.throwNPE()).decode_bor1xe$(source, item));
    }
    var result = destination;
    return result;
  };
  function JsonCodec$encode$lambda$lambda(this$JsonCodec) {
    return function (it) {
      var tmp$, tmp$_0;
      return ((tmp$_0 = this$JsonCodec.commandCodecs_0.get_11rb$((tmp$ = Kotlin.getKClassFromExpression(it).simpleName) != null ? tmp$ : Kotlin.throwNPE())) != null ? tmp$_0 : Kotlin.throwNPE()).encode_anzskc$(it);
    };
  }
  function JsonCodec$encode$lambda$lambda_0(it) {
    return it.toJsonString();
  }
  JsonCodec.prototype.encode_6il2lv$ = function (commands) {
    var $receiver = new Kotlin.kotlin.text.StringBuilder();
    $receiver.append_gw00v9$('[');
    $receiver.append_gw00v9$(joinToString(map(map(asSequence(commands), JsonCodec$encode$lambda$lambda(this)), JsonCodec$encode$lambda$lambda_0), ','));
    $receiver.append_gw00v9$(']');
    return $receiver.toString();
  };
  JsonCodec.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'JsonCodec',
    interfaces: [StringCodec]
  };
  function CommandCodec() {
  }
  CommandCodec.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'CommandCodec',
    interfaces: []
  };
  function ActionCommandCodec(jsonFactory) {
    this.jsonFactory = jsonFactory;
  }
  function ActionCommandCodec$encode$lambda$lambda(closure$typedCommand) {
    return function ($receiver) {
      if (!closure$typedCommand.policy.isDefault())
        $receiver.set_puj7f4$('policy', closure$typedCommand.policy.name);
      $receiver.set_puj7f4$('actionName', closure$typedCommand.actionName);
      var $receiver_0 = closure$typedCommand.modelIds;
      var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$($receiver_0, 10));
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(item.stringId);
      }
      $receiver.set_poujtz$('modelIds', destination);
    };
  }
  function ActionCommandCodec$encode$lambda(closure$typedCommand) {
    return function ($receiver) {
      var tmp$;
      $receiver.set_puj7f4$('type', (tmp$ = Kotlin.getKClass(ActionCommandData).simpleName) != null ? tmp$ : Kotlin.throwNPE());
      $receiver.set_8wy9ij$('data', ActionCommandCodec$encode$lambda$lambda(closure$typedCommand));
    };
  }
  ActionCommandCodec.prototype.encode_anzskc$ = function (untypedCommandData) {
    var tmp$;
    var typedCommand = Kotlin.isType(tmp$ = untypedCommandData, ActionCommandData) ? tmp$ : Kotlin.throwCCE();
    var jsonObj = this.jsonFactory.newJson_1j20nt$(ActionCommandCodec$encode$lambda(typedCommand));
    return jsonObj;
  };
  ActionCommandCodec.prototype.decode_bor1xe$ = function (source, json) {
    var tmp$, tmp$_0;
    var data = json.getObject_61zpoe$('data');
    var policy = (tmp$_0 = (tmp$ = data.optionalString_61zpoe$('policy')) != null ? ApplyPolicy$valueOf(tmp$) : null) != null ? tmp$_0 : ApplyPolicy$DEFAULT_getInstance();
    var modelIds = data.pArray_ytbaoo$('modelIds');
    var tmp$_1 = data.string_61zpoe$('actionName');
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$(modelIds, 10));
    var tmp$_2;
    tmp$_2 = modelIds.iterator();
    while (tmp$_2.hasNext()) {
      var item = tmp$_2.next();
      destination.add_11rb$(new ModelId(item));
    }
    return new ActionCommandData(source, tmp$_1, destination, policy);
  };
  ActionCommandCodec.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ActionCommandCodec',
    interfaces: [CommandCodec]
  };
  function RemoveModelCommandCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
  }
  function RemoveModelCommandCodec$encode$lambda$lambda(closure$typedCommand) {
    return function ($receiver) {
      $receiver.set_puj7f4$('modelId', closure$typedCommand.modelId.stringId);
      $receiver.set_puj7f4$('modelType', closure$typedCommand.modelType.stringId);
    };
  }
  function RemoveModelCommandCodec$encode$lambda(closure$typedCommand) {
    return function ($receiver) {
      var tmp$;
      $receiver.set_puj7f4$('type', (tmp$ = Kotlin.getKClass(RemoveModelCommandData).simpleName) != null ? tmp$ : Kotlin.throwNPE());
      $receiver.set_8wy9ij$('data', RemoveModelCommandCodec$encode$lambda$lambda(closure$typedCommand));
    };
  }
  RemoveModelCommandCodec.prototype.encode_anzskc$ = function (untypedCommandData) {
    var tmp$;
    var typedCommand = Kotlin.isType(tmp$ = untypedCommandData, RemoveModelCommandData) ? tmp$ : Kotlin.throwCCE();
    return this.jsonFactory_0.newJson_1j20nt$(RemoveModelCommandCodec$encode$lambda(typedCommand));
  };
  RemoveModelCommandCodec.prototype.decode_bor1xe$ = function (source, json) {
    var data = json.getObject_61zpoe$('data');
    return new RemoveModelCommandData(source, new ModelId(data.string_61zpoe$('modelId')), new ModelType(data.string_61zpoe$('modelType')));
  };
  RemoveModelCommandCodec.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'RemoveModelCommandCodec',
    interfaces: [CommandCodec]
  };
  function ChangeValueCommandCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
  }
  function ChangeValueCommandCodec$encode$lambda$lambda$lambda(closure$changeValueCommand) {
    return function ($receiver) {
      valueToJson($receiver, closure$changeValueCommand.tag, closure$changeValueCommand.value);
    };
  }
  function ChangeValueCommandCodec$encode$lambda$lambda(closure$changeValueCommand, this$ChangeValueCommandCodec) {
    return function ($receiver) {
      if (!closure$changeValueCommand.policy.isDefault())
        $receiver.set_puj7f4$('policy', closure$changeValueCommand.policy.name);
      $receiver.set_puj7f4$('modelId', closure$changeValueCommand.modelId.stringId);
      $receiver.set_puj7f4$('propertyName', closure$changeValueCommand.propertyName.name);
      $receiver.set_6xncmk$('value', this$ChangeValueCommandCodec.jsonFactory_0.newJson_1j20nt$(ChangeValueCommandCodec$encode$lambda$lambda$lambda(closure$changeValueCommand)));
    };
  }
  function ChangeValueCommandCodec$encode$lambda(closure$changeValueCommand, this$ChangeValueCommandCodec) {
    return function ($receiver) {
      var tmp$;
      $receiver.set_puj7f4$('type', (tmp$ = Kotlin.getKClass(ChangeValueCommandData).simpleName) != null ? tmp$ : Kotlin.throwNPE());
      $receiver.set_8wy9ij$('data', ChangeValueCommandCodec$encode$lambda$lambda(closure$changeValueCommand, this$ChangeValueCommandCodec));
    };
  }
  ChangeValueCommandCodec.prototype.encode_anzskc$ = function (untypedCommandData) {
    var tmp$;
    var changeValueCommand = Kotlin.isType(tmp$ = untypedCommandData, ChangeValueCommandData) ? tmp$ : Kotlin.throwCCE();
    return this.jsonFactory_0.newJson_1j20nt$(ChangeValueCommandCodec$encode$lambda(changeValueCommand, this));
  };
  ChangeValueCommandCodec.prototype.decode_bor1xe$ = function (source, json) {
    var tmp$, tmp$_0;
    var data = json.getObject_61zpoe$('data');
    var policy = (tmp$_0 = (tmp$ = data.optionalString_61zpoe$('policy')) != null ? ApplyPolicy$valueOf(tmp$) : null) != null ? tmp$_0 : ApplyPolicy$DEFAULT_getInstance();
    var modelId = new ModelId(data.string_61zpoe$('modelId'));
    var propertyName = new PropertyName(data.string_61zpoe$('propertyName'));
    var tmp$_1 = valueFromJson(data.getObject_61zpoe$('value'));
    var tag = tmp$_1.component1()
    , value = tmp$_1.component2();
    return new ChangeValueCommandData(source, modelId, propertyName, tag, value, policy);
  };
  ChangeValueCommandCodec.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ChangeValueCommandCodec',
    interfaces: [CommandCodec]
  };
  function CreateModelCommandCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
  }
  function CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda$lambda$lambda(closure$tag, closure$value) {
    return function ($receiver) {
      valueToJson($receiver, closure$tag, closure$value);
    };
  }
  function CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda$lambda(this$CreateModelCommandCodec) {
    return function (f) {
      var tag = f.component1()
      , value = f.component2();
      return this$CreateModelCommandCodec.jsonFactory_0.newJson_1j20nt$(CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda$lambda$lambda(tag, value));
    };
  }
  function CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda(closure$it, this$CreateModelCommandCodec) {
    return function ($receiver) {
      $receiver.set_puj7f4$('propertyName', closure$it.name.name);
      $receiver.set_jqxvxq$('values', new JsonArray(toList(map(closure$it.getValues(), CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda$lambda(this$CreateModelCommandCodec)))));
    };
  }
  function CreateModelCommandCodec$encode$lambda$lambda(closure$createCommand, this$CreateModelCommandCodec) {
    return function ($receiver) {
      $receiver.set_puj7f4$('modelId', closure$createCommand.modelId.stringId);
      $receiver.set_puj7f4$('type', closure$createCommand.modelType.stringId);
      var $receiver_0 = closure$createCommand.properties;
      var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$($receiver_0, 10));
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        var tmp$_0 = destination.add_11rb$;
        var this$CreateModelCommandCodec_0 = this$CreateModelCommandCodec;
        tmp$_0.call(destination, this$CreateModelCommandCodec_0.jsonFactory_0.newJson_1j20nt$(CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda(item, this$CreateModelCommandCodec_0)));
      }
      $receiver.set_jqxvxq$('properties', new JsonArray(destination));
    };
  }
  function CreateModelCommandCodec$encode$lambda(closure$createCommand, this$CreateModelCommandCodec) {
    return function ($receiver) {
      var tmp$;
      $receiver.set_puj7f4$('type', (tmp$ = Kotlin.getKClass(CreateModelCommandData).simpleName) != null ? tmp$ : Kotlin.throwNPE());
      $receiver.set_8wy9ij$('data', CreateModelCommandCodec$encode$lambda$lambda(closure$createCommand, this$CreateModelCommandCodec));
    };
  }
  CreateModelCommandCodec.prototype.encode_anzskc$ = function (untypedCommandData) {
    var tmp$;
    var createCommand = Kotlin.isType(tmp$ = untypedCommandData, CreateModelCommandData) ? tmp$ : Kotlin.throwCCE();
    return this.jsonFactory_0.newJson_1j20nt$(CreateModelCommandCodec$encode$lambda(createCommand, this));
  };
  CreateModelCommandCodec.prototype.decode_bor1xe$ = function (source, json) {
    var data = json.getObject_61zpoe$('data');
    var properties = data.oArray_61zpoe$('properties');
    var tmp$ = new ModelId(data.string_61zpoe$('modelId'));
    var tmp$_0 = new ModelType(data.string_61zpoe$('type'));
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$(properties, 10));
    var tmp$_1;
    tmp$_1 = properties.iterator();
    while (tmp$_1.hasNext()) {
      var item = tmp$_1.next();
      var tmp$_2 = destination.add_11rb$;
      var values = item.oArray_61zpoe$('values');
      tmp$_2.call(destination, new Property(new PropertyName(item.string_61zpoe$('propertyName')), map(asSequence(values), Kotlin.getCallableRef('valueFromJson', function (json) {
        return valueFromJson(json);
      }))));
    }
    return new CreateModelCommandData(source, tmp$, tmp$_0, destination);
  };
  CreateModelCommandCodec.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'CreateModelCommandCodec',
    interfaces: [CommandCodec]
  };
  function RemoveModelByTypeCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
  }
  function RemoveModelByTypeCodec$encode$lambda$lambda(closure$commandData) {
    return function ($receiver) {
      $receiver.set_puj7f4$('modelTypeId', closure$commandData.modelType.stringId);
    };
  }
  function RemoveModelByTypeCodec$encode$lambda(closure$commandData) {
    return function ($receiver) {
      var tmp$;
      $receiver.set_puj7f4$('type', (tmp$ = Kotlin.getKClass(RemoveModelByTypeCommandData).simpleName) != null ? tmp$ : Kotlin.throwNPE());
      $receiver.set_8wy9ij$('data', RemoveModelByTypeCodec$encode$lambda$lambda(closure$commandData));
    };
  }
  RemoveModelByTypeCodec.prototype.encode_anzskc$ = function (untypedCommandData) {
    var tmp$;
    var commandData = Kotlin.isType(tmp$ = untypedCommandData, RemoveModelByTypeCommandData) ? tmp$ : Kotlin.throwCCE();
    return this.jsonFactory_0.newJson_1j20nt$(RemoveModelByTypeCodec$encode$lambda(commandData));
  };
  RemoveModelByTypeCodec.prototype.decode_bor1xe$ = function (source, json) {
    var data = json.getObject_61zpoe$('data');
    return new RemoveModelByTypeCommandData(source, new ModelType(data.string_61zpoe$('modelTypeId')));
  };
  RemoveModelByTypeCodec.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'RemoveModelByTypeCodec',
    interfaces: [CommandCodec]
  };
  function SyncModelCommandCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
  }
  function SyncModelCommandCodec$encode$lambda$lambda(closure$commandData) {
    return function ($receiver) {
      $receiver.set_puj7f4$('src', closure$commandData.sourceModel.stringId);
      $receiver.set_puj7f4$('dst', closure$commandData.destinationModel.stringId);
    };
  }
  function SyncModelCommandCodec$encode$lambda(closure$commandData) {
    return function ($receiver) {
      var tmp$;
      $receiver.set_puj7f4$('type', (tmp$ = Kotlin.getKClass(SyncModelCommandData).simpleName) != null ? tmp$ : Kotlin.throwNPE());
      $receiver.set_8wy9ij$('data', SyncModelCommandCodec$encode$lambda$lambda(closure$commandData));
    };
  }
  SyncModelCommandCodec.prototype.encode_anzskc$ = function (untypedCommandData) {
    var tmp$;
    var commandData = Kotlin.isType(tmp$ = untypedCommandData, SyncModelCommandData) ? tmp$ : Kotlin.throwCCE();
    return this.jsonFactory_0.newJson_1j20nt$(SyncModelCommandCodec$encode$lambda(commandData));
  };
  SyncModelCommandCodec.prototype.decode_bor1xe$ = function (source, json) {
    var data = json.getObject_61zpoe$('data');
    return new SyncModelCommandData(source, new ModelId(data.string_61zpoe$('src')), new ModelId(data.string_61zpoe$('dst')));
  };
  SyncModelCommandCodec.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'SyncModelCommandCodec',
    interfaces: [CommandCodec]
  };
  function valueToJson(jsonObj, tag, value) {
    if (!(typeof value === 'string')) {
      jsonObj.set_puj7f4$('type', getJsonTypeId(value));
    }
    jsonObj.set_puj7f4$('value', asJsonValue(value));
    if (!(tag != null ? tag.equals(Tag$Companion_getInstance().VALUE) : null)) {
      jsonObj.set_puj7f4$('tag', tag.name);
    }
    return jsonObj;
  }
  function getJsonTypeId($receiver) {
    var tmp$;
    if (typeof $receiver === 'string')
      tmp$ = 'String';
    else if (typeof $receiver === 'boolean')
      tmp$ = 'Boolean';
    else if (Kotlin.isType($receiver, ModelId))
      tmp$ = 'ModelId';
    else if (typeof $receiver === 'number')
      tmp$ = 'Double';
    else if (typeof $receiver === 'number')
      tmp$ = 'Float';
    else if (Kotlin.isType($receiver, Kotlin.Long))
      tmp$ = 'Long';
    else if (typeof $receiver === 'number')
      tmp$ = 'Int';
    else if (Kotlin.isChar($receiver))
      tmp$ = 'Char';
    else if (typeof $receiver === 'number')
      tmp$ = 'Short';
    else
      throw new IllegalArgumentException("Type of value '" + $receiver + "' not be supported.");
    return tmp$;
  }
  function asJsonValue($receiver) {
    return $receiver.toString();
  }
  function valueFromJson(json) {
    var tmp$, tmp$_0, tmp$_1;
    var type = (tmp$ = json.optionalString_61zpoe$('type')) != null ? tmp$ : 'String';
    if (Kotlin.equals(type, 'String'))
      tmp$_0 = json.string_61zpoe$('value');
    else if (Kotlin.equals(type, 'Boolean'))
      tmp$_0 = json.boolean_61zpoe$('value');
    else if (Kotlin.equals(type, 'ModelId'))
      tmp$_0 = new ModelId(json.string_61zpoe$('value'));
    else if (Kotlin.equals(type, 'Int'))
      tmp$_0 = json.integer_61zpoe$('value');
    else if (Kotlin.equals(type, 'Long'))
      tmp$_0 = json.long_61zpoe$('value');
    else if (Kotlin.equals(type, 'Float'))
      tmp$_0 = json.float_61zpoe$('value');
    else if (Kotlin.equals(type, 'Double'))
      tmp$_0 = json.double_61zpoe$('value');
    else if (Kotlin.equals(type, 'Char'))
      tmp$_0 = json.string_61zpoe$('value').charCodeAt(0);
    else if (Kotlin.equals(type, 'Short'))
      tmp$_0 = Kotlin.toShort(json.integer_61zpoe$('value'));
    else {
      throw new IllegalArgumentException("Unknown propertyValue type: '" + type + "'");
    }
    var value = tmp$_0;
    var tag = (tmp$_1 = json.optionalString_61zpoe$('tag')) != null ? tmp$_1 : Tag$Companion_getInstance().VALUE.name;
    return new Pair(new Tag(tag), value);
  }
  function ModelBuilder() {
  }
  ModelBuilder.prototype.build_tytvht$ = function (source, policy, callback$default) {
    if (policy === void 0)
      policy = ApplyPolicy$DEFAULT_getInstance();
    return callback$default ? callback$default(source, policy) : this.build_tytvht$$default(source, policy);
  };
  ModelBuilder.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'ModelBuilder',
    interfaces: []
  };
  function ModelStore() {
  }
  ModelStore.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'ModelStore',
    interfaces: []
  };
  function PresentationModel() {
  }
  PresentationModel.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'PresentationModel',
    interfaces: []
  };
  function PresentationModelBuilder(modelId, modelType, block) {
    this.modelId = modelId;
    this.modelType = modelType;
    this.properties_0 = ArrayList_init();
    block(this);
  }
  Object.defineProperty(PresentationModelBuilder.prototype, 'propertyList', {
    get: function () {
      return this.properties_0;
    }
  });
  PresentationModelBuilder.prototype.build_tytvht$$default = function (source, policy) {
    return new CreateModelCommandData(source, this.modelId, this.modelType, this.properties_0, policy);
  };
  PresentationModelBuilder.prototype.property_o74rtj$ = function (name, block) {
    var builder = new PresentationModelBuilder$PropertyBuilder(this, name);
    block(builder);
    this.properties_0.add_11rb$(builder.build());
  };
  PresentationModelBuilder.prototype.createProperty_0 = function (name, values) {
    return new Property(name, values);
  };
  function PresentationModelBuilder$PropertyBuilder($outer, name) {
    this.$outer = $outer;
    this.name = name;
    this.values = LinkedHashMap_init();
  }
  Object.defineProperty(PresentationModelBuilder$PropertyBuilder.prototype, 'label', {
    get: function () {
      var tmp$;
      return typeof (tmp$ = this.get_ol557t$(Tag$Companion_getInstance().LABEL)) === 'string' ? tmp$ : Kotlin.throwCCE();
    },
    set: function (value) {
      this.set_jcm6gy$(Tag$Companion_getInstance().LABEL, value);
    }
  });
  Object.defineProperty(PresentationModelBuilder$PropertyBuilder.prototype, 'toolTip', {
    get: function () {
      var tmp$;
      return typeof (tmp$ = this.get_ol557t$(Tag$Companion_getInstance().TOOL_TIP)) === 'string' ? tmp$ : Kotlin.throwCCE();
    },
    set: function (value) {
      this.set_jcm6gy$(Tag$Companion_getInstance().TOOL_TIP, value);
    }
  });
  Object.defineProperty(PresentationModelBuilder$PropertyBuilder.prototype, 'value', {
    get: function () {
      return this.get_ol557t$(Tag$Companion_getInstance().VALUE);
    },
    set: function (value) {
      this.set_jcm6gy$(Tag$Companion_getInstance().VALUE, value);
    }
  });
  PresentationModelBuilder$PropertyBuilder.prototype.set_jcm6gy$ = function (tag, propertyValue) {
    this.values.put_xwzc9p$(tag, propertyValue);
  };
  PresentationModelBuilder$PropertyBuilder.prototype.get_ol557t$ = function (typeName) {
    var tmp$;
    return (tmp$ = this.values.get_11rb$(typeName)) != null ? tmp$ : Kotlin.throwNPE();
  };
  PresentationModelBuilder$PropertyBuilder.prototype.build = function () {
    var tmp$ = this.$outer;
    var tmp$_0 = this.name;
    var $receiver = this.values.entries;
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$($receiver, 10));
    var tmp$_1;
    tmp$_1 = $receiver.iterator();
    while (tmp$_1.hasNext()) {
      var item = tmp$_1.next();
      var tmp$_2 = destination.add_11rb$;
      var key = item.key;
      var value = item.value;
      tmp$_2.call(destination, new Pair(key, value));
    }
    return tmp$.createProperty_0(tmp$_0, asSequence(destination));
  };
  PresentationModelBuilder$PropertyBuilder.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'PropertyBuilder',
    interfaces: []
  };
  PresentationModelBuilder.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'PresentationModelBuilder',
    interfaces: [ModelBuilder]
  };
  function Property(name, initialValues) {
    this.name = name;
    var $receiver = HashMap_init();
    var tmp$;
    tmp$ = initialValues.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var key = element.component1()
      , value = element.component2();
      $receiver.put_xwzc9p$(key, value);
    }
    this.propertyValue2Values_0 = $receiver;
  }
  Property.prototype.set_jcm6gy$ = function (tag, value) {
    var oldValue = this.propertyValue2Values_0.get_11rb$(tag);
    this.propertyValue2Values_0.put_xwzc9p$(tag, value);
    return oldValue;
  };
  function Property$getValuesArray$lambda(it) {
    return new Pair(it.key, it.value);
  }
  Property.prototype.getValuesArray = function () {
    var $receiver = toList(map(asSequence(this.propertyValue2Values_0.entries), Property$getValuesArray$lambda));
    return Kotlin.kotlin.collections.copyToArray($receiver);
  };
  function Property$getValues$lambda(it) {
    return new Pair(it.key, it.value);
  }
  Property.prototype.getValues = function () {
    return map(asSequence(this.propertyValue2Values_0.entries), Property$getValues$lambda);
  };
  Property.prototype.get_ol557t$ = function (tag) {
    if (tag === void 0)
      tag = Tag$Companion_getInstance().VALUE;
    var tmp$;
    tmp$ = this.propertyValue2Values_0.get_11rb$(tag);
    if (tmp$ == null) {
      throw new IllegalArgumentException("No value for tag '" + tag + "'");
    }
    return tmp$;
  };
  function Property$getValue$lambda(it) {
    return Kotlin.getKClassFromExpression(it).simpleName;
  }
  Property.prototype.getValue_55j8nk$ = Kotlin.defineInlineFunction('openorca-js-client.ch.viseon.openOrca.share.Property.getValue_55j8nk$', function (T_0, isT, tag) {
    if (tag === void 0)
      tag = _.ch.viseon.openOrca.share.Tag.Companion.VALUE;
    var tmp$, tmp$_0;
    var get = this.get_ol557t$(tag);
    tmp$_0 = isT(tmp$ = get) ? tmp$ : null;
    if (tmp$_0 == null) {
      throw new Kotlin.kotlin.IllegalArgumentException('Value is not of type ' + Kotlin.getKClass(T_0) + ". Actual value '" + get + "' Type: " + Kotlin.toString(Kotlin.getKClassFromExpression(get).simpleName));
    }
    return tmp$_0;
  });
  Property.prototype.toString = function () {
    return this.name + ': values: ' + this.propertyValue2Values_0;
  };
  Property.prototype.hasValue_ol557t$ = function (tag) {
    if (tag === void 0)
      tag = Tag$Companion_getInstance().VALUE;
    return this.propertyValue2Values_0.containsKey_11rb$(tag);
  };
  Property.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'Property',
    interfaces: []
  };
  function Source(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Source_initFields() {
    Source_initFields = function () {
    };
    Source$REQUEST_instance = new Source('REQUEST', 0);
    Source$RESPONSE_instance = new Source('RESPONSE', 1);
  }
  var Source$REQUEST_instance;
  function Source$REQUEST_getInstance() {
    Source_initFields();
    return Source$REQUEST_instance;
  }
  var Source$RESPONSE_instance;
  function Source$RESPONSE_getInstance() {
    Source_initFields();
    return Source$RESPONSE_instance;
  }
  Source.prototype.isRequest = function () {
    return this === Source$REQUEST_getInstance();
  };
  Source.prototype.isResponse = function () {
    return this === Source$RESPONSE_getInstance();
  };
  Source.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'Source',
    interfaces: [Enum]
  };
  function Source$values() {
    return [Source$REQUEST_getInstance(), Source$RESPONSE_getInstance()];
  }
  Source.values = Source$values;
  function Source$valueOf(name) {
    switch (name) {
      case 'REQUEST':
        return Source$REQUEST_getInstance();
      case 'RESPONSE':
        return Source$RESPONSE_getInstance();
      default:Kotlin.throwISE('No enum constant ch.viseon.openOrca.share.Source.' + name);
    }
  }
  Source.valueOf_61zpoe$ = Source$valueOf;
  function Tag(name) {
    Tag$Companion_getInstance();
    this.name = name;
  }
  function Tag$Companion() {
    Tag$Companion_instance = this;
    this.VALUE = new Tag('value');
    this.LABEL = new Tag('label');
    this.TOOL_TIP = new Tag('toolTip');
    this.REG_EX = new Tag('regex');
    this.COMPONENT_TYPE = new Tag('componentType');
  }
  Tag$Companion.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Tag$Companion_instance = null;
  function Tag$Companion_getInstance() {
    if (Tag$Companion_instance === null) {
      new Tag$Companion();
    }
    return Tag$Companion_instance;
  }
  Tag.prototype.toString = function () {
    return this.name;
  };
  Tag.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'Tag',
    interfaces: []
  };
  Tag.prototype.component1 = function () {
    return this.name;
  };
  Tag.prototype.copy_61zpoe$ = function (name) {
    return new Tag(name === void 0 ? this.name : name);
  };
  Tag.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    return result;
  };
  Tag.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.name, other.name))));
  };
  function DefaultPresentationModel(id, type, properties) {
    this.id_yri6lt$_0 = id;
    this.type_yri6lt$_0 = type;
    var $receiver = LinkedHashMap_init();
    var tmp$;
    tmp$ = properties.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var key = element.name;
      $receiver.put_xwzc9p$(key, element);
    }
    this.properties_0 = $receiver;
  }
  Object.defineProperty(DefaultPresentationModel.prototype, 'id', {
    get: function () {
      return this.id_yri6lt$_0;
    }
  });
  Object.defineProperty(DefaultPresentationModel.prototype, 'type', {
    get: function () {
      return this.type_yri6lt$_0;
    }
  });
  DefaultPresentationModel.prototype.getPropertiesArray = function () {
    var $receiver = this.properties_0.values;
    return Kotlin.kotlin.collections.copyToArray($receiver);
  };
  DefaultPresentationModel.prototype.getProperties = function () {
    return asSequence(this.properties_0.values);
  };
  DefaultPresentationModel.prototype.propertyCount = function () {
    return this.properties_0.size;
  };
  DefaultPresentationModel.prototype.get_lqljjj$ = function (propertyName) {
    var tmp$;
    tmp$ = this.properties_0.get_11rb$(propertyName);
    if (tmp$ == null) {
      throw new IllegalArgumentException("Property '" + propertyName + "' not found");
    }
    return tmp$;
  };
  DefaultPresentationModel.prototype.toString = function () {
    var $receiver = this.properties_0;
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$($receiver.size);
    var tmp$;
    tmp$ = $receiver.entries.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(item.value.toString());
    }
    return destination.toString();
  };
  DefaultPresentationModel.prototype.hasProperty_lqljjj$ = function (name) {
    return this.properties_0.containsKey_11rb$(name);
  };
  DefaultPresentationModel.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'DefaultPresentationModel',
    interfaces: [PresentationModel]
  };
  function DefaultPresentationModelStore() {
    this.models_0 = LinkedHashMap_init();
    this.modelType2Model_0 = HashMap_init();
  }
  DefaultPresentationModelStore.prototype.addModel_pl55oe$ = function (model) {
    var $receiver = this.models_0;
    var key = model.id;
    $receiver.put_xwzc9p$(key, model);
    var $receiver_0 = this.modelType2Model_0;
    var key_0 = model.type;
    var tmp$;
    var value = $receiver_0.get_11rb$(key_0);
    if (value == null) {
      var answer = ArrayList_init();
      $receiver_0.put_xwzc9p$(key_0, answer);
      tmp$ = answer;
    }
     else {
      tmp$ = value;
    }
    tmp$.add_11rb$(model);
  };
  DefaultPresentationModelStore.prototype.get_accdal$ = function (modelId) {
    var tmp$;
    tmp$ = this.models_0.get_11rb$(modelId);
    if (tmp$ == null) {
      throw new IllegalArgumentException("No model with id '" + modelId + "' present.");
    }
    return tmp$;
  };
  DefaultPresentationModelStore.prototype.get_4tsc7m$ = function (modelType) {
    var tmp$;
    return (tmp$ = this.modelType2Model_0.get_11rb$(modelType)) != null ? tmp$ : Kotlin.kotlin.collections.emptyList_287e2$();
  };
  DefaultPresentationModelStore.prototype.removeModel_accdal$ = function (modelId) {
    var tmp$, tmp$_0;
    var removedPm = (tmp$ = this.models_0.remove_11rb$(modelId)) != null ? tmp$ : Kotlin.throwNPE();
    (tmp$_0 = this.modelType2Model_0.get_11rb$(removedPm.type)) != null ? tmp$_0.remove_11rb$(removedPm) : null;
    return removedPm;
  };
  DefaultPresentationModelStore.prototype.removeModels_4tsc7m$ = function (modelType) {
    var removedPms = this.modelType2Model_0.remove_11rb$(modelType);
    if (removedPms != null) {
      var tmp$;
      tmp$ = removedPms.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        this.models_0.remove_11rb$(element.id);
      }
    }
    return removedPms != null ? removedPms : emptyList();
  };
  DefaultPresentationModelStore.prototype.contains_accdal$ = function (modelId) {
    var $receiver = this.models_0;
    var tmp$;
    return (Kotlin.isType(tmp$ = $receiver, Kotlin.kotlin.collections.Map) ? tmp$ : Kotlin.throwCCE()).containsKey_11rb$(modelId);
  };
  DefaultPresentationModelStore.prototype.contains_4tsc7m$ = function (modelType) {
    var tmp$, tmp$_0;
    return ((tmp$_0 = (tmp$ = this.modelType2Model_0.get_11rb$(modelType)) != null ? tmp$.size : null) != null ? tmp$_0 : 0) > 0;
  };
  DefaultPresentationModelStore.prototype.getAllModels = function () {
    return this.models_0.values;
  };
  DefaultPresentationModelStore.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'DefaultPresentationModelStore',
    interfaces: [ModelStore]
  };
  var package$ch = _.ch || (_.ch = {});
  var package$viseon = package$ch.viseon || (package$ch.viseon = {});
  var package$openOrca = package$viseon.openOrca || (package$viseon.openOrca = {});
  var package$client = package$openOrca.client || (package$openOrca.client = {});
  package$client.ClientOrca = ClientOrca;
  Object.defineProperty(RequestEvent, 'START', {
    get: RequestEvent$START_getInstance
  });
  Object.defineProperty(RequestEvent, 'END', {
    get: RequestEvent$END_getInstance
  });
  package$client.RequestEvent = RequestEvent;
  $$importsForInline$$['kodando-rxjs'] = $module$kodando_rxjs;
  package$client.ClientOrcaImpl = ClientOrcaImpl;
  package$client.CommandListExecutor = CommandListExecutor;
  package$client.ClientCommandListExecutor = ClientCommandListExecutor;
  package$client.JsonFactoryJs = JsonFactoryJs;
  package$client.JsonObjJs_init_1j20nt$ = JsonObjJs_init;
  package$client.JsonObjJs = JsonObjJs;
  package$client.just_mh5how$ = just;
  package$client.Transmitter = Transmitter;
  package$client.XMLHttpRequestTransmitter = XMLHttpRequestTransmitter;
  var package$share = package$openOrca.share || (package$openOrca.share = {});
  package$share.StringCodec = StringCodec;
  Object.defineProperty(CommandApplication, 'Companion', {
    get: CommandApplication$Companion_getInstance
  });
  package$share.CommandApplication = CommandApplication;
  Object.defineProperty(package$share, 'CommandApplier', {
    get: CommandApplier_getInstance
  });
  package$share.CommandExecutor = CommandExecutor;
  Object.defineProperty(ApplyPolicy, 'DEFAULT', {
    get: ApplyPolicy$DEFAULT_getInstance
  });
  Object.defineProperty(ApplyPolicy, 'FORCE_SEND', {
    get: ApplyPolicy$FORCE_SEND_getInstance
  });
  Object.defineProperty(ApplyPolicy, 'FORCE_APPLY', {
    get: ApplyPolicy$FORCE_APPLY_getInstance
  });
  package$share.ApplyPolicy = ApplyPolicy;
  package$share.CommandData = CommandData;
  package$share.ChangeValueCommandData = ChangeValueCommandData;
  package$share.CreateModelCommandData = CreateModelCommandData;
  package$share.RemoveModelCommandData = RemoveModelCommandData;
  package$share.ActionCommandData = ActionCommandData;
  package$share.RemoveModelByTypeCommandData = RemoveModelByTypeCommandData;
  package$share.SyncModelCommandData = SyncModelCommandData;
  package$share.Event = Event;
  Object.defineProperty(ModelStoreChangeEventType, 'ADD', {
    get: ModelStoreChangeEventType$ADD_getInstance
  });
  Object.defineProperty(ModelStoreChangeEventType, 'REMOVE', {
    get: ModelStoreChangeEventType$REMOVE_getInstance
  });
  package$share.ModelStoreChangeEventType = ModelStoreChangeEventType;
  package$share.ModelStoreChangeEvent = ModelStoreChangeEvent;
  package$share.PropertyChangeEvent = PropertyChangeEvent;
  package$share.ValueChangeEvent = ValueChangeEvent;
  package$share.ActionEvent = ActionEvent;
  package$share.ModelId = ModelId;
  package$share.ModelType = ModelType;
  package$share.PropertyName = PropertyName;
  package$share.JsonArray = JsonArray;
  package$share.JsonObj = JsonObj;
  package$share.JsonFactory = JsonFactory;
  package$share.JsonCodec = JsonCodec;
  package$share.CommandCodec = CommandCodec;
  package$share.RemoveModelByTypeCodec = RemoveModelByTypeCodec;
  package$share.SyncModelCommandCodec = SyncModelCommandCodec;
  package$share.valueToJson_ixxqss$ = valueToJson;
  package$share.valueFromJson_ipy83i$ = valueFromJson;
  package$share.ModelBuilder = ModelBuilder;
  package$share.ModelStore = ModelStore;
  package$share.PresentationModel = PresentationModel;
  PresentationModelBuilder.PropertyBuilder = PresentationModelBuilder$PropertyBuilder;
  package$share.PresentationModelBuilder = PresentationModelBuilder;
  Object.defineProperty(Tag, 'Companion', {
    get: Tag$Companion_getInstance
  });
  Property.getValue$f = Property$getValue$lambda;
  package$share.Property = Property;
  Object.defineProperty(Source, 'REQUEST', {
    get: Source$REQUEST_getInstance
  });
  Object.defineProperty(Source, 'RESPONSE', {
    get: Source$RESPONSE_getInstance
  });
  package$share.Source = Source;
  package$share.Tag = Tag;
  var package$impl = package$share.impl || (package$share.impl = {});
  package$impl.DefaultPresentationModel = DefaultPresentationModel;
  package$impl.DefaultPresentationModelStore = DefaultPresentationModelStore;
  ClientCommandListExecutor.prototype.execute_sy5qnb$ = CommandListExecutor.prototype.execute_sy5qnb$;
  CreateModelExecutor.prototype.forceApply_ls2jj0$ = CommandExecutor.prototype.forceApply_ls2jj0$;
  ChangeValueExecutor.prototype.forceApply_ls2jj0$ = CommandExecutor.prototype.forceApply_ls2jj0$;
  ActionExecutor.prototype.forceApply_ls2jj0$ = CommandExecutor.prototype.forceApply_ls2jj0$;
  RemoveModelExecutor.prototype.forceApply_ls2jj0$ = CommandExecutor.prototype.forceApply_ls2jj0$;
  RemoveModelByTypeExecutor.prototype.forceApply_ls2jj0$ = CommandExecutor.prototype.forceApply_ls2jj0$;
  SyncModelExecutor.prototype.forceApply_ls2jj0$ = CommandExecutor.prototype.forceApply_ls2jj0$;
  PresentationModelBuilder.prototype.build_tytvht$ = ModelBuilder.prototype.build_tytvht$;
  Kotlin.defineModule('openorca-js-client', _);
  return _;
}));

//# sourceMappingURL=openorca-js-client.js.map
