/*
 * Copyright 2017 viseon gmbh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ch.viseon.openOrca.client

import ch.viseon.openOrca.share.*
import kodando.rxjs.Rx

/**
 * The observer* methods allow a declarative approach to listen to changes.
 *
 */
interface ClientOrca {

  fun observeModelStore(): Rx.IObservable<ModelStoreChangeEvent>
  fun observeModel(modelId: ModelId): Rx.IObservable<PropertyChangeEvent>
  fun observeModel(modelType: ModelType): Rx.IObservable<PropertyChangeEvent>
  fun observeProperty(modelId: ModelId, propertyName: PropertyName): Rx.IObservable<ValueChangeEvent>

  fun model(modelId: ModelId): PresentationModel
  fun model(modelType: ModelType): Collection<PresentationModel>

  fun registerNamedCommand(actionName: String): Rx.IObservable<ActionEvent>

  //Process and send a series of commands.
  fun executeCommands(commands: Array<CommandData>)

}

