(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define('openorca-js-client', ['exports', 'kotlin', 'rxjs/Rx', 'kodando-rxjs'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('rxjs/Rx'), require('kodando-rxjs'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'openorca-js-client'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'openorca-js-client'.");
    }
    if (typeof Rx === 'undefined') {
      throw new Error("Error loading module 'openorca-js-client'. Its dependency 'rxjs/Rx' was not found. Please, check whether 'rxjs/Rx' is loaded prior to 'openorca-js-client'.");
    }
    if (typeof this['kodando-rxjs'] === 'undefined') {
      throw new Error("Error loading module 'openorca-js-client'. Its dependency 'kodando-rxjs' was not found. Please, check whether 'kodando-rxjs' is loaded prior to 'openorca-js-client'.");
    }
    root['openorca-js-client'] = factory(typeof this['openorca-js-client'] === 'undefined' ? {} : this['openorca-js-client'], kotlin, Rx, this['kodando-rxjs']);
  }
}(this, function (_, Kotlin, $module$rxjs_Rx, $module$kodando_rxjs) {
  'use strict';
  var asIterable = Kotlin.kotlin.collections.asIterable_us0mfu$;
  var toMutableList = Kotlin.kotlin.collections.toMutableList_4c7yge$;
  var json = Kotlin.kotlin.js.json_pyyo18$;
  var IllegalArgumentException = Kotlin.kotlin.IllegalArgumentException;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var mapOf = Kotlin.kotlin.collections.mapOf_qfcya0$;
  var asSequence = Kotlin.kotlin.collections.asSequence_7wnvza$;
  var toList = Kotlin.kotlin.collections.toList_7wnvza$;
  var map_2 = Kotlin.kotlin.sequences.map_z5avom$;
  var flatMap_0 = Kotlin.kotlin.sequences.flatMap_49vfel$;
  var toList_0 = Kotlin.kotlin.sequences.toList_veqyi0$;
  var Error_0 = Kotlin.kotlin.Error;
  var Exception = Kotlin.kotlin.Exception;
  var Enum = Kotlin.kotlin.Enum;
  var println = Kotlin.kotlin.io.println_s8jyv4$;
  var HashMap_init = Kotlin.kotlin.collections.HashMap_init_q3lmfv$;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var Iterable = Kotlin.kotlin.collections.Iterable;
  var joinToString = Kotlin.kotlin.sequences.joinToString_853xkz$;
  ModelIdValue.prototype = Object.create(ValuePropertyValue.prototype);
  ModelIdValue.prototype.constructor = ModelIdValue;
  StringValue.prototype = Object.create(ValuePropertyValue.prototype);
  StringValue.prototype.constructor = StringValue;
  BooleanValue.prototype = Object.create(ValuePropertyValue.prototype);
  BooleanValue.prototype.constructor = BooleanValue;
  Source.prototype = Object.create(Enum.prototype);
  Source.prototype.constructor = Source;
  ModelStoreChangeEvent$Type.prototype = Object.create(Enum.prototype);
  ModelStoreChangeEvent$Type.prototype.constructor = ModelStoreChangeEvent$Type;
  function ClientOrca() {
  }
  ClientOrca.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'ClientOrca',
    interfaces: []
  };
  function just(t) {
    return $module$rxjs_Rx.Observable.of(t);
  }
  function JsonFactoryJs() {
  }
  JsonFactoryJs.prototype.newJson_1j20nt$ = function (block) {
    return JsonObjJs_init(block);
  };
  JsonFactoryJs.prototype.parse_61zpoe$ = function (content) {
    var $receiver = JSON.parse(content);
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$($receiver.length);
    var tmp$;
    for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
      var item = $receiver[tmp$];
      destination.add_11rb$(new JsonObjJs(item));
    }
    return new JsonArray(destination);
  };
  JsonFactoryJs.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'JsonFactoryJs',
    interfaces: [JsonFactory]
  };
  function JsonObjJs(json_0) {
    if (json_0 === void 0)
      json_0 = json([]);
    this.json = json_0;
  }
  JsonObjJs.prototype.boolean_61zpoe$ = function (key) {
    var tmp$;
    return typeof (tmp$ = this.json[key]) === 'boolean' ? tmp$ : Kotlin.throwCCE();
  };
  JsonObjJs.prototype.pArray_ytbaoo$ = function (key) {
    var tmp$;
    var array = Array.isArray(tmp$ = this.json[key]) ? tmp$ : Kotlin.throwCCE();
    return new JsonArray(asIterable(array));
  };
  JsonObjJs.prototype.oArray_61zpoe$ = function (key) {
    var tmp$;
    var $receiver = Array.isArray(tmp$ = this.json[key]) ? tmp$ : Kotlin.throwCCE();
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$($receiver.length);
    var tmp$_0;
    for (tmp$_0 = 0; tmp$_0 !== $receiver.length; ++tmp$_0) {
      var item = $receiver[tmp$_0];
      destination.add_11rb$(new JsonObjJs(item));
    }
    var values = toMutableList(destination);
    return new JsonArray(values);
  };
  JsonObjJs.prototype.string_61zpoe$ = function (key) {
    var tmp$;
    return typeof (tmp$ = this.json[key]) === 'string' ? tmp$ : Kotlin.throwCCE();
  };
  JsonObjJs.prototype.getObject_61zpoe$ = function (key) {
    var tmp$;
    return new JsonObjJs(Kotlin.isType(tmp$ = this.json[key], Object) ? tmp$ : Kotlin.throwCCE());
  };
  JsonObjJs.prototype.set_puj7f4$ = function (key, value) {
    this.json[key] = value;
  };
  JsonObjJs.prototype.set_ivxn3r$ = function (key, value) {
    this.json[key] = value;
  };
  JsonObjJs.prototype.set_6xncmk$ = function (key, value) {
    var tmp$;
    this.json[key] = (Kotlin.isType(tmp$ = value, JsonObjJs) ? tmp$ : Kotlin.throwCCE()).json;
  };
  JsonObjJs.prototype.set_jqxvxq$ = function (key, value) {
    var tmp$ = this.json;
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$(value, 10));
    var tmp$_0;
    tmp$_0 = value.iterator();
    while (tmp$_0.hasNext()) {
      var item = tmp$_0.next();
      var tmp$_1;
      destination.add_11rb$((Kotlin.isType(tmp$_1 = item, JsonObjJs) ? tmp$_1 : Kotlin.throwCCE()).json);
    }
    tmp$[key] = destination;
  };
  JsonObjJs.prototype.set_poujtz$ = function (key, value) {
    this.json[key] = value;
  };
  JsonObjJs.prototype.set_8wy9ij$ = function (key, block) {
    var subJsonObj = new JsonObjJs();
    block(subJsonObj);
    this.json[key] = subJsonObj.json;
  };
  JsonObjJs.prototype.toJsonString = function () {
    return JSON.stringify(this.json);
  };
  JsonObjJs.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'JsonObjJs',
    interfaces: [JsonObj]
  };
  function JsonObjJs_init(block, $this) {
    $this = $this || Object.create(JsonObjJs.prototype);
    JsonObjJs.call($this);
    block($this);
    return $this;
  }
  function ClientOrcaImpl(commandListExecutor, transmitter) {
    this.commandListExecutor = commandListExecutor;
    this.transmitter = transmitter;
    this.clientModelStore = new DefaultPresentationModelStore();
    this.eventSubject_0 = new $module$rxjs_Rx.Subject();
  }
  function ClientOrcaImpl$executeCommands$lambda(this$ClientOrcaImpl) {
    return function (it) {
      this$ClientOrcaImpl.eventSubject_0.next(it);
    };
  }
  ClientOrcaImpl.prototype.executeCommands_rggine$ = function (commands) {
    var responseCommands = this.transmitter.sendCommands_rggine$(commands);
    var responseEvent = this.commandListExecutor.execute_wl1ujw$(this.clientModelStore, $module$rxjs_Rx.Observable.merge($module$rxjs_Rx.Observable.from(commands), responseCommands));
    responseEvent.subscribe(ClientOrcaImpl$executeCommands$lambda(this));
  };
  function ClientOrcaImpl$observeModelStore$lambda(it) {
    return Kotlin.isType(it, ModelStoreChangeEvent);
  }
  function ClientOrcaImpl$observeModelStore$lambda_0(it) {
    var tmp$;
    return Kotlin.isType(tmp$ = it, ModelStoreChangeEvent) ? tmp$ : Kotlin.throwCCE();
  }
  ClientOrcaImpl.prototype.observeModelStore = function () {
    return this.eventSubject_0.filter(ClientOrcaImpl$observeModelStore$lambda).map(ClientOrcaImpl$observeModelStore$lambda_0);
  };
  function ClientOrcaImpl$observeModel$lambda(closure$modelId) {
    return function (it) {
      var tmp$;
      return (tmp$ = it.modelId) != null ? tmp$.equals(closure$modelId) : null;
    };
  }
  ClientOrcaImpl.prototype.observeModel_accdal$ = function (modelId) {
    return this.eventStreamAsPropertyChangeEvent_0().filter(ClientOrcaImpl$observeModel$lambda(modelId));
  };
  function ClientOrcaImpl$observeModel$lambda_0(closure$modelType) {
    return function (it) {
      var tmp$;
      return (tmp$ = it.modelType) != null ? tmp$.equals(closure$modelType) : null;
    };
  }
  ClientOrcaImpl.prototype.observeModel_4tsc7m$ = function (modelType) {
    return this.eventStreamAsPropertyChangeEvent_0().filter(ClientOrcaImpl$observeModel$lambda_0(modelType));
  };
  function ClientOrcaImpl$observeProperty$lambda(closure$modelId) {
    return function (it) {
      var tmp$;
      return (tmp$ = it.modelId) != null ? tmp$.equals(closure$modelId) : null;
    };
  }
  function ClientOrcaImpl$observeProperty$lambda_0(it) {
    return it.valueChangeEvent;
  }
  ClientOrcaImpl.prototype.observeProperty_g7hk0o$ = function (modelId, propertyName) {
    return this.eventStreamAsPropertyChangeEvent_0().filter(ClientOrcaImpl$observeProperty$lambda(modelId)).map(ClientOrcaImpl$observeProperty$lambda_0);
  };
  function ClientOrcaImpl$eventStreamAsPropertyChangeEvent$lambda(it) {
    return Kotlin.isType(it, PropertyChangeEvent);
  }
  function ClientOrcaImpl$eventStreamAsPropertyChangeEvent$lambda_0(it) {
    var tmp$;
    return Kotlin.isType(tmp$ = it, PropertyChangeEvent) ? tmp$ : Kotlin.throwCCE();
  }
  ClientOrcaImpl.prototype.eventStreamAsPropertyChangeEvent_0 = function () {
    return this.eventSubject_0.filter(ClientOrcaImpl$eventStreamAsPropertyChangeEvent$lambda).map(ClientOrcaImpl$eventStreamAsPropertyChangeEvent$lambda_0);
  };
  function ClientOrcaImpl$registerNamedCommand$lambda(it) {
    return Kotlin.isType(it, ActionEvent);
  }
  function ClientOrcaImpl$registerNamedCommand$lambda_0(it) {
    var tmp$;
    return Kotlin.isType(tmp$ = it, ActionEvent) ? tmp$ : Kotlin.throwCCE();
  }
  function ClientOrcaImpl$registerNamedCommand$lambda_1(closure$actionName) {
    return function (it) {
      return Kotlin.equals(it.actionName, closure$actionName);
    };
  }
  ClientOrcaImpl.prototype.registerNamedCommand_61zpoe$ = function (actionName) {
    return this.eventSubject_0.filter(ClientOrcaImpl$registerNamedCommand$lambda).map(ClientOrcaImpl$registerNamedCommand$lambda_0).filter(ClientOrcaImpl$registerNamedCommand$lambda_1(actionName));
  };
  ClientOrcaImpl.prototype.model_4tsc7m$ = function (modelType) {
    return this.clientModelStore.get_4tsc7m$(modelType);
  };
  ClientOrcaImpl.prototype.model_accdal$ = function (modelId) {
    return this.clientModelStore.get_accdal$(modelId);
  };
  ClientOrcaImpl.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ClientOrcaImpl',
    interfaces: [ClientOrca]
  };
  function CommandListExecutor() {
  }
  CommandListExecutor.prototype.execute_isgdc6$ = function (modelStore, commandData) {
    return this.execute_wl1ujw$(modelStore, just(commandData));
  };
  CommandListExecutor.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'CommandListExecutor',
    interfaces: []
  };
  function ClientCommandListExecutor() {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3, tmp$_4;
    this.executors_0 = mapOf([to((tmp$ = Kotlin.getKClass(CreateModelCommandData).simpleName) != null ? tmp$ : Kotlin.throwNPE(), CreateModelExecutor_getInstance()), to((tmp$_0 = Kotlin.getKClass(RemoveModelCommandData).simpleName) != null ? tmp$_0 : Kotlin.throwNPE(), RemoveModelExecutor_getInstance()), to((tmp$_1 = Kotlin.getKClass(ActionCommandData).simpleName) != null ? tmp$_1 : Kotlin.throwNPE(), ActionExecutor_getInstance()), to((tmp$_2 = Kotlin.getKClass(ChangeValueCommandData).simpleName) != null ? tmp$_2 : Kotlin.throwNPE(), ChangeValueExecutor_getInstance()), to((tmp$_3 = Kotlin.getKClass(RemoveModelByTypeCommandData).simpleName) != null ? tmp$_3 : Kotlin.throwNPE(), RemoveModelByTypeExecutor_getInstance()), to((tmp$_4 = Kotlin.getKClass(SyncModelCommandData).simpleName) != null ? tmp$_4 : Kotlin.throwNPE(), SyncModelExecutor_getInstance())]);
  }
  function ClientCommandListExecutor$execute$lambda(closure$modelStore, this$ClientCommandListExecutor) {
    return function (it) {
      return this$ClientCommandListExecutor.applyCommand_0(closure$modelStore, it);
    };
  }
  ClientCommandListExecutor.prototype.execute_wl1ujw$ = function (modelStore, commandData) {
    return commandData.flatMap(ClientCommandListExecutor$execute$lambda(modelStore, this));
  };
  ClientCommandListExecutor.prototype.applyCommand_0 = function (modelStore, it) {
    var tmp$, tmp$_0;
    tmp$_0 = this.executors_0.get_11rb$((tmp$ = Kotlin.getKClassFromExpression(it).simpleName) != null ? tmp$ : Kotlin.throwNPE());
    if (tmp$_0 == null) {
      throw new IllegalArgumentException("No executor found for commandData: '" + it + "'");
    }
    var executor = tmp$_0;
    return executor.execute_isgdc6$(modelStore, it);
  };
  ClientCommandListExecutor.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ClientCommandListExecutor',
    interfaces: [CommandListExecutor]
  };
  function CommandExecutor() {
  }
  CommandExecutor.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'CommandExecutor',
    interfaces: []
  };
  function CreateModelExecutor() {
    CreateModelExecutor_instance = this;
  }
  CreateModelExecutor.prototype.execute_isgdc6$ = function (modelStore, commandData) {
    var tmp$;
    var it = Kotlin.isType(tmp$ = commandData, CreateModelCommandData) ? tmp$ : Kotlin.throwCCE();
    var model = new DefaultPresentationModel(it.modelId, it.modelType, asSequence(it.properties));
    modelStore.addModel_pl55oe$(model);
    return just(new ModelStoreChangeEvent(it.source, model.id, model.type, ModelStoreChangeEvent$Type$ADD_getInstance()));
  };
  CreateModelExecutor.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'CreateModelExecutor',
    interfaces: [CommandExecutor]
  };
  var CreateModelExecutor_instance = null;
  function CreateModelExecutor_getInstance() {
    if (CreateModelExecutor_instance === null) {
      new CreateModelExecutor();
    }
    return CreateModelExecutor_instance;
  }
  function ChangeValueExecutor() {
    ChangeValueExecutor_instance = this;
  }
  ChangeValueExecutor.prototype.execute_isgdc6$ = function (modelStore, commandData) {
    var tmp$;
    var it = Kotlin.isType(tmp$ = commandData, ChangeValueCommandData) ? tmp$ : Kotlin.throwCCE();
    var model = modelStore.get_accdal$(it.modelId);
    var oldValue = model.get_lqljjj$(it.propertyName).setValue_yi4zkl$(it.value);
    return just(new PropertyChangeEvent(it.source, model.id, model.type, new ValueChangeEvent(it.source, it.propertyName, oldValue, it.value)));
  };
  ChangeValueExecutor.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'ChangeValueExecutor',
    interfaces: [CommandExecutor]
  };
  var ChangeValueExecutor_instance = null;
  function ChangeValueExecutor_getInstance() {
    if (ChangeValueExecutor_instance === null) {
      new ChangeValueExecutor();
    }
    return ChangeValueExecutor_instance;
  }
  function ActionExecutor() {
    ActionExecutor_instance = this;
  }
  ActionExecutor.prototype.execute_isgdc6$ = function (modelStore, commandData) {
    var tmp$;
    var it = Kotlin.isType(tmp$ = commandData, ActionCommandData) ? tmp$ : Kotlin.throwCCE();
    return just(new ActionEvent(it.source, it.actionName, it.modelIds));
  };
  ActionExecutor.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'ActionExecutor',
    interfaces: [CommandExecutor]
  };
  var ActionExecutor_instance = null;
  function ActionExecutor_getInstance() {
    if (ActionExecutor_instance === null) {
      new ActionExecutor();
    }
    return ActionExecutor_instance;
  }
  function RemoveModelExecutor() {
    RemoveModelExecutor_instance = this;
  }
  RemoveModelExecutor.prototype.execute_isgdc6$ = function (modelStore, commandData) {
    var tmp$;
    var it = Kotlin.isType(tmp$ = commandData, RemoveModelCommandData) ? tmp$ : Kotlin.throwCCE();
    var oldModel = modelStore.removeModel_accdal$(it.modelId);
    return just(new ModelStoreChangeEvent(it.source, it.modelId, oldModel.type, ModelStoreChangeEvent$Type$REMOVE_getInstance()));
  };
  RemoveModelExecutor.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'RemoveModelExecutor',
    interfaces: [CommandExecutor]
  };
  var RemoveModelExecutor_instance = null;
  function RemoveModelExecutor_getInstance() {
    if (RemoveModelExecutor_instance === null) {
      new RemoveModelExecutor();
    }
    return RemoveModelExecutor_instance;
  }
  function RemoveModelByTypeExecutor() {
    RemoveModelByTypeExecutor_instance = this;
  }
  RemoveModelByTypeExecutor.prototype.execute_isgdc6$ = function (modelStore, commandData) {
    var tmp$;
    var data = Kotlin.isType(tmp$ = commandData, RemoveModelByTypeCommandData) ? tmp$ : Kotlin.throwCCE();
    var $receiver = modelStore.removeModels_4tsc7m$(data.modelType);
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$($receiver, 10));
    var tmp$_0;
    tmp$_0 = $receiver.iterator();
    while (tmp$_0.hasNext()) {
      var item = tmp$_0.next();
      destination.add_11rb$(new ModelStoreChangeEvent(data.source, item.id, item.type, ModelStoreChangeEvent$Type$REMOVE_getInstance()));
    }
    var map_4 = destination;
    var $receiver_0 = toList(map_4);
    return $module$rxjs_Rx.Observable.from(Kotlin.kotlin.collections.copyToArray($receiver_0));
  };
  RemoveModelByTypeExecutor.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'RemoveModelByTypeExecutor',
    interfaces: [CommandExecutor]
  };
  var RemoveModelByTypeExecutor_instance = null;
  function RemoveModelByTypeExecutor_getInstance() {
    if (RemoveModelByTypeExecutor_instance === null) {
      new RemoveModelByTypeExecutor();
    }
    return RemoveModelByTypeExecutor_instance;
  }
  function SyncModelExecutor() {
    SyncModelExecutor_instance = this;
  }
  function SyncModelExecutor$execute$lambda$lambda(it) {
    return it.value;
  }
  function SyncModelExecutor$execute$lambda$lambda_0(closure$destinationPm, closure$property, closure$data) {
    return function (value) {
      var oldValue = closure$destinationPm.get_lqljjj$(closure$property.name).setValue_yi4zkl$(value);
      return new ValueChangeEvent(closure$data.source, closure$property.name, oldValue, value);
    };
  }
  function SyncModelExecutor$execute$lambda(closure$destinationPm, closure$data) {
    return function (property) {
      return map_2(map_2(property.getValues(), SyncModelExecutor$execute$lambda$lambda), SyncModelExecutor$execute$lambda$lambda_0(closure$destinationPm, property, closure$data));
    };
  }
  SyncModelExecutor.prototype.execute_isgdc6$ = function (modelStore, commandData) {
    var tmp$;
    var data = Kotlin.isType(tmp$ = commandData, SyncModelCommandData) ? tmp$ : Kotlin.throwCCE();
    var sourcePm = modelStore.get_accdal$(data.sourceModel);
    var destinationPm = modelStore.get_accdal$(data.destinationModel);
    var events = toList_0(flatMap_0(sourcePm.getProperties(), SyncModelExecutor$execute$lambda(destinationPm, data)));
    return $module$rxjs_Rx.Observable.from(Kotlin.kotlin.collections.copyToArray(events));
  };
  SyncModelExecutor.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'SyncModelExecutor',
    interfaces: [CommandExecutor]
  };
  var SyncModelExecutor_instance = null;
  function SyncModelExecutor_getInstance() {
    if (SyncModelExecutor_instance === null) {
      new SyncModelExecutor();
    }
    return SyncModelExecutor_instance;
  }
  function Transmitter() {
  }
  Transmitter.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'Transmitter',
    interfaces: []
  };
  function XMLHttpRequestTransmitter(url, codec) {
    this.url = url;
    this.codec = codec;
    this.commandQueue_0 = Kotlin.kotlin.collections.ArrayList_init_ww73n8$();
    this.request_0 = new XMLHttpRequest();
    this.alreadySending_0 = false;
  }
  function XMLHttpRequestTransmitter$CommandSubjectPair(commands) {
    this.commands = commands;
    this.subject = new $module$rxjs_Rx.Subject();
  }
  XMLHttpRequestTransmitter$CommandSubjectPair.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'CommandSubjectPair',
    interfaces: []
  };
  function XMLHttpRequestTransmitter$sendCommands$lambda(closure$commands, this$XMLHttpRequestTransmitter) {
    return function (it) {
      var pair = new XMLHttpRequestTransmitter$CommandSubjectPair(closure$commands);
      this$XMLHttpRequestTransmitter.commandQueue_0.add_11rb$(pair);
      this$XMLHttpRequestTransmitter.send_0();
      return pair.subject.subscribe(it);
    };
  }
  XMLHttpRequestTransmitter.prototype.sendCommands_rggine$ = function (commands) {
    return new $module$rxjs_Rx.Observable(XMLHttpRequestTransmitter$sendCommands$lambda(commands, this));
  };
  XMLHttpRequestTransmitter.prototype.send_0 = function () {
    if (this.alreadySending_0) {
      return;
    }
    while (!this.commandQueue_0.isEmpty()) {
      var pair = this.commandQueue_0.removeAt_za3lpa$(0);
      var handler = new Handler(pair.subject, this.request_0, this.codec);
      this.request_0.onreadystatechange = Kotlin.getCallableRef('readyStateHandler', function ($receiver, event) {
        return $receiver.readyStateHandler_9ojx7i$(event);
      }.bind(null, handler));
      this.request_0.onerror = Kotlin.getCallableRef('onErrorHandler', function ($receiver, event) {
        return $receiver.onErrorHandler_9ojx7i$(event);
      }.bind(null, handler));
      this.request_0.open('POST', this.url, true);
      this.request_0.send(pair.commands);
    }
  };
  XMLHttpRequestTransmitter.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'XMLHttpRequestTransmitter',
    interfaces: [Transmitter]
  };
  function Handler(subject, request, codec) {
    this.subject = subject;
    this.request = request;
    this.codec = codec;
  }
  Handler.prototype.onErrorHandler_9ojx7i$ = function (event) {
    this.subject.error(new Error_0('Error received: ' + event));
  };
  Handler.prototype.readyStateHandler_9ojx7i$ = function (event) {
    if (this.request.readyState !== XMLHttpRequest.DONE) {
      return;
    }
    if (this.request.status !== Kotlin.toShort(200)) {
      this.subject.error(new Error_0("Incorrect status received '" + this.request.status + "', expected 200."));
      return;
    }
    var $receiver = this.request.responseText;
    var tmp$;
    var responseText = Kotlin.kotlin.text.trim_gw00vp$(Kotlin.isCharSequence(tmp$ = $receiver) ? tmp$ : Kotlin.throwCCE()).toString();
    try {
      var responseCommands = this.codec.decode_2azfem$(Source$RESPONSE_getInstance(), responseText);
      this.onDone_0(responseCommands);
    }
     catch (exception) {
      if (Kotlin.isType(exception, Exception)) {
        console.log('Error occurred parsing responseText: ' + exception);
        this.subject.error(new Error_0('Response text in wrong format: ' + responseText));
      }
       else
        throw exception;
    }
  };
  Handler.prototype.onDone_0 = function (commands) {
    var tmp$;
    for (tmp$ = 0; tmp$ !== commands.length; ++tmp$) {
      var element = commands[tmp$];
      this.subject.next(element);
    }
  };
  Handler.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'Handler',
    interfaces: []
  };
  function Codec() {
  }
  Codec.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'Codec',
    interfaces: []
  };
  function CommandData() {
  }
  CommandData.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'CommandData',
    interfaces: []
  };
  function ChangeValueCommandData(source, modelId, propertyName, value) {
    this.source_avhejv$_0 = source;
    this.modelId = modelId;
    this.propertyName = propertyName;
    this.value = value;
  }
  Object.defineProperty(ChangeValueCommandData.prototype, 'source', {
    get: function () {
      return this.source_avhejv$_0;
    }
  });
  ChangeValueCommandData.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ChangeValueCommandData',
    interfaces: [CommandData]
  };
  ChangeValueCommandData.prototype.component1 = function () {
    return this.source;
  };
  ChangeValueCommandData.prototype.component2 = function () {
    return this.modelId;
  };
  ChangeValueCommandData.prototype.component3 = function () {
    return this.propertyName;
  };
  ChangeValueCommandData.prototype.component4 = function () {
    return this.value;
  };
  ChangeValueCommandData.prototype.copy_ljwy2n$ = function (source, modelId, propertyName, value) {
    return new ChangeValueCommandData(source === void 0 ? this.source : source, modelId === void 0 ? this.modelId : modelId, propertyName === void 0 ? this.propertyName : propertyName, value === void 0 ? this.value : value);
  };
  ChangeValueCommandData.prototype.toString = function () {
    return 'ChangeValueCommandData(source=' + Kotlin.toString(this.source) + (', modelId=' + Kotlin.toString(this.modelId)) + (', propertyName=' + Kotlin.toString(this.propertyName)) + (', value=' + Kotlin.toString(this.value)) + ')';
  };
  ChangeValueCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelId) | 0;
    result = result * 31 + Kotlin.hashCode(this.propertyName) | 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  ChangeValueCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.modelId, other.modelId) && Kotlin.equals(this.propertyName, other.propertyName) && Kotlin.equals(this.value, other.value)))));
  };
  function CreateModelCommandData(source, modelId, modelType, properties) {
    this.source_5h0uf5$_0 = source;
    this.modelId = modelId;
    this.modelType = modelType;
    this.properties = properties;
  }
  Object.defineProperty(CreateModelCommandData.prototype, 'source', {
    get: function () {
      return this.source_5h0uf5$_0;
    }
  });
  CreateModelCommandData.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'CreateModelCommandData',
    interfaces: [CommandData]
  };
  CreateModelCommandData.prototype.component1 = function () {
    return this.source;
  };
  CreateModelCommandData.prototype.component2 = function () {
    return this.modelId;
  };
  CreateModelCommandData.prototype.component3 = function () {
    return this.modelType;
  };
  CreateModelCommandData.prototype.component4 = function () {
    return this.properties;
  };
  CreateModelCommandData.prototype.copy_l7u0xm$ = function (source, modelId, modelType, properties) {
    return new CreateModelCommandData(source === void 0 ? this.source : source, modelId === void 0 ? this.modelId : modelId, modelType === void 0 ? this.modelType : modelType, properties === void 0 ? this.properties : properties);
  };
  CreateModelCommandData.prototype.toString = function () {
    return 'CreateModelCommandData(source=' + Kotlin.toString(this.source) + (', modelId=' + Kotlin.toString(this.modelId)) + (', modelType=' + Kotlin.toString(this.modelType)) + (', properties=' + Kotlin.toString(this.properties)) + ')';
  };
  CreateModelCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelId) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelType) | 0;
    result = result * 31 + Kotlin.hashCode(this.properties) | 0;
    return result;
  };
  CreateModelCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.modelId, other.modelId) && Kotlin.equals(this.modelType, other.modelType) && Kotlin.equals(this.properties, other.properties)))));
  };
  function RemoveModelCommandData(source, modelId) {
    this.source_ij9do9$_0 = source;
    this.modelId = modelId;
  }
  Object.defineProperty(RemoveModelCommandData.prototype, 'source', {
    get: function () {
      return this.source_ij9do9$_0;
    }
  });
  RemoveModelCommandData.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'RemoveModelCommandData',
    interfaces: [CommandData]
  };
  RemoveModelCommandData.prototype.component1 = function () {
    return this.source;
  };
  RemoveModelCommandData.prototype.component2 = function () {
    return this.modelId;
  };
  RemoveModelCommandData.prototype.copy_ua2enn$ = function (source, modelId) {
    return new RemoveModelCommandData(source === void 0 ? this.source : source, modelId === void 0 ? this.modelId : modelId);
  };
  RemoveModelCommandData.prototype.toString = function () {
    return 'RemoveModelCommandData(source=' + Kotlin.toString(this.source) + (', modelId=' + Kotlin.toString(this.modelId)) + ')';
  };
  RemoveModelCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelId) | 0;
    return result;
  };
  RemoveModelCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.modelId, other.modelId)))));
  };
  function ActionCommandData(source, actionName, modelIds) {
    this.source_ftpbjg$_0 = source;
    this.actionName = actionName;
    this.modelIds = modelIds;
  }
  Object.defineProperty(ActionCommandData.prototype, 'source', {
    get: function () {
      return this.source_ftpbjg$_0;
    }
  });
  ActionCommandData.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ActionCommandData',
    interfaces: [CommandData]
  };
  ActionCommandData.prototype.component1 = function () {
    return this.source;
  };
  ActionCommandData.prototype.component2 = function () {
    return this.actionName;
  };
  ActionCommandData.prototype.component3 = function () {
    return this.modelIds;
  };
  ActionCommandData.prototype.copy_y2nfqq$ = function (source, actionName, modelIds) {
    return new ActionCommandData(source === void 0 ? this.source : source, actionName === void 0 ? this.actionName : actionName, modelIds === void 0 ? this.modelIds : modelIds);
  };
  ActionCommandData.prototype.toString = function () {
    return 'ActionCommandData(source=' + Kotlin.toString(this.source) + (', actionName=' + Kotlin.toString(this.actionName)) + (', modelIds=' + Kotlin.toString(this.modelIds)) + ')';
  };
  ActionCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.actionName) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelIds) | 0;
    return result;
  };
  ActionCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.actionName, other.actionName) && Kotlin.equals(this.modelIds, other.modelIds)))));
  };
  function RemoveModelByTypeCommandData(source, modelType) {
    this.source_vd4yfe$_0 = source;
    this.modelType = modelType;
  }
  Object.defineProperty(RemoveModelByTypeCommandData.prototype, 'source', {
    get: function () {
      return this.source_vd4yfe$_0;
    }
  });
  RemoveModelByTypeCommandData.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'RemoveModelByTypeCommandData',
    interfaces: [CommandData]
  };
  RemoveModelByTypeCommandData.prototype.component1 = function () {
    return this.source;
  };
  RemoveModelByTypeCommandData.prototype.component2 = function () {
    return this.modelType;
  };
  RemoveModelByTypeCommandData.prototype.copy_nxppny$ = function (source, modelType) {
    return new RemoveModelByTypeCommandData(source === void 0 ? this.source : source, modelType === void 0 ? this.modelType : modelType);
  };
  RemoveModelByTypeCommandData.prototype.toString = function () {
    return 'RemoveModelByTypeCommandData(source=' + Kotlin.toString(this.source) + (', modelType=' + Kotlin.toString(this.modelType)) + ')';
  };
  RemoveModelByTypeCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelType) | 0;
    return result;
  };
  RemoveModelByTypeCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.modelType, other.modelType)))));
  };
  function SyncModelCommandData(source, sourceModel, destinationModel) {
    this.source_1wmcxu$_0 = source;
    this.sourceModel = sourceModel;
    this.destinationModel = destinationModel;
  }
  Object.defineProperty(SyncModelCommandData.prototype, 'source', {
    get: function () {
      return this.source_1wmcxu$_0;
    }
  });
  SyncModelCommandData.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'SyncModelCommandData',
    interfaces: [CommandData]
  };
  SyncModelCommandData.prototype.component1 = function () {
    return this.source;
  };
  SyncModelCommandData.prototype.component2 = function () {
    return this.sourceModel;
  };
  SyncModelCommandData.prototype.component3 = function () {
    return this.destinationModel;
  };
  SyncModelCommandData.prototype.copy_opviic$ = function (source, sourceModel, destinationModel) {
    return new SyncModelCommandData(source === void 0 ? this.source : source, sourceModel === void 0 ? this.sourceModel : sourceModel, destinationModel === void 0 ? this.destinationModel : destinationModel);
  };
  SyncModelCommandData.prototype.toString = function () {
    return 'SyncModelCommandData(source=' + Kotlin.toString(this.source) + (', sourceModel=' + Kotlin.toString(this.sourceModel)) + (', destinationModel=' + Kotlin.toString(this.destinationModel)) + ')';
  };
  SyncModelCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.sourceModel) | 0;
    result = result * 31 + Kotlin.hashCode(this.destinationModel) | 0;
    return result;
  };
  SyncModelCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.sourceModel, other.sourceModel) && Kotlin.equals(this.destinationModel, other.destinationModel)))));
  };
  function ModelStore() {
  }
  ModelStore.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'ModelStore',
    interfaces: []
  };
  function StringCodec() {
  }
  StringCodec.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'StringCodec',
    interfaces: []
  };
  function PropertyValue() {
  }
  PropertyValue.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'PropertyValue',
    interfaces: []
  };
  function ToolTipPropertyValue(value) {
    this.value = value;
  }
  ToolTipPropertyValue.prototype.getJsonTypeId = function () {
    var tmp$;
    return (tmp$ = Kotlin.getKClassFromExpression(this).simpleName) != null ? tmp$ : Kotlin.throwNPE();
  };
  ToolTipPropertyValue.prototype.asJsonValue = function () {
    return asJsonString(this.value);
  };
  ToolTipPropertyValue.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ToolTipPropertyValue',
    interfaces: [PropertyValue]
  };
  ToolTipPropertyValue.prototype.component1 = function () {
    return this.value;
  };
  ToolTipPropertyValue.prototype.copy_61zpoe$ = function (value) {
    return new ToolTipPropertyValue(value === void 0 ? this.value : value);
  };
  ToolTipPropertyValue.prototype.toString = function () {
    return 'ToolTipPropertyValue(value=' + Kotlin.toString(this.value) + ')';
  };
  ToolTipPropertyValue.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  ToolTipPropertyValue.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function LabelPropertyValue(value) {
    this.value = value;
  }
  LabelPropertyValue.prototype.getJsonTypeId = function () {
    var tmp$;
    return (tmp$ = Kotlin.getKClassFromExpression(this).simpleName) != null ? tmp$ : Kotlin.throwNPE();
  };
  LabelPropertyValue.prototype.asJsonValue = function () {
    return asJsonString(this.value);
  };
  LabelPropertyValue.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'LabelPropertyValue',
    interfaces: [PropertyValue]
  };
  LabelPropertyValue.prototype.component1 = function () {
    return this.value;
  };
  LabelPropertyValue.prototype.copy_61zpoe$ = function (value) {
    return new LabelPropertyValue(value === void 0 ? this.value : value);
  };
  LabelPropertyValue.prototype.toString = function () {
    return 'LabelPropertyValue(value=' + Kotlin.toString(this.value) + ')';
  };
  LabelPropertyValue.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    return result;
  };
  LabelPropertyValue.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.value, other.value))));
  };
  function ValuePropertyValue() {
  }
  ValuePropertyValue.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ValuePropertyValue',
    interfaces: [PropertyValue]
  };
  function ModelIdValue(modelId) {
    ValuePropertyValue.call(this);
    this.modelId = modelId;
  }
  ModelIdValue.prototype.getJsonTypeId = function () {
    var tmp$;
    return (tmp$ = Kotlin.getKClassFromExpression(this).simpleName) != null ? tmp$ : Kotlin.throwNPE();
  };
  ModelIdValue.prototype.asJsonValue = function () {
    return asJsonString(this.modelId.stringId);
  };
  ModelIdValue.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ModelIdValue',
    interfaces: [ValuePropertyValue]
  };
  ModelIdValue.prototype.component1 = function () {
    return this.modelId;
  };
  ModelIdValue.prototype.copy_accdal$ = function (modelId) {
    return new ModelIdValue(modelId === void 0 ? this.modelId : modelId);
  };
  ModelIdValue.prototype.toString = function () {
    return 'ModelIdValue(modelId=' + Kotlin.toString(this.modelId) + ')';
  };
  ModelIdValue.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.modelId) | 0;
    return result;
  };
  ModelIdValue.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.modelId, other.modelId))));
  };
  function StringValue(string) {
    ValuePropertyValue.call(this);
    this.string = string;
  }
  StringValue.prototype.getJsonTypeId = function () {
    var tmp$;
    return (tmp$ = Kotlin.getKClassFromExpression(this).simpleName) != null ? tmp$ : Kotlin.throwNPE();
  };
  StringValue.prototype.asJsonValue = function () {
    return asJsonString(this.string);
  };
  StringValue.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'StringValue',
    interfaces: [ValuePropertyValue]
  };
  StringValue.prototype.component1 = function () {
    return this.string;
  };
  StringValue.prototype.copy_61zpoe$ = function (string) {
    return new StringValue(string === void 0 ? this.string : string);
  };
  StringValue.prototype.toString = function () {
    return 'StringValue(string=' + Kotlin.toString(this.string) + ')';
  };
  StringValue.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.string) | 0;
    return result;
  };
  StringValue.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.string, other.string))));
  };
  function BooleanValue(boolean) {
    ValuePropertyValue.call(this);
    this.boolean = boolean;
  }
  BooleanValue.prototype.getJsonTypeId = function () {
    var tmp$;
    return (tmp$ = Kotlin.getKClassFromExpression(this).simpleName) != null ? tmp$ : Kotlin.throwNPE();
  };
  BooleanValue.prototype.asJsonValue = function () {
    return this.boolean.toString();
  };
  BooleanValue.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'BooleanValue',
    interfaces: [ValuePropertyValue]
  };
  BooleanValue.prototype.component1 = function () {
    return this.boolean;
  };
  BooleanValue.prototype.copy_6taknv$ = function (boolean) {
    return new BooleanValue(boolean === void 0 ? this.boolean : boolean);
  };
  BooleanValue.prototype.toString = function () {
    return 'BooleanValue(boolean=' + Kotlin.toString(this.boolean) + ')';
  };
  BooleanValue.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.boolean) | 0;
    return result;
  };
  BooleanValue.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.boolean, other.boolean))));
  };
  function asJsonString($receiver) {
    return $receiver;
  }
  function Source(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Source_initFields() {
    Source_initFields = function () {
    };
    Source$REQUEST_instance = new Source('REQUEST', 0);
    Source$RESPONSE_instance = new Source('RESPONSE', 1);
  }
  var Source$REQUEST_instance;
  function Source$REQUEST_getInstance() {
    Source_initFields();
    return Source$REQUEST_instance;
  }
  var Source$RESPONSE_instance;
  function Source$RESPONSE_getInstance() {
    Source_initFields();
    return Source$RESPONSE_instance;
  }
  Source.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'Source',
    interfaces: [Enum]
  };
  function Source$values() {
    return [Source$REQUEST_getInstance(), Source$RESPONSE_getInstance()];
  }
  Source.values = Source$values;
  function Source$valueOf(name) {
    switch (name) {
      case 'REQUEST':
        return Source$REQUEST_getInstance();
      case 'RESPONSE':
        return Source$RESPONSE_getInstance();
      default:Kotlin.throwISE('No enum constant ch.viseon.openOrca.share.Source.' + name);
    }
  }
  Source.valueOf_61zpoe$ = Source$valueOf;
  function Event() {
  }
  Event.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'Event',
    interfaces: []
  };
  function ModelStoreChangeEvent(source, modelId, modelType, type) {
    this.source_xc4rc7$_0 = source;
    this.modelId = modelId;
    this.modelType = modelType;
    this.type = type;
  }
  Object.defineProperty(ModelStoreChangeEvent.prototype, 'source', {
    get: function () {
      return this.source_xc4rc7$_0;
    }
  });
  function ModelStoreChangeEvent$Type(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function ModelStoreChangeEvent$Type_initFields() {
    ModelStoreChangeEvent$Type_initFields = function () {
    };
    ModelStoreChangeEvent$Type$ADD_instance = new ModelStoreChangeEvent$Type('ADD', 0);
    ModelStoreChangeEvent$Type$REMOVE_instance = new ModelStoreChangeEvent$Type('REMOVE', 1);
  }
  var ModelStoreChangeEvent$Type$ADD_instance;
  function ModelStoreChangeEvent$Type$ADD_getInstance() {
    ModelStoreChangeEvent$Type_initFields();
    return ModelStoreChangeEvent$Type$ADD_instance;
  }
  var ModelStoreChangeEvent$Type$REMOVE_instance;
  function ModelStoreChangeEvent$Type$REMOVE_getInstance() {
    ModelStoreChangeEvent$Type_initFields();
    return ModelStoreChangeEvent$Type$REMOVE_instance;
  }
  ModelStoreChangeEvent$Type.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'Type',
    interfaces: [Enum]
  };
  function ModelStoreChangeEvent$Type$values() {
    return [ModelStoreChangeEvent$Type$ADD_getInstance(), ModelStoreChangeEvent$Type$REMOVE_getInstance()];
  }
  ModelStoreChangeEvent$Type.values = ModelStoreChangeEvent$Type$values;
  function ModelStoreChangeEvent$Type$valueOf(name) {
    switch (name) {
      case 'ADD':
        return ModelStoreChangeEvent$Type$ADD_getInstance();
      case 'REMOVE':
        return ModelStoreChangeEvent$Type$REMOVE_getInstance();
      default:Kotlin.throwISE('No enum constant ch.viseon.openOrca.share.ModelStoreChangeEvent.Type.' + name);
    }
  }
  ModelStoreChangeEvent$Type.valueOf_61zpoe$ = ModelStoreChangeEvent$Type$valueOf;
  ModelStoreChangeEvent.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ModelStoreChangeEvent',
    interfaces: [Event]
  };
  function PropertyChangeEvent(source, modelId, modelType, valueChangeEvent) {
    this.source_64kfm2$_0 = source;
    this.modelId = modelId;
    this.modelType = modelType;
    this.valueChangeEvent = valueChangeEvent;
  }
  Object.defineProperty(PropertyChangeEvent.prototype, 'source', {
    get: function () {
      return this.source_64kfm2$_0;
    }
  });
  PropertyChangeEvent.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'PropertyChangeEvent',
    interfaces: [Event]
  };
  function ValueChangeEvent(source, property, oldValue, newValue) {
    this.source_s4spyo$_0 = source;
    this.property = property;
    this.oldValue = oldValue;
    this.newValue = newValue;
  }
  Object.defineProperty(ValueChangeEvent.prototype, 'source', {
    get: function () {
      return this.source_s4spyo$_0;
    }
  });
  ValueChangeEvent.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ValueChangeEvent',
    interfaces: [Event]
  };
  function ActionEvent(source, actionName, pmIds) {
    this.source_awcbd3$_0 = source;
    this.actionName = actionName;
    this.pmIds = pmIds;
  }
  Object.defineProperty(ActionEvent.prototype, 'source', {
    get: function () {
      return this.source_awcbd3$_0;
    }
  });
  ActionEvent.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ActionEvent',
    interfaces: [Event]
  };
  function Property(name, initialValues) {
    this.name = name;
    var $receiver = HashMap_init();
    var tmp$;
    tmp$ = initialValues.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var tmp$_0, tmp$_1;
      tmp$_1 = (tmp$_0 = Kotlin.getKClassFromExpression(element).simpleName) != null ? tmp$_0 : Kotlin.throwNPE();
      $receiver.put_xwzc9p$(tmp$_1, element);
    }
    this.propertyValue2Values_0 = $receiver;
  }
  Property.prototype.setValue_yi4zkl$ = function (value) {
    var tmp$;
    var typeName = this.getTypeName_0((tmp$ = Kotlin.getKClassFromExpression(value).simpleName) != null ? tmp$ : Kotlin.throwNPE());
    println("setter: typeName: '" + typeName + "' value: '" + value + "'");
    var oldValue = this.propertyValue2Values_0.get_11rb$(typeName);
    this.propertyValue2Values_0.put_xwzc9p$(typeName, value);
    return oldValue;
  };
  Property.prototype.getValues = function () {
    return asSequence(this.propertyValue2Values_0.entries);
  };
  Property.prototype.get_61zpoe$ = function (valueType) {
    var typeName = this.getTypeName_0(valueType);
    println("getter: typeName: '" + typeName + "' value: '" + valueType + "'");
    return this.propertyValue2Values_0.get_11rb$(typeName);
  };
  function Property$getValue$lambda(it) {
    return Kotlin.getKClassFromExpression(it).simpleName;
  }
  Property.prototype.getValue_5xipil$ = Kotlin.defineInlineFunction('openorca-js-client.ch.viseon.openOrca.share.impl.Property.getValue_5xipil$', function (getValue$T_0, isT) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    tmp$_0 = this.get_61zpoe$((tmp$ = Kotlin.getKClass(getValue$T_0).simpleName) != null ? tmp$ : Kotlin.throwNPE());
    if (tmp$_0 == null) {
      throw new Kotlin.kotlin.IllegalStateException('Value is null for type: ' + Kotlin.getKClass(getValue$T_0));
    }
    var get = tmp$_0;
    tmp$_2 = isT(tmp$_1 = get) ? tmp$_1 : null;
    if (tmp$_2 == null) {
      throw new Kotlin.kotlin.IllegalArgumentException('Value is not of type ' + Kotlin.getKClass(getValue$T_0) + ". Actual value '" + get + "' Type: " + Kotlin.toString(Kotlin.getKClassFromExpression(get).simpleName));
    }
    return tmp$_2;
  });
  Property.prototype.getTypeName_0 = function (valueType) {
    var tmp$, tmp$_0;
    if (Kotlin.equals(valueType, Kotlin.getKClass(StringValue).simpleName) || Kotlin.equals(valueType, Kotlin.getKClass(BooleanValue).simpleName) || Kotlin.equals(valueType, Kotlin.getKClass(ModelIdValue).simpleName)) {
      tmp$_0 = (tmp$ = Kotlin.getKClass(ValuePropertyValue).simpleName) != null ? tmp$ : Kotlin.throwNPE();
    }
     else {
      tmp$_0 = valueType;
    }
    var typeName = tmp$_0;
    return typeName;
  };
  Property.prototype.contains_287e2$ = Kotlin.defineInlineFunction('openorca-js-client.ch.viseon.openOrca.share.impl.Property.contains_287e2$', function (contains$T_0, isT) {
    var tmp$;
    return this.get_61zpoe$((tmp$ = Kotlin.getKClass(contains$T_0).simpleName) != null ? tmp$ : Kotlin.throwNPE()) != null;
  });
  Property.prototype.toString = function () {
    return this.name + ': values: ' + this.propertyValue2Values_0;
  };
  Property.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'Property',
    interfaces: []
  };
  function DefaultPresentationModel(id, type, properties) {
    this.id_yri6lt$_0 = id;
    this.type_yri6lt$_0 = type;
    var $receiver = LinkedHashMap_init();
    var tmp$;
    tmp$ = properties.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var key = element.name;
      $receiver.put_xwzc9p$(key, element);
    }
    this.properties_0 = $receiver;
  }
  Object.defineProperty(DefaultPresentationModel.prototype, 'id', {
    get: function () {
      return this.id_yri6lt$_0;
    }
  });
  Object.defineProperty(DefaultPresentationModel.prototype, 'type', {
    get: function () {
      return this.type_yri6lt$_0;
    }
  });
  DefaultPresentationModel.prototype.getProperties = function () {
    return asSequence(this.properties_0.values);
  };
  DefaultPresentationModel.prototype.get_lqljjj$ = function (propertyName) {
    var tmp$;
    return (tmp$ = this.properties_0.get_11rb$(propertyName)) != null ? tmp$ : Kotlin.throwNPE();
  };
  DefaultPresentationModel.prototype.toString = function () {
    var $receiver = this.properties_0;
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$($receiver.size);
    var tmp$;
    tmp$ = $receiver.entries.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(item.value.toString());
    }
    return destination.toString();
  };
  DefaultPresentationModel.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'DefaultPresentationModel',
    interfaces: [PresentationModel]
  };
  function DefaultPresentationModelStore() {
    this.models_0 = HashMap_init();
    this.modelType2Model_0 = HashMap_init();
  }
  DefaultPresentationModelStore.prototype.addModel_pl55oe$ = function (model) {
    var $receiver = this.models_0;
    var key = model.id;
    $receiver.put_xwzc9p$(key, model);
    var $receiver_0 = this.modelType2Model_0;
    var key_0 = model.type;
    var tmp$;
    var value = $receiver_0.get_11rb$(key_0);
    if (value == null) {
      var answer = ArrayList_init();
      $receiver_0.put_xwzc9p$(key_0, answer);
      tmp$ = answer;
    }
     else {
      tmp$ = value;
    }
    tmp$.add_11rb$(model);
  };
  DefaultPresentationModelStore.prototype.get_accdal$ = function (modelId) {
    var tmp$;
    tmp$ = this.models_0.get_11rb$(modelId);
    if (tmp$ == null) {
      throw new IllegalArgumentException("No model with id '" + modelId + "' present.");
    }
    return tmp$;
  };
  DefaultPresentationModelStore.prototype.get_4tsc7m$ = function (modelType) {
    var tmp$;
    return (tmp$ = this.modelType2Model_0.get_11rb$(modelType)) != null ? tmp$ : Kotlin.kotlin.collections.emptyList_287e2$();
  };
  DefaultPresentationModelStore.prototype.removeModel_accdal$ = function (modelId) {
    var tmp$, tmp$_0;
    var removedPm = (tmp$ = this.models_0.remove_11rb$(modelId)) != null ? tmp$ : Kotlin.throwNPE();
    (tmp$_0 = this.modelType2Model_0.get_11rb$(removedPm.type)) != null ? tmp$_0.remove_11rb$(removedPm) : null;
    return removedPm;
  };
  DefaultPresentationModelStore.prototype.removeModels_4tsc7m$ = function (modelType) {
    var removedPms = this.modelType2Model_0.remove_11rb$(modelType);
    if (removedPms != null) {
      var tmp$;
      tmp$ = removedPms.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        this.models_0.remove_11rb$(element.id);
      }
    }
    return removedPms != null ? removedPms : emptyList();
  };
  DefaultPresentationModelStore.prototype.contains_accdal$ = function (modelId) {
    var $receiver = this.models_0;
    var tmp$;
    return (Kotlin.isType(tmp$ = $receiver, Kotlin.kotlin.collections.Map) ? tmp$ : Kotlin.throwCCE()).containsKey_11rb$(modelId);
  };
  DefaultPresentationModelStore.prototype.contains_4tsc7m$ = function (modelType) {
    var tmp$, tmp$_0;
    return ((tmp$_0 = (tmp$ = this.modelType2Model_0.get_11rb$(modelType)) != null ? tmp$.size : null) != null ? tmp$_0 : 0) >= 0;
  };
  DefaultPresentationModelStore.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'DefaultPresentationModelStore',
    interfaces: [ModelStore]
  };
  function PresentationModelBuilder(modelId, modelType, block) {
    this.modelId = modelId;
    this.modelType = modelType;
    this.properties_0 = ArrayList_init();
    block(this);
  }
  Object.defineProperty(PresentationModelBuilder.prototype, 'propertyList', {
    get: function () {
      return this.properties_0;
    }
  });
  PresentationModelBuilder.prototype.build_9e13n0$ = function (source) {
    return new CreateModelCommandData(source, this.modelId, this.modelType, this.properties_0);
  };
  PresentationModelBuilder.prototype.property_qqeyaj$ = function (name, block) {
    var builder = new PresentationModelBuilder$PropertyBuilder(this, name);
    block(builder);
    this.properties_0.add_11rb$(builder.build());
  };
  PresentationModelBuilder.prototype.createProperty_0 = function (name, values) {
    return new Property(name, values);
  };
  function PresentationModelBuilder$PropertyBuilder($outer, name) {
    this.$outer = $outer;
    this.name = name;
    this.values = LinkedHashMap_init();
  }
  Object.defineProperty(PresentationModelBuilder$PropertyBuilder.prototype, 'label', {
    get: function () {
      var tmp$, tmp$_0;
      return Kotlin.isType(tmp$_0 = this.get_61zpoe$((tmp$ = Kotlin.getKClass(LabelPropertyValue).simpleName) != null ? tmp$ : Kotlin.throwNPE()), LabelPropertyValue) ? tmp$_0 : Kotlin.throwCCE();
    },
    set: function (value) {
      this.set_yi4zkl$(value);
    }
  });
  Object.defineProperty(PresentationModelBuilder$PropertyBuilder.prototype, 'toolTip', {
    get: function () {
      var tmp$, tmp$_0;
      return Kotlin.isType(tmp$_0 = this.get_61zpoe$((tmp$ = Kotlin.getKClass(ToolTipPropertyValue).simpleName) != null ? tmp$ : Kotlin.throwNPE()), ToolTipPropertyValue) ? tmp$_0 : Kotlin.throwCCE();
    },
    set: function (value) {
      this.set_yi4zkl$(value);
    }
  });
  Object.defineProperty(PresentationModelBuilder$PropertyBuilder.prototype, 'value', {
    get: function () {
      var tmp$, tmp$_0;
      return Kotlin.isType(tmp$_0 = this.get_61zpoe$((tmp$ = Kotlin.getKClass(ValuePropertyValue).simpleName) != null ? tmp$ : Kotlin.throwNPE()), ValuePropertyValue) ? tmp$_0 : Kotlin.throwCCE();
    },
    set: function (value) {
      this.set_yi4zkl$(value);
    }
  });
  PresentationModelBuilder$PropertyBuilder.prototype.set_yi4zkl$ = function (propertyValue) {
    var tmp$, tmp$_0;
    tmp$_0 = this.values;
    var key = (tmp$ = Kotlin.getKClassFromExpression(propertyValue).simpleName) != null ? tmp$ : Kotlin.throwNPE();
    tmp$_0.put_xwzc9p$(key, propertyValue);
  };
  PresentationModelBuilder$PropertyBuilder.prototype.get_61zpoe$ = function (typeName) {
    var tmp$;
    return (tmp$ = this.values.get_11rb$(typeName)) != null ? tmp$ : Kotlin.throwNPE();
  };
  PresentationModelBuilder$PropertyBuilder.prototype.build = function () {
    return this.$outer.createProperty_0(this.name, asSequence(this.values.values));
  };
  PresentationModelBuilder$PropertyBuilder.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'PropertyBuilder',
    interfaces: []
  };
  PresentationModelBuilder.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'PresentationModelBuilder',
    interfaces: [ModelBuilder]
  };
  function JsonArray(values) {
    this.values = values;
  }
  JsonArray.prototype.iterator = function () {
    return this.values.iterator();
  };
  JsonArray.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'JsonArray',
    interfaces: [Iterable]
  };
  function JsonObj() {
  }
  JsonObj.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'JsonObj',
    interfaces: []
  };
  function JsonFactory() {
  }
  JsonFactory.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'JsonFactory',
    interfaces: []
  };
  function JsonCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
    var tmp$, tmp$_0, tmp$_1, tmp$_2;
    this.commandCodecs_0 = mapOf([to((tmp$ = Kotlin.getKClass(ActionCommandData).simpleName) != null ? tmp$ : Kotlin.throwNPE(), new ActionCommandCodec(this.jsonFactory_0)), to((tmp$_0 = Kotlin.getKClass(RemoveModelCommandData).simpleName) != null ? tmp$_0 : Kotlin.throwNPE(), new RemoveModelCommandCodec(this.jsonFactory_0)), to((tmp$_1 = Kotlin.getKClass(ChangeValueCommandData).simpleName) != null ? tmp$_1 : Kotlin.throwNPE(), new ChangeValueCommandCodec(this.jsonFactory_0)), to((tmp$_2 = Kotlin.getKClass(CreateModelCommandData).simpleName) != null ? tmp$_2 : Kotlin.throwNPE(), new CreateModelCommandCodec(this.jsonFactory_0))]);
  }
  JsonCodec.prototype.decode_2azfem$ = function (source, data) {
    var json_0 = this.jsonFactory_0.parse_61zpoe$(data);
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$(json_0, 10));
    var tmp$;
    tmp$ = json_0.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      var tmp$_0 = destination.add_11rb$;
      var tmp$_1;
      var type = item.string_61zpoe$('type');
      tmp$_0.call(destination, ((tmp$_1 = this.commandCodecs_0.get_11rb$(type)) != null ? tmp$_1 : Kotlin.throwNPE()).decode_bor1xe$(source, item));
    }
    var result = destination;
    return result;
  };
  function JsonCodec$encode$lambda$lambda(this$JsonCodec) {
    return function (it) {
      var tmp$, tmp$_0;
      return ((tmp$_0 = this$JsonCodec.commandCodecs_0.get_11rb$((tmp$ = Kotlin.getKClassFromExpression(it).simpleName) != null ? tmp$ : Kotlin.throwNPE())) != null ? tmp$_0 : Kotlin.throwNPE()).encode_anzskc$(it);
    };
  }
  function JsonCodec$encode$lambda$lambda_0(it) {
    return it.toJsonString();
  }
  JsonCodec.prototype.encode_6il2lv$ = function (commands) {
    var $receiver = new Kotlin.kotlin.text.StringBuilder();
    $receiver.append_gw00v9$('[');
    $receiver.append_gw00v9$(joinToString(map_2(map_2(asSequence(commands), JsonCodec$encode$lambda$lambda(this)), JsonCodec$encode$lambda$lambda_0), ','));
    $receiver.append_gw00v9$(']');
    return $receiver.toString();
  };
  JsonCodec.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'JsonCodec',
    interfaces: [StringCodec]
  };
  function CommandCodec() {
  }
  CommandCodec.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'CommandCodec',
    interfaces: []
  };
  function ActionCommandCodec(jsonFactory) {
    this.jsonFactory = jsonFactory;
  }
  function ActionCommandCodec$encode$lambda$lambda(closure$typedCommand) {
    return function ($receiver) {
      $receiver.set_puj7f4$('actionName', closure$typedCommand.actionName);
      var $receiver_0 = closure$typedCommand.modelIds;
      var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$($receiver_0, 10));
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(item.stringId);
      }
      $receiver.set_poujtz$('modelIds', destination);
    };
  }
  function ActionCommandCodec$encode$lambda(closure$typedCommand) {
    return function ($receiver) {
      var tmp$;
      $receiver.set_puj7f4$('type', (tmp$ = Kotlin.getKClass(ActionCommandData).simpleName) != null ? tmp$ : Kotlin.throwNPE());
      $receiver.set_8wy9ij$('data', ActionCommandCodec$encode$lambda$lambda(closure$typedCommand));
    };
  }
  ActionCommandCodec.prototype.encode_anzskc$ = function (command) {
    var tmp$;
    var typedCommand = Kotlin.isType(tmp$ = command, ActionCommandData) ? tmp$ : Kotlin.throwCCE();
    var jsonObj = this.jsonFactory.newJson_1j20nt$(ActionCommandCodec$encode$lambda(typedCommand));
    return jsonObj;
  };
  ActionCommandCodec.prototype.decode_bor1xe$ = function (source, json_0) {
    var data = json_0.getObject_61zpoe$('data');
    var modelIds = data.pArray_ytbaoo$('modelIds');
    var tmp$ = data.string_61zpoe$('actionName');
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$(modelIds, 10));
    var tmp$_0;
    tmp$_0 = modelIds.iterator();
    while (tmp$_0.hasNext()) {
      var item = tmp$_0.next();
      destination.add_11rb$(new ModelId(item));
    }
    return new ActionCommandData(source, tmp$, destination);
  };
  ActionCommandCodec.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ActionCommandCodec',
    interfaces: [CommandCodec]
  };
  function RemoveModelCommandCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
  }
  function RemoveModelCommandCodec$encode$lambda$lambda(closure$typedCommand) {
    return function ($receiver) {
      $receiver.set_puj7f4$('modelId', closure$typedCommand.modelId.stringId);
    };
  }
  function RemoveModelCommandCodec$encode$lambda(closure$typedCommand) {
    return function ($receiver) {
      var tmp$;
      $receiver.set_puj7f4$('type', (tmp$ = Kotlin.getKClass(RemoveModelCommandData).simpleName) != null ? tmp$ : Kotlin.throwNPE());
      $receiver.set_8wy9ij$('data', RemoveModelCommandCodec$encode$lambda$lambda(closure$typedCommand));
    };
  }
  RemoveModelCommandCodec.prototype.encode_anzskc$ = function (command) {
    var tmp$;
    var typedCommand = Kotlin.isType(tmp$ = command, RemoveModelCommandData) ? tmp$ : Kotlin.throwCCE();
    return this.jsonFactory_0.newJson_1j20nt$(RemoveModelCommandCodec$encode$lambda(typedCommand));
  };
  RemoveModelCommandCodec.prototype.decode_bor1xe$ = function (source, json_0) {
    var data = json_0.getObject_61zpoe$('data');
    return new RemoveModelCommandData(source, new ModelId(data.string_61zpoe$('modelId')));
  };
  RemoveModelCommandCodec.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'RemoveModelCommandCodec',
    interfaces: [CommandCodec]
  };
  function ChangeValueCommandCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
  }
  function ChangeValueCommandCodec$encode$lambda$lambda$lambda(closure$changeValueCommand) {
    return function ($receiver) {
      valueToJson($receiver, closure$changeValueCommand.value);
    };
  }
  function ChangeValueCommandCodec$encode$lambda$lambda(closure$changeValueCommand, this$ChangeValueCommandCodec) {
    return function ($receiver) {
      $receiver.set_puj7f4$('modelId', closure$changeValueCommand.modelId.stringId);
      $receiver.set_puj7f4$('propertyName', closure$changeValueCommand.propertyName.name);
      $receiver.set_6xncmk$('value', this$ChangeValueCommandCodec.jsonFactory_0.newJson_1j20nt$(ChangeValueCommandCodec$encode$lambda$lambda$lambda(closure$changeValueCommand)));
    };
  }
  function ChangeValueCommandCodec$encode$lambda(closure$changeValueCommand, this$ChangeValueCommandCodec) {
    return function ($receiver) {
      var tmp$;
      $receiver.set_puj7f4$('type', (tmp$ = Kotlin.getKClass(ChangeValueCommandData).simpleName) != null ? tmp$ : Kotlin.throwNPE());
      $receiver.set_8wy9ij$('data', ChangeValueCommandCodec$encode$lambda$lambda(closure$changeValueCommand, this$ChangeValueCommandCodec));
    };
  }
  ChangeValueCommandCodec.prototype.encode_anzskc$ = function (command) {
    var tmp$;
    var changeValueCommand = Kotlin.isType(tmp$ = command, ChangeValueCommandData) ? tmp$ : Kotlin.throwCCE();
    return this.jsonFactory_0.newJson_1j20nt$(ChangeValueCommandCodec$encode$lambda(changeValueCommand, this));
  };
  ChangeValueCommandCodec.prototype.decode_bor1xe$ = function (source, json_0) {
    var data = json_0.getObject_61zpoe$('data');
    var modelId = new ModelId(data.string_61zpoe$('modelId'));
    var propertyName = new PropertyName(data.string_61zpoe$('propertyName'));
    var propertyValue = valueFromJson(data.getObject_61zpoe$('value'));
    return new ChangeValueCommandData(source, modelId, propertyName, propertyValue);
  };
  ChangeValueCommandCodec.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ChangeValueCommandCodec',
    interfaces: [CommandCodec]
  };
  function CreateModelCommandCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
  }
  function CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda$lambda$lambda(closure$it) {
    return function ($receiver) {
      valueToJson($receiver, closure$it);
    };
  }
  function CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda$lambda(this$CreateModelCommandCodec) {
    return function (it) {
      return this$CreateModelCommandCodec.jsonFactory_0.newJson_1j20nt$(CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda$lambda$lambda(it));
    };
  }
  function CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda(closure$it, this$CreateModelCommandCodec) {
    return function ($receiver) {
      $receiver.set_puj7f4$('propertyName', closure$it.name.name);
      $receiver.set_jqxvxq$('values', new JsonArray(toList_0(map_2(map_2(closure$it.getValues(), Kotlin.getPropertyCallableRef('value', 1, function ($receiver_0) {
        return $receiver_0.value;
      })), CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda$lambda(this$CreateModelCommandCodec)))));
    };
  }
  function CreateModelCommandCodec$encode$lambda$lambda(closure$createCommand, this$CreateModelCommandCodec) {
    return function ($receiver) {
      $receiver.set_puj7f4$('modelId', closure$createCommand.modelId.stringId);
      $receiver.set_puj7f4$('type', closure$createCommand.modelType.stringId);
      var $receiver_0 = closure$createCommand.properties;
      var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$($receiver_0, 10));
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        var tmp$_0 = destination.add_11rb$;
        var this$CreateModelCommandCodec_0 = this$CreateModelCommandCodec;
        tmp$_0.call(destination, this$CreateModelCommandCodec_0.jsonFactory_0.newJson_1j20nt$(CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda(item, this$CreateModelCommandCodec_0)));
      }
      $receiver.set_jqxvxq$('properties', new JsonArray(destination));
    };
  }
  function CreateModelCommandCodec$encode$lambda(closure$createCommand, this$CreateModelCommandCodec) {
    return function ($receiver) {
      var tmp$;
      $receiver.set_puj7f4$('type', (tmp$ = Kotlin.getKClass(CreateModelCommandData).simpleName) != null ? tmp$ : Kotlin.throwNPE());
      $receiver.set_8wy9ij$('data', CreateModelCommandCodec$encode$lambda$lambda(closure$createCommand, this$CreateModelCommandCodec));
    };
  }
  CreateModelCommandCodec.prototype.encode_anzskc$ = function (command) {
    var tmp$;
    var createCommand = Kotlin.isType(tmp$ = command, CreateModelCommandData) ? tmp$ : Kotlin.throwCCE();
    return this.jsonFactory_0.newJson_1j20nt$(CreateModelCommandCodec$encode$lambda(createCommand, this));
  };
  CreateModelCommandCodec.prototype.decode_bor1xe$ = function (source, json_0) {
    var data = json_0.getObject_61zpoe$('data');
    var properties = data.oArray_61zpoe$('properties');
    var tmp$ = new ModelId(data.string_61zpoe$('modelId'));
    var tmp$_0 = new ModelType(data.string_61zpoe$('type'));
    var destination = Kotlin.kotlin.collections.ArrayList_init_ww73n8$(Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$(properties, 10));
    var tmp$_1;
    tmp$_1 = properties.iterator();
    while (tmp$_1.hasNext()) {
      var item = tmp$_1.next();
      var tmp$_2 = destination.add_11rb$;
      var values = item.oArray_61zpoe$('values');
      tmp$_2.call(destination, new Property(new PropertyName(item.string_61zpoe$('propertyName')), map_2(asSequence(values), Kotlin.getCallableRef('valueFromJson', function (json_0) {
        return valueFromJson(json_0);
      }))));
    }
    return new CreateModelCommandData(source, tmp$, tmp$_0, destination);
  };
  CreateModelCommandCodec.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'CreateModelCommandCodec',
    interfaces: [CommandCodec]
  };
  function valueToJson(jsonObj, value) {
    jsonObj.set_puj7f4$('type', value.getJsonTypeId());
    jsonObj.set_puj7f4$('value', value.asJsonValue());
    return jsonObj;
  }
  function valueFromJson(json_0) {
    var tmp$_2;
    var type = json_0.string_61zpoe$('type');
    if (Kotlin.equals(type, Kotlin.getKClass(ToolTipPropertyValue).simpleName))
      tmp$_2 = new ToolTipPropertyValue(json_0.string_61zpoe$('value'));
    else if (Kotlin.equals(type, Kotlin.getKClass(LabelPropertyValue).simpleName))
      tmp$_2 = new LabelPropertyValue(json_0.string_61zpoe$('value'));
    else {
      var tmp$;
      if (Kotlin.equals(type, (tmp$ = Kotlin.getKClass(StringValue).simpleName) != null ? tmp$ : Kotlin.throwNPE()))
        tmp$_2 = new StringValue(json_0.string_61zpoe$('value'));
      else {
        var tmp$_0;
        if (Kotlin.equals(type, (tmp$_0 = Kotlin.getKClass(BooleanValue).simpleName) != null ? tmp$_0 : Kotlin.throwNPE()))
          tmp$_2 = new BooleanValue(json_0.boolean_61zpoe$('value'));
        else {
          var tmp$_1;
          if (Kotlin.equals(type, (tmp$_1 = Kotlin.getKClass(ModelId).simpleName) != null ? tmp$_1 : Kotlin.throwNPE()))
            tmp$_2 = new ModelIdValue(new ModelId(json_0.string_61zpoe$('value')));
          else {
            throw new IllegalArgumentException("Unknown propertyValue type: '" + type + "'");
          }
        }
      }
    }
    return tmp$_2;
  }
  function PresentationModel() {
  }
  PresentationModel.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'PresentationModel',
    interfaces: []
  };
  function ModelId(stringId) {
    this.stringId = stringId;
  }
  ModelId.prototype.asValue = function () {
    return new ModelIdValue(this);
  };
  ModelId.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ModelId',
    interfaces: []
  };
  ModelId.prototype.component1 = function () {
    return this.stringId;
  };
  ModelId.prototype.copy_61zpoe$ = function (stringId) {
    return new ModelId(stringId === void 0 ? this.stringId : stringId);
  };
  ModelId.prototype.toString = function () {
    return 'ModelId(stringId=' + Kotlin.toString(this.stringId) + ')';
  };
  ModelId.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.stringId) | 0;
    return result;
  };
  ModelId.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.stringId, other.stringId))));
  };
  function ModelType(stringId) {
    this.stringId = stringId;
  }
  ModelType.prototype.asValue = function () {
    return new StringValue(this.stringId);
  };
  ModelType.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ModelType',
    interfaces: []
  };
  ModelType.prototype.component1 = function () {
    return this.stringId;
  };
  ModelType.prototype.copy_61zpoe$ = function (stringId) {
    return new ModelType(stringId === void 0 ? this.stringId : stringId);
  };
  ModelType.prototype.toString = function () {
    return 'ModelType(stringId=' + Kotlin.toString(this.stringId) + ')';
  };
  ModelType.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.stringId) | 0;
    return result;
  };
  ModelType.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.stringId, other.stringId))));
  };
  function PropertyName(name) {
    this.name = name;
  }
  PropertyName.prototype.asValue = function () {
    return new StringValue(this.name);
  };
  PropertyName.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'PropertyName',
    interfaces: []
  };
  PropertyName.prototype.component1 = function () {
    return this.name;
  };
  PropertyName.prototype.copy_61zpoe$ = function (name) {
    return new PropertyName(name === void 0 ? this.name : name);
  };
  PropertyName.prototype.toString = function () {
    return 'PropertyName(name=' + Kotlin.toString(this.name) + ')';
  };
  PropertyName.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    return result;
  };
  PropertyName.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.name, other.name))));
  };
  function ModelBuilder() {
  }
  ModelBuilder.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'ModelBuilder',
    interfaces: []
  };
  ClientCommandListExecutor.prototype.execute_isgdc6$ = CommandListExecutor.prototype.execute_isgdc6$;
  var package$ch = _.ch || (_.ch = {});
  var package$viseon = package$ch.viseon || (package$ch.viseon = {});
  var package$openOrca = package$viseon.openOrca || (package$viseon.openOrca = {});
  var package$client = package$openOrca.client || (package$openOrca.client = {});
  package$client.ClientOrca = ClientOrca;
  package$client.just_mh5how$ = just;
  var package$impl = package$client.impl || (package$client.impl = {});
  package$impl.JsonFactoryJs = JsonFactoryJs;
  package$impl.JsonObjJs_init_1j20nt$ = JsonObjJs_init;
  package$impl.JsonObjJs = JsonObjJs;
  package$impl.ClientOrcaImpl = ClientOrcaImpl;
  package$impl.CommandListExecutor = CommandListExecutor;
  package$impl.ClientCommandListExecutor = ClientCommandListExecutor;
  package$impl.CommandExecutor = CommandExecutor;
  package$client.Transmitter = Transmitter;
  package$client.XMLHttpRequestTransmitter = XMLHttpRequestTransmitter;
  package$client.Codec = Codec;
  var package$share = package$openOrca.share || (package$openOrca.share = {});
  package$share.CommandData = CommandData;
  package$share.ChangeValueCommandData = ChangeValueCommandData;
  package$share.CreateModelCommandData = CreateModelCommandData;
  package$share.RemoveModelCommandData = RemoveModelCommandData;
  package$share.ActionCommandData = ActionCommandData;
  package$share.RemoveModelByTypeCommandData = RemoveModelByTypeCommandData;
  package$share.SyncModelCommandData = SyncModelCommandData;
  package$share.ModelStore = ModelStore;
  package$share.StringCodec = StringCodec;
  package$share.PropertyValue = PropertyValue;
  package$share.ToolTipPropertyValue = ToolTipPropertyValue;
  package$share.LabelPropertyValue = LabelPropertyValue;
  package$share.ValuePropertyValue = ValuePropertyValue;
  package$share.ModelIdValue = ModelIdValue;
  package$share.StringValue = StringValue;
  package$share.BooleanValue = BooleanValue;
  Object.defineProperty(Source, 'REQUEST', {
    get: Source$REQUEST_getInstance
  });
  Object.defineProperty(Source, 'RESPONSE', {
    get: Source$RESPONSE_getInstance
  });
  package$share.Source = Source;
  package$share.Event = Event;
  Object.defineProperty(ModelStoreChangeEvent$Type, 'ADD', {
    get: ModelStoreChangeEvent$Type$ADD_getInstance
  });
  Object.defineProperty(ModelStoreChangeEvent$Type, 'REMOVE', {
    get: ModelStoreChangeEvent$Type$REMOVE_getInstance
  });
  ModelStoreChangeEvent.Type = ModelStoreChangeEvent$Type;
  package$share.ModelStoreChangeEvent = ModelStoreChangeEvent;
  package$share.PropertyChangeEvent = PropertyChangeEvent;
  package$share.ValueChangeEvent = ValueChangeEvent;
  package$share.ActionEvent = ActionEvent;
  Property.getValue$f = Property$getValue$lambda;
  var package$impl_0 = package$share.impl || (package$share.impl = {});
  package$impl_0.Property = Property;
  package$impl_0.DefaultPresentationModel = DefaultPresentationModel;
  package$impl_0.DefaultPresentationModelStore = DefaultPresentationModelStore;
  PresentationModelBuilder.PropertyBuilder = PresentationModelBuilder$PropertyBuilder;
  package$impl_0.PresentationModelBuilder = PresentationModelBuilder;
  package$share.JsonArray = JsonArray;
  package$share.JsonObj = JsonObj;
  package$share.JsonFactory = JsonFactory;
  package$share.JsonCodec = JsonCodec;
  package$share.CommandCodec = CommandCodec;
  package$share.valueToJson_lzol5z$ = valueToJson;
  package$share.valueFromJson_ipy83i$ = valueFromJson;
  package$share.PresentationModel = PresentationModel;
  package$share.ModelId = ModelId;
  package$share.ModelType = ModelType;
  package$share.PropertyName = PropertyName;
  package$share.ModelBuilder = ModelBuilder;
  Kotlin.defineModule('openorca-js-client', _);
  return _;
}));

//@ sourceMappingURL=openorca-js-client.js.map
