(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'rxjs/Rx', 'kodando-rxjs'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('rxjs/Rx'), require('kodando-rxjs'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'openorca-js-client'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'openorca-js-client'.");
    }
    if (typeof Rx === 'undefined') {
      throw new Error("Error loading module 'openorca-js-client'. Its dependency 'rxjs/Rx' was not found. Please, check whether 'rxjs/Rx' is loaded prior to 'openorca-js-client'.");
    }
    if (typeof this['kodando-rxjs'] === 'undefined') {
      throw new Error("Error loading module 'openorca-js-client'. Its dependency 'kodando-rxjs' was not found. Please, check whether 'kodando-rxjs' is loaded prior to 'openorca-js-client'.");
    }
    root['openorca-js-client'] = factory(typeof this['openorca-js-client'] === 'undefined' ? {} : this['openorca-js-client'], kotlin, Rx, this['kodando-rxjs']);
  }
}(this, function (_, Kotlin, $module$rxjs_Rx, $module$kodando_rxjs) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Enum = Kotlin.kotlin.Enum;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var throwISE = Kotlin.throwISE;
  var Rx$Observable$Companion = $module$rxjs_Rx.Observable;
  var Unit = Kotlin.kotlin.Unit;
  var Throwable = Error;
  var throwCCE = Kotlin.throwCCE;
  var equals = Kotlin.equals;
  var Rx$Subject = $module$rxjs_Rx.Subject;
  var RuntimeException_init = Kotlin.kotlin.RuntimeException_init_pdl1vj$;
  var Exception = Kotlin.kotlin.Exception;
  var getCallableRef = Kotlin.getCallableRef;
  var toString = Kotlin.toString;
  var toInt = Kotlin.kotlin.text.toInt_pdl1vz$;
  var toLong = Kotlin.kotlin.text.toLong_pdl1vz$;
  var toDouble = Kotlin.kotlin.text.toDouble_pdl1vz$;
  var asIterable = Kotlin.kotlin.collections.asIterable_us0mfu$;
  var toMutableList = Kotlin.kotlin.collections.toMutableList_4c7yge$;
  var json = Kotlin.kotlin.js.json_pyyo18$;
  var Error_0 = Kotlin.kotlin.Error;
  var Error_init = Kotlin.kotlin.Error_init_pdl1vj$;
  var toShort = Kotlin.toShort;
  var ensureNotNull = Kotlin.ensureNotNull;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var getKClass = Kotlin.getKClass;
  var to = Kotlin.kotlin.to_ujzrz7$;
  var mapOf = Kotlin.kotlin.collections.mapOf_qfcya0$;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Iterable = Kotlin.kotlin.collections.Iterable;
  var emptyList = Kotlin.kotlin.collections.emptyList_287e2$;
  var asSequence = Kotlin.kotlin.collections.asSequence_7wnvza$;
  var map = Kotlin.kotlin.sequences.map_z5avom$;
  var joinToString = Kotlin.kotlin.sequences.joinToString_853xkz$;
  var toList = Kotlin.kotlin.sequences.toList_veqyi0$;
  var toSet = Kotlin.kotlin.sequences.toSet_veqyi0$;
  var toList_0 = Kotlin.kotlin.collections.toList_7wnvza$;
  var toBoxedChar = Kotlin.toBoxedChar;
  var Pair = Kotlin.kotlin.Pair;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var wrapFunction = Kotlin.wrapFunction;
  var hashCode = Kotlin.hashCode;
  var emptySet = Kotlin.kotlin.collections.emptySet_287e2$;
  var HashMap_init = Kotlin.kotlin.collections.HashMap_init_q3lmfv$;
  var listOf = Kotlin.kotlin.collections.listOf_mh5how$;
  var mapIndexed = Kotlin.kotlin.sequences.mapIndexed_b7yuyq$;
  var filter = Kotlin.kotlin.sequences.filter_euau3h$;
  var flatMap = Kotlin.kotlin.sequences.flatMap_49vfel$;
  var emptySequence = Kotlin.kotlin.sequences.emptySequence_287e2$;
  RequestEvent.prototype = Object.create(Enum.prototype);
  RequestEvent.prototype.constructor = RequestEvent;
  ApplyPolicy.prototype = Object.create(Enum.prototype);
  ApplyPolicy.prototype.constructor = ApplyPolicy;
  ModelStoreChangeEventType.prototype = Object.create(Enum.prototype);
  ModelStoreChangeEventType.prototype.constructor = ModelStoreChangeEventType;
  Source.prototype = Object.create(Enum.prototype);
  Source.prototype.constructor = Source;
  function ClientOrca() {
  }
  ClientOrca.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ClientOrca',
    interfaces: []
  };
  function RequestEvent(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function RequestEvent_initFields() {
    RequestEvent_initFields = function () {
    };
    RequestEvent$START_instance = new RequestEvent('START', 0);
    RequestEvent$END_instance = new RequestEvent('END', 1);
  }
  var RequestEvent$START_instance;
  function RequestEvent$START_getInstance() {
    RequestEvent_initFields();
    return RequestEvent$START_instance;
  }
  var RequestEvent$END_instance;
  function RequestEvent$END_getInstance() {
    RequestEvent_initFields();
    return RequestEvent$END_instance;
  }
  RequestEvent.prototype.isStart = function () {
    return this === RequestEvent$START_getInstance();
  };
  RequestEvent.prototype.isEnd = function () {
    return this === RequestEvent$END_getInstance();
  };
  RequestEvent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RequestEvent',
    interfaces: [Enum]
  };
  function RequestEvent$values() {
    return [RequestEvent$START_getInstance(), RequestEvent$END_getInstance()];
  }
  RequestEvent.values = RequestEvent$values;
  function RequestEvent$valueOf(name) {
    switch (name) {
      case 'START':
        return RequestEvent$START_getInstance();
      case 'END':
        return RequestEvent$END_getInstance();
      default:throwISE('No enum constant ch.viseon.openOrca.client.RequestEvent.' + name);
    }
  }
  RequestEvent.valueOf_61zpoe$ = RequestEvent$valueOf;
  function ClientOrcaImpl(commandListExecutor, transmitter) {
    this.commandListExecutor_0 = commandListExecutor;
    this.transmitter_0 = transmitter;
    this.clientModelStore = new DefaultPresentationModelStore();
    this.eventSubject_0 = new Rx$Subject();
    this.requestTrackerSubject_0 = new Rx$Subject();
  }
  function ClientOrcaImpl$executeCommands$lambda(closure$eventsFromInputCommands, closure$commandsToSend) {
    return function (it) {
      if (it.applied) {
        closure$eventsFromInputCommands.add_11rb$(it.events);
      }
      if (it.sendCommand()) {
        closure$commandsToSend.add_11rb$(it.commandData);
      }
      return Unit;
    };
  }
  function ClientOrcaImpl$executeCommands$lambda_0(it) {
    return it.applied;
  }
  function ClientOrcaImpl$executeCommands$lambda_1(it) {
    return it.events;
  }
  function ClientOrcaImpl$executeCommands$lambda_2(this$ClientOrcaImpl) {
    return function (events) {
      var tmp$;
      tmp$ = events.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        this$ClientOrcaImpl.eventSubject_0.next(element);
      }
      return Unit;
    };
  }
  function ClientOrcaImpl$executeCommands$lambda_3(it) {
    if (Kotlin.isType(it, Throwable)) {
      console.error(Kotlin.newThrowable('Error during command processing', it));
    }
     else {
      console.error('Error during command processing');
      console.error(it);
    }
    return Unit;
  }
  function ClientOrcaImpl$executeCommands$lambda_4(this$ClientOrcaImpl) {
    return function () {
      this$ClientOrcaImpl.requestTrackerSubject_0.next(RequestEvent$END_getInstance());
      return Unit;
    };
  }
  var copyToArray = Kotlin.kotlin.collections.copyToArray;
  ClientOrcaImpl.prototype.executeCommands = function (commands) {
    if (commands.length === 0) {
      return;
    }
    var appliedCommands = this.commandListExecutor_0.execute_nhty4f$(this.clientModelStore, Rx$Observable$Companion.from(commands));
    var commandsToSend = ArrayList_init();
    var eventsFromInputCommands = ArrayList_init();
    appliedCommands.subscribe(ClientOrcaImpl$executeCommands$lambda(eventsFromInputCommands, commandsToSend));
    var responseCommands = this.transmitter_0.sendCommands_gjicav$(commandsToSend);
    var responseEvents = this.commandListExecutor_0.execute_nhty4f$(this.clientModelStore, responseCommands);
    var finalObservable = Rx$Observable$Companion.merge(Rx$Observable$Companion.from(copyToArray(eventsFromInputCommands)), responseEvents.filter(ClientOrcaImpl$executeCommands$lambda_0).map(ClientOrcaImpl$executeCommands$lambda_1));
    this.requestTrackerSubject_0.next(RequestEvent$START_getInstance());
    finalObservable.subscribe(ClientOrcaImpl$executeCommands$lambda_2(this), ClientOrcaImpl$executeCommands$lambda_3, ClientOrcaImpl$executeCommands$lambda_4(this));
  };
  function ClientOrcaImpl$observeModelStore$lambda(it) {
    return Kotlin.isType(it, ModelStoreChangeEvent);
  }
  function ClientOrcaImpl$observeModelStore$lambda_0(it) {
    var tmp$;
    return Kotlin.isType(tmp$ = it, ModelStoreChangeEvent) ? tmp$ : throwCCE();
  }
  ClientOrcaImpl.prototype.observeModelStore = function () {
    return this.eventSubject_0.filter(ClientOrcaImpl$observeModelStore$lambda).map(ClientOrcaImpl$observeModelStore$lambda_0);
  };
  function ClientOrcaImpl$observeModel$lambda(closure$modelId) {
    return function (it) {
      var tmp$;
      return (tmp$ = it.modelId) != null ? tmp$.equals(closure$modelId) : null;
    };
  }
  ClientOrcaImpl.prototype.observeModelById = function (modelId) {
    return this.eventStreamAsPropertyChangeEvent_0().filter(ClientOrcaImpl$observeModel$lambda(modelId));
  };
  function ClientOrcaImpl$observeModel$lambda_0(closure$modelType) {
    return function (it) {
      var tmp$;
      return (tmp$ = it.modelType) != null ? tmp$.equals(closure$modelType) : null;
    };
  }
  ClientOrcaImpl.prototype.observeModelByType = function (modelType) {
    return this.eventStreamAsPropertyChangeEvent_0().filter(ClientOrcaImpl$observeModel$lambda_0(modelType));
  };
  function ClientOrcaImpl$observeProperty$lambda(closure$modelId) {
    return function (it) {
      var tmp$;
      return (tmp$ = it.modelId) != null ? tmp$.equals(closure$modelId) : null;
    };
  }
  function ClientOrcaImpl$observeProperty$lambda_0(closure$propertyName) {
    return function (it) {
      var tmp$;
      return (tmp$ = it.valueChangeEvent.property) != null ? tmp$.equals(closure$propertyName) : null;
    };
  }
  function ClientOrcaImpl$observeProperty$lambda_1(it) {
    return it.valueChangeEvent;
  }
  ClientOrcaImpl.prototype.observeProperty = function (modelId, propertyName) {
    return this.eventStreamAsPropertyChangeEvent_0().filter(ClientOrcaImpl$observeProperty$lambda(modelId)).filter(ClientOrcaImpl$observeProperty$lambda_0(propertyName)).map(ClientOrcaImpl$observeProperty$lambda_1);
  };
  function ClientOrcaImpl$eventStreamAsPropertyChangeEvent$lambda(it) {
    return Kotlin.isType(it, PropertyChangeEvent);
  }
  function ClientOrcaImpl$eventStreamAsPropertyChangeEvent$lambda_0(it) {
    var tmp$;
    return Kotlin.isType(tmp$ = it, PropertyChangeEvent) ? tmp$ : throwCCE();
  }
  ClientOrcaImpl.prototype.eventStreamAsPropertyChangeEvent_0 = function () {
    return this.eventSubject_0.filter(ClientOrcaImpl$eventStreamAsPropertyChangeEvent$lambda).map(ClientOrcaImpl$eventStreamAsPropertyChangeEvent$lambda_0);
  };
  function ClientOrcaImpl$registerNamedCommand$lambda(it) {
    return Kotlin.isType(it, ActionEvent);
  }
  function ClientOrcaImpl$registerNamedCommand$lambda_0(it) {
    var tmp$;
    return Kotlin.isType(tmp$ = it, ActionEvent) ? tmp$ : throwCCE();
  }
  function ClientOrcaImpl$registerNamedCommand$lambda_1(closure$actionName) {
    return function (it) {
      return equals(it.actionName, closure$actionName);
    };
  }
  ClientOrcaImpl.prototype.registerNamedCommand = function (actionName) {
    return this.eventSubject_0.filter(ClientOrcaImpl$registerNamedCommand$lambda).map(ClientOrcaImpl$registerNamedCommand$lambda_0).filter(ClientOrcaImpl$registerNamedCommand$lambda_1(actionName));
  };
  ClientOrcaImpl.prototype.getModelByType = function (modelType) {
    return copyToArray(this.clientModelStore.get_4tsc7m$(modelType));
  };
  ClientOrcaImpl.prototype.getModelById = function (modelId) {
    return this.clientModelStore.get_accdal$(modelId);
  };
  ClientOrcaImpl.prototype.containsModelById = function (modelId) {
    return this.clientModelStore.contains_accdal$(modelId);
  };
  ClientOrcaImpl.prototype.containsModelByType = function (modelId) {
    return this.clientModelStore.contains_4tsc7m$(modelId);
  };
  ClientOrcaImpl.prototype.getAllModels = function () {
    return copyToArray(this.clientModelStore.getAllModels());
  };
  ClientOrcaImpl.prototype.observeRequest = function () {
    return this.requestTrackerSubject_0;
  };
  ClientOrcaImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ClientOrcaImpl',
    interfaces: [ClientOrca]
  };
  function CommandListExecutor() {
  }
  CommandListExecutor.prototype.execute_sy5qnb$ = function (modelStore, commandData) {
    return this.execute_nhty4f$(modelStore, just(commandData));
  };
  CommandListExecutor.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CommandListExecutor',
    interfaces: []
  };
  function ClientCommandListExecutor() {
  }
  function ClientCommandListExecutor$execute$lambda(closure$modelStore, this$ClientCommandListExecutor) {
    return function (it) {
      return this$ClientCommandListExecutor.applyCommand_0(closure$modelStore, it);
    };
  }
  ClientCommandListExecutor.prototype.execute_nhty4f$ = function (modelStore, commandData) {
    return commandData.flatMap(ClientCommandListExecutor$execute$lambda(modelStore, this));
  };
  ClientCommandListExecutor.prototype.applyCommand_0 = function (modelStore, it) {
    try {
      return Rx$Observable$Companion.of(CommandApplier_getInstance().apply_mq2q7b$(Source$REQUEST_getInstance(), modelStore, it));
    }
     catch (e) {
      if (Kotlin.isType(e, Exception)) {
        throw RuntimeException_init('Error during application of command ' + it + '.' + '\n' + ' Original error: ' + e);
      }
       else
        throw e;
    }
  };
  ClientCommandListExecutor.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ClientCommandListExecutor',
    interfaces: [CommandListExecutor]
  };
  function JsonFactoryJs() {
  }
  JsonFactoryJs.prototype.newJson_1j20nt$ = function (block) {
    return JsonObjJs_init(block);
  };
  JsonFactoryJs.prototype.parse_61zpoe$ = function (content) {
    var $receiver = JSON.parse(content);
    var destination = ArrayList_init($receiver.length);
    var tmp$;
    for (tmp$ = 0; tmp$ !== $receiver.length; ++tmp$) {
      var item = $receiver[tmp$];
      destination.add_11rb$(new JsonObjJs(item));
    }
    return new JsonArray(destination);
  };
  JsonFactoryJs.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsonFactoryJs',
    interfaces: [JsonFactory]
  };
  function JsonObjJs(json_0) {
    if (json_0 === void 0)
      json_0 = json([]);
    this.json = json_0;
  }
  JsonObjJs.prototype.integer_61zpoe$ = function (key) {
    return toInt(toString(this.json[key]));
  };
  JsonObjJs.prototype.long_61zpoe$ = function (key) {
    return toLong(toString(this.json[key]));
  };
  JsonObjJs.prototype.float_61zpoe$ = function (key) {
    return toDouble(toString(this.json[key]));
  };
  JsonObjJs.prototype.double_61zpoe$ = function (key) {
    return toDouble(toString(this.json[key]));
  };
  JsonObjJs.prototype.boolean_61zpoe$ = function (key) {
    return equals(this.json[key], 'true');
  };
  JsonObjJs.prototype.pArray_ytbaoo$ = function (key) {
    var tmp$;
    var array = Kotlin.isArray(tmp$ = this.json[key]) ? tmp$ : throwCCE();
    return new JsonArray(asIterable(array));
  };
  JsonObjJs.prototype.oArray_61zpoe$ = function (key) {
    var tmp$;
    var $receiver = Kotlin.isArray(tmp$ = this.json[key]) ? tmp$ : throwCCE();
    var destination = ArrayList_init($receiver.length);
    var tmp$_0;
    for (tmp$_0 = 0; tmp$_0 !== $receiver.length; ++tmp$_0) {
      var item = $receiver[tmp$_0];
      destination.add_11rb$(new JsonObjJs(item));
    }
    var values = toMutableList(destination);
    return new JsonArray(values);
  };
  JsonObjJs.prototype.string_61zpoe$ = function (key) {
    var tmp$;
    return typeof (tmp$ = this.json[key]) === 'string' ? tmp$ : throwCCE();
  };
  JsonObjJs.prototype.optionalString_61zpoe$ = function (key) {
    var tmp$;
    return (tmp$ = this.json[key]) == null || typeof tmp$ === 'string' ? tmp$ : throwCCE();
  };
  JsonObjJs.prototype.optionalBoolean_61zpoe$ = function (key) {
    var tmp$;
    return (tmp$ = this.json[key]) == null || typeof tmp$ === 'boolean' ? tmp$ : throwCCE();
  };
  JsonObjJs.prototype.getObject_61zpoe$ = function (key) {
    var tmp$;
    return new JsonObjJs(Kotlin.isType(tmp$ = this.json[key], Object) ? tmp$ : throwCCE());
  };
  JsonObjJs.prototype.set_puj7f4$ = function (key, value) {
    this.json[key] = value;
  };
  JsonObjJs.prototype.set_ivxn3r$ = function (key, value) {
    this.json[key] = value;
  };
  JsonObjJs.prototype.set_c1kmwu$ = function (key, value) {
    this.json[key] = value;
  };
  JsonObjJs.prototype.set_6xncmk$ = function (key, value) {
    var tmp$;
    this.json[key] = (Kotlin.isType(tmp$ = value, JsonObjJs) ? tmp$ : throwCCE()).json;
  };
  var collectionSizeOrDefault = Kotlin.kotlin.collections.collectionSizeOrDefault_ba2ldo$;
  JsonObjJs.prototype.set_jqxvxq$ = function (key, value) {
    var tmp$ = this.json;
    var destination = ArrayList_init(collectionSizeOrDefault(value, 10));
    var tmp$_0;
    tmp$_0 = value.iterator();
    while (tmp$_0.hasNext()) {
      var item = tmp$_0.next();
      var tmp$_1;
      destination.add_11rb$((Kotlin.isType(tmp$_1 = item, JsonObjJs) ? tmp$_1 : throwCCE()).json);
    }
    tmp$[key] = destination;
  };
  JsonObjJs.prototype.set_poujtz$ = function (key, value) {
    this.json[key] = value;
  };
  JsonObjJs.prototype.set_8wy9ij$ = function (key, block) {
    var subJsonObj = new JsonObjJs();
    block(subJsonObj);
    this.json[key] = subJsonObj.json;
  };
  JsonObjJs.prototype.toJsonString = function () {
    return JSON.stringify(this.json);
  };
  JsonObjJs.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsonObjJs',
    interfaces: [JsonObj]
  };
  function JsonObjJs_init(block, $this) {
    $this = $this || Object.create(JsonObjJs.prototype);
    JsonObjJs.call($this);
    block($this);
    return $this;
  }
  function just(t) {
    return Rx$Observable$Companion.of(t);
  }
  function Transmitter() {
  }
  Transmitter.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Transmitter',
    interfaces: []
  };
  function XMLHttpRequestTransmitter(url, codec) {
    this.url = url;
    this.codec = codec;
    this.commandQueue_0 = ArrayList_init();
    this.request_0 = new XMLHttpRequest();
    this.alreadySending_0 = false;
  }
  function XMLHttpRequestTransmitter$CommandSubjectPair(commands) {
    this.commands = commands;
    this.subject = new Rx$Subject();
  }
  XMLHttpRequestTransmitter$CommandSubjectPair.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CommandSubjectPair',
    interfaces: []
  };
  function XMLHttpRequestTransmitter$sendCommands$lambda$lambda(closure$observer) {
    return function (it) {
      closure$observer.next(it);
      return Unit;
    };
  }
  function XMLHttpRequestTransmitter$sendCommands$lambda$lambda_0(closure$observer) {
    return function (error) {
      var tmp$, tmp$_0;
      tmp$_0 = Kotlin.isType(tmp$ = error, Error_0) ? tmp$ : throwCCE();
      closure$observer.error(tmp$_0);
      return Unit;
    };
  }
  function XMLHttpRequestTransmitter$sendCommands$lambda$lambda_1(closure$observer, this$XMLHttpRequestTransmitter) {
    return function () {
      closure$observer.complete();
      this$XMLHttpRequestTransmitter.sendComplete_0();
      return Unit;
    };
  }
  function XMLHttpRequestTransmitter$sendCommands$lambda(closure$commands, this$XMLHttpRequestTransmitter) {
    return function (observer) {
      var pair = new XMLHttpRequestTransmitter$CommandSubjectPair(closure$commands);
      this$XMLHttpRequestTransmitter.commandQueue_0.add_11rb$(pair);
      var result = pair.subject.subscribe(XMLHttpRequestTransmitter$sendCommands$lambda$lambda(observer), XMLHttpRequestTransmitter$sendCommands$lambda$lambda_0(observer), XMLHttpRequestTransmitter$sendCommands$lambda$lambda_1(observer, this$XMLHttpRequestTransmitter));
      this$XMLHttpRequestTransmitter.send_0();
      return result;
    };
  }
  XMLHttpRequestTransmitter.prototype.sendCommands_gjicav$ = function (commands) {
    if (commands.isEmpty()) {
      return Rx$Observable$Companion.empty();
    }
    return new Rx$Observable$Companion(XMLHttpRequestTransmitter$sendCommands$lambda(commands, this));
  };
  XMLHttpRequestTransmitter.prototype.send_0 = function () {
    if (this.alreadySending_0) {
      return;
    }
    if (this.commandQueue_0.isEmpty()) {
      return;
    }
    this.alreadySending_0 = true;
    var pair = this.commandQueue_0.removeAt_za3lpa$(0);
    var handler = new Handler(pair.subject, this.request_0, this.codec);
    this.request_0.onreadystatechange = getCallableRef('readyStateHandler', function ($receiver, event) {
      return $receiver.readyStateHandler_9ojx7i$(event), Unit;
    }.bind(null, handler));
    this.request_0.onerror = getCallableRef('onErrorHandler', function ($receiver, event) {
      return $receiver.onErrorHandler_9ojx7i$(event), Unit;
    }.bind(null, handler));
    this.request_0.open('POST', this.url, true);
    this.request_0.withCredentials = true;
    this.request_0.setRequestHeader('Content-Type', this.codec.mimeType + '; charset=' + this.codec.encoding);
    this.request_0.send(this.codec.encode_6il2lv$(pair.commands));
  };
  XMLHttpRequestTransmitter.prototype.sendComplete_0 = function () {
    this.alreadySending_0 = false;
    this.send_0();
  };
  XMLHttpRequestTransmitter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'XMLHttpRequestTransmitter',
    interfaces: [Transmitter]
  };
  function Handler(subject, request, codec) {
    this.subject = subject;
    this.request = request;
    this.codec = codec;
  }
  Handler.prototype.onErrorHandler_9ojx7i$ = function (event) {
    this.subject.error(Error_init('Error received: ' + event));
  };
  var trim = Kotlin.kotlin.text.trim_gw00vp$;
  Handler.prototype.readyStateHandler_9ojx7i$ = function (event) {
    if (this.request.readyState !== XMLHttpRequest.DONE) {
      return;
    }
    if (this.request.status !== toShort(200)) {
      this.subject.error(Error_init("Incorrect status received '" + this.request.status + "', expected 200."));
      return;
    }
    var $receiver = this.request.responseText;
    var tmp$;
    var responseText = trim(Kotlin.isCharSequence(tmp$ = $receiver) ? tmp$ : throwCCE()).toString();
    try {
      var responseCommands = this.codec.decode_2azfem$(Source$RESPONSE_getInstance(), responseText);
      this.onDone_0(responseCommands);
    }
     catch (exception) {
      if (Kotlin.isType(exception, Throwable)) {
        var newError = Kotlin.newThrowable("Error occurred parsing responseText: '" + responseText + "'", exception);
        console.error(newError);
        this.subject.error(Error_init(newError.toString()));
      }
       else
        throw exception;
    }
  };
  Handler.prototype.onDone_0 = function (commands) {
    var tmp$;
    tmp$ = commands.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      this.subject.next(element);
    }
    this.subject.complete();
  };
  Handler.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Handler',
    interfaces: []
  };
  function StringCodec() {
  }
  StringCodec.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'StringCodec',
    interfaces: []
  };
  function CommandApplier() {
    CommandApplier_instance = this;
    this.executors_0 = mapOf([to(ensureNotNull(getKClass(CreateModelCommandData).simpleName), CreateModelExecutor_getInstance()), to(ensureNotNull(getKClass(RemoveModelCommandData).simpleName), RemoveModelExecutor_getInstance()), to(ensureNotNull(getKClass(ActionCommandData).simpleName), ActionExecutor_getInstance()), to(ensureNotNull(getKClass(ChangeValueCommandData).simpleName), ChangeValueExecutor_getInstance()), to(ensureNotNull(getKClass(RemoveModelByTypeCommandData).simpleName), RemoveModelByTypeExecutor_getInstance()), to(ensureNotNull(getKClass(SyncModelCommandData).simpleName), SyncModelExecutor_getInstance()), to(ensureNotNull(getKClass(CompositeCommandData).simpleName), CompositeCommandExecutor_getInstance())]);
  }
  CommandApplier.prototype.apply_mq2q7b$ = function (source, modelStore, commandData) {
    return this.apply_2f2r5l$(source, false, true, modelStore, commandData);
  };
  CommandApplier.prototype.apply_2f2r5l$ = function (source, isCompositeUpdate, isLastEventOfCompositeUpdate, modelStore, commandData) {
    var tmp$;
    tmp$ = this.executors_0.get_11rb$(ensureNotNull(Kotlin.getKClassFromExpression(commandData).simpleName));
    if (tmp$ == null) {
      throw IllegalArgumentException_init("No executor found for commandData: '" + commandData + "'");
    }
    var executor = tmp$;
    try {
      return executor.execute_2f2r5l$(source, isCompositeUpdate, isLastEventOfCompositeUpdate, modelStore, commandData);
    }
     catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw Kotlin.newThrowable("Failed to apply command: '" + commandData + "'. Original error message: '" + toString(e.message) + "'", e);
      }
       else
        throw e;
    }
  };
  CommandApplier.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'CommandApplier',
    interfaces: []
  };
  var CommandApplier_instance = null;
  function CommandApplier_getInstance() {
    if (CommandApplier_instance === null) {
      new CommandApplier();
    }
    return CommandApplier_instance;
  }
  function ApplyPolicy(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function ApplyPolicy_initFields() {
    ApplyPolicy_initFields = function () {
    };
    ApplyPolicy$DEFAULT_instance = new ApplyPolicy('DEFAULT', 0);
    ApplyPolicy$FORCE_SEND_instance = new ApplyPolicy('FORCE_SEND', 1);
    ApplyPolicy$FORCE_APPLY_instance = new ApplyPolicy('FORCE_APPLY', 2);
  }
  var ApplyPolicy$DEFAULT_instance;
  function ApplyPolicy$DEFAULT_getInstance() {
    ApplyPolicy_initFields();
    return ApplyPolicy$DEFAULT_instance;
  }
  var ApplyPolicy$FORCE_SEND_instance;
  function ApplyPolicy$FORCE_SEND_getInstance() {
    ApplyPolicy_initFields();
    return ApplyPolicy$FORCE_SEND_instance;
  }
  var ApplyPolicy$FORCE_APPLY_instance;
  function ApplyPolicy$FORCE_APPLY_getInstance() {
    ApplyPolicy_initFields();
    return ApplyPolicy$FORCE_APPLY_instance;
  }
  ApplyPolicy.prototype.isForceSend = function () {
    return this === ApplyPolicy$FORCE_SEND_getInstance() || this.isForceApply();
  };
  ApplyPolicy.prototype.isForceApply = function () {
    return this === ApplyPolicy$FORCE_APPLY_getInstance();
  };
  ApplyPolicy.prototype.isDefault = function () {
    return this === ApplyPolicy$DEFAULT_getInstance();
  };
  ApplyPolicy.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ApplyPolicy',
    interfaces: [Enum]
  };
  function ApplyPolicy$values() {
    return [ApplyPolicy$DEFAULT_getInstance(), ApplyPolicy$FORCE_SEND_getInstance(), ApplyPolicy$FORCE_APPLY_getInstance()];
  }
  ApplyPolicy.values = ApplyPolicy$values;
  function ApplyPolicy$valueOf(name) {
    switch (name) {
      case 'DEFAULT':
        return ApplyPolicy$DEFAULT_getInstance();
      case 'FORCE_SEND':
        return ApplyPolicy$FORCE_SEND_getInstance();
      case 'FORCE_APPLY':
        return ApplyPolicy$FORCE_APPLY_getInstance();
      default:throwISE('No enum constant ch.viseon.openOrca.share.ApplyPolicy.' + name);
    }
  }
  ApplyPolicy.valueOf_61zpoe$ = ApplyPolicy$valueOf;
  function CommandData() {
  }
  CommandData.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CommandData',
    interfaces: []
  };
  function ChangeValueCommandData(source, modelId, propertyName, tag, value, policy) {
    if (policy === void 0)
      policy = ApplyPolicy$DEFAULT_getInstance();
    this.source_ot96ei$_0 = source;
    this.modelId = modelId;
    this.propertyName = propertyName;
    this.tag = tag;
    this.value = value;
    this.policy_21k55r$_0 = policy;
  }
  Object.defineProperty(ChangeValueCommandData.prototype, 'source', {
    get: function () {
      return this.source_ot96ei$_0;
    }
  });
  Object.defineProperty(ChangeValueCommandData.prototype, 'policy', {
    get: function () {
      return this.policy_21k55r$_0;
    }
  });
  ChangeValueCommandData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChangeValueCommandData',
    interfaces: [CommandData]
  };
  ChangeValueCommandData.prototype.component1 = function () {
    return this.source;
  };
  ChangeValueCommandData.prototype.component2 = function () {
    return this.modelId;
  };
  ChangeValueCommandData.prototype.component3 = function () {
    return this.propertyName;
  };
  ChangeValueCommandData.prototype.component4 = function () {
    return this.tag;
  };
  ChangeValueCommandData.prototype.component5 = function () {
    return this.value;
  };
  ChangeValueCommandData.prototype.component6 = function () {
    return this.policy;
  };
  ChangeValueCommandData.prototype.copy_p1l631$ = function (source, modelId, propertyName, tag, value, policy) {
    return new ChangeValueCommandData(source === void 0 ? this.source : source, modelId === void 0 ? this.modelId : modelId, propertyName === void 0 ? this.propertyName : propertyName, tag === void 0 ? this.tag : tag, value === void 0 ? this.value : value, policy === void 0 ? this.policy : policy);
  };
  ChangeValueCommandData.prototype.toString = function () {
    return 'ChangeValueCommandData(source=' + Kotlin.toString(this.source) + (', modelId=' + Kotlin.toString(this.modelId)) + (', propertyName=' + Kotlin.toString(this.propertyName)) + (', tag=' + Kotlin.toString(this.tag)) + (', value=' + Kotlin.toString(this.value)) + (', policy=' + Kotlin.toString(this.policy)) + ')';
  };
  ChangeValueCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelId) | 0;
    result = result * 31 + Kotlin.hashCode(this.propertyName) | 0;
    result = result * 31 + Kotlin.hashCode(this.tag) | 0;
    result = result * 31 + Kotlin.hashCode(this.value) | 0;
    result = result * 31 + Kotlin.hashCode(this.policy) | 0;
    return result;
  };
  ChangeValueCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.modelId, other.modelId) && Kotlin.equals(this.propertyName, other.propertyName) && Kotlin.equals(this.tag, other.tag) && Kotlin.equals(this.value, other.value) && Kotlin.equals(this.policy, other.policy)))));
  };
  function CreateModelCommandData(source, modelId, modelType, properties, clientOnly, policy) {
    if (clientOnly === void 0)
      clientOnly = false;
    if (policy === void 0)
      policy = ApplyPolicy$DEFAULT_getInstance();
    this.source_hp1ija$_0 = source;
    this.modelId = modelId;
    this.modelType = modelType;
    this.properties = properties;
    this.clientOnly = clientOnly;
    this.policy_95rt0z$_0 = policy;
  }
  Object.defineProperty(CreateModelCommandData.prototype, 'source', {
    get: function () {
      return this.source_hp1ija$_0;
    }
  });
  Object.defineProperty(CreateModelCommandData.prototype, 'policy', {
    get: function () {
      return this.policy_95rt0z$_0;
    }
  });
  CreateModelCommandData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CreateModelCommandData',
    interfaces: [CommandData]
  };
  CreateModelCommandData.prototype.component1 = function () {
    return this.source;
  };
  CreateModelCommandData.prototype.component2 = function () {
    return this.modelId;
  };
  CreateModelCommandData.prototype.component3 = function () {
    return this.modelType;
  };
  CreateModelCommandData.prototype.component4 = function () {
    return this.properties;
  };
  CreateModelCommandData.prototype.component5 = function () {
    return this.clientOnly;
  };
  CreateModelCommandData.prototype.component6 = function () {
    return this.policy;
  };
  CreateModelCommandData.prototype.copy_7yahy6$ = function (source, modelId, modelType, properties, clientOnly, policy) {
    return new CreateModelCommandData(source === void 0 ? this.source : source, modelId === void 0 ? this.modelId : modelId, modelType === void 0 ? this.modelType : modelType, properties === void 0 ? this.properties : properties, clientOnly === void 0 ? this.clientOnly : clientOnly, policy === void 0 ? this.policy : policy);
  };
  CreateModelCommandData.prototype.toString = function () {
    return 'CreateModelCommandData(source=' + Kotlin.toString(this.source) + (', modelId=' + Kotlin.toString(this.modelId)) + (', modelType=' + Kotlin.toString(this.modelType)) + (', properties=' + Kotlin.toString(this.properties)) + (', clientOnly=' + Kotlin.toString(this.clientOnly)) + (', policy=' + Kotlin.toString(this.policy)) + ')';
  };
  CreateModelCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelId) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelType) | 0;
    result = result * 31 + Kotlin.hashCode(this.properties) | 0;
    result = result * 31 + Kotlin.hashCode(this.clientOnly) | 0;
    result = result * 31 + Kotlin.hashCode(this.policy) | 0;
    return result;
  };
  CreateModelCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.modelId, other.modelId) && Kotlin.equals(this.modelType, other.modelType) && Kotlin.equals(this.properties, other.properties) && Kotlin.equals(this.clientOnly, other.clientOnly) && Kotlin.equals(this.policy, other.policy)))));
  };
  function RemoveModelCommandData(source, modelId, modelType, policy) {
    if (policy === void 0)
      policy = ApplyPolicy$DEFAULT_getInstance();
    this.source_q2ey5u$_0 = source;
    this.modelId = modelId;
    this.modelType = modelType;
    this.policy_i3vs91$_0 = policy;
  }
  Object.defineProperty(RemoveModelCommandData.prototype, 'source', {
    get: function () {
      return this.source_q2ey5u$_0;
    }
  });
  Object.defineProperty(RemoveModelCommandData.prototype, 'policy', {
    get: function () {
      return this.policy_i3vs91$_0;
    }
  });
  RemoveModelCommandData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RemoveModelCommandData',
    interfaces: [CommandData]
  };
  RemoveModelCommandData.prototype.component1 = function () {
    return this.source;
  };
  RemoveModelCommandData.prototype.component2 = function () {
    return this.modelId;
  };
  RemoveModelCommandData.prototype.component3 = function () {
    return this.modelType;
  };
  RemoveModelCommandData.prototype.component4 = function () {
    return this.policy;
  };
  RemoveModelCommandData.prototype.copy_23g25s$ = function (source, modelId, modelType, policy) {
    return new RemoveModelCommandData(source === void 0 ? this.source : source, modelId === void 0 ? this.modelId : modelId, modelType === void 0 ? this.modelType : modelType, policy === void 0 ? this.policy : policy);
  };
  RemoveModelCommandData.prototype.toString = function () {
    return 'RemoveModelCommandData(source=' + Kotlin.toString(this.source) + (', modelId=' + Kotlin.toString(this.modelId)) + (', modelType=' + Kotlin.toString(this.modelType)) + (', policy=' + Kotlin.toString(this.policy)) + ')';
  };
  RemoveModelCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelId) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelType) | 0;
    result = result * 31 + Kotlin.hashCode(this.policy) | 0;
    return result;
  };
  RemoveModelCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.modelId, other.modelId) && Kotlin.equals(this.modelType, other.modelType) && Kotlin.equals(this.policy, other.policy)))));
  };
  function ActionCommandData(source, actionName, modelIds, policy) {
    if (modelIds === void 0) {
      modelIds = emptyList();
    }
    if (policy === void 0)
      policy = ApplyPolicy$DEFAULT_getInstance();
    this.source_oc8o4h$_0 = source;
    this.actionName = actionName;
    this.modelIds = modelIds;
    this.policy_2iknfs$_0 = policy;
  }
  Object.defineProperty(ActionCommandData.prototype, 'source', {
    get: function () {
      return this.source_oc8o4h$_0;
    }
  });
  Object.defineProperty(ActionCommandData.prototype, 'policy', {
    get: function () {
      return this.policy_2iknfs$_0;
    }
  });
  ActionCommandData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ActionCommandData',
    interfaces: [CommandData]
  };
  ActionCommandData.prototype.component1 = function () {
    return this.source;
  };
  ActionCommandData.prototype.component2 = function () {
    return this.actionName;
  };
  ActionCommandData.prototype.component3 = function () {
    return this.modelIds;
  };
  ActionCommandData.prototype.component4 = function () {
    return this.policy;
  };
  ActionCommandData.prototype.copy_oa3o1h$ = function (source, actionName, modelIds, policy) {
    return new ActionCommandData(source === void 0 ? this.source : source, actionName === void 0 ? this.actionName : actionName, modelIds === void 0 ? this.modelIds : modelIds, policy === void 0 ? this.policy : policy);
  };
  ActionCommandData.prototype.toString = function () {
    return 'ActionCommandData(source=' + Kotlin.toString(this.source) + (', actionName=' + Kotlin.toString(this.actionName)) + (', modelIds=' + Kotlin.toString(this.modelIds)) + (', policy=' + Kotlin.toString(this.policy)) + ')';
  };
  ActionCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.actionName) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelIds) | 0;
    result = result * 31 + Kotlin.hashCode(this.policy) | 0;
    return result;
  };
  ActionCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.actionName, other.actionName) && Kotlin.equals(this.modelIds, other.modelIds) && Kotlin.equals(this.policy, other.policy)))));
  };
  function CompositeCommandData(source, commands) {
    this.source_redh5c$_0 = source;
    this.commands = commands;
    this.policy_jk5l3$_0 = ApplyPolicy$DEFAULT_getInstance();
  }
  Object.defineProperty(CompositeCommandData.prototype, 'source', {
    get: function () {
      return this.source_redh5c$_0;
    }
  });
  Object.defineProperty(CompositeCommandData.prototype, 'policy', {
    get: function () {
      return this.policy_jk5l3$_0;
    }
  });
  CompositeCommandData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CompositeCommandData',
    interfaces: [CommandData]
  };
  CompositeCommandData.prototype.component1 = function () {
    return this.source;
  };
  CompositeCommandData.prototype.component2 = function () {
    return this.commands;
  };
  CompositeCommandData.prototype.copy_7stcjr$ = function (source, commands) {
    return new CompositeCommandData(source === void 0 ? this.source : source, commands === void 0 ? this.commands : commands);
  };
  CompositeCommandData.prototype.toString = function () {
    return 'CompositeCommandData(source=' + Kotlin.toString(this.source) + (', commands=' + Kotlin.toString(this.commands)) + ')';
  };
  CompositeCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.commands) | 0;
    return result;
  };
  CompositeCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.commands, other.commands)))));
  };
  function RemoveModelByTypeCommandData(source, modelType, policy) {
    if (policy === void 0)
      policy = ApplyPolicy$DEFAULT_getInstance();
    this.source_x0xmyn$_0 = source;
    this.modelType = modelType;
    this.policy_664bee$_0 = policy;
  }
  Object.defineProperty(RemoveModelByTypeCommandData.prototype, 'source', {
    get: function () {
      return this.source_x0xmyn$_0;
    }
  });
  Object.defineProperty(RemoveModelByTypeCommandData.prototype, 'policy', {
    get: function () {
      return this.policy_664bee$_0;
    }
  });
  RemoveModelByTypeCommandData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RemoveModelByTypeCommandData',
    interfaces: [CommandData]
  };
  RemoveModelByTypeCommandData.prototype.component1 = function () {
    return this.source;
  };
  RemoveModelByTypeCommandData.prototype.component2 = function () {
    return this.modelType;
  };
  RemoveModelByTypeCommandData.prototype.component3 = function () {
    return this.policy;
  };
  RemoveModelByTypeCommandData.prototype.copy_73wdex$ = function (source, modelType, policy) {
    return new RemoveModelByTypeCommandData(source === void 0 ? this.source : source, modelType === void 0 ? this.modelType : modelType, policy === void 0 ? this.policy : policy);
  };
  RemoveModelByTypeCommandData.prototype.toString = function () {
    return 'RemoveModelByTypeCommandData(source=' + Kotlin.toString(this.source) + (', modelType=' + Kotlin.toString(this.modelType)) + (', policy=' + Kotlin.toString(this.policy)) + ')';
  };
  RemoveModelByTypeCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelType) | 0;
    result = result * 31 + Kotlin.hashCode(this.policy) | 0;
    return result;
  };
  RemoveModelByTypeCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.modelType, other.modelType) && Kotlin.equals(this.policy, other.policy)))));
  };
  function SyncModelCommandData(source, sourceModel, destinationModel, policy) {
    if (policy === void 0)
      policy = ApplyPolicy$DEFAULT_getInstance();
    this.source_wt6z3r$_0 = source;
    this.sourceModel = sourceModel;
    this.destinationModel = destinationModel;
    this.policy_5ydnji$_0 = policy;
  }
  Object.defineProperty(SyncModelCommandData.prototype, 'source', {
    get: function () {
      return this.source_wt6z3r$_0;
    }
  });
  Object.defineProperty(SyncModelCommandData.prototype, 'policy', {
    get: function () {
      return this.policy_5ydnji$_0;
    }
  });
  SyncModelCommandData.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SyncModelCommandData',
    interfaces: [CommandData]
  };
  SyncModelCommandData.prototype.component1 = function () {
    return this.source;
  };
  SyncModelCommandData.prototype.component2 = function () {
    return this.sourceModel;
  };
  SyncModelCommandData.prototype.component3 = function () {
    return this.destinationModel;
  };
  SyncModelCommandData.prototype.component4 = function () {
    return this.policy;
  };
  SyncModelCommandData.prototype.copy_rms6zz$ = function (source, sourceModel, destinationModel, policy) {
    return new SyncModelCommandData(source === void 0 ? this.source : source, sourceModel === void 0 ? this.sourceModel : sourceModel, destinationModel === void 0 ? this.destinationModel : destinationModel, policy === void 0 ? this.policy : policy);
  };
  SyncModelCommandData.prototype.toString = function () {
    return 'SyncModelCommandData(source=' + Kotlin.toString(this.source) + (', sourceModel=' + Kotlin.toString(this.sourceModel)) + (', destinationModel=' + Kotlin.toString(this.destinationModel)) + (', policy=' + Kotlin.toString(this.policy)) + ')';
  };
  SyncModelCommandData.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.sourceModel) | 0;
    result = result * 31 + Kotlin.hashCode(this.destinationModel) | 0;
    result = result * 31 + Kotlin.hashCode(this.policy) | 0;
    return result;
  };
  SyncModelCommandData.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.sourceModel, other.sourceModel) && Kotlin.equals(this.destinationModel, other.destinationModel) && Kotlin.equals(this.policy, other.policy)))));
  };
  function Event() {
  }
  Event.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Event',
    interfaces: []
  };
  function ModelStoreChangeEventType(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function ModelStoreChangeEventType_initFields() {
    ModelStoreChangeEventType_initFields = function () {
    };
    ModelStoreChangeEventType$ADD_instance = new ModelStoreChangeEventType('ADD', 0);
    ModelStoreChangeEventType$REMOVE_instance = new ModelStoreChangeEventType('REMOVE', 1);
  }
  var ModelStoreChangeEventType$ADD_instance;
  function ModelStoreChangeEventType$ADD_getInstance() {
    ModelStoreChangeEventType_initFields();
    return ModelStoreChangeEventType$ADD_instance;
  }
  var ModelStoreChangeEventType$REMOVE_instance;
  function ModelStoreChangeEventType$REMOVE_getInstance() {
    ModelStoreChangeEventType_initFields();
    return ModelStoreChangeEventType$REMOVE_instance;
  }
  ModelStoreChangeEventType.prototype.isAdd = function () {
    return this === ModelStoreChangeEventType$ADD_getInstance();
  };
  ModelStoreChangeEventType.prototype.isRemove = function () {
    return this === ModelStoreChangeEventType$REMOVE_getInstance();
  };
  ModelStoreChangeEventType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ModelStoreChangeEventType',
    interfaces: [Enum]
  };
  function ModelStoreChangeEventType$values() {
    return [ModelStoreChangeEventType$ADD_getInstance(), ModelStoreChangeEventType$REMOVE_getInstance()];
  }
  ModelStoreChangeEventType.values = ModelStoreChangeEventType$values;
  function ModelStoreChangeEventType$valueOf(name) {
    switch (name) {
      case 'ADD':
        return ModelStoreChangeEventType$ADD_getInstance();
      case 'REMOVE':
        return ModelStoreChangeEventType$REMOVE_getInstance();
      default:throwISE('No enum constant ch.viseon.openOrca.share.ModelStoreChangeEventType.' + name);
    }
  }
  ModelStoreChangeEventType.valueOf_61zpoe$ = ModelStoreChangeEventType$valueOf;
  function ModelStoreChangeEvent(source, isCompositeUpdate, isLastEventOfCompositeUpdate, modelId, modelType, eventType) {
    this.source_2sv73i$_0 = source;
    this.isCompositeUpdate_jwos69$_0 = isCompositeUpdate;
    this.isLastEventOfCompositeUpdate_fdnfm6$_0 = isLastEventOfCompositeUpdate;
    this.modelId = modelId;
    this.modelType = modelType;
    this.eventType = eventType;
  }
  Object.defineProperty(ModelStoreChangeEvent.prototype, 'source', {
    get: function () {
      return this.source_2sv73i$_0;
    }
  });
  Object.defineProperty(ModelStoreChangeEvent.prototype, 'isCompositeUpdate', {
    get: function () {
      return this.isCompositeUpdate_jwos69$_0;
    }
  });
  Object.defineProperty(ModelStoreChangeEvent.prototype, 'isLastEventOfCompositeUpdate', {
    get: function () {
      return this.isLastEventOfCompositeUpdate_fdnfm6$_0;
    }
  });
  ModelStoreChangeEvent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ModelStoreChangeEvent',
    interfaces: [Event]
  };
  ModelStoreChangeEvent.prototype.component1 = function () {
    return this.source;
  };
  ModelStoreChangeEvent.prototype.component2 = function () {
    return this.isCompositeUpdate;
  };
  ModelStoreChangeEvent.prototype.component3 = function () {
    return this.isLastEventOfCompositeUpdate;
  };
  ModelStoreChangeEvent.prototype.component4 = function () {
    return this.modelId;
  };
  ModelStoreChangeEvent.prototype.component5 = function () {
    return this.modelType;
  };
  ModelStoreChangeEvent.prototype.component6 = function () {
    return this.eventType;
  };
  ModelStoreChangeEvent.prototype.copy_dacx24$ = function (source, isCompositeUpdate, isLastEventOfCompositeUpdate, modelId, modelType, eventType) {
    return new ModelStoreChangeEvent(source === void 0 ? this.source : source, isCompositeUpdate === void 0 ? this.isCompositeUpdate : isCompositeUpdate, isLastEventOfCompositeUpdate === void 0 ? this.isLastEventOfCompositeUpdate : isLastEventOfCompositeUpdate, modelId === void 0 ? this.modelId : modelId, modelType === void 0 ? this.modelType : modelType, eventType === void 0 ? this.eventType : eventType);
  };
  ModelStoreChangeEvent.prototype.toString = function () {
    return 'ModelStoreChangeEvent(source=' + Kotlin.toString(this.source) + (', isCompositeUpdate=' + Kotlin.toString(this.isCompositeUpdate)) + (', isLastEventOfCompositeUpdate=' + Kotlin.toString(this.isLastEventOfCompositeUpdate)) + (', modelId=' + Kotlin.toString(this.modelId)) + (', modelType=' + Kotlin.toString(this.modelType)) + (', eventType=' + Kotlin.toString(this.eventType)) + ')';
  };
  ModelStoreChangeEvent.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.isCompositeUpdate) | 0;
    result = result * 31 + Kotlin.hashCode(this.isLastEventOfCompositeUpdate) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelId) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelType) | 0;
    result = result * 31 + Kotlin.hashCode(this.eventType) | 0;
    return result;
  };
  ModelStoreChangeEvent.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.isCompositeUpdate, other.isCompositeUpdate) && Kotlin.equals(this.isLastEventOfCompositeUpdate, other.isLastEventOfCompositeUpdate) && Kotlin.equals(this.modelId, other.modelId) && Kotlin.equals(this.modelType, other.modelType) && Kotlin.equals(this.eventType, other.eventType)))));
  };
  function PropertyChangeEvent(source, isCompositeUpdate, isLastEventOfCompositeUpdate, modelId, modelType, valueChangeEvent) {
    this.source_9f4ey3$_0 = source;
    this.isCompositeUpdate_v53r6$_0 = isCompositeUpdate;
    this.isLastEventOfCompositeUpdate_j9t01b$_0 = isLastEventOfCompositeUpdate;
    this.modelId = modelId;
    this.modelType = modelType;
    this.valueChangeEvent = valueChangeEvent;
  }
  Object.defineProperty(PropertyChangeEvent.prototype, 'source', {
    get: function () {
      return this.source_9f4ey3$_0;
    }
  });
  Object.defineProperty(PropertyChangeEvent.prototype, 'isCompositeUpdate', {
    get: function () {
      return this.isCompositeUpdate_v53r6$_0;
    }
  });
  Object.defineProperty(PropertyChangeEvent.prototype, 'isLastEventOfCompositeUpdate', {
    get: function () {
      return this.isLastEventOfCompositeUpdate_j9t01b$_0;
    }
  });
  PropertyChangeEvent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PropertyChangeEvent',
    interfaces: [Event]
  };
  PropertyChangeEvent.prototype.component1 = function () {
    return this.source;
  };
  PropertyChangeEvent.prototype.component2 = function () {
    return this.isCompositeUpdate;
  };
  PropertyChangeEvent.prototype.component3 = function () {
    return this.isLastEventOfCompositeUpdate;
  };
  PropertyChangeEvent.prototype.component4 = function () {
    return this.modelId;
  };
  PropertyChangeEvent.prototype.component5 = function () {
    return this.modelType;
  };
  PropertyChangeEvent.prototype.component6 = function () {
    return this.valueChangeEvent;
  };
  PropertyChangeEvent.prototype.copy_501d6x$ = function (source, isCompositeUpdate, isLastEventOfCompositeUpdate, modelId, modelType, valueChangeEvent) {
    return new PropertyChangeEvent(source === void 0 ? this.source : source, isCompositeUpdate === void 0 ? this.isCompositeUpdate : isCompositeUpdate, isLastEventOfCompositeUpdate === void 0 ? this.isLastEventOfCompositeUpdate : isLastEventOfCompositeUpdate, modelId === void 0 ? this.modelId : modelId, modelType === void 0 ? this.modelType : modelType, valueChangeEvent === void 0 ? this.valueChangeEvent : valueChangeEvent);
  };
  PropertyChangeEvent.prototype.toString = function () {
    return 'PropertyChangeEvent(source=' + Kotlin.toString(this.source) + (', isCompositeUpdate=' + Kotlin.toString(this.isCompositeUpdate)) + (', isLastEventOfCompositeUpdate=' + Kotlin.toString(this.isLastEventOfCompositeUpdate)) + (', modelId=' + Kotlin.toString(this.modelId)) + (', modelType=' + Kotlin.toString(this.modelType)) + (', valueChangeEvent=' + Kotlin.toString(this.valueChangeEvent)) + ')';
  };
  PropertyChangeEvent.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.isCompositeUpdate) | 0;
    result = result * 31 + Kotlin.hashCode(this.isLastEventOfCompositeUpdate) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelId) | 0;
    result = result * 31 + Kotlin.hashCode(this.modelType) | 0;
    result = result * 31 + Kotlin.hashCode(this.valueChangeEvent) | 0;
    return result;
  };
  PropertyChangeEvent.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.isCompositeUpdate, other.isCompositeUpdate) && Kotlin.equals(this.isLastEventOfCompositeUpdate, other.isLastEventOfCompositeUpdate) && Kotlin.equals(this.modelId, other.modelId) && Kotlin.equals(this.modelType, other.modelType) && Kotlin.equals(this.valueChangeEvent, other.valueChangeEvent)))));
  };
  function ValueChangeEvent(source, isCompositeUpdate, isLastEventOfCompositeUpdate, property, tag, oldValue, newValue) {
    this.source_sasi9n$_0 = source;
    this.isCompositeUpdate_izp4go$_0 = isCompositeUpdate;
    this.isLastEventOfCompositeUpdate_7vn1h3$_0 = isLastEventOfCompositeUpdate;
    this.property = property;
    this.tag = tag;
    this.oldValue = oldValue;
    this.newValue = newValue;
  }
  Object.defineProperty(ValueChangeEvent.prototype, 'source', {
    get: function () {
      return this.source_sasi9n$_0;
    }
  });
  Object.defineProperty(ValueChangeEvent.prototype, 'isCompositeUpdate', {
    get: function () {
      return this.isCompositeUpdate_izp4go$_0;
    }
  });
  Object.defineProperty(ValueChangeEvent.prototype, 'isLastEventOfCompositeUpdate', {
    get: function () {
      return this.isLastEventOfCompositeUpdate_7vn1h3$_0;
    }
  });
  ValueChangeEvent.prototype.isValueChange = function () {
    var tmp$;
    return (tmp$ = this.tag) != null ? tmp$.equals(Tag$Companion_getInstance().VALUE) : null;
  };
  ValueChangeEvent.prototype.isLabelChange = function () {
    var tmp$;
    return (tmp$ = this.tag) != null ? tmp$.equals(Tag$Companion_getInstance().LABEL) : null;
  };
  ValueChangeEvent.prototype.isToolTipChange = function () {
    var tmp$;
    return (tmp$ = this.tag) != null ? tmp$.equals(Tag$Companion_getInstance().TOOL_TIP) : null;
  };
  ValueChangeEvent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ValueChangeEvent',
    interfaces: [Event]
  };
  ValueChangeEvent.prototype.component1 = function () {
    return this.source;
  };
  ValueChangeEvent.prototype.component2 = function () {
    return this.isCompositeUpdate;
  };
  ValueChangeEvent.prototype.component3 = function () {
    return this.isLastEventOfCompositeUpdate;
  };
  ValueChangeEvent.prototype.component4 = function () {
    return this.property;
  };
  ValueChangeEvent.prototype.component5 = function () {
    return this.tag;
  };
  ValueChangeEvent.prototype.component6 = function () {
    return this.oldValue;
  };
  ValueChangeEvent.prototype.component7 = function () {
    return this.newValue;
  };
  ValueChangeEvent.prototype.copy_uxyv4d$ = function (source, isCompositeUpdate, isLastEventOfCompositeUpdate, property, tag, oldValue, newValue) {
    return new ValueChangeEvent(source === void 0 ? this.source : source, isCompositeUpdate === void 0 ? this.isCompositeUpdate : isCompositeUpdate, isLastEventOfCompositeUpdate === void 0 ? this.isLastEventOfCompositeUpdate : isLastEventOfCompositeUpdate, property === void 0 ? this.property : property, tag === void 0 ? this.tag : tag, oldValue === void 0 ? this.oldValue : oldValue, newValue === void 0 ? this.newValue : newValue);
  };
  ValueChangeEvent.prototype.toString = function () {
    return 'ValueChangeEvent(source=' + Kotlin.toString(this.source) + (', isCompositeUpdate=' + Kotlin.toString(this.isCompositeUpdate)) + (', isLastEventOfCompositeUpdate=' + Kotlin.toString(this.isLastEventOfCompositeUpdate)) + (', property=' + Kotlin.toString(this.property)) + (', tag=' + Kotlin.toString(this.tag)) + (', oldValue=' + Kotlin.toString(this.oldValue)) + (', newValue=' + Kotlin.toString(this.newValue)) + ')';
  };
  ValueChangeEvent.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.isCompositeUpdate) | 0;
    result = result * 31 + Kotlin.hashCode(this.isLastEventOfCompositeUpdate) | 0;
    result = result * 31 + Kotlin.hashCode(this.property) | 0;
    result = result * 31 + Kotlin.hashCode(this.tag) | 0;
    result = result * 31 + Kotlin.hashCode(this.oldValue) | 0;
    result = result * 31 + Kotlin.hashCode(this.newValue) | 0;
    return result;
  };
  ValueChangeEvent.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.isCompositeUpdate, other.isCompositeUpdate) && Kotlin.equals(this.isLastEventOfCompositeUpdate, other.isLastEventOfCompositeUpdate) && Kotlin.equals(this.property, other.property) && Kotlin.equals(this.tag, other.tag) && Kotlin.equals(this.oldValue, other.oldValue) && Kotlin.equals(this.newValue, other.newValue)))));
  };
  function ActionEvent(source, isCompositeUpdate, isLastEventOfCompositeUpdate, actionName, pmIds) {
    this.source_kup7q4$_0 = source;
    this.isCompositeUpdate_elftov$_0 = isCompositeUpdate;
    this.isLastEventOfCompositeUpdate_hxtylc$_0 = isLastEventOfCompositeUpdate;
    this.actionName = actionName;
    this.pmIds = pmIds;
  }
  Object.defineProperty(ActionEvent.prototype, 'source', {
    get: function () {
      return this.source_kup7q4$_0;
    }
  });
  Object.defineProperty(ActionEvent.prototype, 'isCompositeUpdate', {
    get: function () {
      return this.isCompositeUpdate_elftov$_0;
    }
  });
  Object.defineProperty(ActionEvent.prototype, 'isLastEventOfCompositeUpdate', {
    get: function () {
      return this.isLastEventOfCompositeUpdate_hxtylc$_0;
    }
  });
  ActionEvent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ActionEvent',
    interfaces: [Event]
  };
  ActionEvent.prototype.component1 = function () {
    return this.source;
  };
  ActionEvent.prototype.component2 = function () {
    return this.isCompositeUpdate;
  };
  ActionEvent.prototype.component3 = function () {
    return this.isLastEventOfCompositeUpdate;
  };
  ActionEvent.prototype.component4 = function () {
    return this.actionName;
  };
  ActionEvent.prototype.component5 = function () {
    return this.pmIds;
  };
  ActionEvent.prototype.copy_ivo88e$ = function (source, isCompositeUpdate, isLastEventOfCompositeUpdate, actionName, pmIds) {
    return new ActionEvent(source === void 0 ? this.source : source, isCompositeUpdate === void 0 ? this.isCompositeUpdate : isCompositeUpdate, isLastEventOfCompositeUpdate === void 0 ? this.isLastEventOfCompositeUpdate : isLastEventOfCompositeUpdate, actionName === void 0 ? this.actionName : actionName, pmIds === void 0 ? this.pmIds : pmIds);
  };
  ActionEvent.prototype.toString = function () {
    return 'ActionEvent(source=' + Kotlin.toString(this.source) + (', isCompositeUpdate=' + Kotlin.toString(this.isCompositeUpdate)) + (', isLastEventOfCompositeUpdate=' + Kotlin.toString(this.isLastEventOfCompositeUpdate)) + (', actionName=' + Kotlin.toString(this.actionName)) + (', pmIds=' + Kotlin.toString(this.pmIds)) + ')';
  };
  ActionEvent.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.source) | 0;
    result = result * 31 + Kotlin.hashCode(this.isCompositeUpdate) | 0;
    result = result * 31 + Kotlin.hashCode(this.isLastEventOfCompositeUpdate) | 0;
    result = result * 31 + Kotlin.hashCode(this.actionName) | 0;
    result = result * 31 + Kotlin.hashCode(this.pmIds) | 0;
    return result;
  };
  ActionEvent.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.source, other.source) && Kotlin.equals(this.isCompositeUpdate, other.isCompositeUpdate) && Kotlin.equals(this.isLastEventOfCompositeUpdate, other.isLastEventOfCompositeUpdate) && Kotlin.equals(this.actionName, other.actionName) && Kotlin.equals(this.pmIds, other.pmIds)))));
  };
  function ModelId(stringId) {
    this.stringId = stringId;
  }
  ModelId.prototype.toString = function () {
    return this.stringId;
  };
  ModelId.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ModelId',
    interfaces: []
  };
  ModelId.prototype.component1 = function () {
    return this.stringId;
  };
  ModelId.prototype.copy_61zpoe$ = function (stringId) {
    return new ModelId(stringId === void 0 ? this.stringId : stringId);
  };
  ModelId.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.stringId) | 0;
    return result;
  };
  ModelId.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.stringId, other.stringId))));
  };
  function ModelType(stringId) {
    this.stringId = stringId;
  }
  ModelType.prototype.toString = function () {
    return this.stringId;
  };
  ModelType.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ModelType',
    interfaces: []
  };
  ModelType.prototype.component1 = function () {
    return this.stringId;
  };
  ModelType.prototype.copy_61zpoe$ = function (stringId) {
    return new ModelType(stringId === void 0 ? this.stringId : stringId);
  };
  ModelType.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.stringId) | 0;
    return result;
  };
  ModelType.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.stringId, other.stringId))));
  };
  function PropertyName(name) {
    this.name = name;
  }
  PropertyName.prototype.asValue = function () {
    return this.name;
  };
  PropertyName.prototype.toString = function () {
    return this.name;
  };
  PropertyName.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PropertyName',
    interfaces: []
  };
  PropertyName.prototype.component1 = function () {
    return this.name;
  };
  PropertyName.prototype.copy_61zpoe$ = function (name) {
    return new PropertyName(name === void 0 ? this.name : name);
  };
  PropertyName.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    return result;
  };
  PropertyName.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.name, other.name))));
  };
  function JsonArray(values) {
    this.values = values;
  }
  JsonArray.prototype.iterator = function () {
    return this.values.iterator();
  };
  JsonArray.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsonArray',
    interfaces: [Iterable]
  };
  function JsonObj() {
  }
  JsonObj.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'JsonObj',
    interfaces: []
  };
  function JsonFactory() {
  }
  JsonFactory.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'JsonFactory',
    interfaces: []
  };
  function JsonCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
    this.mimeType_e8n0rf$_0 = 'application/json';
    this.encoding_sfstje$_0 = 'UTF-8';
    this.commandCodecs_0 = mapOf([to(ensureNotNull(getKClass(ActionCommandData).simpleName), new ActionCommandCodec(this.jsonFactory_0)), to(ensureNotNull(getKClass(RemoveModelCommandData).simpleName), new RemoveModelCommandCodec(this.jsonFactory_0)), to(ensureNotNull(getKClass(RemoveModelByTypeCommandData).simpleName), new RemoveModelByTypeCodec(this.jsonFactory_0)), to(ensureNotNull(getKClass(ChangeValueCommandData).simpleName), new ChangeValueCommandCodec(this.jsonFactory_0)), to(ensureNotNull(getKClass(CreateModelCommandData).simpleName), new CreateModelCommandCodec(this.jsonFactory_0)), to(ensureNotNull(getKClass(SyncModelCommandData).simpleName), new SyncModelCommandCodec(this.jsonFactory_0)), to(ensureNotNull(getKClass(CompositeCommandData).simpleName), new CompositeCommandCodec(this.jsonFactory_0, this))]);
  }
  Object.defineProperty(JsonCodec.prototype, 'mimeType', {
    get: function () {
      return this.mimeType_e8n0rf$_0;
    }
  });
  Object.defineProperty(JsonCodec.prototype, 'encoding', {
    get: function () {
      return this.encoding_sfstje$_0;
    }
  });
  JsonCodec.prototype.decode_2azfem$ = function (source, data) {
    if (data.length === 0) {
      return emptyList();
    }
    try {
      var json = this.jsonFactory_0.parse_61zpoe$(data);
      var destination = ArrayList_init(collectionSizeOrDefault(json, 10));
      var tmp$;
      tmp$ = json.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(this.decodeCommandData_bor1xe$(source, item));
      }
      return destination;
    }
     catch (e) {
      if (Kotlin.isType(e, Throwable)) {
        throw Kotlin.newThrowable('Could not parse json ' + data, e);
      }
       else
        throw e;
    }
  };
  JsonCodec.prototype.decodeCommandData_bor1xe$ = function (source, it) {
    var type = it.string_61zpoe$('type');
    return ensureNotNull(this.commandCodecs_0.get_11rb$(type)).decode_bor1xe$(source, it);
  };
  JsonCodec.prototype.encodeToJsonObj_anzskc$ = function (commandData) {
    var tmp$, tmp$_0;
    var tmp$_1;
    if ((tmp$ = this.commandCodecs_0.get_11rb$(ensureNotNull(Kotlin.getKClassFromExpression(commandData).simpleName))) != null) {
      var block$result;
      try {
        block$result = tmp$.encode_anzskc$(commandData);
      }
       catch (e) {
        if (Kotlin.isType(e, Throwable)) {
          throw Kotlin.newThrowable('Error processing command ' + commandData, e);
        }
         else
          throw e;
      }
      tmp$_1 = block$result;
    }
     else
      tmp$_1 = null;
    tmp$_0 = tmp$_1;
    if (tmp$_0 == null) {
      throw IllegalArgumentException_init('No Codec found for command ' + commandData);
    }
    return tmp$_0;
  };
  function JsonCodec$encode$lambda$lambda(this$JsonCodec) {
    return function (it) {
      return this$JsonCodec.encodeToJsonObj_anzskc$(it);
    };
  }
  function JsonCodec$encode$lambda$lambda_0(it) {
    return it.toJsonString();
  }
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder;
  JsonCodec.prototype.encode_6il2lv$ = function (commands) {
    var $receiver = new StringBuilder_init();
    $receiver.append_gw00v9$('[');
    $receiver.append_gw00v9$(joinToString(map(map(asSequence(commands), JsonCodec$encode$lambda$lambda(this)), JsonCodec$encode$lambda$lambda_0), ','));
    $receiver.append_gw00v9$(']');
    return $receiver.toString();
  };
  JsonCodec.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'JsonCodec',
    interfaces: [StringCodec]
  };
  function CommandCodec() {
  }
  CommandCodec.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CommandCodec',
    interfaces: []
  };
  function ActionCommandCodec(jsonFactory) {
    this.jsonFactory = jsonFactory;
  }
  function ActionCommandCodec$encode$lambda$lambda(closure$typedCommand) {
    return function ($receiver) {
      if (!closure$typedCommand.policy.isDefault())
        $receiver.set_puj7f4$('policy', closure$typedCommand.policy.name);
      $receiver.set_puj7f4$('actionName', closure$typedCommand.actionName);
      var $receiver_0 = closure$typedCommand.modelIds;
      var destination = ArrayList_init(collectionSizeOrDefault($receiver_0, 10));
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(item.stringId);
      }
      $receiver.set_poujtz$('modelIds', destination);
      return Unit;
    };
  }
  function ActionCommandCodec$encode$lambda(closure$typedCommand) {
    return function ($receiver) {
      $receiver.set_puj7f4$('type', ensureNotNull(getKClass(ActionCommandData).simpleName));
      $receiver.set_8wy9ij$('data', ActionCommandCodec$encode$lambda$lambda(closure$typedCommand));
      return Unit;
    };
  }
  ActionCommandCodec.prototype.encode_anzskc$ = function (untypedCommandData) {
    var tmp$;
    var typedCommand = Kotlin.isType(tmp$ = untypedCommandData, ActionCommandData) ? tmp$ : throwCCE();
    var jsonObj = this.jsonFactory.newJson_1j20nt$(ActionCommandCodec$encode$lambda(typedCommand));
    return jsonObj;
  };
  ActionCommandCodec.prototype.decode_bor1xe$ = function (source, json) {
    var tmp$, tmp$_0;
    var data = json.getObject_61zpoe$('data');
    var policy = (tmp$_0 = (tmp$ = data.optionalString_61zpoe$('policy')) != null ? ApplyPolicy$valueOf(tmp$) : null) != null ? tmp$_0 : ApplyPolicy$DEFAULT_getInstance();
    var modelIds = data.pArray_ytbaoo$('modelIds');
    var tmp$_1 = data.string_61zpoe$('actionName');
    var destination = ArrayList_init(collectionSizeOrDefault(modelIds, 10));
    var tmp$_2;
    tmp$_2 = modelIds.iterator();
    while (tmp$_2.hasNext()) {
      var item = tmp$_2.next();
      destination.add_11rb$(new ModelId(item));
    }
    return new ActionCommandData(source, tmp$_1, destination, policy);
  };
  ActionCommandCodec.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ActionCommandCodec',
    interfaces: [CommandCodec]
  };
  function RemoveModelCommandCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
  }
  function RemoveModelCommandCodec$encode$lambda$lambda(closure$typedCommand) {
    return function ($receiver) {
      $receiver.set_puj7f4$('modelId', closure$typedCommand.modelId.stringId);
      $receiver.set_puj7f4$('modelType', closure$typedCommand.modelType.stringId);
      return Unit;
    };
  }
  function RemoveModelCommandCodec$encode$lambda(closure$typedCommand) {
    return function ($receiver) {
      $receiver.set_puj7f4$('type', ensureNotNull(getKClass(RemoveModelCommandData).simpleName));
      $receiver.set_8wy9ij$('data', RemoveModelCommandCodec$encode$lambda$lambda(closure$typedCommand));
      return Unit;
    };
  }
  RemoveModelCommandCodec.prototype.encode_anzskc$ = function (untypedCommandData) {
    var tmp$;
    var typedCommand = Kotlin.isType(tmp$ = untypedCommandData, RemoveModelCommandData) ? tmp$ : throwCCE();
    return this.jsonFactory_0.newJson_1j20nt$(RemoveModelCommandCodec$encode$lambda(typedCommand));
  };
  RemoveModelCommandCodec.prototype.decode_bor1xe$ = function (source, json) {
    var data = json.getObject_61zpoe$('data');
    return new RemoveModelCommandData(source, new ModelId(data.string_61zpoe$('modelId')), new ModelType(data.string_61zpoe$('modelType')));
  };
  RemoveModelCommandCodec.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RemoveModelCommandCodec',
    interfaces: [CommandCodec]
  };
  function ChangeValueCommandCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
  }
  function ChangeValueCommandCodec$encode$lambda$lambda$lambda(closure$changeValueCommand) {
    return function ($receiver) {
      valueToJson($receiver, closure$changeValueCommand.tag, closure$changeValueCommand.value);
      return Unit;
    };
  }
  function ChangeValueCommandCodec$encode$lambda$lambda(closure$changeValueCommand, this$ChangeValueCommandCodec) {
    return function ($receiver) {
      if (!closure$changeValueCommand.policy.isDefault())
        $receiver.set_puj7f4$('policy', closure$changeValueCommand.policy.name);
      $receiver.set_puj7f4$('modelId', closure$changeValueCommand.modelId.stringId);
      $receiver.set_puj7f4$('propertyName', closure$changeValueCommand.propertyName.name);
      $receiver.set_6xncmk$('value', this$ChangeValueCommandCodec.jsonFactory_0.newJson_1j20nt$(ChangeValueCommandCodec$encode$lambda$lambda$lambda(closure$changeValueCommand)));
      return Unit;
    };
  }
  function ChangeValueCommandCodec$encode$lambda(closure$changeValueCommand, this$ChangeValueCommandCodec) {
    return function ($receiver) {
      $receiver.set_puj7f4$('type', ensureNotNull(getKClass(ChangeValueCommandData).simpleName));
      $receiver.set_8wy9ij$('data', ChangeValueCommandCodec$encode$lambda$lambda(closure$changeValueCommand, this$ChangeValueCommandCodec));
      return Unit;
    };
  }
  ChangeValueCommandCodec.prototype.encode_anzskc$ = function (untypedCommandData) {
    var tmp$;
    var changeValueCommand = Kotlin.isType(tmp$ = untypedCommandData, ChangeValueCommandData) ? tmp$ : throwCCE();
    return this.jsonFactory_0.newJson_1j20nt$(ChangeValueCommandCodec$encode$lambda(changeValueCommand, this));
  };
  ChangeValueCommandCodec.prototype.decode_bor1xe$ = function (source, json) {
    var tmp$, tmp$_0;
    var data = json.getObject_61zpoe$('data');
    var policy = (tmp$_0 = (tmp$ = data.optionalString_61zpoe$('policy')) != null ? ApplyPolicy$valueOf(tmp$) : null) != null ? tmp$_0 : ApplyPolicy$DEFAULT_getInstance();
    var modelId = new ModelId(data.string_61zpoe$('modelId'));
    var propertyName = new PropertyName(data.string_61zpoe$('propertyName'));
    var tmp$_1 = valueFromJson(data.getObject_61zpoe$('value'));
    var tag = tmp$_1.component1()
    , value = tmp$_1.component2();
    return new ChangeValueCommandData(source, modelId, propertyName, tag, value, policy);
  };
  ChangeValueCommandCodec.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ChangeValueCommandCodec',
    interfaces: [CommandCodec]
  };
  function CreateModelCommandCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
  }
  function CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda$lambda$lambda(closure$tag, closure$value) {
    return function ($receiver) {
      valueToJson($receiver, closure$tag, closure$value);
      return Unit;
    };
  }
  function CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda$lambda(this$CreateModelCommandCodec) {
    return function (f) {
      var tag = f.component1()
      , value = f.component2();
      return this$CreateModelCommandCodec.jsonFactory_0.newJson_1j20nt$(CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda$lambda$lambda(tag, value));
    };
  }
  function CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda(closure$it, this$CreateModelCommandCodec) {
    return function ($receiver) {
      $receiver.set_puj7f4$('propertyName', closure$it.name.name);
      var $receiver_0 = closure$it.clientOnly;
      if (($receiver_0 ? $receiver_0 : null) != null) {
        $receiver.set_ivxn3r$('clientOnly', true);
      }
      var $receiver_1 = closure$it.clientTags;
      var destination = ArrayList_init(collectionSizeOrDefault($receiver_1, 10));
      var tmp$;
      tmp$ = $receiver_1.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(item.name);
      }
      $receiver.set_poujtz$('clientTags', destination);
      $receiver.set_jqxvxq$('values', new JsonArray(toList(map(closure$it.getValues(), CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda$lambda(this$CreateModelCommandCodec)))));
      return Unit;
    };
  }
  function CreateModelCommandCodec$encode$lambda$lambda(closure$createCommand, this$CreateModelCommandCodec) {
    return function ($receiver) {
      $receiver.set_puj7f4$('modelId', closure$createCommand.modelId.stringId);
      $receiver.set_puj7f4$('type', closure$createCommand.modelType.stringId);
      var $receiver_0 = closure$createCommand.clientOnly;
      if (($receiver_0 ? $receiver_0 : null) != null) {
        $receiver.set_ivxn3r$('clientOnly', true);
      }
      var $receiver_1 = closure$createCommand.properties;
      var destination = ArrayList_init(collectionSizeOrDefault($receiver_1, 10));
      var tmp$;
      tmp$ = $receiver_1.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        var tmp$_0 = destination.add_11rb$;
        var this$CreateModelCommandCodec_0 = this$CreateModelCommandCodec;
        tmp$_0.call(destination, this$CreateModelCommandCodec_0.jsonFactory_0.newJson_1j20nt$(CreateModelCommandCodec$encode$lambda$lambda$lambda$lambda(item, this$CreateModelCommandCodec_0)));
      }
      $receiver.set_jqxvxq$('properties', new JsonArray(destination));
      return Unit;
    };
  }
  function CreateModelCommandCodec$encode$lambda(closure$createCommand, this$CreateModelCommandCodec) {
    return function ($receiver) {
      $receiver.set_puj7f4$('type', ensureNotNull(getKClass(CreateModelCommandData).simpleName));
      $receiver.set_8wy9ij$('data', CreateModelCommandCodec$encode$lambda$lambda(closure$createCommand, this$CreateModelCommandCodec));
      return Unit;
    };
  }
  CreateModelCommandCodec.prototype.encode_anzskc$ = function (untypedCommandData) {
    var tmp$;
    var createCommand = Kotlin.isType(tmp$ = untypedCommandData, CreateModelCommandData) ? tmp$ : throwCCE();
    return this.jsonFactory_0.newJson_1j20nt$(CreateModelCommandCodec$encode$lambda(createCommand, this));
  };
  function CreateModelCommandCodec$decode$lambda$lambda(it) {
    return new Tag(it);
  }
  CreateModelCommandCodec.prototype.decode_bor1xe$ = function (source, json) {
    var tmp$;
    var data = json.getObject_61zpoe$('data');
    var clientPm = (tmp$ = data.optionalBoolean_61zpoe$('clientOnly')) != null ? tmp$ : false;
    var properties = data.oArray_61zpoe$('properties');
    var tmp$_0 = new ModelId(data.string_61zpoe$('modelId'));
    var tmp$_1 = new ModelType(data.string_61zpoe$('type'));
    var destination = ArrayList_init(collectionSizeOrDefault(properties, 10));
    var tmp$_2;
    tmp$_2 = properties.iterator();
    while (tmp$_2.hasNext()) {
      var item = tmp$_2.next();
      var tmp$_3 = destination.add_11rb$;
      var tmp$_4;
      var clientProperty = (tmp$_4 = item.optionalBoolean_61zpoe$('clientOnly')) != null ? tmp$_4 : false;
      var values = item.oArray_61zpoe$('values');
      tmp$_3.call(destination, new Property(new PropertyName(item.string_61zpoe$('propertyName')), map(asSequence(values), getCallableRef('valueFromJson', function (json) {
        return valueFromJson(json);
      })), clientProperty, toSet(map(asSequence(item.pArray_ytbaoo$('clientTags')), CreateModelCommandCodec$decode$lambda$lambda))));
    }
    return new CreateModelCommandData(source, tmp$_0, tmp$_1, destination, clientPm);
  };
  CreateModelCommandCodec.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CreateModelCommandCodec',
    interfaces: [CommandCodec]
  };
  function RemoveModelByTypeCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
  }
  function RemoveModelByTypeCodec$encode$lambda$lambda(closure$commandData) {
    return function ($receiver) {
      $receiver.set_puj7f4$('modelTypeId', closure$commandData.modelType.stringId);
      return Unit;
    };
  }
  function RemoveModelByTypeCodec$encode$lambda(closure$commandData) {
    return function ($receiver) {
      $receiver.set_puj7f4$('type', ensureNotNull(getKClass(RemoveModelByTypeCommandData).simpleName));
      $receiver.set_8wy9ij$('data', RemoveModelByTypeCodec$encode$lambda$lambda(closure$commandData));
      return Unit;
    };
  }
  RemoveModelByTypeCodec.prototype.encode_anzskc$ = function (untypedCommandData) {
    var tmp$;
    var commandData = Kotlin.isType(tmp$ = untypedCommandData, RemoveModelByTypeCommandData) ? tmp$ : throwCCE();
    return this.jsonFactory_0.newJson_1j20nt$(RemoveModelByTypeCodec$encode$lambda(commandData));
  };
  RemoveModelByTypeCodec.prototype.decode_bor1xe$ = function (source, json) {
    var data = json.getObject_61zpoe$('data');
    return new RemoveModelByTypeCommandData(source, new ModelType(data.string_61zpoe$('modelTypeId')));
  };
  RemoveModelByTypeCodec.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'RemoveModelByTypeCodec',
    interfaces: [CommandCodec]
  };
  function SyncModelCommandCodec(jsonFactory) {
    this.jsonFactory_0 = jsonFactory;
  }
  function SyncModelCommandCodec$encode$lambda$lambda(closure$commandData) {
    return function ($receiver) {
      $receiver.set_puj7f4$('src', closure$commandData.sourceModel.stringId);
      $receiver.set_puj7f4$('dst', closure$commandData.destinationModel.stringId);
      return Unit;
    };
  }
  function SyncModelCommandCodec$encode$lambda(closure$commandData) {
    return function ($receiver) {
      $receiver.set_puj7f4$('type', ensureNotNull(getKClass(SyncModelCommandData).simpleName));
      $receiver.set_8wy9ij$('data', SyncModelCommandCodec$encode$lambda$lambda(closure$commandData));
      return Unit;
    };
  }
  SyncModelCommandCodec.prototype.encode_anzskc$ = function (untypedCommandData) {
    var tmp$;
    var commandData = Kotlin.isType(tmp$ = untypedCommandData, SyncModelCommandData) ? tmp$ : throwCCE();
    return this.jsonFactory_0.newJson_1j20nt$(SyncModelCommandCodec$encode$lambda(commandData));
  };
  SyncModelCommandCodec.prototype.decode_bor1xe$ = function (source, json) {
    var data = json.getObject_61zpoe$('data');
    return new SyncModelCommandData(source, new ModelId(data.string_61zpoe$('src')), new ModelId(data.string_61zpoe$('dst')));
  };
  SyncModelCommandCodec.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SyncModelCommandCodec',
    interfaces: [CommandCodec]
  };
  function CompositeCommandCodec(jsonFactory, jsonCodec) {
    this.jsonFactory_0 = jsonFactory;
    this.jsonCodec_0 = jsonCodec;
  }
  function CompositeCommandCodec$encode$lambda(closure$commandData, this$CompositeCommandCodec) {
    return function ($receiver) {
      $receiver.set_puj7f4$('type', ensureNotNull(getKClass(CompositeCommandData).simpleName));
      var $receiver_0 = closure$commandData.commands;
      var destination = ArrayList_init(collectionSizeOrDefault($receiver_0, 10));
      var tmp$;
      tmp$ = $receiver_0.iterator();
      while (tmp$.hasNext()) {
        var item = tmp$.next();
        destination.add_11rb$(this$CompositeCommandCodec.jsonCodec_0.encodeToJsonObj_anzskc$(item));
      }
      $receiver.set_jqxvxq$('data', new JsonArray(destination));
      return Unit;
    };
  }
  CompositeCommandCodec.prototype.encode_anzskc$ = function (untypedCommandData) {
    var tmp$;
    var commandData = Kotlin.isType(tmp$ = untypedCommandData, CompositeCommandData) ? tmp$ : throwCCE();
    return this.jsonFactory_0.newJson_1j20nt$(CompositeCommandCodec$encode$lambda(commandData, this));
  };
  CompositeCommandCodec.prototype.decode_bor1xe$ = function (source, json) {
    var data = json.oArray_61zpoe$('data');
    var destination = ArrayList_init(collectionSizeOrDefault(data, 10));
    var tmp$;
    tmp$ = data.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(this.jsonCodec_0.decodeCommandData_bor1xe$(source, item));
    }
    return new CompositeCommandData(source, toList_0(destination));
  };
  CompositeCommandCodec.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CompositeCommandCodec',
    interfaces: [CommandCodec]
  };
  function valueToJson(jsonObj, tag, value) {
    if (!(typeof value === 'string')) {
      jsonObj.set_puj7f4$('type', getJsonTypeId(value));
    }
    jsonObj.set_puj7f4$('value', asJsonValue(value));
    if (!(tag != null ? tag.equals(Tag$Companion_getInstance().VALUE) : null)) {
      jsonObj.set_puj7f4$('tag', tag.name);
    }
    return jsonObj;
  }
  function getJsonTypeId($receiver) {
    var tmp$;
    if (typeof $receiver === 'string')
      tmp$ = 'String';
    else if (typeof $receiver === 'boolean')
      tmp$ = 'Boolean';
    else if (typeof $receiver === 'number')
      tmp$ = 'Double';
    else if (typeof $receiver === 'number')
      tmp$ = 'Float';
    else if (Kotlin.isType($receiver, Kotlin.Long))
      tmp$ = 'Long';
    else if (typeof $receiver === 'number')
      tmp$ = 'Int';
    else if (Kotlin.isChar($receiver))
      tmp$ = 'Char';
    else if (typeof $receiver === 'number')
      tmp$ = 'Short';
    else if (Kotlin.isType($receiver, ModelId))
      tmp$ = 'ModelId';
    else if (Kotlin.isType($receiver, ModelType))
      tmp$ = 'ModelType';
    else
      throw IllegalArgumentException_init("Type of value '" + $receiver + "' (class.simpleName: '" + toString(Kotlin.getKClassFromExpression($receiver).simpleName) + "') not be supported.");
    return tmp$;
  }
  function isSupported(value) {
    return typeof value === 'string' || typeof value === 'boolean' || typeof value === 'number' || typeof value === 'number' || Kotlin.isType(value, Kotlin.Long) || typeof value === 'number' || Kotlin.isChar(value) || typeof value === 'number' || Kotlin.isType(value, ModelId) || Kotlin.isType(value, ModelType);
  }
  function asJsonValue($receiver) {
    return $receiver.toString();
  }
  function valueFromJson(json) {
    var tmp$, tmp$_0, tmp$_1;
    var type = (tmp$ = json.optionalString_61zpoe$('type')) != null ? tmp$ : 'String';
    switch (type) {
      case 'String':
        tmp$_0 = json.string_61zpoe$('value');
        break;
      case 'Boolean':
        tmp$_0 = json.boolean_61zpoe$('value');
        break;
      case 'Int':
        tmp$_0 = json.integer_61zpoe$('value');
        break;
      case 'Long':
        tmp$_0 = json.long_61zpoe$('value');
        break;
      case 'Float':
        tmp$_0 = json.float_61zpoe$('value');
        break;
      case 'Double':
        tmp$_0 = json.double_61zpoe$('value');
        break;
      case 'Char':
        tmp$_0 = toBoxedChar(json.string_61zpoe$('value').charCodeAt(0));
        break;
      case 'Short':
        tmp$_0 = toShort(json.integer_61zpoe$('value'));
        break;
      case 'ModelId':
        tmp$_0 = new ModelId(json.string_61zpoe$('value'));
        break;
      case 'ModelType':
        tmp$_0 = new ModelType(json.string_61zpoe$('value'));
        break;
      default:throw IllegalArgumentException_init("Unknown propertyValue type: '" + type + "'");
    }
    var value = tmp$_0;
    var tag = (tmp$_1 = json.optionalString_61zpoe$('tag')) != null ? tmp$_1 : Tag$Companion_getInstance().VALUE.name;
    return new Pair(new Tag(tag), value);
  }
  function ModelBuilder() {
  }
  ModelBuilder.prototype.build_tytvht$ = function (source, policy, callback$default) {
    if (policy === void 0)
      policy = ApplyPolicy$DEFAULT_getInstance();
    return callback$default ? callback$default(source, policy) : this.build_tytvht$$default(source, policy);
  };
  ModelBuilder.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ModelBuilder',
    interfaces: []
  };
  function ModelStore() {
  }
  ModelStore.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'ModelStore',
    interfaces: []
  };
  function PresentationModel() {
  }
  PresentationModel.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'PresentationModel',
    interfaces: []
  };
  function PresentationModelBuilder(modelId, modelType, clientPm, block) {
    if (clientPm === void 0)
      clientPm = false;
    this.modelId = modelId;
    this.modelType = modelType;
    this.clientPm = clientPm;
    this.properties_0 = ArrayList_init();
    block(this);
  }
  Object.defineProperty(PresentationModelBuilder.prototype, 'propertyList', {
    get: function () {
      return this.properties_0;
    }
  });
  PresentationModelBuilder.prototype.build_tytvht$$default = function (source, policy) {
    return new CreateModelCommandData(source, this.modelId, this.modelType, this.properties_0, this.clientPm, policy);
  };
  PresentationModelBuilder.prototype.property_wzygeq$ = function (name, clientProperty, block) {
    if (clientProperty === void 0)
      clientProperty = false;
    var builder = new PresentationModelBuilder$PropertyBuilder(this, name, clientProperty);
    block(builder);
    this.properties_0.add_11rb$(builder.build());
  };
  var LinkedHashSet_init = Kotlin.kotlin.collections.LinkedHashSet_init_287e2$;
  function PresentationModelBuilder$PropertyBuilder($outer, name, clientProperty) {
    this.$outer = $outer;
    if (clientProperty === void 0)
      clientProperty = false;
    this.name = name;
    this.clientProperty = clientProperty;
    this.values = LinkedHashMap_init();
    this.clientTags = LinkedHashSet_init();
  }
  Object.defineProperty(PresentationModelBuilder$PropertyBuilder.prototype, 'label', {
    get: function () {
      var tmp$;
      return typeof (tmp$ = this.get_ol557t$(Tag$Companion_getInstance().LABEL)) === 'string' ? tmp$ : throwCCE();
    },
    set: function (value) {
      this.set_jcm6gy$(Tag$Companion_getInstance().LABEL, value);
    }
  });
  Object.defineProperty(PresentationModelBuilder$PropertyBuilder.prototype, 'toolTip', {
    get: function () {
      var tmp$;
      return typeof (tmp$ = this.get_ol557t$(Tag$Companion_getInstance().TOOL_TIP)) === 'string' ? tmp$ : throwCCE();
    },
    set: function (value) {
      this.set_jcm6gy$(Tag$Companion_getInstance().TOOL_TIP, value);
    }
  });
  Object.defineProperty(PresentationModelBuilder$PropertyBuilder.prototype, 'value', {
    get: function () {
      return this.get_ol557t$(Tag$Companion_getInstance().VALUE);
    },
    set: function (value) {
      this.set_jcm6gy$(Tag$Companion_getInstance().VALUE, value);
    }
  });
  PresentationModelBuilder$PropertyBuilder.prototype.set_jcm6gy$ = function (tag, propertyValue) {
    this.values.put_xwzc9p$(tag, propertyValue);
  };
  PresentationModelBuilder$PropertyBuilder.prototype.get_ol557t$ = function (typeName) {
    return ensureNotNull(this.values.get_11rb$(typeName));
  };
  PresentationModelBuilder$PropertyBuilder.prototype.clientTag_ol557t$ = function (tag) {
    this.clientTags.add_11rb$(tag);
  };
  PresentationModelBuilder$PropertyBuilder.prototype.build = function () {
    var tmp$ = this.name;
    var $receiver = this.values.entries;
    var destination = ArrayList_init(collectionSizeOrDefault($receiver, 10));
    var tmp$_0;
    tmp$_0 = $receiver.iterator();
    while (tmp$_0.hasNext()) {
      var item = tmp$_0.next();
      var tmp$_1 = destination.add_11rb$;
      var key = item.key;
      var value = item.value;
      tmp$_1.call(destination, new Pair(key, value));
    }
    return new Property(tmp$, asSequence(destination), this.$outer.clientPm || this.clientProperty, this.clientTags);
  };
  PresentationModelBuilder$PropertyBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PropertyBuilder',
    interfaces: []
  };
  PresentationModelBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PresentationModelBuilder',
    interfaces: [ModelBuilder]
  };
  function Property(name, initialValues, clientOnly, clientTags) {
    if (clientOnly === void 0)
      clientOnly = false;
    if (clientTags === void 0)
      clientTags = emptySet();
    this.name = name;
    this.clientOnly = clientOnly;
    this.clientTags = clientTags;
    var $receiver = HashMap_init();
    var tmp$;
    tmp$ = initialValues.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var key = element.component1()
      , value = element.component2();
      $receiver.put_xwzc9p$(key, value);
    }
    this.propertyValue2Values_0 = $receiver;
  }
  Property.prototype.set_jcm6gy$ = function (tag, value) {
    this.checkIfValueCanBeSent_0(tag, value);
    var oldValue = this.propertyValue2Values_0.get_11rb$(tag);
    this.propertyValue2Values_0.put_xwzc9p$(tag, value);
    return oldValue;
  };
  Property.prototype.checkIfValueCanBeSent_0 = function (tag, value) {
    if (!isSupported(value)) {
      throw IllegalArgumentException_init("Not supported value: '" + value + "'. Property: '" + this.name + "' for Tag '" + tag + "'");
    }
  };
  function Property$getValuesArray$lambda(it) {
    return new Pair(it.key, it.value);
  }
  Property.prototype.getValuesArray = function () {
    return copyToArray(toList(map(asSequence(this.propertyValue2Values_0.entries), Property$getValuesArray$lambda)));
  };
  function Property$getValues$lambda(it) {
    return new Pair(it.key, it.value);
  }
  Property.prototype.getValues = function () {
    return map(asSequence(this.propertyValue2Values_0.entries), Property$getValues$lambda);
  };
  Property.prototype.get_ol557t$ = function (tag) {
    if (tag === void 0)
      tag = Tag$Companion_getInstance().VALUE;
    var tmp$;
    tmp$ = this.propertyValue2Values_0.get_11rb$(tag);
    if (tmp$ == null) {
      throw IllegalArgumentException_init("No value for tag '" + tag + "'");
    }
    return tmp$;
  };
  Property.prototype.getValue_55j8nk$ = defineInlineFunction('openorca-js-client.ch.viseon.openOrca.share.Property.getValue_55j8nk$', wrapFunction(function () {
    var Tag = _.ch.viseon.openOrca.share.Tag;
    var getKClass = Kotlin.getKClass;
    var toString = Kotlin.toString;
    var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
    return function (T_0, isT, tag) {
      if (tag === void 0)
        tag = Tag.Companion.VALUE;
      var tmp$, tmp$_0;
      var get = this.get_ol557t$(tag);
      tmp$_0 = isT(tmp$ = get) ? tmp$ : null;
      if (tmp$_0 == null) {
        throw IllegalArgumentException_init('Value is not of type ' + getKClass(T_0) + ". Actual value '" + get + "' Type: " + toString(Kotlin.getKClassFromExpression(get).simpleName));
      }
      return tmp$_0;
    };
  }));
  Property.prototype.toString = function () {
    return this.name.toString() + ' isClientProperty: ' + this.clientOnly + ' values: ' + this.propertyValue2Values_0;
  };
  Property.prototype.hasValue_ol557t$ = function (tag) {
    if (tag === void 0)
      tag = Tag$Companion_getInstance().VALUE;
    return this.propertyValue2Values_0.containsKey_11rb$(tag);
  };
  Property.prototype.isClientTag_ol557t$ = function (tag) {
    return this.clientOnly || this.clientTags.contains_11rb$(tag);
  };
  Property.prototype.equals = function (other) {
    var tmp$, tmp$_0, tmp$_1;
    if (this === other)
      return true;
    if (other == null || !((tmp$ = Kotlin.getKClassFromExpression(this)) != null ? tmp$.equals(Kotlin.getKClassFromExpression(other)) : null))
      return false;
    Kotlin.isType(tmp$_0 = other, Property) ? tmp$_0 : throwCCE();
    if (!((tmp$_1 = this.name) != null ? tmp$_1.equals(other.name) : null))
      return false;
    if (this.clientOnly !== other.clientOnly)
      return false;
    if (!equals(this.clientTags, other.clientTags))
      return false;
    if (!equals(this.propertyValue2Values_0, other.propertyValue2Values_0))
      return false;
    return true;
  };
  Property.prototype.hashCode = function () {
    var result = this.name.hashCode();
    result = (31 * result | 0) + hashCode(this.clientOnly) | 0;
    result = (31 * result | 0) + hashCode(this.clientTags) | 0;
    result = (31 * result | 0) + hashCode(this.propertyValue2Values_0) | 0;
    return result;
  };
  Property.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Property',
    interfaces: []
  };
  function Source(name, ordinal) {
    Enum.call(this);
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Source_initFields() {
    Source_initFields = function () {
    };
    Source$REQUEST_instance = new Source('REQUEST', 0);
    Source$RESPONSE_instance = new Source('RESPONSE', 1);
  }
  var Source$REQUEST_instance;
  function Source$REQUEST_getInstance() {
    Source_initFields();
    return Source$REQUEST_instance;
  }
  var Source$RESPONSE_instance;
  function Source$RESPONSE_getInstance() {
    Source_initFields();
    return Source$RESPONSE_instance;
  }
  Source.prototype.isRequest = function () {
    return this === Source$REQUEST_getInstance();
  };
  Source.prototype.isResponse = function () {
    return this === Source$RESPONSE_getInstance();
  };
  Source.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Source',
    interfaces: [Enum]
  };
  function Source$values() {
    return [Source$REQUEST_getInstance(), Source$RESPONSE_getInstance()];
  }
  Source.values = Source$values;
  function Source$valueOf(name) {
    switch (name) {
      case 'REQUEST':
        return Source$REQUEST_getInstance();
      case 'RESPONSE':
        return Source$RESPONSE_getInstance();
      default:throwISE('No enum constant ch.viseon.openOrca.share.Source.' + name);
    }
  }
  Source.valueOf_61zpoe$ = Source$valueOf;
  function Tag(name) {
    Tag$Companion_getInstance();
    this.name = name;
  }
  function Tag$Companion() {
    Tag$Companion_instance = this;
    this.VALUE = new Tag('value');
    this.LABEL = new Tag('label');
    this.TOOL_TIP = new Tag('toolTip');
    this.REG_EX = new Tag('regex');
    this.COMPONENT_TYPE = new Tag('componentType');
  }
  Tag$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var Tag$Companion_instance = null;
  function Tag$Companion_getInstance() {
    if (Tag$Companion_instance === null) {
      new Tag$Companion();
    }
    return Tag$Companion_instance;
  }
  Tag.prototype.toString = function () {
    return this.name;
  };
  Tag.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Tag',
    interfaces: []
  };
  Tag.prototype.component1 = function () {
    return this.name;
  };
  Tag.prototype.copy_61zpoe$ = function (name) {
    return new Tag(name === void 0 ? this.name : name);
  };
  Tag.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.name) | 0;
    return result;
  };
  Tag.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.name, other.name))));
  };
  function CommandApplication(applied, shouldSendCommand, events, commandData) {
    CommandApplication$Companion_getInstance();
    this.applied = applied;
    this.shouldSendCommand_0 = shouldSendCommand;
    this.events = events;
    this.commandData = commandData;
  }
  CommandApplication.prototype.sendCommand = function () {
    return this.shouldSendCommand_0;
  };
  function CommandApplication$Companion() {
    CommandApplication$Companion_instance = this;
  }
  CommandApplication$Companion.prototype.clientCommandApplied_16dypu$ = function (events, commandData) {
    return new CommandApplication(true, false, events, commandData);
  };
  CommandApplication$Companion.prototype.applied_16dypu$ = function (events, commandData) {
    return new CommandApplication(true, true, events, commandData);
  };
  CommandApplication$Companion.prototype.rejected_anzskc$ = function (commandData) {
    return new CommandApplication(false, commandData.policy.isForceSend(), emptyList(), commandData);
  };
  CommandApplication$Companion.prototype.clientOnlyCommand_anzskc$ = function (commandData) {
    return new CommandApplication(false, true, emptyList(), commandData);
  };
  CommandApplication$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CommandApplication$Companion_instance = null;
  function CommandApplication$Companion_getInstance() {
    if (CommandApplication$Companion_instance === null) {
      new CommandApplication$Companion();
    }
    return CommandApplication$Companion_instance;
  }
  CommandApplication.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CommandApplication',
    interfaces: []
  };
  function ActionExecutor() {
    ActionExecutor_instance = this;
  }
  ActionExecutor.prototype.execute_2f2r5l$ = function (source, isCompositeUpdate, isLastEvetOfCompositeUpdate, modelStore, commandData) {
    var tmp$;
    var it = Kotlin.isType(tmp$ = commandData, ActionCommandData) ? tmp$ : throwCCE();
    return CommandApplication$Companion_getInstance().applied_16dypu$(listOf(new ActionEvent(it.source, isCompositeUpdate, isLastEvetOfCompositeUpdate, it.actionName, it.modelIds)), commandData);
  };
  ActionExecutor.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ActionExecutor',
    interfaces: [CommandExecutor]
  };
  var ActionExecutor_instance = null;
  function ActionExecutor_getInstance() {
    if (ActionExecutor_instance === null) {
      new ActionExecutor();
    }
    return ActionExecutor_instance;
  }
  function ChangeValueExecutor() {
    ChangeValueExecutor_instance = this;
  }
  function ChangeValueExecutor$execute$valueAlreadyPresent(closure$modelStore, closure$commandData) {
    return function () {
      var $receiver = closure$modelStore.get_accdal$(closure$commandData.modelId).get_lqljjj$(closure$commandData.propertyName);
      var closure$commandData_0 = closure$commandData;
      return $receiver.hasValue_ol557t$(closure$commandData_0.tag) && equals($receiver.get_ol557t$(closure$commandData_0.tag), closure$commandData_0.value);
    };
  }
  ChangeValueExecutor.prototype.execute_2f2r5l$ = function (source, isCompositeUpdate, isLastEvetOfCompositeUpdate, modelStore, commandData) {
    var tmp$, tmp$_0;
    var it = Kotlin.isType(tmp$ = commandData, ChangeValueCommandData) ? tmp$ : throwCCE();
    var valueAlreadyPresent = ChangeValueExecutor$execute$valueAlreadyPresent(modelStore, commandData);
    var model = modelStore.get_accdal$(it.modelId);
    if (model.clientOnly && source.isResponse()) {
      return CommandApplication$Companion_getInstance().clientOnlyCommand_anzskc$(commandData);
    }
    if (!this.forceApply_ls2jj0$(source, it) && valueAlreadyPresent()) {
      return CommandApplication$Companion_getInstance().rejected_anzskc$(commandData);
    }
    var property = model.get_lqljjj$(it.propertyName);
    if (property.isClientTag_ol557t$(it.tag) && source.isResponse()) {
      return CommandApplication$Companion_getInstance().clientOnlyCommand_anzskc$(commandData);
    }
    var clientOnlyChange = model.clientOnly || property.clientOnly || property.isClientTag_ol557t$(it.tag);
    var oldValue = property.set_jcm6gy$(it.tag, it.value);
    var events = listOf(new PropertyChangeEvent(it.source, isCompositeUpdate, isLastEvetOfCompositeUpdate, model.id, model.type, new ValueChangeEvent(it.source, isCompositeUpdate, isLastEvetOfCompositeUpdate, it.propertyName, it.tag, oldValue, it.value)));
    if (clientOnlyChange) {
      tmp$_0 = CommandApplication$Companion_getInstance().clientCommandApplied_16dypu$(events, commandData);
    }
     else {
      tmp$_0 = CommandApplication$Companion_getInstance().applied_16dypu$(events, commandData);
    }
    return tmp$_0;
  };
  ChangeValueExecutor.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'ChangeValueExecutor',
    interfaces: [CommandExecutor]
  };
  var ChangeValueExecutor_instance = null;
  function ChangeValueExecutor_getInstance() {
    if (ChangeValueExecutor_instance === null) {
      new ChangeValueExecutor();
    }
    return ChangeValueExecutor_instance;
  }
  function CommandExecutor() {
  }
  CommandExecutor.prototype.forceApply_ls2jj0$ = function (ourSource, commandData) {
    return commandData.policy.isForceApply() || (ourSource !== commandData.source && commandData.policy.isForceSend());
  };
  CommandExecutor.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CommandExecutor',
    interfaces: []
  };
  function CompositeCommandExecutor() {
    CompositeCommandExecutor_instance = this;
  }
  function CompositeCommandExecutor$execute$lambda(closure$source, closure$commandCount, closure$modelStore) {
    return function (index, command) {
      return CommandApplier_getInstance().apply_2f2r5l$(closure$source, true, closure$commandCount === (index + 1 | 0), closure$modelStore, command);
    };
  }
  function CompositeCommandExecutor$execute$lambda_0(it) {
    return it.applied;
  }
  function CompositeCommandExecutor$execute$lambda_1(it) {
    return asSequence(it.events);
  }
  CompositeCommandExecutor.prototype.execute_2f2r5l$ = function (source, isCompositeUpdate, isLastEvetOfCompositeUpdate, modelStore, commandData) {
    var tmp$;
    var data = Kotlin.isType(tmp$ = commandData, CompositeCommandData) ? tmp$ : throwCCE();
    var commandCount = data.commands.size;
    var events = toList(flatMap(filter(mapIndexed(asSequence(data.commands), CompositeCommandExecutor$execute$lambda(source, commandCount, modelStore)), CompositeCommandExecutor$execute$lambda_0), CompositeCommandExecutor$execute$lambda_1));
    return CommandApplication$Companion_getInstance().applied_16dypu$(events, data);
  };
  CompositeCommandExecutor.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'CompositeCommandExecutor',
    interfaces: [CommandExecutor]
  };
  var CompositeCommandExecutor_instance = null;
  function CompositeCommandExecutor_getInstance() {
    if (CompositeCommandExecutor_instance === null) {
      new CompositeCommandExecutor();
    }
    return CompositeCommandExecutor_instance;
  }
  function CreateModelExecutor() {
    CreateModelExecutor_instance = this;
  }
  function CreateModelExecutor$execute$lambda(closure$source) {
    return function (it) {
      return !(it.clientOnly && closure$source.isResponse());
    };
  }
  CreateModelExecutor.prototype.execute_2f2r5l$ = function (source, isCompositeUpdate, isLastEvetOfCompositeUpdate, modelStore, commandData) {
    var tmp$;
    var it = Kotlin.isType(tmp$ = commandData, CreateModelCommandData) ? tmp$ : throwCCE();
    if (commandData.clientOnly && source.isResponse()) {
      var model = new DefaultPresentationModel(it.modelId, it.modelType, commandData.clientOnly, emptySequence());
      modelStore.addModel_pl55oe$(model);
      return CommandApplication$Companion_getInstance().clientOnlyCommand_anzskc$(commandData);
    }
    if (!this.forceApply_ls2jj0$(source, it) && modelStore.contains_accdal$(commandData.modelId)) {
      return CommandApplication$Companion_getInstance().rejected_anzskc$(commandData);
    }
    var properties = filter(asSequence(it.properties), CreateModelExecutor$execute$lambda(source));
    var model_0 = new DefaultPresentationModel(it.modelId, it.modelType, commandData.clientOnly, properties);
    modelStore.addModel_pl55oe$(model_0);
    var events = listOf(new ModelStoreChangeEvent(it.source, isCompositeUpdate, isLastEvetOfCompositeUpdate, model_0.id, model_0.type, ModelStoreChangeEventType$ADD_getInstance()));
    if (model_0.clientOnly) {
      return CommandApplication$Companion_getInstance().clientCommandApplied_16dypu$(events, commandData);
    }
    return CommandApplication$Companion_getInstance().applied_16dypu$(events, commandData);
  };
  CreateModelExecutor.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'CreateModelExecutor',
    interfaces: [CommandExecutor]
  };
  var CreateModelExecutor_instance = null;
  function CreateModelExecutor_getInstance() {
    if (CreateModelExecutor_instance === null) {
      new CreateModelExecutor();
    }
    return CreateModelExecutor_instance;
  }
  function RemoveModelByTypeExecutor() {
    RemoveModelByTypeExecutor_instance = this;
  }
  function RemoveModelByTypeExecutor$execute$isLastEvent(closure$isCompositeUpdate, closure$isLastEvetOfCompositeUpdate, closure$models) {
    return function (index) {
      return closure$isCompositeUpdate && closure$isLastEvetOfCompositeUpdate && (index + 1 | 0) === closure$models.size || (!closure$isCompositeUpdate && (index + 1 | 0) === closure$models.size);
    };
  }
  RemoveModelByTypeExecutor.prototype.execute_2f2r5l$ = function (source, isCompositeUpdate, isLastEvetOfCompositeUpdate, modelStore, commandData) {
    var tmp$;
    var it = Kotlin.isType(tmp$ = commandData, RemoveModelByTypeCommandData) ? tmp$ : throwCCE();
    if (!this.forceApply_ls2jj0$(source, it) && !modelStore.contains_4tsc7m$(it.modelType)) {
      return CommandApplication$Companion_getInstance().rejected_anzskc$(commandData);
    }
    var models = modelStore.removeModels_4tsc7m$(it.modelType);
    var isLastEvent = RemoveModelByTypeExecutor$execute$isLastEvent(isCompositeUpdate, isLastEvetOfCompositeUpdate, models);
    var tmp$_0 = CommandApplication$Companion_getInstance();
    var destination = ArrayList_init(collectionSizeOrDefault(models, 10));
    var tmp$_1, tmp$_0_0;
    var index = 0;
    tmp$_1 = models.iterator();
    while (tmp$_1.hasNext()) {
      var item = tmp$_1.next();
      var tmp$_2 = destination.add_11rb$;
      var index_0 = (tmp$_0_0 = index, index = tmp$_0_0 + 1 | 0, tmp$_0_0);
      tmp$_2.call(destination, new ModelStoreChangeEvent(it.source, true, isLastEvent(index_0), item.id, item.type, ModelStoreChangeEventType$REMOVE_getInstance()));
    }
    return tmp$_0.applied_16dypu$(destination, commandData);
  };
  RemoveModelByTypeExecutor.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'RemoveModelByTypeExecutor',
    interfaces: [CommandExecutor]
  };
  var RemoveModelByTypeExecutor_instance = null;
  function RemoveModelByTypeExecutor_getInstance() {
    if (RemoveModelByTypeExecutor_instance === null) {
      new RemoveModelByTypeExecutor();
    }
    return RemoveModelByTypeExecutor_instance;
  }
  function RemoveModelExecutor() {
    RemoveModelExecutor_instance = this;
  }
  RemoveModelExecutor.prototype.execute_2f2r5l$ = function (source, isCompositeUpdate, isLastEvetOfCompositeUpdate, modelStore, commandData) {
    var tmp$;
    var it = Kotlin.isType(tmp$ = commandData, RemoveModelCommandData) ? tmp$ : throwCCE();
    if (!this.forceApply_ls2jj0$(source, it) && !modelStore.contains_accdal$(it.modelId)) {
      return CommandApplication$Companion_getInstance().rejected_anzskc$(commandData);
    }
    if (modelStore.contains_accdal$(it.modelId))
      modelStore.removeModel_accdal$(it.modelId);
    return CommandApplication$Companion_getInstance().applied_16dypu$(listOf(new ModelStoreChangeEvent(it.source, isCompositeUpdate, isLastEvetOfCompositeUpdate, it.modelId, it.modelType, ModelStoreChangeEventType$REMOVE_getInstance())), commandData);
  };
  RemoveModelExecutor.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'RemoveModelExecutor',
    interfaces: [CommandExecutor]
  };
  var RemoveModelExecutor_instance = null;
  function RemoveModelExecutor_getInstance() {
    if (RemoveModelExecutor_instance === null) {
      new RemoveModelExecutor();
    }
    return RemoveModelExecutor_instance;
  }
  function SyncModelExecutor() {
    SyncModelExecutor_instance = this;
  }
  function SyncModelExecutor$execute$lambda(closure$destinationPm) {
    return function (property) {
      return closure$destinationPm.hasProperty_lqljjj$(property.name);
    };
  }
  function SyncModelExecutor$execute$lambda$lambda(closure$destinationPm, closure$property, closure$data, closure$isCompositeUpdate, closure$isLastEvetOfCompositeUpdate) {
    return function (pair) {
      var tag = pair.component1()
      , value = pair.component2();
      var oldValue = closure$destinationPm.get_lqljjj$(closure$property.name).set_jcm6gy$(tag, value);
      return new PropertyChangeEvent(closure$data.source, closure$isCompositeUpdate, closure$isLastEvetOfCompositeUpdate, closure$destinationPm.id, closure$destinationPm.type, new ValueChangeEvent(closure$data.source, closure$isCompositeUpdate, closure$isLastEvetOfCompositeUpdate, closure$property.name, tag, oldValue, value));
    };
  }
  function SyncModelExecutor$execute$lambda_0(closure$destinationPm, closure$data, closure$isCompositeUpdate, closure$isLastEvetOfCompositeUpdate) {
    return function (property) {
      return map(property.getValues(), SyncModelExecutor$execute$lambda$lambda(closure$destinationPm, property, closure$data, closure$isCompositeUpdate, closure$isLastEvetOfCompositeUpdate));
    };
  }
  SyncModelExecutor.prototype.execute_2f2r5l$ = function (source, isCompositeUpdate, isLastEvetOfCompositeUpdate, modelStore, commandData) {
    var tmp$;
    var data = Kotlin.isType(tmp$ = commandData, SyncModelCommandData) ? tmp$ : throwCCE();
    var sourcePm = modelStore.get_accdal$(data.sourceModel);
    var destinationPm = modelStore.get_accdal$(data.destinationModel);
    var events = toList(flatMap(filter(sourcePm.getProperties(), SyncModelExecutor$execute$lambda(destinationPm)), SyncModelExecutor$execute$lambda_0(destinationPm, data, isCompositeUpdate, isLastEvetOfCompositeUpdate)));
    return CommandApplication$Companion_getInstance().applied_16dypu$(events, commandData);
  };
  SyncModelExecutor.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'SyncModelExecutor',
    interfaces: [CommandExecutor]
  };
  var SyncModelExecutor_instance = null;
  function SyncModelExecutor_getInstance() {
    if (SyncModelExecutor_instance === null) {
      new SyncModelExecutor();
    }
    return SyncModelExecutor_instance;
  }
  function DefaultPresentationModel(id, type, clientOnly, properties) {
    this.id_om9u90$_0 = id;
    this.type_53pwpv$_0 = type;
    this.clientOnly_i5t2cg$_0 = clientOnly;
    var $receiver = LinkedHashMap_init();
    var tmp$;
    tmp$ = properties.iterator();
    while (tmp$.hasNext()) {
      var element = tmp$.next();
      var key = element.name;
      $receiver.put_xwzc9p$(key, element);
    }
    this.properties_0 = $receiver;
  }
  Object.defineProperty(DefaultPresentationModel.prototype, 'id', {
    get: function () {
      return this.id_om9u90$_0;
    }
  });
  Object.defineProperty(DefaultPresentationModel.prototype, 'type', {
    get: function () {
      return this.type_53pwpv$_0;
    }
  });
  Object.defineProperty(DefaultPresentationModel.prototype, 'clientOnly', {
    get: function () {
      return this.clientOnly_i5t2cg$_0;
    }
  });
  DefaultPresentationModel.prototype.getPropertiesArray = function () {
    return copyToArray(this.properties_0.values);
  };
  DefaultPresentationModel.prototype.getProperties = function () {
    return asSequence(this.properties_0.values);
  };
  DefaultPresentationModel.prototype.propertyCount = function () {
    return this.properties_0.size;
  };
  DefaultPresentationModel.prototype.get_lqljjj$ = function (propertyName) {
    var tmp$;
    tmp$ = this.properties_0.get_11rb$(propertyName);
    if (tmp$ == null) {
      throw IllegalArgumentException_init("Property '" + propertyName + "' in model '" + this.id + "' not found");
    }
    return tmp$;
  };
  DefaultPresentationModel.prototype.toString = function () {
    var $receiver = this.properties_0;
    var destination = ArrayList_init($receiver.size);
    var tmp$;
    tmp$ = $receiver.entries.iterator();
    while (tmp$.hasNext()) {
      var item = tmp$.next();
      destination.add_11rb$(item.value.toString());
    }
    return destination.toString();
  };
  DefaultPresentationModel.prototype.hasProperty_lqljjj$ = function (name) {
    return this.properties_0.containsKey_11rb$(name);
  };
  DefaultPresentationModel.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DefaultPresentationModel',
    interfaces: [PresentationModel]
  };
  function DefaultPresentationModelStore() {
    this.models_0 = LinkedHashMap_init();
    this.modelType2Model_0 = HashMap_init();
  }
  DefaultPresentationModelStore.prototype.addModel_pl55oe$ = function (model) {
    var $receiver = this.models_0;
    var key = model.id;
    $receiver.put_xwzc9p$(key, model);
    var $receiver_0 = this.modelType2Model_0;
    var key_0 = model.type;
    var tmp$;
    var value = $receiver_0.get_11rb$(key_0);
    if (value == null) {
      var answer = ArrayList_init();
      $receiver_0.put_xwzc9p$(key_0, answer);
      tmp$ = answer;
    }
     else {
      tmp$ = value;
    }
    tmp$.add_11rb$(model);
  };
  DefaultPresentationModelStore.prototype.get_accdal$ = function (modelId) {
    var tmp$;
    tmp$ = this.models_0.get_11rb$(modelId);
    if (tmp$ == null) {
      throw IllegalArgumentException_init("No model with id '" + modelId + "' present.");
    }
    return tmp$;
  };
  DefaultPresentationModelStore.prototype.get_4tsc7m$ = function (modelType) {
    var tmp$;
    return (tmp$ = this.modelType2Model_0.get_11rb$(modelType)) != null ? tmp$ : emptyList();
  };
  DefaultPresentationModelStore.prototype.removeModel_accdal$ = function (modelId) {
    var tmp$;
    var removedPm = ensureNotNull(this.models_0.remove_11rb$(modelId));
    (tmp$ = this.modelType2Model_0.get_11rb$(removedPm.type)) != null ? tmp$.remove_11rb$(removedPm) : null;
    return removedPm;
  };
  DefaultPresentationModelStore.prototype.removeModels_4tsc7m$ = function (modelType) {
    var removedPms = this.modelType2Model_0.remove_11rb$(modelType);
    if (removedPms != null) {
      var tmp$;
      tmp$ = removedPms.iterator();
      while (tmp$.hasNext()) {
        var element = tmp$.next();
        this.models_0.remove_11rb$(element.id);
      }
    }
    return removedPms != null ? removedPms : emptyList();
  };
  var Map = Kotlin.kotlin.collections.Map;
  DefaultPresentationModelStore.prototype.contains_accdal$ = function (modelId) {
    var $receiver = this.models_0;
    var tmp$;
    return (Kotlin.isType(tmp$ = $receiver, Map) ? tmp$ : throwCCE()).containsKey_11rb$(modelId);
  };
  DefaultPresentationModelStore.prototype.contains_4tsc7m$ = function (modelType) {
    var tmp$, tmp$_0;
    return ((tmp$_0 = (tmp$ = this.modelType2Model_0.get_11rb$(modelType)) != null ? tmp$.size : null) != null ? tmp$_0 : 0) > 0;
  };
  DefaultPresentationModelStore.prototype.getAllModels = function () {
    return this.models_0.values;
  };
  DefaultPresentationModelStore.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DefaultPresentationModelStore',
    interfaces: [ModelStore]
  };
  var package$ch = _.ch || (_.ch = {});
  var package$viseon = package$ch.viseon || (package$ch.viseon = {});
  var package$openOrca = package$viseon.openOrca || (package$viseon.openOrca = {});
  var package$client = package$openOrca.client || (package$openOrca.client = {});
  package$client.ClientOrca = ClientOrca;
  Object.defineProperty(RequestEvent, 'START', {
    get: RequestEvent$START_getInstance
  });
  Object.defineProperty(RequestEvent, 'END', {
    get: RequestEvent$END_getInstance
  });
  package$client.RequestEvent = RequestEvent;
  $$importsForInline$$['kodando-rxjs'] = $module$kodando_rxjs;
  package$client.ClientOrcaImpl = ClientOrcaImpl;
  package$client.CommandListExecutor = CommandListExecutor;
  package$client.ClientCommandListExecutor = ClientCommandListExecutor;
  package$client.JsonFactoryJs = JsonFactoryJs;
  package$client.JsonObjJs_init_1j20nt$ = JsonObjJs_init;
  package$client.JsonObjJs = JsonObjJs;
  package$client.just_mh5how$ = just;
  package$client.Transmitter = Transmitter;
  package$client.XMLHttpRequestTransmitter = XMLHttpRequestTransmitter;
  var package$share = package$openOrca.share || (package$openOrca.share = {});
  package$share.StringCodec = StringCodec;
  Object.defineProperty(package$share, 'CommandApplier', {
    get: CommandApplier_getInstance
  });
  Object.defineProperty(ApplyPolicy, 'DEFAULT', {
    get: ApplyPolicy$DEFAULT_getInstance
  });
  Object.defineProperty(ApplyPolicy, 'FORCE_SEND', {
    get: ApplyPolicy$FORCE_SEND_getInstance
  });
  Object.defineProperty(ApplyPolicy, 'FORCE_APPLY', {
    get: ApplyPolicy$FORCE_APPLY_getInstance
  });
  package$share.ApplyPolicy = ApplyPolicy;
  package$share.CommandData = CommandData;
  package$share.ChangeValueCommandData = ChangeValueCommandData;
  package$share.CreateModelCommandData = CreateModelCommandData;
  package$share.RemoveModelCommandData = RemoveModelCommandData;
  package$share.ActionCommandData = ActionCommandData;
  package$share.CompositeCommandData = CompositeCommandData;
  package$share.RemoveModelByTypeCommandData = RemoveModelByTypeCommandData;
  package$share.SyncModelCommandData = SyncModelCommandData;
  package$share.Event = Event;
  Object.defineProperty(ModelStoreChangeEventType, 'ADD', {
    get: ModelStoreChangeEventType$ADD_getInstance
  });
  Object.defineProperty(ModelStoreChangeEventType, 'REMOVE', {
    get: ModelStoreChangeEventType$REMOVE_getInstance
  });
  package$share.ModelStoreChangeEventType = ModelStoreChangeEventType;
  package$share.ModelStoreChangeEvent = ModelStoreChangeEvent;
  package$share.PropertyChangeEvent = PropertyChangeEvent;
  package$share.ValueChangeEvent = ValueChangeEvent;
  package$share.ActionEvent = ActionEvent;
  package$share.ModelId = ModelId;
  package$share.ModelType = ModelType;
  package$share.PropertyName = PropertyName;
  package$share.JsonArray = JsonArray;
  package$share.JsonObj = JsonObj;
  package$share.JsonFactory = JsonFactory;
  package$share.JsonCodec = JsonCodec;
  package$share.CommandCodec = CommandCodec;
  package$share.RemoveModelByTypeCodec = RemoveModelByTypeCodec;
  package$share.SyncModelCommandCodec = SyncModelCommandCodec;
  package$share.CompositeCommandCodec = CompositeCommandCodec;
  package$share.valueToJson_ixxqss$ = valueToJson;
  package$share.isSupported_za3rmp$ = isSupported;
  package$share.valueFromJson_ipy83i$ = valueFromJson;
  package$share.ModelBuilder = ModelBuilder;
  package$share.ModelStore = ModelStore;
  package$share.PresentationModel = PresentationModel;
  PresentationModelBuilder.PropertyBuilder = PresentationModelBuilder$PropertyBuilder;
  package$share.PresentationModelBuilder = PresentationModelBuilder;
  package$share.Tag = Tag;
  package$share.Property = Property;
  Object.defineProperty(Source, 'REQUEST', {
    get: Source$REQUEST_getInstance
  });
  Object.defineProperty(Source, 'RESPONSE', {
    get: Source$RESPONSE_getInstance
  });
  package$share.Source = Source;
  Object.defineProperty(Tag, 'Companion', {
    get: Tag$Companion_getInstance
  });
  Object.defineProperty(CommandApplication, 'Companion', {
    get: CommandApplication$Companion_getInstance
  });
  var package$command = package$share.command || (package$share.command = {});
  package$command.CommandApplication = CommandApplication;
  var package$execution = package$command.execution || (package$command.execution = {});
  Object.defineProperty(package$execution, 'ActionExecutor', {
    get: ActionExecutor_getInstance
  });
  Object.defineProperty(package$execution, 'ChangeValueExecutor', {
    get: ChangeValueExecutor_getInstance
  });
  package$execution.CommandExecutor = CommandExecutor;
  Object.defineProperty(package$execution, 'CompositeCommandExecutor', {
    get: CompositeCommandExecutor_getInstance
  });
  Object.defineProperty(package$execution, 'CreateModelExecutor', {
    get: CreateModelExecutor_getInstance
  });
  Object.defineProperty(package$execution, 'RemoveModelByTypeExecutor', {
    get: RemoveModelByTypeExecutor_getInstance
  });
  Object.defineProperty(package$execution, 'RemoveModelExecutor', {
    get: RemoveModelExecutor_getInstance
  });
  Object.defineProperty(package$execution, 'SyncModelExecutor', {
    get: SyncModelExecutor_getInstance
  });
  var package$impl = package$share.impl || (package$share.impl = {});
  package$impl.DefaultPresentationModel = DefaultPresentationModel;
  package$impl.DefaultPresentationModelStore = DefaultPresentationModelStore;
  ClientCommandListExecutor.prototype.execute_sy5qnb$ = CommandListExecutor.prototype.execute_sy5qnb$;
  PresentationModelBuilder.prototype.build_tytvht$ = ModelBuilder.prototype.build_tytvht$;
  ActionExecutor.prototype.forceApply_ls2jj0$ = CommandExecutor.prototype.forceApply_ls2jj0$;
  ChangeValueExecutor.prototype.forceApply_ls2jj0$ = CommandExecutor.prototype.forceApply_ls2jj0$;
  CompositeCommandExecutor.prototype.forceApply_ls2jj0$ = CommandExecutor.prototype.forceApply_ls2jj0$;
  CreateModelExecutor.prototype.forceApply_ls2jj0$ = CommandExecutor.prototype.forceApply_ls2jj0$;
  RemoveModelByTypeExecutor.prototype.forceApply_ls2jj0$ = CommandExecutor.prototype.forceApply_ls2jj0$;
  RemoveModelExecutor.prototype.forceApply_ls2jj0$ = CommandExecutor.prototype.forceApply_ls2jj0$;
  SyncModelExecutor.prototype.forceApply_ls2jj0$ = CommandExecutor.prototype.forceApply_ls2jj0$;
  Kotlin.defineModule('openorca-js-client', _);
  return _;
}));

//# sourceMappingURL=openorca-js-client.js.map
