package ch.viseon.openOrca.server

import ch.viseon.openOrca.server.impl.CommandListExecutor
import ch.viseon.openOrca.server.impl.OrcaSourceImpl
import ch.viseon.openOrca.share.CommandData
import ch.viseon.openOrca.share.Event
import io.reactivex.Observable
import io.reactivex.subjects.PublishSubject
import io.reactivex.subjects.ReplaySubject

class OrcaRun(
    private val commandListExecutor: CommandListExecutor,
    private val requestProcessor: (OrcaSource) -> Observable<CommandData>,
    private val storeLifecycle: StoreLifecycle) {


  fun execute(request: Request, responseProcessor: Response) {
    val eventSubject = ReplaySubject.create<Event>(1)

    val modelStore = storeLifecycle.getStore()
    val orcaSource = OrcaSourceImpl(modelStore, eventSubject)

    val responseCommandSubject = PublishSubject.create<CommandData>()
    val responseCommands = requestProcessor(orcaSource)
        .doOnNext { responseCommandSubject.onNext(it) }

    val events = commandListExecutor.execute(modelStore, Observable.concat(request.readCommands(), responseCommands))

    responseProcessor.sendCommands(responseCommandSubject)

    events
        .doOnNext(::println)
        .subscribe(eventSubject)
    storeLifecycle.updateStore(modelStore)

    responseCommandSubject.onComplete()
  }

}

