package ch.viseon.openOrca.server

import ch.viseon.openOrca.share.*
import io.reactivex.Observable

interface OrcaSource {
  fun observeModelStore(): Observable<ModelStoreChangeEvent>
  fun observeModel(modelId: ModelId): Observable<PropertyChangeEvent>
  fun observeModel(modelType: ModelType): Observable<PropertyChangeEvent>
  fun observeProperty(modelId: ModelId, propertyName: PropertyName): Observable<ValueChangeEvent>

  fun model(modelId: ModelId): PresentationModel
  fun model(modelType: ModelType): Collection<PresentationModel>

  fun registerNamedCommand(actionName: String): Observable<ActionEvent>

}

