package ch.viseon.openOrca.server.impl

import ch.viseon.openOrca.server.OrcaSource
import ch.viseon.openOrca.share.*
import io.reactivex.Observable

/**
 * This class acts as a facade.
 */
/*
 * The eventSubject serves as multiplexer to various subscriptions.
 */
class OrcaSourceImpl(private val modelStore: ModelStore,
                     private val eventSubject: Observable<Event>) : OrcaSource {

  override fun observeModelStore(): Observable<ModelStoreChangeEvent> {
    return eventSubject
        .filter { it is ModelStoreChangeEvent }
        .map { it as ModelStoreChangeEvent }
  }

  override fun observeModel(modelId: ModelId): Observable<PropertyChangeEvent> {
    return eventStreamAsPropertyChangeEvent()
        .filter { it.modelId == modelId }
  }

  override fun observeModel(modelType: ModelType): Observable<PropertyChangeEvent> {
    return eventStreamAsPropertyChangeEvent()
        .filter { it.modelType == modelType }
  }

  override fun observeProperty(modelId: ModelId, propertyName: PropertyName): Observable<ValueChangeEvent> {
    return eventStreamAsPropertyChangeEvent()
        .filter { it.modelId == modelId }
        .map { it.valueChangeEvent }
  }

  private fun eventStreamAsPropertyChangeEvent(): Observable<PropertyChangeEvent> {
    return eventSubject
        .filter { it is PropertyChangeEvent }
        .map { it as PropertyChangeEvent }
  }

  override fun registerNamedCommand(actionName: String): Observable<ActionEvent> {
    return eventSubject
        .filter { it is ActionEvent }
        .map { it as ActionEvent }
        .filter { it.actionName == actionName }
  }

  override fun model(modelType: ModelType): Collection<PresentationModel> {
    return modelStore[modelType]
  }

  override fun model(modelId: ModelId): PresentationModel {
    return modelStore[modelId]
  }

}

