/*
 * Copyright 2017 viseon gmbh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ch.viseon.openOrca.server

import ch.viseon.openOrca.server.impl.CommandListExecutor
import ch.viseon.openOrca.server.impl.OrcaSourceImpl
import ch.viseon.openOrca.share.CommandData
import ch.viseon.openOrca.share.Event
import io.reactivex.Observable
import io.reactivex.subjects.PublishSubject
import io.reactivex.subjects.ReplaySubject

class OrcaRun(
    private val commandListExecutor: CommandListExecutor,
    private val requestProcessor: (OrcaSource) -> Observable<CommandData>,
    private val storeLifecycle: StoreLifecycle) {


  fun execute(request: Request, responseProcessor: Response) {
    val eventSubject = ReplaySubject.create<Event>(1)

    val modelStore = storeLifecycle.getStore()
    val orcaSource = OrcaSourceImpl(modelStore, eventSubject)

    val responseCommandSubject = PublishSubject.create<CommandData>()
    val responseCommands = requestProcessor(orcaSource)
        .doOnError { it.printStackTrace() }
        .doOnNext { responseCommandSubject.onNext(it) }

    val events = commandListExecutor.execute(modelStore, Observable.concat(request.readCommands(), responseCommands))

    responseProcessor.sendCommands(responseCommandSubject)

    events
        .doOnError { it.printStackTrace() }
        .doOnNext(::println)
        .subscribe(eventSubject)
    storeLifecycle.updateStore(modelStore)

    responseCommandSubject.onComplete()
  }

}

