/*
 * Copyright 2017 viseon gmbh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ch.viseon.openOrca.server.impl

import ch.viseon.openOrca.share.CommandApplication
import ch.viseon.openOrca.share.CommandApplier
import ch.viseon.openOrca.share.CommandData
import ch.viseon.openOrca.share.ModelStore
import io.reactivex.Observable

interface CommandListExecutor {

  fun execute(modelStore: ModelStore, commandData: Observable<CommandData>): Observable<CommandApplication>

  fun execute(modelStore: ModelStore, commandData: CommandData): Observable<CommandApplication> {
    return execute(modelStore, Observable.just(commandData))
  }

}

private val LOGGER = loggerFor<ServerCommandListExecutor>()

class ServerCommandListExecutor : CommandListExecutor {

  override fun execute(modelStore: ModelStore, commandData: Observable<CommandData>): Observable<CommandApplication> {
    return commandData.flatMap { applyCommand(modelStore, it) }
  }

  private fun applyCommand(modelStore: ModelStore, it: CommandData): Observable<CommandApplication> {
    LOGGER.finer { "applyingCommand data: $it" }
    return Observable.just(CommandApplier.apply(modelStore, it))
  }

}

