/*
 * Decompiled with CFR 0.152.
 */
package ch.viseon.openOrca.share;

import ch.viseon.openOrca.share.JsonObj;
import ch.viseon.openOrca.share.ModelId;
import ch.viseon.openOrca.share.ModelType;
import ch.viseon.openOrca.share.Tag;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0003H\u0002\u001a\f\u0010\u000e\u001a\u00020\r*\u00020\u0003H\u0002\u00a8\u0006\u000f"}, d2={"isSupported", "", "value", "", "valueFromJson", "Lkotlin/Pair;", "Lch/viseon/openOrca/share/Tag;", "json", "Lch/viseon/openOrca/share/JsonObj;", "valueToJson", "jsonObj", "tag", "asJsonValue", "", "getJsonTypeId", "server-servlet"})
public final class JsonCodecKt {
    @NotNull
    public static final JsonObj valueToJson(@NotNull JsonObj jsonObj2, @NotNull Tag tag, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)jsonObj2, (String)"jsonObj");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        JsonObj $receiver = jsonObj2;
        if (!(value instanceof String)) {
            $receiver.set("type", JsonCodecKt.getJsonTypeId(value));
        }
        $receiver.set("value", JsonCodecKt.asJsonValue(value));
        if (Intrinsics.areEqual((Object)tag, (Object)Tag.Companion.getVALUE()) ^ true) {
            $receiver.set("tag", tag.getName());
        }
        return jsonObj2;
    }

    private static final String getJsonTypeId(@NotNull Object $receiver) {
        String string;
        Object object = $receiver;
        if (object instanceof String) {
            string = "String";
        } else if (object instanceof Boolean) {
            string = "Boolean";
        } else if (object instanceof Double) {
            string = "Double";
        } else if (object instanceof Float) {
            string = "Float";
        } else if (object instanceof Long) {
            string = "Long";
        } else if (object instanceof Integer) {
            string = "Int";
        } else if (object instanceof Character) {
            string = "Char";
        } else if (object instanceof Short) {
            string = "Short";
        } else if (object instanceof ModelId) {
            string = "ModelId";
        } else if (object instanceof ModelType) {
            string = "ModelType";
        } else {
            throw (Throwable)new IllegalArgumentException("Type of value '" + $receiver + "' (class.simpleName: '" + Reflection.getOrCreateKotlinClass($receiver.getClass()).getSimpleName() + "') not be supported.");
        }
        return string;
    }

    public static final boolean isSupported(@NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return value instanceof String || value instanceof Boolean || value instanceof Double || value instanceof Float || value instanceof Long || value instanceof Integer || value instanceof Character || value instanceof Short || value instanceof ModelId || value instanceof ModelType;
    }

    private static final String asJsonValue(@NotNull Object $receiver) {
        return $receiver.toString();
    }

    @NotNull
    public static final Pair<Tag, Object> valueFromJson(@NotNull JsonObj json) {
        Object object;
        String type;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        String string = json.optionalString("type");
        if (string == null) {
            string = "String";
        }
        switch (type = string) {
            case "String": {
                object = json.string("value");
                break;
            }
            case "Boolean": {
                object = json.boolean("value");
                break;
            }
            case "Int": {
                object = json.integer("value");
                break;
            }
            case "Long": {
                object = json.long("value");
                break;
            }
            case "Float": {
                object = Float.valueOf(json.float("value"));
                break;
            }
            case "Double": {
                object = json.double("value");
                break;
            }
            case "Char": {
                object = Character.valueOf(json.string("value").charAt(0));
                break;
            }
            case "Short": {
                object = (short)json.integer("value");
                break;
            }
            case "ModelId": {
                object = new ModelId(json.string("value"));
                break;
            }
            case "ModelType": {
                object = new ModelType(json.string("value"));
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unknown propertyValue type: '" + type + '\'');
            }
        }
        Object value = object;
        String string2 = json.optionalString("tag");
        if (string2 == null) {
            string2 = Tag.Companion.getVALUE().getName();
        }
        String tag = string2;
        return new Pair((Object)new Tag(tag), value);
    }
}

