/*
 * Copyright 2017 viseon gmbh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ch.viseon.openOrca.share

class PresentationModelBuilder(
    val modelId: ModelId,
    val modelType: ModelType,
    block: PresentationModelBuilder.() -> Unit) : ModelBuilder {


  private val properties: MutableList<Property> = ArrayList()

  val propertyList: List<Property> get() {
    return properties
  }

  init {
    block()
  }

  override fun build(source: Source): CreateModelCommandData {
    return CreateModelCommandData(source, modelId, modelType, properties)
  }

  fun property(name: PropertyName, block: PropertyBuilder.() -> Unit) {
    val builder = PropertyBuilder(name)
    builder.block()
    properties.add(builder.build())
  }

  private fun createProperty(name: PropertyName, values: Sequence<PropertyValue>): Property {
    return Property(name, values)
  }

  inner class PropertyBuilder(val name: PropertyName) {

    val values: MutableMap<String, PropertyValue> = LinkedHashMap()

    var label: LabelPropertyValue
      set(value) {
        set(value)
      }
      get() {
        return this[LabelPropertyValue::class.simpleName!!] as LabelPropertyValue
      }

    var toolTip: ToolTipPropertyValue
      set(value) {
        set(value)
      }
      get() {
        return this[ToolTipPropertyValue::class.simpleName!!] as ToolTipPropertyValue
      }


    var value: ValuePropertyValue
      set(value) {
        set(value)
      }
      get() {
        return this[ValuePropertyValue::class.simpleName!!] as ValuePropertyValue
      }


    fun set(propertyValue: PropertyValue) {
      values[propertyValue::class.simpleName!!] = propertyValue
    }

    operator fun get(typeName: String): PropertyValue {
      return values[typeName]!!
    }

    fun build(): Property {
      return createProperty(name, values.values.asSequence())
    }

  }

}
