/*
 * Copyright 2017 viseon gmbh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ch.viseon.openOrca.share

interface PropertyValue {
  fun asJsonValue(): String
  fun getJsonTypeId(): String
}

data class ToolTipPropertyValue(val value: String): PropertyValue {
  override fun getJsonTypeId(): String {
    return this::class.simpleName!!
  }

  override fun asJsonValue(): String {
    return value.asJsonString()
  }
}

data class LabelPropertyValue(val value: String): PropertyValue {
  override fun getJsonTypeId(): String {
    return this::class.simpleName!!
  }
  override fun asJsonValue(): String {
    return value.asJsonString()
  }
}

sealed class ValuePropertyValue: PropertyValue {
  abstract val value: Any
}

data class ModelIdValue(override val value: ModelId): ValuePropertyValue() {
  override fun getJsonTypeId(): String {
    return this::class.simpleName!!
  }

  override fun asJsonValue(): String {
    return value.stringId.asJsonString()
  }
}

data class StringValue(override val value: String): ValuePropertyValue() {
  override fun getJsonTypeId(): String {
    return this::class.simpleName!!
  }

  override fun asJsonValue(): String {
    return value.asJsonString()
  }
}

data class BooleanValue(override val value: Boolean): ValuePropertyValue() {
  override fun getJsonTypeId(): String {
    return this::class.simpleName!!
  }

  override fun asJsonValue(): String {
    return value.toString()
  }
}

private fun String.asJsonString(): String {
  return this
}

