/*
 * Copyright 2017 viseon gmbh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ch.viseon.openOrca.share

/**
 * Command data serves as a carrier of a change: Create a new model, or change a value from a particular model.
 *
 * Clients can implement there on commands. Check serialization of commands from a Request and deserialization to a Response.
 */
interface CommandData {
  val source: Source
  val forceSend: Boolean
}

data class ChangeValueCommandData(override val source: Source,
                                  val modelId: ModelId,
                                  val propertyName: PropertyName,
                                  val tag: Tag,
                                  val value: PropertyValue,
                                  override val forceSend: Boolean = false) : CommandData

data class CreateModelCommandData(override val source: Source,
                                  val modelId: ModelId,
                                  val modelType: ModelType,
                                  val properties: Collection<Property>,
                                  override val forceSend: Boolean = false) : CommandData

data class RemoveModelCommandData(override val source: Source,
                                  val modelId: ModelId,
                                  override val forceSend: Boolean = false) : CommandData

data class ActionCommandData(override val source: Source,
                             val actionName: String,
                             val modelIds: List<ModelId> = listOf(),
                             override val forceSend: Boolean = false) : CommandData {

}

/**
 * Removes all models of a certain type.
 */
data class RemoveModelByTypeCommandData(
    override val source: Source,
    val modelType: ModelType,
    override val forceSend: Boolean = false) : CommandData

/**
 * Copy one model onto another.
 */
data class SyncModelCommandData(
    override val source: Source,
    val sourceModel: ModelId,
    val destinationModel: ModelId,
    override val forceSend: Boolean = false) : CommandData

