/*
 * Copyright 2017 viseon gmbh
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ch.viseon.openOrca.share

sealed class PropertyValue {
  abstract val value: Any
  abstract fun asJsonValue(): String
  abstract fun getJsonTypeId(): String
}

data class ModelIdValue(override val value: ModelId): PropertyValue() {
  override fun getJsonTypeId(): String {
    return this::class.simpleName!!
  }

  override fun asJsonValue(): String {
    return value.stringId.asJsonString()
  }
}

data class StringValue(override val value: String): PropertyValue() {
  override fun getJsonTypeId(): String {
    return this::class.simpleName!!
  }

  override fun asJsonValue(): String {
    return value.asJsonString()
  }
}

data class BooleanValue(override val value: Boolean): PropertyValue() {
  override fun getJsonTypeId(): String {
    return this::class.simpleName!!
  }

  override fun asJsonValue(): String {
    return value.toString()
  }
}

data class IntegerValue(override val value: Int): PropertyValue() {
  override fun asJsonValue(): String {
    return value.toString()
  }

  override fun getJsonTypeId(): String {
    return this::class.simpleName!!
  }
}

data class LongValue(override val value: Long): PropertyValue() {
  override fun asJsonValue(): String {
    return value.toString()
  }

  override fun getJsonTypeId(): String {
    return this::class.simpleName!!
  }

}

data class DoubleValue(override val value: Double): PropertyValue() {
  override fun asJsonValue(): String {
    return value.toString()
  }

  override fun getJsonTypeId(): String {
    return this::class.simpleName!!
  }
}

data class FloatValue(override val value: Float): PropertyValue() {
  override fun asJsonValue(): String {
    return value.toString()
  }

  override fun getJsonTypeId(): String {
    return this::class.simpleName!!
  }
}


private fun String.asJsonString(): String {
  return this
}

