/*
 * Decompiled with CFR 0.152.
 */
package ch.weetech.validator;

import ch.weetech.validator.Validator;

public class EmailValidator
extends Validator<String> {
    private static final String specialsNoDotNoAt = "()<>,;:\\\"[]";
    private static final String specialsNoDot = "()<>,;:\\\"[]@";

    @Override
    public boolean isValid(String v) {
        if (v == null || v.isEmpty()) {
            return false;
        }
        if (v.length() >= 320) {
            return false;
        }
        try {
            EmailValidator.checkAddress(v, true, true);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return true;
    }

    private static void checkAddress(String addr, boolean routeAddr, boolean validate) throws IllegalArgumentException {
        int i;
        int start = 0;
        if (addr == null) {
            throw new IllegalArgumentException("Address is null");
        }
        int len = addr.length();
        if (len == 0) {
            throw new IllegalArgumentException("Empty address" + addr);
        }
        if (routeAddr && addr.charAt(0) == '@') {
            start = 0;
            while ((i = EmailValidator.indexOfAny(addr, ",:", start)) >= 0) {
                if (addr.charAt(start) != '@') {
                    throw new IllegalArgumentException("Illegal route-addr" + addr);
                }
                if (addr.charAt(i) == ':') {
                    start = i + 1;
                    break;
                }
                start = i + 1;
            }
        }
        char c = '\uffff';
        char lastc = '\uffff';
        boolean inquote = false;
        for (i = start; i < len; ++i) {
            lastc = c;
            c = addr.charAt(i);
            if (c == 92 || lastc == '\\') continue;
            if (c == '\"') {
                if (inquote) {
                    if (validate && i + 1 < len && addr.charAt(i + 1) != '@') {
                        throw new IllegalArgumentException("Quote not at end of local address " + addr);
                    }
                    inquote = false;
                    continue;
                }
                if (validate && i != 0) {
                    throw new IllegalArgumentException("Quote not at start of local address" + addr);
                }
                inquote = true;
                continue;
            }
            if (c == '\r') {
                if (i + 1 < len && addr.charAt(i + 1) != '\n') {
                    throw new IllegalArgumentException("Quoted local address contains CR without LF" + addr);
                }
            } else if (c == '\n' && i + 1 < len && addr.charAt(i + 1) != ' ' && addr.charAt(i + 1) != '\t') {
                throw new IllegalArgumentException("Quoted local address contains newline without whitespace" + addr);
            }
            if (inquote) continue;
            if (c == '.') {
                if (i == start) {
                    throw new IllegalArgumentException("Local address starts with dot" + addr);
                }
                if (lastc == '.') {
                    throw new IllegalArgumentException("Local address contains dot-dot" + addr);
                }
            }
            if (c == '@') {
                if (i == 0) {
                    throw new IllegalArgumentException("Missing local name" + addr);
                }
                if (lastc != 46) break;
                throw new IllegalArgumentException("Local address ends with dot" + addr);
            }
            if (c <= ' ' || c == '\u007f') {
                throw new IllegalArgumentException("Local address contains control or whitespace" + addr);
            }
            if (specialsNoDot.indexOf(c) < 0) continue;
            throw new IllegalArgumentException("Local address contains illegal character" + addr);
        }
        if (inquote) {
            throw new IllegalArgumentException("Unterminated quote" + addr);
        }
        if (c != '@') {
            if (validate) {
                throw new IllegalArgumentException("Missing final '@domain'" + addr);
            }
            return;
        }
        start = i + 1;
        if (start >= len) {
            throw new IllegalArgumentException("Missing domain" + addr);
        }
        if (addr.charAt(start) == '.') {
            throw new IllegalArgumentException("Domain starts with dot" + addr);
        }
        boolean inliteral = false;
        for (i = start; i < len; ++i) {
            c = addr.charAt(i);
            if (c == '[') {
                if (i != start) {
                    throw new IllegalArgumentException("Domain literal not at start of domain" + addr);
                }
                inliteral = true;
            } else if (c == ']') {
                if (i != len - 1) {
                    throw new IllegalArgumentException("Domain literal end not at end of domain" + addr);
                }
                inliteral = false;
            } else {
                if (c <= ' ' || c == '\u007f') {
                    throw new IllegalArgumentException("Domain contains control or whitespace" + addr);
                }
                if (!inliteral) {
                    if (!Character.isLetterOrDigit(c) && c != '-' && c != '.') {
                        throw new IllegalArgumentException("Domain contains illegal character" + addr);
                    }
                    if (c == '.' && lastc == '.') {
                        throw new IllegalArgumentException("Domain contains dot-dot" + addr);
                    }
                }
            }
            lastc = c;
        }
        if (lastc == '.') {
            throw new IllegalArgumentException("Domain ends with dot" + addr);
        }
    }

    private static int indexOfAny(String s, String any) {
        return EmailValidator.indexOfAny(s, any, 0);
    }

    private static int indexOfAny(String s, String any, int start) {
        try {
            int len = s.length();
            for (int i = start; i < len; ++i) {
                if (any.indexOf(s.charAt(i)) < 0) continue;
                return i;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException e) {
            return -1;
        }
    }
}

