/*
 * Decompiled with CFR 0.152.
 */
package ch.weetech.alert;

import ch.weetech.alert.Email;
import ch.weetech.alert.EmailAddress;
import ch.weetech.alert.EmailAttachment;
import ch.weetech.alert.EmailBody;
import ch.weetech.alert.SMTP;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EmailApp {
    public static boolean sendText(EmailAddress from, List<EmailAddress> recipients, List<EmailAddress> cc, List<EmailAddress> bcc, String subject, EmailBody body, List<EmailAttachment> attachments, final SMTP smtp, boolean debug) throws AddressException, MessagingException, UnsupportedEncodingException {
        assert (smtp != null);
        assert (recipients != null);
        assert (recipients.size() > 0);
        Properties prop = System.getProperties();
        prop.put("mail.smtp.host", smtp.getSmtpHost());
        prop.put("mail.smtp.port", (Object)smtp.getSmtpPort());
        if (debug) {
            prop.put("mail.debug", "true");
        }
        Session session = null;
        if (smtp.isSmtpAuth()) {
            prop.put("mail.smtp.auth", (Object)smtp.isSmtpAuth());
            prop.put("mail.smtp.starttls.enable", (Object)smtp.isSmtpStartTlsEnable());
            session = Session.getDefaultInstance((Properties)prop, (Authenticator)new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    String username = smtp.getSmtpUsername();
                    String password = smtp.getSmtpPassword();
                    return new PasswordAuthentication(username, password);
                }
            });
        } else {
            session = Session.getInstance((Properties)prop, null);
        }
        MimeMessage msg = new MimeMessage(session);
        if (from.getName() != null) {
            msg.setFrom((Address)new InternetAddress(from.getAddress(), from.getName(), StandardCharsets.UTF_8.name()));
        } else {
            msg.setFrom((Address)new InternetAddress(from.getAddress()));
        }
        msg.addRecipients(Message.RecipientType.TO, (Address[])recipients.stream().map(r -> {
            try {
                if (r.getName() != null) {
                    return new InternetAddress(r.getAddress(), r.getName(), StandardCharsets.UTF_8.name());
                }
                return new InternetAddress(r.getAddress());
            }
            catch (UnsupportedEncodingException | AddressException throwable) {
                return null;
            }
        }).toArray(InternetAddress[]::new));
        if (cc != null) {
            msg.addRecipients(Message.RecipientType.CC, (Address[])cc.stream().map(ccc -> {
                try {
                    if (ccc.getName() != null) {
                        return new InternetAddress(ccc.getAddress(), ccc.getName(), StandardCharsets.UTF_8.name());
                    }
                    return new InternetAddress(ccc.getAddress());
                }
                catch (UnsupportedEncodingException | AddressException throwable) {
                    return null;
                }
            }).toArray(InternetAddress[]::new));
        }
        if (bcc != null) {
            msg.addRecipients(Message.RecipientType.BCC, (Address[])bcc.stream().map(bccc -> {
                try {
                    if (bccc.getName() != null) {
                        return new InternetAddress(bccc.getAddress(), bccc.getName(), StandardCharsets.UTF_8.name());
                    }
                    return new InternetAddress(bccc.getAddress());
                }
                catch (UnsupportedEncodingException | AddressException throwable) {
                    return null;
                }
            }).toArray(InternetAddress[]::new));
        }
        if (attachments != null) {
            MimeMultipart altAndAtt = new MimeMultipart(Email.Type.mixed.toString());
            MimeBodyPart plain = new MimeBodyPart();
            plain.setContent((Object)body.getContent(), body.getContent());
            altAndAtt.addBodyPart((BodyPart)plain);
            for (EmailAttachment ea : attachments) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                try {
                    if ("text/plain".equals(ea.getContentType())) {
                        messageBodyPart.setText(ea.getContent());
                        messageBodyPart.setFileName(ea.getName());
                    } else {
                        messageBodyPart.attachFile(ea.getFile());
                        messageBodyPart.setFileName(ea.getName());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                altAndAtt.addBodyPart((BodyPart)messageBodyPart);
            }
            msg.setContent((Multipart)altAndAtt);
        } else {
            msg.setSubject(subject);
            msg.setText(body.getContent());
        }
        try (Transport t = session.getTransport();){
            t.connect();
            t.sendMessage((Message)msg, msg.getAllRecipients());
        }
        return true;
    }

    public static boolean sendHtml(EmailAddress from, List<EmailAddress> recipients, List<EmailAddress> cc, List<EmailAddress> bcc, String subject, EmailBody msgHtml, List<EmailAttachment> attachments, final SMTP smtp, boolean debug) throws AddressException, MessagingException, UnsupportedEncodingException {
        MimeBodyPart html;
        assert (smtp != null);
        assert (recipients != null);
        assert (recipients.size() > 0);
        Properties prop = System.getProperties();
        prop.put("mail.smtp.host", smtp.getSmtpHost());
        prop.put("mail.smtp.port", (Object)smtp.getSmtpPort());
        if (debug) {
            prop.put("mail.debug", "true");
        }
        Session session = null;
        if (smtp.isSmtpAuth()) {
            prop.put("mail.smtp.auth", (Object)smtp.isSmtpAuth());
            prop.put("mail.smtp.starttls.enable", (Object)smtp.isSmtpStartTlsEnable());
            session = Session.getDefaultInstance((Properties)prop, (Authenticator)new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    String username = smtp.getSmtpUsername();
                    String password = smtp.getSmtpPassword();
                    return new PasswordAuthentication(username, password);
                }
            });
        } else {
            session = Session.getInstance((Properties)prop, null);
        }
        MimeMessage msg = new MimeMessage(session);
        if (from.getName() != null) {
            msg.setFrom((Address)new InternetAddress(from.getAddress(), from.getName(), StandardCharsets.UTF_8.name()));
        } else {
            msg.setFrom((Address)new InternetAddress(from.getAddress()));
        }
        msg.addRecipients(Message.RecipientType.TO, (Address[])recipients.stream().map(r -> {
            try {
                if (r.getName() != null) {
                    return new InternetAddress(r.getAddress(), r.getName(), StandardCharsets.UTF_8.name());
                }
                return new InternetAddress(r.getAddress());
            }
            catch (UnsupportedEncodingException | AddressException throwable) {
                return null;
            }
        }).toArray(InternetAddress[]::new));
        if (cc != null) {
            msg.addRecipients(Message.RecipientType.CC, (Address[])cc.stream().map(ccc -> {
                try {
                    if (ccc.getName() != null) {
                        return new InternetAddress(ccc.getAddress(), ccc.getName(), StandardCharsets.UTF_8.name());
                    }
                    return new InternetAddress(ccc.getAddress());
                }
                catch (UnsupportedEncodingException | AddressException throwable) {
                    return null;
                }
            }).toArray(InternetAddress[]::new));
        }
        if (bcc != null) {
            msg.addRecipients(Message.RecipientType.BCC, (Address[])bcc.stream().map(bccc -> {
                try {
                    if (bccc.getName() != null) {
                        return new InternetAddress(bccc.getAddress(), bccc.getName(), StandardCharsets.UTF_8.name());
                    }
                    return new InternetAddress(bccc.getAddress());
                }
                catch (UnsupportedEncodingException | AddressException throwable) {
                    return null;
                }
            }).toArray(InternetAddress[]::new));
        }
        msg.setSubject(subject, "UTF-8");
        if (attachments != null) {
            MimeMultipart altAndAtt = new MimeMultipart(Email.Type.mixed.toString());
            html = new MimeBodyPart();
            html.setContent((Object)msgHtml.getContent(), msgHtml.getContentType());
            altAndAtt.addBodyPart((BodyPart)html);
            for (EmailAttachment ea : attachments) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                try {
                    if ("text/plain".equals(ea.getContentType())) {
                        messageBodyPart.setText(ea.getContent());
                        messageBodyPart.setFileName(ea.getName());
                    } else {
                        messageBodyPart.attachFile(ea.getFile());
                        messageBodyPart.setFileName(ea.getName());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                altAndAtt.addBodyPart((BodyPart)messageBodyPart);
            }
            msg.setContent((Multipart)altAndAtt);
        } else {
            MimeMultipart content = new MimeMultipart("alternative");
            html = new MimeBodyPart();
            html.setContent((Object)msgHtml.getContent(), msgHtml.getContentType());
            html.setHeader("Content-Transfer-Encoding", "8bit");
            content.addBodyPart((BodyPart)html);
            msg.setContent((Object)content, "UTF-8");
        }
        try (Transport t = session.getTransport();){
            t.connect();
            t.sendMessage((Message)msg, msg.getAllRecipients());
        }
        return true;
    }

    public static boolean sendTextAndHtml(EmailAddress from, List<EmailAddress> recipients, List<EmailAddress> cc, List<EmailAddress> bcc, String subject, EmailBody msgText, EmailBody msgHtml, List<EmailAttachment> attachments, final SMTP smtp, boolean debug) throws AddressException, MessagingException, UnsupportedEncodingException {
        assert (smtp != null);
        assert (recipients != null);
        assert (recipients.size() > 0);
        Properties prop = System.getProperties();
        prop.put("mail.smtp.host", smtp.getSmtpHost());
        prop.put("mail.smtp.port", (Object)smtp.getSmtpPort());
        if (debug) {
            prop.put("mail.debug", "true");
        }
        Session session = null;
        if (smtp.isSmtpAuth()) {
            prop.put("mail.smtp.auth", (Object)smtp.isSmtpAuth());
            prop.put("mail.smtp.starttls.enable", (Object)smtp.isSmtpStartTlsEnable());
            session = Session.getDefaultInstance((Properties)prop, (Authenticator)new Authenticator(){

                public PasswordAuthentication getPasswordAuthentication() {
                    String username = smtp.getSmtpUsername();
                    String password = smtp.getSmtpPassword();
                    return new PasswordAuthentication(username, password);
                }
            });
        } else {
            session = Session.getInstance((Properties)prop, null);
        }
        MimeMessage msg = new MimeMessage(session);
        if (from.getName() != null) {
            msg.setFrom((Address)new InternetAddress(from.getAddress(), from.getName(), StandardCharsets.UTF_8.name()));
        } else {
            msg.setFrom((Address)new InternetAddress(from.getAddress()));
        }
        msg.addRecipients(Message.RecipientType.TO, (Address[])recipients.stream().map(r -> {
            try {
                if (r.getName() != null) {
                    return new InternetAddress(r.getAddress(), r.getName(), StandardCharsets.UTF_8.name());
                }
                return new InternetAddress(r.getAddress());
            }
            catch (UnsupportedEncodingException | AddressException throwable) {
                return null;
            }
        }).toArray(InternetAddress[]::new));
        if (cc != null) {
            msg.addRecipients(Message.RecipientType.CC, (Address[])cc.stream().map(ccc -> {
                try {
                    if (ccc.getName() != null) {
                        return new InternetAddress(ccc.getAddress(), ccc.getName(), StandardCharsets.UTF_8.name());
                    }
                    return new InternetAddress(ccc.getAddress());
                }
                catch (UnsupportedEncodingException | AddressException throwable) {
                    return null;
                }
            }).toArray(InternetAddress[]::new));
        }
        if (bcc != null) {
            msg.addRecipients(Message.RecipientType.BCC, (Address[])bcc.stream().map(bccc -> {
                try {
                    if (bccc.getName() != null) {
                        return new InternetAddress(bccc.getAddress(), bccc.getName(), StandardCharsets.UTF_8.name());
                    }
                    return new InternetAddress(bccc.getAddress());
                }
                catch (UnsupportedEncodingException | AddressException throwable) {
                    return null;
                }
            }).toArray(InternetAddress[]::new));
        }
        msg.setSubject(subject, "UTF-8");
        if (attachments != null) {
            MimeMultipart altAndAtt = new MimeMultipart(Email.Type.mixed.toString());
            MimeMultipart plainAndHtml = new MimeMultipart("alternative");
            MimeBodyPart plain = new MimeBodyPart();
            plain.setContent((Object)msgText, "text/plain; charset=utf-8");
            plainAndHtml.addBodyPart((BodyPart)plain);
            MimeBodyPart html = new MimeBodyPart();
            html.setContent((Object)msgHtml, "text/html; charset=utf-8");
            plainAndHtml.addBodyPart((BodyPart)html);
            MimeBodyPart wrapper = new MimeBodyPart();
            wrapper.setContent((Multipart)plainAndHtml);
            altAndAtt.addBodyPart((BodyPart)wrapper);
            for (EmailAttachment ea : attachments) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                try {
                    if ("text/plain".equals(ea.getContentType())) {
                        messageBodyPart.setText(ea.getContent());
                        messageBodyPart.setFileName(ea.getName());
                    } else {
                        messageBodyPart.attachFile(ea.getFile());
                        messageBodyPart.setFileName(ea.getName());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                altAndAtt.addBodyPart((BodyPart)messageBodyPart);
            }
            msg.setContent((Multipart)altAndAtt);
        } else {
            MimeMultipart content = new MimeMultipart("alternative");
            MimeBodyPart html = new MimeBodyPart();
            html.setContent((Object)msgHtml.getContent(), msgHtml.getContentType());
            html.setHeader("Content-Transfer-Encoding", "8bit");
            content.addBodyPart((BodyPart)html);
            msg.setContent((Object)content, "UTF-8");
        }
        try (Transport t = session.getTransport();){
            t.connect();
            t.sendMessage((Message)msg, msg.getAllRecipients());
        }
        return true;
    }
}

