/*
 * Decompiled with CFR 0.152.
 */
package ch.weetech.alert;

import ch.weetech.alert.Email;

public class EmailBody
extends Email {
    private String contentType;
    private String content;

    private EmailBody(Builder builder) {
        this.contentType = builder.contentType;
        this.content = builder.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContent() {
        return this.content;
    }

    public static class Builder {
        private String contentType;
        private String content;

        public Builder(String content, String contentType) {
            this.contentType = contentType;
            this.content = content;
        }

        public EmailBody build() {
            this.validate();
            return new EmailBody(this);
        }

        private void validate() throws IllegalStateException {
            if (this.content == null) {
                throw new IllegalStateException("content must not be null");
            }
            if (this.contentType == null || this.contentType.trim().isEmpty()) {
                throw new IllegalStateException("contentType must not be null nor empty");
            }
        }
    }
}

