/*
 * Decompiled with CFR 0.152.
 */
package ch.weetech.cache;

import ch.weetech.cache.Cache;
import ch.weetech.cache.CacheElement;
import ch.weetech.cache.DoublyLinkedList;
import ch.weetech.cache.LinkedListNode;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LRUCache<K, V>
implements Cache<K, V> {
    private int size;
    private Map<K, LinkedListNode<CacheElement<K, V>>> linkedListNodeMap;
    private DoublyLinkedList<CacheElement<K, V>> doublyLinkedList;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public LRUCache(int size) {
        this.size = size;
        this.linkedListNodeMap = new ConcurrentHashMap<K, LinkedListNode<CacheElement<K, V>>>(size);
        this.doublyLinkedList = new DoublyLinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(K key, V value) {
        this.lock.writeLock().lock();
        try {
            LinkedListNode<CacheElement<K, V>> newNode;
            CacheElement<K, V> item = new CacheElement<K, V>(key, value);
            if (this.linkedListNodeMap.containsKey(key)) {
                LinkedListNode<CacheElement<K, V>> node = this.linkedListNodeMap.get(key);
                newNode = this.doublyLinkedList.updateAndMoveToFront(node, item);
            } else {
                if (this.size() >= this.size) {
                    this.evictElement();
                }
                newNode = this.doublyLinkedList.add(item);
            }
            if (newNode.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.linkedListNodeMap.put(key, newNode);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<V> get(K key) {
        this.lock.readLock().lock();
        try {
            LinkedListNode<CacheElement<K, V>> linkedListNode = this.linkedListNodeMap.get(key);
            if (linkedListNode != null && !linkedListNode.isEmpty()) {
                this.linkedListNodeMap.put(key, this.doublyLinkedList.moveToFront(linkedListNode));
                Optional<V> optional = Optional.of(linkedListNode.getElement().getValue());
                return optional;
            }
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.doublyLinkedList.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.linkedListNodeMap.clear();
            this.doublyLinkedList.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean evictElement() {
        this.lock.writeLock().lock();
        try {
            LinkedListNode<CacheElement<K, V>> linkedListNode = this.doublyLinkedList.removeTail();
            if (linkedListNode.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.linkedListNodeMap.remove(linkedListNode.getElement().getKey());
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

