/*
 * Decompiled with CFR 0.152.
 */
package ch.weetech.database;

import ch.weetech.database.Jdbc;
import ch.weetech.database.RStoListMap;
import ch.weetech.database.Result;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseManager
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseManager.class);
    private Connection con;
    private String username;
    private String password;
    private String url;

    public DatabaseManager(String username, String password, String url) {
        this.username = username;
        this.password = password;
        this.url = url;
    }

    public void init() throws Exception {
        this.con = Jdbc.getConnection(this.url, this.username, this.password);
    }

    public void shutdown() {
        try {
            logger.info("releasing database connection");
            this.con.close();
        }
        catch (SQLException e) {
            logger.info("", (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Result execute(String query) {
        Result res = new Result();
        try (Statement stmt = this.con.createStatement();){
            Result result;
            block14: {
                ResultSet results = stmt.executeQuery(query);
                try {
                    List<Map<String, String>> dbRes = RStoListMap.toMapList(results);
                    res.setResultsList(dbRes);
                    res.setSuccess(true);
                    result = res;
                    if (results == null) break block14;
                }
                catch (Throwable throwable) {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                results.close();
            }
            return result;
        }
        catch (SQLException e) {
            logger.error("unable to execute query", (Throwable)e);
            return res;
        }
    }
}

