/*
 * Decompiled with CFR 0.152.
 */
package ch.weetech.network;

import java.net.InetAddress;

public class IP {
    public static final boolean isIpInSubnet(String ip, String net, int prefix) {
        try {
            int p;
            byte[] ipBin = InetAddress.getByName(ip).getAddress();
            byte[] netBin = InetAddress.getByName(net).getAddress();
            if (ipBin.length != netBin.length) {
                return false;
            }
            int i = 0;
            for (p = prefix; p >= 8; p -= 8) {
                if (ipBin[i] != netBin[i]) {
                    return false;
                }
                ++i;
            }
            int m = 65280 >> p & 0xFF;
            return (ipBin[i] & m) == (netBin[i] & m);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static final boolean isIpInSubnet(String ip, String net, String mask) {
        try {
            byte[] ipBin = InetAddress.getByName(ip).getAddress();
            byte[] netBin = InetAddress.getByName(net).getAddress();
            byte[] maskBin = InetAddress.getByName(mask).getAddress();
            if (ipBin.length != netBin.length) {
                return false;
            }
            if (netBin.length != maskBin.length) {
                return false;
            }
            for (int i = 0; i < ipBin.length; ++i) {
                if ((ipBin[i] & maskBin[i]) == (netBin[i] & maskBin[i])) continue;
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

