/*
 * Decompiled with CFR 0.152.
 */
package ch.weetech.alert;

import ch.weetech.alert.Email;

public class EmailAddress
extends Email {
    private String address;
    private String name;

    private EmailAddress(Builder builder) {
        this.address = builder.address;
        this.name = builder.name;
    }

    public String getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public static class Builder {
        private String address;
        private String name;

        public Builder(String address) {
            this.address = address;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public EmailAddress build() {
            this.validate();
            return new EmailAddress(this);
        }

        private void validate() throws IllegalStateException {
            if (this.address == null || this.address.trim().isEmpty()) {
                throw new IllegalStateException("address must not be null nor empty");
            }
            if (!Email.isValidEmail(this.address)) {
                throw new IllegalStateException("invalid email address");
            }
        }
    }
}

