/*
 * Decompiled with CFR 0.152.
 */
package ch.weetech.cache;

import ch.weetech.cache.DummyNode;
import ch.weetech.cache.LinkedListNode;
import ch.weetech.cache.Node;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DoublyLinkedList<T> {
    private DummyNode<T> dummyNode;
    private LinkedListNode<T> head;
    private LinkedListNode<T> tail;
    private AtomicInteger size;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public DoublyLinkedList() {
        this.dummyNode = new DummyNode(this);
        this.clear();
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.head = this.dummyNode;
            this.tail = this.dummyNode;
            this.size = new AtomicInteger(0);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.size.get();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.head.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean contains(T value) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.search(value).hasElement();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public LinkedListNode<T> search(T value) {
        this.lock.readLock().lock();
        try {
            LinkedListNode<T> linkedListNode = this.head.search(value);
            return linkedListNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public LinkedListNode<T> add(T value) {
        this.lock.writeLock().lock();
        try {
            this.head = new Node<T>(value, this.head, this);
            if (this.tail.isEmpty()) {
                this.tail = this.head;
            }
            this.size.incrementAndGet();
            LinkedListNode<T> linkedListNode = this.head;
            return linkedListNode;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection<T> values) {
        this.lock.writeLock().lock();
        try {
            for (T value : values) {
                if (!this.add(value).isEmpty()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedListNode<T> remove(T value) {
        this.lock.writeLock().lock();
        try {
            LinkedListNode<T> linkedListNode = this.head.search(value);
            if (!linkedListNode.isEmpty()) {
                if (linkedListNode == this.tail) {
                    this.tail = this.tail.getPrev();
                }
                if (linkedListNode == this.head) {
                    this.head = this.head.getNext();
                }
                linkedListNode.detach();
                this.size.decrementAndGet();
            }
            LinkedListNode<T> linkedListNode2 = linkedListNode;
            return linkedListNode2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public LinkedListNode<T> removeTail() {
        this.lock.writeLock().lock();
        try {
            LinkedListNode<T> oldTail = this.tail;
            if (oldTail == this.head) {
                this.head = this.dummyNode;
                this.tail = this.head;
            } else {
                this.tail = this.tail.getPrev();
                oldTail.detach();
            }
            if (!oldTail.isEmpty()) {
                this.size.decrementAndGet();
            }
            LinkedListNode<T> linkedListNode = oldTail;
            return linkedListNode;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public LinkedListNode<T> moveToFront(LinkedListNode<T> node) {
        return node.isEmpty() ? this.dummyNode : this.updateAndMoveToFront(node, node.getElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedListNode<T> updateAndMoveToFront(LinkedListNode<T> node, T newValue) {
        this.lock.writeLock().lock();
        try {
            if (node.isEmpty() || this != node.getListReference()) {
                DummyNode<T> dummyNode = this.dummyNode;
                return dummyNode;
            }
            this.detach(node);
            this.add(newValue);
            LinkedListNode<T> linkedListNode = this.head;
            return linkedListNode;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void detach(LinkedListNode<T> node) {
        if (node != this.tail) {
            node.detach();
            if (node == this.head) {
                this.head = this.head.getNext();
            }
            this.size.decrementAndGet();
        } else {
            this.removeTail();
        }
    }
}

