/*
 * Decompiled with CFR 0.152.
 */
package ch.welld.kie;

import ch.welld.kie.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTDRLPersistence;
import org.drools.workbench.models.guided.dtable.backend.GuidedDTXMLPersistence;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;

public class DroolsConverter {
    private static String convertGdstFileToDrlString(File gdstFile) throws IOException {
        String decisionTableXml = new String(Files.readAllBytes(gdstFile.toPath()));
        GuidedDecisionTable52 model = GuidedDTXMLPersistence.getInstance().unmarshal(decisionTableXml);
        return GuidedDTDRLPersistence.getInstance().marshal(model);
    }

    private static File convertGdst(File sourceFile, Path destinationPath, boolean overwriteFile) throws IOException {
        String drlString = DroolsConverter.convertGdstFileToDrlString(sourceFile);
        FileUtils.createDirectoryIfNotExists(destinationPath);
        File targetFile = new File(destinationPath.toFile(), sourceFile.getName().replace(".gdst", ".drl"));
        if (overwriteFile || !targetFile.exists()) {
            Files.write(targetFile.toPath(), drlString.getBytes(), new OpenOption[0]);
        }
        return targetFile;
    }

    public static File copyKnowledge(File sourceFile, Path destinationPath, boolean overwriteFile) throws IOException {
        String ext;
        switch (ext = sourceFile.getName().substring(sourceFile.getName().lastIndexOf("."))) {
            case ".gdst": {
                return DroolsConverter.convertGdst(sourceFile, destinationPath, overwriteFile);
            }
            case ".drl": {
                return FileUtils.copyFile(sourceFile, destinationPath.resolve(sourceFile.getName()), overwriteFile);
            }
        }
        throw new IOException("Cannot convert file with extension " + ext);
    }
}

