/*
 * Decompiled with CFR 0.152.
 */
package ch.welld.kie;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileUtils {
    public static void createDirectoryIfNotExists(Path directoryPath) {
        File directory = directoryPath.toFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    public static List<Path> findAllFilesWithExtensions(File directory, Set<String> extensions) throws IOException {
        try (Stream<Path> walk = Files.walk(directory.toPath(), new FileVisitOption[0]);){
            List<Path> list = walk.filter(s -> extensions.stream().anyMatch(ext -> s.toString().endsWith((String)ext))).collect(Collectors.toList());
            return list;
        }
    }

    public static File copyFile(File source, Path destinationPath, boolean overwriteFile) throws IOException {
        FileUtils.createDirectoryIfNotExists(destinationPath);
        if (overwriteFile) {
            Files.copy(source.toPath(), destinationPath, StandardCopyOption.REPLACE_EXISTING);
        } else {
            Files.copy(source.toPath(), destinationPath, new CopyOption[0]);
        }
        return destinationPath.toFile();
    }
}

