/*
 * Decompiled with CFR 0.152.
 */
package ch.welld.kie;

import ch.welld.kie.FileUtils;
import ch.welld.kie.format.KnowledgeFormatConverter;
import ch.welld.kie.format.KnowledgeFormatConverterFactory;
import ch.welld.kie.format.UnsupportedKnowledgeFormatException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;

public class DroolsConverter {
    public static Set<String> getSupportedFormats() {
        return KnowledgeFormatConverterFactory.getSupportedFormats();
    }

    public static File convertKnowledgeFile(File sourceFile, Path destinationPath, boolean overwriteFile) throws IOException, UnsupportedKnowledgeFormatException {
        String extension = sourceFile.getName().substring(sourceFile.getName().lastIndexOf(46));
        KnowledgeFormatConverter converter = KnowledgeFormatConverterFactory.getConverter(extension).orElseThrow(() -> new UnsupportedKnowledgeFormatException(sourceFile));
        String drlString = converter.convertToDrl(sourceFile);
        String fileName = sourceFile.getName().replaceAll(String.format("%s$", converter.supportedFormat()), ".drl");
        return FileUtils.createFile(drlString, fileName, destinationPath, overwriteFile);
    }
}

