/*
 * Decompiled with CFR 0.152.
 */
package ch.welld.kie;

import ch.welld.kie.DroolsConverter;
import ch.welld.kie.FileUtils;
import ch.welld.kie.format.UnsupportedKnowledgeFormatException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="convert-knowledge", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class KnowledgeConverterMojo
extends AbstractMojo {
    @Parameter(property="outputDirectory", required=true)
    private File outputDirectory;
    @Parameter(property="inputDirectory", required=true)
    private File inputDirectory;
    @Parameter(defaultValue="false", property="overwriteFiles")
    private boolean overwriteFiles;

    private void logParameters() {
        this.getLog().info((CharSequence)"--- PARAMETERS ---");
        this.getLog().info((CharSequence)("Output directory: " + this.outputDirectory));
        this.getLog().info((CharSequence)("Input directory: " + this.inputDirectory));
        this.getLog().info((CharSequence)"--- ---------- ---");
    }

    private void convertToDrlAndCopy(Path knowledgeFilePath, Path destinationPath, boolean overwriteFiles) {
        try {
            this.getLog().debug((CharSequence)("Copying file " + knowledgeFilePath));
            DroolsConverter.convertKnowledgeFile(knowledgeFilePath.toFile(), destinationPath, overwriteFiles);
        }
        catch (UnsupportedKnowledgeFormatException | IOException ex) {
            this.getLog().error((CharSequence)("Cannot convert file " + knowledgeFilePath.toString()));
        }
    }

    public void execute() {
        this.logParameters();
        Path inputDirectoryPath = this.inputDirectory.toPath();
        Path outputDirectoryPath = this.outputDirectory.toPath();
        FileUtils.createDirectoryIfNotExists(outputDirectoryPath);
        try {
            List<Path> knowledgeFiles = FileUtils.findAllFilesWithExtensions(this.inputDirectory, DroolsConverter.getSupportedFormats());
            this.getLog().info((CharSequence)("Knowledge files found: " + knowledgeFiles.size()));
            knowledgeFiles.forEach(knowledgeFile -> this.getLog().debug((CharSequence)(" - " + knowledgeFile)));
            knowledgeFiles.forEach(knowledgeFilePath -> this.convertToDrlAndCopy((Path)knowledgeFilePath, outputDirectoryPath.resolve(inputDirectoryPath.relativize(knowledgeFilePath.getParent())), this.overwriteFiles));
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }
}

