/*
 * Decompiled with CFR 0.152.
 */
package ch.welld.kie.format;

import ch.welld.kie.format.DrlFormatConverter;
import ch.welld.kie.format.GdstFormatConverter;
import ch.welld.kie.format.KnowledgeFormatConverter;
import ch.welld.kie.format.TemplateFormatConverter;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class KnowledgeFormatConverterFactory {
    private static List<KnowledgeFormatConverter> converters = List.of(new GdstFormatConverter(), new TemplateFormatConverter(), new DrlFormatConverter());

    private KnowledgeFormatConverterFactory() {
    }

    public static Set<String> getSupportedFormats() {
        return converters.stream().map(KnowledgeFormatConverter::supportedFormat).collect(Collectors.toSet());
    }

    public static Optional<KnowledgeFormatConverter> getConverter(String format) {
        return converters.stream().filter(c -> c.supportedFormat().equals(format)).findFirst();
    }
}

