/*
 * Decompiled with CFR 0.152.
 */
package ch.zizka.junitdiff.util;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J0\u0010\n\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u001a\u0010\u0015\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lch/zizka/junitdiff/util/ZipUtil;", "", "()V", "BUFFER_SIZE", "", "TEST_XML_FILTER", "Lorg/apache/commons/io/filefilter/IOFileFilter;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "unzipFileToDir", "", "zip", "Ljava/io/File;", "intoDir", "mode", "Lch/zizka/junitdiff/util/ZipUtil$OverwriteMode;", "", "zipFile", "fileFilter", "Ljava/io/FileFilter;", "unzipFileToTempDir", "OverwriteMode", "JUnitDiff"})
@SourceDebugExtension(value={"SMAP\nZipUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipUtil.kt\nch/zizka/junitdiff/util/ZipUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class ZipUtil {
    @NotNull
    public static final ZipUtil INSTANCE = new ZipUtil();
    private static final Logger log = LoggerFactory.getLogger(ZipUtil.class);
    private static final int BUFFER_SIZE = 32768;
    private static final IOFileFilter TEST_XML_FILTER;

    private ZipUtil() {
    }

    @NotNull
    public final File unzipFileToTempDir(@Nullable File zipFile, @Nullable OverwriteMode mode) {
        File file = zipFile;
        Intrinsics.checkNotNull(file);
        Object path = file.getPath();
        String string = path;
        Intrinsics.checkNotNullExpressionValue(string, "path");
        path = StringsKt.endsWith$default(string, ".zip", false, 2, null) ? StringUtils.removeEndIgnoreCase((String)path, ".zip") : (String)path + "-";
        File tmpDir = new File((String)path);
        if (tmpDir.getParentFile().canWrite()) {
            tmpDir.mkdir();
        } else {
            File file2 = File.createTempFile("JUnitDiff-", "");
            Intrinsics.checkNotNullExpressionValue(file2, "createTempFile(\"JUnitDiff-\", \"\")");
            tmpDir = file2;
            tmpDir.delete();
        }
        tmpDir.deleteOnExit();
        this.unzipFileToDir(zipFile, tmpDir, TEST_XML_FILTER, mode);
        return tmpDir;
    }

    public final boolean unzipFileToDir(@NotNull File zip2, @NotNull File intoDir, @NotNull OverwriteMode mode) {
        Intrinsics.checkNotNullParameter(zip2, "zip");
        Intrinsics.checkNotNullParameter(intoDir, "intoDir");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        if (intoDir.exists()) {
            switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                case 1: {
                    return false;
                }
                case 2: {
                    FileUtils.deleteDirectory(intoDir);
                }
            }
        }
        ZipUtil.unzipFileToDir$default(this, zip2, intoDir, null, null, 12, null);
        return true;
    }

    @JvmOverloads
    public final void unzipFileToDir(@NotNull File zipFile, @NotNull File intoDir, @Nullable FileFilter fileFilter, @Nullable OverwriteMode mode) {
        Intrinsics.checkNotNullParameter(zipFile, "zipFile");
        Intrinsics.checkNotNullParameter(intoDir, "intoDir");
        ZipFile zip2 = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> enumeration = zip2.entries();
        Intrinsics.checkNotNull(enumeration, "null cannot be cast to non-null type java.util.Enumeration<out java.util.zip.ZipEntry>");
        Enumeration<? extends ZipEntry> entries = enumeration;
        byte[] buf = new byte[32768];
        try {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue(string, "entry.name");
                if (StringsKt.contains$default((CharSequence)string, "..", false, 2, null) || fileFilter != null && !fileFilter.accept(new File(entry.getName()))) continue;
                log.trace("  Extracting: " + entry);
                File f = new File(intoDir, entry.getName());
                if (!f.exists()) {
                    f.getParentFile().mkdirs();
                    f.createNewFile();
                }
                InputStream iStream = zip2.getInputStream(entry);
                OutputStream os = Files.newOutputStream(f.toPath(), new OpenOption[0]);
                int r = 0;
                while (true) {
                    int n;
                    int it = n = iStream.read(buf);
                    boolean bl = false;
                    r = it;
                    if (n == -1) break;
                    os.write(buf, 0, r);
                }
                os.close();
                iStream.close();
            }
        }
        catch (Exception ex) {
            log.error(" Error when unzipping " + zipFile.getPath() + ": " + ex.getMessage());
        }
    }

    public static /* synthetic */ void unzipFileToDir$default(ZipUtil zipUtil, File file, File file2, FileFilter fileFilter, OverwriteMode overwriteMode, int n, Object object) {
        if ((n & 4) != 0) {
            fileFilter = null;
        }
        if ((n & 8) != 0) {
            overwriteMode = OverwriteMode.WRITE_INTO;
        }
        zipUtil.unzipFileToDir(file, file2, fileFilter, overwriteMode);
    }

    @JvmOverloads
    public final void unzipFileToDir(@NotNull File zipFile, @NotNull File intoDir, @Nullable FileFilter fileFilter) {
        Intrinsics.checkNotNullParameter(zipFile, "zipFile");
        Intrinsics.checkNotNullParameter(intoDir, "intoDir");
        ZipUtil.unzipFileToDir$default(this, zipFile, intoDir, fileFilter, null, 8, null);
    }

    @JvmOverloads
    public final void unzipFileToDir(@NotNull File zipFile, @NotNull File intoDir) {
        Intrinsics.checkNotNullParameter(zipFile, "zipFile");
        Intrinsics.checkNotNullParameter(intoDir, "intoDir");
        ZipUtil.unzipFileToDir$default(this, zipFile, intoDir, null, null, 12, null);
    }

    static {
        IOFileFilter[] iOFileFilterArray = new IOFileFilter[]{FileFilterUtils.prefixFileFilter("TEST-"), FileFilterUtils.suffixFileFilter(".xml")};
        TEST_XML_FILTER = FileFilterUtils.and(iOFileFilterArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lch/zizka/junitdiff/util/ZipUtil$OverwriteMode;", "", "(Ljava/lang/String;I)V", "ONLY_NEW", "WRITE_INTO", "DELETE_FIRST", "JUnitDiff"})
    public static final class OverwriteMode
    extends Enum<OverwriteMode> {
        public static final /* enum */ OverwriteMode ONLY_NEW = new OverwriteMode();
        public static final /* enum */ OverwriteMode WRITE_INTO = new OverwriteMode();
        public static final /* enum */ OverwriteMode DELETE_FIRST = new OverwriteMode();
        private static final /* synthetic */ OverwriteMode[] $VALUES;

        public static OverwriteMode[] values() {
            return (OverwriteMode[])$VALUES.clone();
        }

        public static OverwriteMode valueOf(String value) {
            return Enum.valueOf(OverwriteMode.class, value);
        }

        static {
            $VALUES = overwriteModeArray = new OverwriteMode[]{OverwriteMode.ONLY_NEW, OverwriteMode.WRITE_INTO, OverwriteMode.DELETE_FIRST};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OverwriteMode.values().length];
            try {
                nArray[OverwriteMode.ONLY_NEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverwriteMode.DELETE_FIRST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

