/*
 * Decompiled with CFR 0.152.
 */
package cz.dynawest.xslt;

import cz.dynawest.xslt.MyErrorListener;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\bJ6\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0010H\u0007J\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007\u00a8\u0006\u0014"}, d2={"Lcz/dynawest/xslt/XsltTransformer;", "", "()V", "main", "", "arg", "", "", "([Ljava/lang/String;)V", "transform", "inputStream", "Ljava/io/InputStream;", "xsl", "outputFile", "Ljava/io/File;", "params", "", "inXML", "inXSL", "outTXT", "JUnitDiff"})
public final class XsltTransformer {
    @NotNull
    public static final XsltTransformer INSTANCE = new XsltTransformer();

    private XsltTransformer() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] arg) {
        Intrinsics.checkNotNullParameter(arg, "arg");
        if (arg.length != 3) {
            System.err.println("Usage: SimpleXMLTransform <input.xml> <input.xsl> <output>");
            System.exit(1);
        }
        String inXML = arg[0];
        String inXSL = arg[1];
        String outTXT = arg[2];
        try {
            INSTANCE.transform(inXML, inXSL, outTXT);
        }
        catch (TransformerConfigurationException e) {
            System.err.println("Invalid factory configuration");
            System.err.println(e);
        }
        catch (TransformerException e) {
            System.err.println("Error during transformation");
            System.err.println(e);
        }
    }

    public final void transform(@NotNull String inXML, @NotNull String inXSL, @NotNull String outTXT) throws TransformerConfigurationException, TransformerException {
        Intrinsics.checkNotNullParameter(inXML, "inXML");
        Intrinsics.checkNotNullParameter(inXSL, "inXSL");
        Intrinsics.checkNotNullParameter(outTXT, "outTXT");
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslStream = new StreamSource(inXSL);
        Transformer transformer = factory.newTransformer(xslStream);
        transformer.setErrorListener(new MyErrorListener());
        StreamSource in = new StreamSource(inXML);
        StreamResult out = new StreamResult(outTXT);
        transformer.transform(in, out);
        System.out.println((Object)("The generated HTML file is: " + outTXT));
    }

    @JvmOverloads
    public final void transform(@NotNull InputStream inputStream, @NotNull InputStream xsl, @NotNull File outputFile, @NotNull Map<String, ? extends Object> params) throws TransformerConfigurationException, TransformerException {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        Intrinsics.checkNotNullParameter(xsl, "xsl");
        Intrinsics.checkNotNullParameter(outputFile, "outputFile");
        Intrinsics.checkNotNullParameter(params, "params");
        outputFile.getParentFile().mkdirs();
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslStream = new StreamSource(xsl);
        Transformer transformer = factory.newTransformer(xslStream);
        transformer.setErrorListener(new MyErrorListener());
        StreamSource inSource = new StreamSource(inputStream);
        StreamResult outResult = new StreamResult(outputFile);
        for (Map.Entry<String, ? extends Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key == null) continue;
            transformer.setParameter(key, value);
        }
        transformer.transform(inSource, outResult);
    }

    public static /* synthetic */ void transform$default(XsltTransformer xsltTransformer, InputStream inputStream, InputStream inputStream2, File file, Map map, int n, Object object) throws TransformerConfigurationException, TransformerException {
        if ((n & 8) != 0) {
            Map map2 = Collections.emptyMap();
            Intrinsics.checkNotNullExpressionValue(map2, "emptyMap()");
            map = map2;
        }
        xsltTransformer.transform(inputStream, inputStream2, file, map);
    }

    @JvmOverloads
    public final void transform(@NotNull InputStream inputStream, @NotNull InputStream xsl, @NotNull File outputFile) throws TransformerConfigurationException, TransformerException {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        Intrinsics.checkNotNullParameter(xsl, "xsl");
        Intrinsics.checkNotNullParameter(outputFile, "outputFile");
        XsltTransformer.transform$default(this, inputStream, xsl, outputFile, null, 8, null);
    }
}

