/*
 * Decompiled with CFR 0.152.
 */
package ch.zizka.junitdiff;

import ch.zizka.junitdiff.util.FileUtil;
import ch.zizka.junitdiff.util.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0010J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lch/zizka/junitdiff/InputPreparation;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "downloadAndUnzipUrls", "", "paths", "", "", "downloadUrlToTempFile", "Ljava/io/File;", "urlStr", "downloadZipAndExtractToTempDir", "preprocessPaths", "", "reportFiles", "readListOfPaths", "path", "scanDirForJUnitReports", "UpperCasePrefixFilter", "JUnitDiff"})
@SourceDebugExtension(value={"SMAP\nInputPreparation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputPreparation.kt\nch/zizka/junitdiff/InputPreparation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class InputPreparation {
    @NotNull
    public static final InputPreparation INSTANCE = new InputPreparation();
    private static final Logger log = LoggerFactory.getLogger(InputPreparation.class);

    private InputPreparation() {
    }

    @NotNull
    public final List<File> preprocessPaths(@NotNull List<? extends File> reportFiles) {
        Intrinsics.checkNotNullParameter(reportFiles, (String)"reportFiles");
        List expandedPaths = new LinkedList();
        for (File file : reportFiles) {
            File path2 = file;
            if (path2.isFile()) {
                String string = path2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path2.name");
                if (StringsKt.endsWith$default((String)string, (String)".zip", (boolean)false, (int)2, null)) {
                    try {
                        path2 = ZipUtil.INSTANCE.unzipFileToTempDir(path2, ZipUtil.OverwriteMode.DELETE_FIRST);
                    }
                    catch (IOException ex) {
                        log.error("Can't unzip " + path2 + ": " + ex);
                    }
                } else {
                    String string2 = path2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path2.name");
                    if (StringsKt.endsWith$default((String)string2, (String)".xml", (boolean)false, (int)2, null)) {
                        expandedPaths.add(path2);
                    } else {
                        expandedPaths.addAll((Collection)this.readListOfPaths(path2));
                    }
                }
            }
            if (!path2.isDirectory()) continue;
            expandedPaths.addAll((Collection)this.scanDirForJUnitReports(path2));
        }
        return expandedPaths;
    }

    public final void downloadAndUnzipUrls(@NotNull List<String> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        int n = paths.size();
        for (int i = 0; i < n; ++i) {
            String path = paths.get(i);
            if (!StringsKt.startsWith$default((String)path, (String)"http://", (boolean)false, (int)2, null)) continue;
            try {
                File file;
                File resultDir = null;
                if (StringsKt.endsWith$default((String)path, (String)".zip", (boolean)false, (int)2, null)) {
                    file = this.downloadZipAndExtractToTempDir(path);
                } else if (StringsKt.endsWith$default((String)path, (String)".xml", (boolean)false, (int)2, null)) {
                    file = this.downloadUrlToTempFile(path);
                } else {
                    log.warn("  URL is not .zip nor .xml - skipping: " + path);
                    continue;
                }
                File file2 = resultDir = file;
                Intrinsics.checkNotNull((Object)file2);
                String string = file2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultDir!!.path");
                paths.set(i, string);
                continue;
            }
            catch (IOException ex) {
                log.warn("  Error when processing URL " + path + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private final File downloadZipAndExtractToTempDir(String urlStr) {
        File tmpFile = this.downloadUrlToTempFile(urlStr);
        File dirWithZipContent = ZipUtil.INSTANCE.unzipFileToTempDir(tmpFile, ZipUtil.OverwriteMode.DELETE_FIRST);
        tmpFile.delete();
        return dirWithZipContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File downloadUrlToTempFile(String urlStr) {
        URL url = new URL(urlStr);
        File downloadToFile = File.createTempFile("JUnitDiff-tmp-", ".zip");
        Path path = downloadToFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"downloadToFile.toPath()");
        Object object = path;
        Object object2 = new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING};
        OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(this, *options)");
        object = outputStream;
        object2 = null;
        try {
            OutputStream os22 = (OutputStream)object;
            boolean bl = false;
            long os22 = url.openStream().transferTo(os22);
        }
        catch (Throwable os22) {
            object2 = os22;
            throw os22;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Object it = object2 = downloadToFile;
        boolean bl = false;
        ((File)it).deleteOnExit();
        Object object3 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"downloadToFile.also { it.deleteOnExit() }");
        return object3;
    }

    private final List<File> readListOfPaths(File path) {
        List list;
        try {
            if (FileUtil.INSTANCE.isBinaryFile(path)) {
                log.warn("  Can't read list of paths from a binary file: " + path.getPath());
                return CollectionsKt.emptyList();
            }
            List lines = FileUtils.readLines((File)path, (Charset)StandardCharsets.UTF_8);
            List paths = new ArrayList(lines.size());
            for (String line : lines) {
                File f = new File(line);
                if (!f.exists()) {
                    log.warn("  Does not exist: " + f.getPath());
                    continue;
                }
                if (!f.isFile()) {
                    log.warn("  Not a regular file: " + f.getPath());
                    continue;
                }
                paths.add(f);
            }
            list = paths;
        }
        catch (IOException ex) {
            log.warn("Error reading " + path.getPath() + " : " + ex.getMessage());
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<File> scanDirForJUnitReports(File path) {
        Object object = new IOFileFilter[2];
        object[0] = FileFilterUtils.directoryFileFilter();
        IOFileFilter[] iOFileFilterArray = new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)".xml"), UpperCasePrefixFilter.INSTANCE, FileFilterUtils.magicNumberFileFilter((String)"<?xml")};
        object[1] = FileFilterUtils.and((IOFileFilter[])iOFileFilterArray);
        IOFileFilter rigidFilter = FileFilterUtils.or((IOFileFilter[])object);
        try {
            LinkedList<File> resultList = new LinkedList<File>();
            new DirectoryWalker<File>(rigidFilter, path){
                final /* synthetic */ File $path;
                {
                    this.$path = $path;
                    super((FileFilter)$rigidFilter, -1);
                }

                protected void handleFile(@NotNull File file, int depth, @NotNull Collection<File> results) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter(results, (String)"results");
                    results.add(file);
                }

                protected boolean handleDirectory(@NotNull File directory, int depth, @NotNull Collection<? extends File> results) {
                    Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                    Intrinsics.checkNotNullParameter(results, (String)"results");
                    return true;
                }

                public final void doWalk(@NotNull LinkedList<File> list) {
                    Intrinsics.checkNotNullParameter(list, (String)"list");
                    this.walk(this.$path, list);
                }
            }.doWalk(resultList);
            object = CollectionsKt.filterNotNull((Iterable)resultList);
        }
        catch (IOException ex) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016j\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lch/zizka/junitdiff/InputPreparation$UpperCasePrefixFilter;", "", "Lorg/apache/commons/io/filefilter/IOFileFilter;", "(Ljava/lang/String;I)V", "accept", "", "file", "Ljava/io/File;", "s", "", "INSTANCE", "JUnitDiff"})
    public static final class UpperCasePrefixFilter
    extends Enum<UpperCasePrefixFilter>
    implements IOFileFilter {
        public static final /* enum */ UpperCasePrefixFilter INSTANCE = new UpperCasePrefixFilter();
        private static final /* synthetic */ UpperCasePrefixFilter[] $VALUES;

        public boolean accept(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            CharSequence charSequence = string;
            return new Regex("^\\p{javaUpperCase}+.*$").matches(charSequence);
        }

        public boolean accept(@NotNull File file, @NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return this.accept(new File(file, s));
        }

        public static UpperCasePrefixFilter[] values() {
            return (UpperCasePrefixFilter[])$VALUES.clone();
        }

        public static UpperCasePrefixFilter valueOf(String value) {
            return Enum.valueOf(UpperCasePrefixFilter.class, value);
        }

        static {
            $VALUES = upperCasePrefixFilterArray = new UpperCasePrefixFilter[]{UpperCasePrefixFilter.INSTANCE};
        }
    }
}

