/*
 * Decompiled with CFR 0.152.
 */
package ch.zizka.junitdiff;

import ch.zizka.junitdiff.ex.JUnitDiffException;
import ch.zizka.junitdiff.model.Failure;
import ch.zizka.junitdiff.model.TestRunInfo;
import ch.zizka.junitdiff.model.TestRunResultsList;
import ch.zizka.junitdiff.model.TestSuite;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.commons.io.FileUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000eH\u0003J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0013\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lch/zizka/junitdiff/FileParsing;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "MAX_LIST_FILE_SIZE_KB", "", "getSeparatedResultsLists", "", "Lch/zizka/junitdiff/model/TestSuite;", "reportFiles", "Ljava/io/File;", "parseFile", "file", "parseAsListOfFiles", "Lch/zizka/junitdiff/model/TestRunResultsList;", "tryParsingAsXml", "stream", "Ljava/io/FileInputStream;", "parseJUnitXmlReport", "doc", "Lorg/jdom/Document;", "JUnitDiff"})
@SourceDebugExtension(value={"SMAP\nFileParsing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileParsing.kt\nch/zizka/junitdiff/FileParsing\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,212:1\n1557#2:213\n1628#2,3:214\n1557#2:240\n1628#2,3:241\n108#3:217\n80#3,22:218\n*S KotlinDebug\n*F\n+ 1 FileParsing.kt\nch/zizka/junitdiff/FileParsing\n*L\n53#1:213\n53#1:214,3\n117#1:240\n117#1:241,3\n100#1:217\n100#1:218,22\n*E\n"})
public final class FileParsing {
    @NotNull
    public static final FileParsing INSTANCE = new FileParsing();
    private static final Logger log = LoggerFactory.getLogger(FileParsing.class);
    private static final int MAX_LIST_FILE_SIZE_KB = 512;

    private FileParsing() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TestSuite> getSeparatedResultsLists(@NotNull List<? extends File> reportFiles) throws JUnitDiffException {
        TestSuite ts;
        Intrinsics.checkNotNullParameter(reportFiles, "reportFiles");
        List reportsLists = new LinkedList();
        List errors = new ArrayList();
        for (File file : reportFiles) {
            if (!file.isFile()) {
                log.warn("  Not a regular file: " + file.getPath());
                continue;
            }
            if (file.length() == 0L) {
                log.warn("  File is empty: " + file.getPath());
                continue;
            }
            try {
                ts = this.parseFile(file);
                reportsLists.add(ts);
            }
            catch (JUnitDiffException ex) {
                String msg = "  Error processing '" + file.getPath() + "': " + ex.getMessage();
                log.error(msg);
                errors.add(new JUnitDiffException(msg, ex));
            }
        }
        if (!((Collection)errors).isEmpty()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = errors;
            int n = errors.size();
            boolean bl = false;
            ts = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JUnitDiffException jUnitDiffException = (JUnitDiffException)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getMessage());
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 2;
            Throwable throwable = null;
            String string = n + " errors:" + CollectionsKt.joinToString$default(collection, null, "\n", null, 0, null, null, 61, null);
            throw new JUnitDiffException(string, throwable, n2, defaultConstructorMarker);
        }
        return reportsLists;
    }

    private final TestSuite parseFile(File file) throws JUnitDiffException {
        TestSuite testSuite;
        try {
            testSuite = this.tryParsingAsXml(file);
        }
        catch (JDOMException ex) {
            throw new JUnitDiffException("  Failed parsing '" + file.getPath() + "' as XML JUnit test report: " + ex.getMessage(), null, 2, null);
        }
        catch (IOException ex) {
            throw new JUnitDiffException("  Error reading from file '" + file.getPath() + "': " + ex.getMessage(), null, 2, null);
        }
        return testSuite;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="List expanding is handled in FileParsing#preprocessPaths();")
    private final TestRunResultsList parseAsListOfFiles(File file) throws JUnitDiffException {
        String line2;
        List<String> list;
        if (file.length() > 524288L) {
            log.warn("  File is too big (" + file.length() / (long)1024 + " kb) : " + file.getPath());
        }
        try {
            list = FileUtils.readLines(file, Charsets.UTF_8);
        }
        catch (IOException ex) {
            throw new JUnitDiffException("  Error reading from file '" + file.getPath() + "': " + ex.getMessage(), null, 2, null);
        }
        List<String> readLines = list;
        List trls = new ArrayList();
        List errors = new ArrayList();
        for (String line : readLines) {
            String msg;
            Intrinsics.checkNotNull(line);
            String $this$trim$iv = line;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            line2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            try {
                TestSuite ts22 = this.tryParsingAsXml(new File(line2));
                boolean ts22 = trls.add(ts22.getTestRunResultsList());
            }
            catch (JDOMException ex) {
                msg = "  Error parsing '" + file.getPath() + "': " + ex.getMessage();
                log.error(msg);
                errors.add(ex);
            }
            catch (IOException ex) {
                msg = "  Error reading from file '" + file.getPath() + "': " + ex.getMessage();
                log.error(msg);
                errors.add(new IOException(msg));
            }
        }
        if (!errors.isEmpty()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = errors;
            int n = errors.size();
            boolean $i$f$map = false;
            line2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Exception startIndex$iv$iv = (Exception)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getMessage());
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 2;
            Throwable throwable = null;
            String string = n + " errors  when parsing the list of files:" + CollectionsKt.joinToString$default(collection, null, "\n", null, 0, null, null, 61, null);
            throw new JUnitDiffException(string, throwable, n2, defaultConstructorMarker);
        }
        return TestRunResultsList.Companion.fromList(trls);
    }

    private final TestSuite tryParsingAsXml(FileInputStream stream) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(stream);
        Intrinsics.checkNotNull(doc);
        return this.parseJUnitXmlReport(doc);
    }

    private final TestSuite tryParsingAsXml(File file) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(file);
        Intrinsics.checkNotNull(doc);
        TestSuite parseJUnitXmlReport = this.parseJUnitXmlReport(doc);
        File file2 = file;
        Intrinsics.checkNotNull(file2);
        parseJUnitXmlReport.setOrigin(file2.getPath());
        return parseJUnitXmlReport;
    }

    private final TestSuite parseJUnitXmlReport(Document doc) throws JDOMException {
        XPath xPath = XPath.newInstance("//testsuite/testcase");
        List list = xPath.selectNodes(doc);
        Intrinsics.checkNotNull(list, "null cannot be cast to non-null type kotlin.collections.List<org.jdom.Element>");
        List testcaseElements = list;
        TestRunResultsList resultsList = new TestRunResultsList(null, 1, null);
        for (Element elm : testcaseElements) {
            Failure fail;
            String string;
            String trace;
            String type;
            String message;
            String time = elm.getAttributeValue("time");
            String name = elm.getAttributeValue("name");
            String classname = elm.getAttributeValue("classname");
            TestRunInfo info = new TestRunInfo(classname, name, TestRunInfo.Result.OK, time);
            Element child = elm.getChild("failure");
            if (child != null) {
                message = child.getAttributeValue("message");
                type = child.getAttributeValue("type");
                trace = child.getText();
                Intrinsics.checkNotNull(message);
                string = trace;
                Intrinsics.checkNotNull(string);
                fail = new Failure(message, type, string);
                info.setResult(TestRunInfo.Result.FAIL);
                info.setFailure(fail);
            }
            if ((child = elm.getChild("error")) != null) {
                message = child.getAttributeValue("message");
                type = child.getAttributeValue("type");
                trace = child.getText();
                Intrinsics.checkNotNull(message);
                string = trace;
                Intrinsics.checkNotNull(string);
                fail = new Failure(message, type, string);
                info.setResult(TestRunInfo.Result.ERROR);
                info.setFailure(fail);
            }
            if ((child = elm.getChild("skipped")) != null) {
                info.setResult(TestRunInfo.Result.SKIPPED);
            }
            resultsList.add(info);
        }
        Object object = XPath.selectSingleNode(doc, "string(//testsuite/system-out)");
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.String");
        String systemOut = (String)object;
        Object object2 = XPath.selectSingleNode(doc, "string(//testsuite/system-err)");
        Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.String");
        String systemErr = (String)object2;
        Object object3 = XPath.selectSingleNode(doc, "string(//testsuite/@name)");
        Intrinsics.checkNotNull(object3, "null cannot be cast to non-null type kotlin.String");
        String tsName = (String)object3;
        return new TestSuite(tsName, resultsList, systemOut, systemErr);
    }
}

