/*
 * Decompiled with CFR 0.152.
 */
package ch.zizka.junitdiff;

import ch.zizka.junitdiff.util.FileUtil;
import ch.zizka.junitdiff.util.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lch/zizka/junitdiff/InputPreparation;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "preprocessPaths", "", "Ljava/io/File;", "reportFiles", "downloadAndUnzipUrls", "", "paths", "", "", "downloadZipAndExtractToTempDir", "urlStr", "downloadUrlToTempFile", "readListOfPaths", "path", "scanDirForJUnitReports", "UpperCasePrefixFilter", "JUnitDiff"})
@SourceDebugExtension(value={"SMAP\nInputPreparation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputPreparation.kt\nch/zizka/junitdiff/InputPreparation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class InputPreparation {
    @NotNull
    public static final InputPreparation INSTANCE = new InputPreparation();
    private static final Logger log = LoggerFactory.getLogger(InputPreparation.class);

    private InputPreparation() {
    }

    @NotNull
    public final List<File> preprocessPaths(@NotNull List<? extends File> reportFiles) {
        Intrinsics.checkNotNullParameter(reportFiles, "reportFiles");
        List expandedPaths = new LinkedList();
        for (File file : reportFiles) {
            File path2 = file;
            if (path2.isFile()) {
                String string = path2.getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                if (StringsKt.endsWith$default(string, ".zip", false, 2, null)) {
                    try {
                        path2 = ZipUtil.INSTANCE.unzipFileToTempDir(path2, ZipUtil.OverwriteMode.DELETE_FIRST);
                    }
                    catch (IOException ex) {
                        log.error("Can't unzip " + path2 + ": " + ex);
                    }
                } else {
                    String string2 = path2.getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                    boolean bl = StringsKt.endsWith$default(string2, ".xml", false, 2, null) ? expandedPaths.add(path2) : expandedPaths.addAll((Collection)this.readListOfPaths(path2));
                }
            }
            if (!path2.isDirectory()) continue;
            expandedPaths.addAll((Collection)this.scanDirForJUnitReports(path2));
        }
        return expandedPaths;
    }

    public final void downloadAndUnzipUrls(@NotNull List<String> paths) {
        Intrinsics.checkNotNullParameter(paths, "paths");
        int n = ((Collection)paths).size();
        for (int i = 0; i < n; ++i) {
            String path = paths.get(i);
            if (!StringsKt.startsWith$default(path, "http://", false, 2, null)) continue;
            try {
                File file;
                File resultDir = null;
                if (StringsKt.endsWith$default(path, ".zip", false, 2, null)) {
                    file = this.downloadZipAndExtractToTempDir(path);
                } else if (StringsKt.endsWith$default(path, ".xml", false, 2, null)) {
                    file = this.downloadUrlToTempFile(path);
                } else {
                    log.warn("  URL is not .zip nor .xml - skipping: " + path);
                    continue;
                }
                File file2 = resultDir = file;
                Intrinsics.checkNotNull(file2);
                String string = file2.getPath();
                Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
                paths.set(i, string);
                continue;
            }
            catch (IOException ex) {
                log.warn("  Error when processing URL " + path + ": " + ex.getMessage(), ex);
            }
        }
    }

    private final File downloadZipAndExtractToTempDir(String urlStr) {
        File tmpFile = this.downloadUrlToTempFile(urlStr);
        File dirWithZipContent = ZipUtil.INSTANCE.unzipFileToTempDir(tmpFile, ZipUtil.OverwriteMode.DELETE_FIRST);
        tmpFile.delete();
        return dirWithZipContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File downloadUrlToTempFile(String urlStr) {
        URL url = new URL(urlStr);
        File downloadToFile = File.createTempFile("JUnitDiff-tmp-", ".zip");
        Path path = downloadToFile.toPath();
        Intrinsics.checkNotNullExpressionValue(path, "toPath(...)");
        Object object = path;
        Object object2 = new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING};
        OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length));
        Intrinsics.checkNotNullExpressionValue(outputStream, "newOutputStream(...)");
        object = outputStream;
        object2 = null;
        try {
            OutputStream os22 = (OutputStream)object;
            boolean bl = false;
            long os22 = url.openStream().transferTo(os22);
        }
        catch (Throwable bl) {
            object2 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Object it = object2 = downloadToFile;
        boolean bl = false;
        ((File)it).deleteOnExit();
        Object object3 = object2;
        Intrinsics.checkNotNullExpressionValue(object3, "also(...)");
        return object3;
    }

    private final List<File> readListOfPaths(File path) {
        List list;
        try {
            if (FileUtil.INSTANCE.isBinaryFile(path)) {
                log.warn("  Can't read list of paths from a binary file: " + path.getPath());
                return CollectionsKt.emptyList();
            }
            List<String> lines = FileUtils.readLines(path, StandardCharsets.UTF_8);
            List paths = new ArrayList(lines.size());
            for (String line : lines) {
                File f = new File(line);
                if (!f.exists()) {
                    log.warn("  Does not exist: " + f.getPath());
                    continue;
                }
                if (!f.isFile()) {
                    log.warn("  Not a regular file: " + f.getPath());
                    continue;
                }
                paths.add(f);
            }
            list = paths;
        }
        catch (IOException ex) {
            log.warn("Error reading " + path.getPath() + " : " + ex.getMessage());
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<File> scanDirForJUnitReports(File path) {
        Object object = new IOFileFilter[2];
        object[0] = FileFilterUtils.directoryFileFilter();
        IOFileFilter[] iOFileFilterArray = new IOFileFilter[]{FileFilterUtils.suffixFileFilter(".xml"), UpperCasePrefixFilter.INSTANCE, FileFilterUtils.magicNumberFileFilter("<?xml")};
        object[1] = FileFilterUtils.and(iOFileFilterArray);
        IOFileFilter rigidFilter = FileFilterUtils.or(object);
        try {
            LinkedList<File> resultList = new LinkedList<File>();
            new DirectoryWalker<File>(rigidFilter, path){
                final /* synthetic */ File $path;
                {
                    this.$path = $path;
                    super($rigidFilter, -1);
                }

                protected void handleFile(File file, int depth, Collection<File> results) {
                    Intrinsics.checkNotNullParameter(file, "file");
                    Intrinsics.checkNotNullParameter(results, "results");
                    results.add(file);
                }

                protected boolean handleDirectory(File directory, int depth, Collection<? extends File> results) {
                    Intrinsics.checkNotNullParameter(directory, "directory");
                    Intrinsics.checkNotNullParameter(results, "results");
                    return true;
                }

                public final void doWalk(LinkedList<File> list) {
                    Intrinsics.checkNotNullParameter(list, "list");
                    this.walk(this.$path, (Collection)list);
                }
            }.doWalk(resultList);
            object = CollectionsKt.filterNotNull((Iterable)resultList);
        }
        catch (IOException ex) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016j\u0002\b\u0005\u00a8\u0006\f"}, d2={"Lch/zizka/junitdiff/InputPreparation$UpperCasePrefixFilter;", "Lorg/apache/commons/io/filefilter/IOFileFilter;", "", "<init>", "(Ljava/lang/String;I)V", "INSTANCE", "accept", "", "file", "Ljava/io/File;", "s", "", "JUnitDiff"})
    public static final class UpperCasePrefixFilter
    extends Enum<UpperCasePrefixFilter>
    implements IOFileFilter {
        public static final /* enum */ UpperCasePrefixFilter INSTANCE = new UpperCasePrefixFilter();
        private static final /* synthetic */ UpperCasePrefixFilter[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @Override
        public boolean accept(@NotNull File file) {
            Intrinsics.checkNotNullParameter(file, "file");
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            CharSequence charSequence = string;
            return new Regex("^\\p{javaUpperCase}+.*$").matches(charSequence);
        }

        @Override
        public boolean accept(@NotNull File file, @NotNull String s) {
            Intrinsics.checkNotNullParameter(file, "file");
            Intrinsics.checkNotNullParameter(s, "s");
            return this.accept(new File(file, s));
        }

        public static UpperCasePrefixFilter[] values() {
            return (UpperCasePrefixFilter[])$VALUES.clone();
        }

        public static UpperCasePrefixFilter valueOf(String value) {
            return Enum.valueOf(UpperCasePrefixFilter.class, value);
        }

        @NotNull
        public static EnumEntries<UpperCasePrefixFilter> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = upperCasePrefixFilterArray = new UpperCasePrefixFilter[]{UpperCasePrefixFilter.INSTANCE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

