/*
 * Decompiled with CFR 0.152.
 */
package ch.zizka.junitdiff.export;

import ch.zizka.junitdiff.ex.JUnitDiffException;
import ch.zizka.junitdiff.model.AggregatedData;
import ch.zizka.junitdiff.model.AggregatedTestResults;
import ch.zizka.junitdiff.model.Failure;
import ch.zizka.junitdiff.model.IGroup;
import ch.zizka.junitdiff.model.TestCaseInfo;
import ch.zizka.junitdiff.model.TestRunInfo;
import ch.zizka.junitdiff.model.TestSuite;
import cz.dynawest.xslt.XsltTransformer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lch/zizka/junitdiff/export/XmlExporter;", "", "<init>", "()V", "XSL_TEMPLATE_PATH", "", "exportToHtmlFile", "", "aggData", "Lch/zizka/junitdiff/model/AggregatedData;", "outFile", "Ljava/io/File;", "title", "exportToXML", "fout", "out", "Ljava/io/PrintStream;", "x", "s", "JUnitDiff"})
public final class XmlExporter {
    @NotNull
    public static final XmlExporter INSTANCE = new XmlExporter();
    @NotNull
    private static final String XSL_TEMPLATE_PATH = "/JUnitDiff-to-HTML.xsl";

    private XmlExporter() {
    }

    public final void exportToHtmlFile(@NotNull AggregatedData aggData, @NotNull File outFile, @Nullable String title) throws JUnitDiffException {
        Intrinsics.checkNotNullParameter(aggData, "aggData");
        Intrinsics.checkNotNullParameter(outFile, "outFile");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.exportToXML(aggData, new PrintStream(baos));
        try {
            ReaderInputStream ris = new ReaderInputStream((Reader)new StringReader(baos.toString("utf8")), "utf8");
            InputStream inputStream = XmlExporter.class.getResourceAsStream(XSL_TEMPLATE_PATH);
            if (inputStream == null) {
                throw new JUnitDiffException("Template resource not found: /JUnitDiff-to-HTML.xsl (a bug)", null, 2, null);
            }
            InputStream xslTemplate = inputStream;
            Map params = new HashMap();
            if (title != null) {
                params.put("title", title);
            }
            XsltTransformer.INSTANCE.transform(ris, xslTemplate, outFile, params);
        }
        catch (TransformerException ex) {
            throw new JUnitDiffException("Error when creating HTML file: " + ex.getMessage(), ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final void exportToXML(@NotNull AggregatedData aggData, @NotNull File fout) throws FileNotFoundException {
        Intrinsics.checkNotNullParameter(aggData, "aggData");
        Intrinsics.checkNotNullParameter(fout, "fout");
        this.exportToXML(aggData, new PrintStream(fout));
    }

    private final void exportToXML(AggregatedData aggData, PrintStream out) {
        out.println("<aggregate>");
        AggregatedTestResults atr = aggData.getAggregatedTestResults();
        out.println("\t<groups>");
        atr.shortenGroupsNames();
        List<IGroup> groups2 = atr.getGroups();
        for (IGroup g : groups2) {
            out.append("\t\t<group name=\"").append(this.x(g.getName())).append("\" path=\"").append(this.x(g.getPath())).append("\" id=\"").append(this.x(String.valueOf(g.getId()))).append("\"/>\n");
        }
        out.println("\t</groups>\n");
        for (TestCaseInfo testcase : atr.getTestCases()) {
            out.append("\t<testcase classname=\"").append(this.x(testcase.getClassName())).append("\" name=\"").append(this.x(testcase.getName())).append("\">\n");
            for (TestRunInfo testRun : testcase.getTestRuns()) {
                TestRunInfo.Result result = testRun.getResult();
                out.append("\t\t<testrun result=\"").append(this.x(result != null ? result.name() : null)).append("\" time=\"").append(this.x(testRun.getTime())).append("\" group=\"").append(this.x(testRun.getGroupID())).append("\">\n");
                if (testRun.getFailure() != null) {
                    PrintStream printStream = out.append("\t\t\t<failure message=\"");
                    Failure failure = testRun.getFailure();
                    Intrinsics.checkNotNull(failure);
                    PrintStream printStream2 = printStream.append(this.x(failure.getMessage())).append("\" type=\"");
                    Failure failure2 = testRun.getFailure();
                    Intrinsics.checkNotNull(failure2);
                    printStream2.append(this.x(failure2.getType())).append("\">\n");
                    Failure failure3 = testRun.getFailure();
                    Intrinsics.checkNotNull(failure3);
                    out.print(this.x(failure3.getTrace()));
                    out.println("</failure>");
                }
                out.println("\t\t</testrun>");
            }
            out.println("\t</testcase>");
        }
        out.println("\t<testsuites>");
        for (TestSuite ts : aggData.getTestSuites()) {
            out.append("\t\t<testsuite group=\"").append(this.x(ts.getGroup())).append("\" name=\"").append(this.x(ts.getClassName())).append("\" origin=\"").append(this.x(ts.getOrigin())).append("\">\n");
            out.append("\t\t<system-out><![CDATA[").append(ts.getStdOut()).append("]]></system-out>\n");
            out.append("\t\t<system-err><![CDATA[").append(ts.getStdErr()).append("]]></system-err>\n");
            out.println("\t\t</testsuite>");
        }
        out.println("\t</testsuites>\n");
        out.println("</aggregate>");
    }

    private final String x(String s) {
        if (s == null) {
            return "";
        }
        String string = StringEscapeUtils.escapeXml11(s);
        Intrinsics.checkNotNullExpressionValue(string, "escapeXml11(...)");
        return string;
    }
}

