/*
 * Decompiled with CFR 0.152.
 */
package ch.zizka.junitdiff.model;

import ch.zizka.junitdiff.model.IGroup;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lch/zizka/junitdiff/model/Groups;", "", "<init>", "()V", "groups", "", "", "Lch/zizka/junitdiff/model/Groups$Group;", "id", "", "getGroup", "Lch/zizka/junitdiff/model/IGroup;", "path", "shortenNames", "", "Group", "JUnitDiff"})
public final class Groups {
    @NotNull
    private final Map<String, Group> groups = new HashMap();
    private int id = 1;

    @NotNull
    public final IGroup getGroup(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Group group = null;
        if (this.groups.containsKey(path)) {
            Group group2 = this.groups.get(path);
            Intrinsics.checkNotNull(group2);
            group = group2;
        } else {
            group = new Group(path, this.id);
            int n = this.id;
            this.id = n + 1;
            this.groups.put(path, group);
        }
        return group;
    }

    public final void shortenNames() {
        int suffixLength;
        String[] allPaths = new String[this.groups.size()];
        String[] allPathsRev = new String[this.groups.size()];
        int i = 0;
        for (Group g : this.groups.values()) {
            allPaths[i] = g.getPath();
            allPathsRev[i] = StringUtils.reverse(g.getPath());
            ++i;
        }
        String commonPrefix = StringUtils.getCommonPrefix(Arrays.copyOf(allPaths, allPaths.length));
        String commonSuffix = StringUtils.getCommonPrefix(Arrays.copyOf(allPathsRev, allPathsRev.length));
        int prefixLength = commonPrefix.length();
        if (prefixLength + (suffixLength = commonSuffix.length()) == 0) {
            return;
        }
        for (Group g : this.groups.values()) {
            int nameLength = g.getPath().length();
            int end = nameLength - suffixLength;
            if (prefixLength >= end) {
                end = nameLength;
            }
            String string = g.getPath().substring(prefixLength, end);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            g.setName(string);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lch/zizka/junitdiff/model/Groups$Group;", "Lch/zizka/junitdiff/model/IGroup;", "path", "", "id", "", "<init>", "(Ljava/lang/String;I)V", "getPath", "()Ljava/lang/String;", "getId", "()I", "name", "getName", "setName", "(Ljava/lang/String;)V", "toString", "JUnitDiff"})
    private static final class Group
    implements IGroup {
        @NotNull
        private final String path;
        private final int id;
        @NotNull
        private String name;

        public Group(@NotNull String path, int id) {
            Intrinsics.checkNotNullParameter(path, "path");
            this.path = path;
            this.id = id;
            this.name = this.getPath();
        }

        @Override
        @NotNull
        public String getPath() {
            return this.path;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        public void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.name = string;
        }

        @NotNull
        public String toString() {
            return "Groups{name=" + this.getName() + "}";
        }
    }
}

