/*
 * Decompiled with CFR 0.152.
 */
package ch.zizka.junitdiff;

import ch.zizka.junitdiff.FileParsing;
import ch.zizka.junitdiff.InputPreparation;
import ch.zizka.junitdiff.ex.JUnitDiffException;
import ch.zizka.junitdiff.export.XmlExporter;
import ch.zizka.junitdiff.model.AggregatedData;
import ch.zizka.junitdiff.model.TestSuite;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0002\u000b\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lch/zizka/junitdiff/JUnitDiffApp;", "", "<init>", "()V", "runApp", "", "p", "Lch/zizka/junitdiff/JUnitDiffApp$InvocationParams;", "putJavascriptFunctionsFileToDir", "dir", "Ljava/nio/file/Path;", "InvocationParams", "Companion", "JUnitDiff"})
@SourceDebugExtension(value={"SMAP\nJUnitDiffApp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitDiffApp.kt\nch/zizka/junitdiff/JUnitDiffApp\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n1#2:224\n*E\n"})
public final class JUnitDiffApp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(JUnitDiffApp.class);
    @NotNull
    private static final String DEFAULT_OUT_FILE = "JUnitDiff";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void runApp(InvocationParams p) {
        List reportFiles = new ArrayList(p.getInputPaths().size());
        InputPreparation.INSTANCE.downloadAndUnzipUrls(p.getInputPaths());
        for (String path : p.getInputPaths()) {
            File reportFile = new File(path);
            if (!reportFile.exists()) {
                boolean $i$a$-require-JUnitDiffApp$runApp$22 = false;
                String $i$a$-require-JUnitDiffApp$runApp$22 = "  File " + reportFile.getPath() + " does not exist.";
                throw new IllegalArgumentException($i$a$-require-JUnitDiffApp$runApp$22.toString());
            }
            reportFiles.add(reportFile);
        }
        AggregatedData aggregatedData = new AggregatedData();
        Object object = reportFiles.iterator();
        while (object.hasNext()) {
            File file;
            File file2 = file = (File)object.next();
            Intrinsics.checkNotNull((Object)file2);
            String groupName = file2.getPath();
            List inList = CollectionsKt.listOf((Object)file);
            List<File> filesToProcess = InputPreparation.INSTANCE.preprocessPaths(inList);
            if (filesToProcess.isEmpty()) {
                log.warn("No report files to process from source '" + groupName + "'.");
                continue;
            }
            Intrinsics.checkNotNull((Object)groupName);
            List testSuites = JUnitDiffApp.Companion.processGroup(groupName, filesToProcess);
            if (testSuites.isEmpty()) {
                log.warn("No testsuites to process from source '" + groupName + "'.");
                continue;
            }
            log.info("Aggregating test results - group: " + groupName + " - " + testSuites.size() + " test suites.");
            try {
                aggregatedData.mergeTestSuites(testSuites, groupName);
            }
            catch (Exception ex) {
                log.error("Error when aggregating: " + ex.getMessage(), (Throwable)ex);
                System.exit(3);
            }
        }
        if (aggregatedData.getTestSuites().size() == 0) {
            log.error("No results to process.");
            System.exit(4);
        }
        log.info("Exporting to " + p + ".outPath");
        switch (WhenMappings.$EnumSwitchMapping$0[p.getOutputFormat().ordinal()]) {
            case 1: {
                try {
                    File file = p.getOutPath().toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    XmlExporter.INSTANCE.exportToXML(aggregatedData, file);
                    break;
                }
                catch (FileNotFoundException ex) {
                    log.error("Can't write to file '" + p.getOutPath() + "': " + ex.getMessage());
                    System.exit(5);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
            }
            case 2: {
                try {
                    File file = p.getOutPath().toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    XmlExporter.INSTANCE.exportToHtmlFile(aggregatedData, file, p.getTitle());
                    break;
                }
                catch (JUnitDiffException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    System.exit(6);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Path path = p.getOutPath().getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        this.putJavascriptFunctionsFileToDir(path);
        if (p.getToStdOut()) {
            log.debug("Output goes to stdout.");
            object = p.getOutPath();
            OpenOption[] ex = new OpenOption[]{};
            Object object2 = Charsets.UTF_8;
            object = new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(ex, ex.length)), (Charset)object2);
            object2 = null;
            try {
                InputStreamReader it = (InputStreamReader)object;
                boolean bl = false;
                Reader reader = it;
                PrintStream printStream = System.out;
                Intrinsics.checkNotNull((Object)printStream, (String)"null cannot be cast to non-null type java.io.OutputStream");
                IOUtils.copy((Reader)reader, (OutputStream)printStream, (Charset)StandardCharsets.UTF_8);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void putJavascriptFunctionsFileToDir(Path dir) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isDirectory(dir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new JUnitDiffException("Not a directory: " + dir, null, 2, null);
        }
        Path path = dir.resolve("functions.js");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Object object = path;
        Object object2 = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        object = outputStream;
        object2 = null;
        try {
            Long l;
            OutputStream os = (OutputStream)object;
            boolean bl = false;
            Object object3 = this.getClass().getClassLoader().getResource("functions.js");
            if (object3 != null && (object3 = ((URL)object3).openStream()) != null) {
                Closeable closeable = (Closeable)object3;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl2 = false;
                    Long l2 = it.transferTo(os);
                    l = l2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                l = null;
            }
            Long l3 = l;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\rH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\u00020\u00102\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\rH\u0002\u00a2\u0006\u0002\u0010\u0011J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0013H\u0002J\b\u0010\u0018\u001a\u00020\u000bH\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lch/zizka/junitdiff/JUnitDiffApp$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "DEFAULT_OUT_FILE", "", "main", "", "args", "", "([Ljava/lang/String;)V", "parseArguments", "Lch/zizka/junitdiff/JUnitDiffApp$InvocationParams;", "([Ljava/lang/String;)Lch/zizka/junitdiff/JUnitDiffApp$InvocationParams;", "processGroup", "", "Lch/zizka/junitdiff/model/TestSuite;", "groupName", "reportFiles", "Ljava/io/File;", "printUsage", "JUnitDiff"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            log.debug("Starting JUnitDiff - multiple JUnit test runs comparing tool.");
            if (args.length == 0) {
                this.printUsage();
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            InvocationParams invocationParams = this.parseArguments(args);
            new JUnitDiffApp().runApp(invocationParams);
        }

        private final InvocationParams parseArguments(String[] args) {
            Object outFile = null;
            String title = null;
            InvocationParams.OutputFormat outputFormat = InvocationParams.OutputFormat.HTML;
            boolean stdOut = false;
            for (int i = 0; i < args.length; ++i) {
                if (Intrinsics.areEqual((Object)"-xml", (Object)args[i])) {
                    outputFormat = InvocationParams.OutputFormat.XML;
                    args[i] = null;
                    continue;
                }
                if (Intrinsics.areEqual((Object)"-o", (Object)args[i])) {
                    args[i] = null;
                    if (i >= args.length - 1) continue;
                    outFile = args[i + 1];
                    args[i + 1] = null;
                    ++i;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)"--title", (Object)args[i])) continue;
                args[i] = null;
                if (i >= args.length - 1) continue;
                title = args[i + 1];
                args[i + 1] = null;
                ++i;
            }
            if (Intrinsics.areEqual((Object)"-", outFile)) {
                stdOut = true;
                outFile = null;
            }
            if (outFile == null) {
                outFile = JUnitDiffApp.DEFAULT_OUT_FILE + outputFormat.getSuffix();
            }
            List list = CollectionsKt.toMutableList((Collection)ArraysKt.filterNotNull((Object[])args));
            Path path = Path.of((String)outFile, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            return new InvocationParams(list, path, outputFormat, stdOut, title);
        }

        private final List<TestSuite> processGroup(String groupName, List<? extends File> reportFiles) {
            List<TestSuite> list;
            log.info("Parsing test reports group '" + groupName + "': " + reportFiles.size() + " files.");
            List<TestSuite> testSuites = null;
            try {
                list = FileParsing.INSTANCE.getSeparatedResultsLists(reportFiles);
            }
            catch (JUnitDiffException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                return CollectionsKt.emptyList();
            }
            testSuites = list;
            for (TestSuite testSuite : testSuites) {
                testSuite.setGroup(groupName);
            }
            return testSuites;
        }

        private final void printUsage() {
            System.out.println((Object)"  Aggregates multiple JUnit XML reports into one comprehensible page.");
            System.out.println((Object)"  Usage:");
            System.out.println((Object)"    java -jar JUnitDiff.jar [options] ( dir | TEST-foo.xml | list-of-paths.txt | http://host/reports.zip )+");
            System.out.println((Object)"");
            System.out.println((Object)"  Options:");
            System.out.println((Object)"    -o ('-' | outputPath)   Output file. '-' dumps the result to the stdout. Logging output always goes to the stderr.");
            System.out.println((Object)"    -xml                    XML output (default is HTML).");
            System.out.println((Object)"    --title <title>         Title and heading for the HTML report.");
            System.out.println((Object)"");
            System.out.println((Object)"  Examples:");
            System.out.println((Object)"    java -jar JUnitDiff.jar -o - > aggregated-test-report.html");
            System.out.println((Object)"    java -jar JUnitDiff.jar -xml -o aggregated-test-report.xml");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001#B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003JC\u0010\u001d\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lch/zizka/junitdiff/JUnitDiffApp$InvocationParams;", "", "inputPaths", "", "", "outPath", "Ljava/nio/file/Path;", "outputFormat", "Lch/zizka/junitdiff/JUnitDiffApp$InvocationParams$OutputFormat;", "toStdOut", "", "title", "<init>", "(Ljava/util/List;Ljava/nio/file/Path;Lch/zizka/junitdiff/JUnitDiffApp$InvocationParams$OutputFormat;ZLjava/lang/String;)V", "getInputPaths", "()Ljava/util/List;", "getOutPath", "()Ljava/nio/file/Path;", "getOutputFormat", "()Lch/zizka/junitdiff/JUnitDiffApp$InvocationParams$OutputFormat;", "getToStdOut", "()Z", "getTitle", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "OutputFormat", "JUnitDiff"})
    public static final class InvocationParams {
        @NotNull
        private final List<String> inputPaths;
        @NotNull
        private final Path outPath;
        @NotNull
        private final OutputFormat outputFormat;
        private final boolean toStdOut;
        @Nullable
        private final String title;

        public InvocationParams(@NotNull List<String> inputPaths, @NotNull Path outPath, @NotNull OutputFormat outputFormat, boolean toStdOut, @Nullable String title) {
            Intrinsics.checkNotNullParameter(inputPaths, (String)"inputPaths");
            Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
            Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
            this.inputPaths = inputPaths;
            this.outPath = outPath;
            this.outputFormat = outputFormat;
            this.toStdOut = toStdOut;
            this.title = title;
        }

        @NotNull
        public final List<String> getInputPaths() {
            return this.inputPaths;
        }

        @NotNull
        public final Path getOutPath() {
            return this.outPath;
        }

        @NotNull
        public final OutputFormat getOutputFormat() {
            return this.outputFormat;
        }

        public final boolean getToStdOut() {
            return this.toStdOut;
        }

        @Nullable
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final List<String> component1() {
            return this.inputPaths;
        }

        @NotNull
        public final Path component2() {
            return this.outPath;
        }

        @NotNull
        public final OutputFormat component3() {
            return this.outputFormat;
        }

        public final boolean component4() {
            return this.toStdOut;
        }

        @Nullable
        public final String component5() {
            return this.title;
        }

        @NotNull
        public final InvocationParams copy(@NotNull List<String> inputPaths, @NotNull Path outPath, @NotNull OutputFormat outputFormat, boolean toStdOut, @Nullable String title) {
            Intrinsics.checkNotNullParameter(inputPaths, (String)"inputPaths");
            Intrinsics.checkNotNullParameter((Object)outPath, (String)"outPath");
            Intrinsics.checkNotNullParameter((Object)((Object)outputFormat), (String)"outputFormat");
            return new InvocationParams(inputPaths, outPath, outputFormat, toStdOut, title);
        }

        public static /* synthetic */ InvocationParams copy$default(InvocationParams invocationParams, List list, Path path, OutputFormat outputFormat, boolean bl, String string, int n, Object object) {
            if ((n & 1) != 0) {
                list = invocationParams.inputPaths;
            }
            if ((n & 2) != 0) {
                path = invocationParams.outPath;
            }
            if ((n & 4) != 0) {
                outputFormat = invocationParams.outputFormat;
            }
            if ((n & 8) != 0) {
                bl = invocationParams.toStdOut;
            }
            if ((n & 0x10) != 0) {
                string = invocationParams.title;
            }
            return invocationParams.copy(list, path, outputFormat, bl, string);
        }

        @NotNull
        public String toString() {
            return "InvocationParams(inputPaths=" + this.inputPaths + ", outPath=" + this.outPath + ", outputFormat=" + this.outputFormat + ", toStdOut=" + this.toStdOut + ", title=" + this.title + ")";
        }

        public int hashCode() {
            int result = ((Object)this.inputPaths).hashCode();
            result = result * 31 + ((Object)this.outPath).hashCode();
            result = result * 31 + this.outputFormat.hashCode();
            result = result * 31 + Boolean.hashCode(this.toStdOut);
            result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InvocationParams)) {
                return false;
            }
            InvocationParams invocationParams = (InvocationParams)other;
            if (!Intrinsics.areEqual(this.inputPaths, invocationParams.inputPaths)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outPath, (Object)invocationParams.outPath)) {
                return false;
            }
            if (this.outputFormat != invocationParams.outputFormat) {
                return false;
            }
            if (this.toStdOut != invocationParams.toStdOut) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.title, (Object)invocationParams.title);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lch/zizka/junitdiff/JUnitDiffApp$InvocationParams$OutputFormat;", "", "suffix", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getSuffix", "()Ljava/lang/String;", "HTML", "XML", "JUnitDiff"})
        public static final class OutputFormat
        extends Enum<OutputFormat> {
            @NotNull
            private final String suffix;
            public static final /* enum */ OutputFormat HTML = new OutputFormat(".html");
            public static final /* enum */ OutputFormat XML = new OutputFormat(".xml");
            private static final /* synthetic */ OutputFormat[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private OutputFormat(String suffix) {
                this.suffix = suffix;
            }

            @NotNull
            public final String getSuffix() {
                return this.suffix;
            }

            public static OutputFormat[] values() {
                return (OutputFormat[])$VALUES.clone();
            }

            public static OutputFormat valueOf(String value) {
                return Enum.valueOf(OutputFormat.class, value);
            }

            @NotNull
            public static EnumEntries<OutputFormat> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = outputFormatArray = new OutputFormat[]{OutputFormat.HTML, OutputFormat.XML};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InvocationParams.OutputFormat.values().length];
            try {
                nArray[InvocationParams.OutputFormat.XML.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InvocationParams.OutputFormat.HTML.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

