/*
 * Decompiled with CFR 0.152.
 */
package ch.zizka.junitdiff.model;

import ch.zizka.junitdiff.model.TestRunInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B!\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u0005\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\u0005\u0010\fB\u0011\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u000eJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0011\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0016H\u0086\u0002J\u0014\u0010\u001c\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001eJ\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\tR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0013\u0010%\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0010\u00a8\u0006'"}, d2={"Lch/zizka/junitdiff/model/TestCaseInfo;", "", "className", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "testInfos", "", "Lch/zizka/junitdiff/model/TestRunInfo;", "(Ljava/lang/String;Ljava/util/List;)V", "test", "(Lch/zizka/junitdiff/model/TestRunInfo;)V", "testCase", "(Lch/zizka/junitdiff/model/TestCaseInfo;)V", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "getName", "setName", "size", "", "isEmpty", "", "()Z", "get", "index", "addAll", "c", "", "add", "e", "testRuns", "", "getTestRuns", "()Ljava/util/List;", "fullName", "getFullName", "JUnitDiff"})
public final class TestCaseInfo {
    @Nullable
    private String className;
    @Nullable
    private String name;
    @NotNull
    private List<TestRunInfo> testInfos;

    @Nullable
    public final String getClassName() {
        return this.className;
    }

    public final void setClassName(@Nullable String string) {
        this.className = string;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string) {
        this.name = string;
    }

    public TestCaseInfo(@Nullable String className, @Nullable String name) {
        this.testInfos = new ArrayList();
        this.name = name;
        this.className = className;
    }

    public TestCaseInfo(@Nullable String name, @NotNull List<TestRunInfo> testInfos) {
        Intrinsics.checkNotNullParameter(testInfos, (String)"testInfos");
        this.testInfos = new ArrayList();
        this.name = name;
        this.testInfos = testInfos;
    }

    public TestCaseInfo(@NotNull TestRunInfo test) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        this.testInfos = new ArrayList();
        this.name = test.getName();
        this.className = test.getClassname();
    }

    public TestCaseInfo(@NotNull TestCaseInfo testCase) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        this.testInfos = new ArrayList();
        this.className = testCase.className;
        this.name = testCase.name;
        this.testInfos.addAll((Collection<TestRunInfo>)testCase.testInfos);
    }

    public final int size() {
        return this.testInfos.size();
    }

    public final boolean isEmpty() {
        return this.testInfos.isEmpty();
    }

    @NotNull
    public final TestRunInfo get(int index) {
        return this.testInfos.get(index);
    }

    public final boolean addAll(@NotNull Collection<TestRunInfo> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        return this.testInfos.addAll(c);
    }

    public final boolean add(@NotNull TestRunInfo e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.testInfos.add(e);
    }

    @NotNull
    public final List<TestRunInfo> getTestRuns() {
        List<TestRunInfo> list = Collections.unmodifiableList(this.testInfos);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        return list;
    }

    @Nullable
    public final String getFullName() {
        return this.className == null ? this.name : this.className + "." + this.name;
    }
}

