/*
 * Decompiled with CFR 0.152.
 */
package ch.zizka.junitdiff.model;

import ch.zizka.junitdiff.model.TestCaseInfo;
import ch.zizka.junitdiff.model.TestRunInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rJ\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\nH\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lch/zizka/junitdiff/model/TestClassInfo;", "", "className", "", "<init>", "(Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "testsByTestName", "", "Lch/zizka/junitdiff/model/TestCaseInfo;", "classRuns", "", "Lch/zizka/junitdiff/model/TestRunInfo;", "setTests", "", "tests", "", "add", "testRun", "testCasesWithPseudoRuns", "getTestCasesWithPseudoRuns", "()Ljava/util/List;", "addTestCase", "testcase", "JUnitDiff"})
public final class TestClassInfo {
    @Nullable
    private final String className;
    @NotNull
    private final Map<String, TestCaseInfo> testsByTestName;
    @NotNull
    private final List<TestRunInfo> classRuns;

    public TestClassInfo(@Nullable String className) {
        this.className = className;
        this.testsByTestName = new HashMap();
        this.classRuns = new ArrayList();
    }

    @Nullable
    public final String getClassName() {
        return this.className;
    }

    private final void setTests(List<TestCaseInfo> tests) {
        this.testsByTestName.clear();
        for (TestCaseInfo test : tests) {
            this.testsByTestName.put(test.getName(), test);
        }
    }

    public final void add(@NotNull TestRunInfo testRun) {
        Intrinsics.checkNotNullParameter((Object)testRun, (String)"testRun");
        if (testRun.getClassname() != null && Intrinsics.areEqual((Object)testRun.getClassname(), (Object)testRun.getName())) {
            this.classRuns.add(testRun);
            return;
        }
        TestCaseInfo testcase = this.testsByTestName.get(testRun.getName());
        if (testcase == null) {
            testcase = new TestCaseInfo(testRun);
            this.addTestCase(testcase);
        }
        testcase.add(testRun);
    }

    @NotNull
    public final List<TestCaseInfo> getTestCasesWithPseudoRuns() {
        List testcases = new ArrayList();
        for (TestCaseInfo tc : this.testsByTestName.values()) {
            TestCaseInfo testcase = new TestCaseInfo(tc);
            for (TestRunInfo classRun : this.classRuns) {
                TestRunInfo pseudoTestrun = new TestRunInfo(this.className, testcase.getName(), classRun.getResult(), classRun.getTime());
                pseudoTestrun.setFailure(classRun.getFailure());
                pseudoTestrun.setGroup(classRun.getGroup());
                testcase.add(pseudoTestrun);
            }
            testcases.add(testcase);
        }
        return testcases;
    }

    private final void addTestCase(TestCaseInfo testcase) {
        this.testsByTestName.put(testcase.getName(), testcase);
    }
}

