/*
 * Decompiled with CFR 0.152.
 */
package ch.zizka.junitdiff.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lch/zizka/junitdiff/util/FileUtil;", "", "<init>", "()V", "isBinaryFile", "", "f", "Ljava/io/File;", "JUnitDiff"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();

    private FileUtil() {
    }

    public final boolean isBinaryFile(@Nullable File f) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(f);
        int size = in.available();
        if (size > 1024) {
            size = 1024;
        }
        byte[] data = new byte[size];
        in.read(data);
        in.close();
        int ascii = 0;
        int other = 0;
        for (byte b : data) {
            if (b < 9) {
                return true;
            }
            if (b == 9 || b == 10 || b == 12 || b == 13) {
                ++ascii;
                continue;
            }
            if (b >= 32 && b <= 126) {
                ++ascii;
                continue;
            }
            ++other;
        }
        return other == 0 ? false : (ascii + other) * 100 / other > 95;
    }
}

