/*
 * Decompiled with CFR 0.152.
 */
package ch.zizka.junitdiff.util;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ0\u0010\u000f\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\n \u0006*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lch/zizka/junitdiff/util/ZipUtil;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "BUFFER_SIZE", "", "unzipFileToTempDir", "Ljava/io/File;", "zipFile", "mode", "Lch/zizka/junitdiff/util/ZipUtil$OverwriteMode;", "unzipFileToDir", "", "zip", "intoDir", "", "fileFilter", "Ljava/io/FileFilter;", "TEST_XML_FILTER", "Lorg/apache/commons/io/filefilter/IOFileFilter;", "Lorg/apache/commons/io/filefilter/IOFileFilter;", "OverwriteMode", "JUnitDiff"})
@SourceDebugExtension(value={"SMAP\nZipUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipUtil.kt\nch/zizka/junitdiff/util/ZipUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class ZipUtil {
    @NotNull
    public static final ZipUtil INSTANCE = new ZipUtil();
    private static final Logger log = LoggerFactory.getLogger(ZipUtil.class);
    private static final int BUFFER_SIZE = 32768;
    private static final IOFileFilter TEST_XML_FILTER;

    private ZipUtil() {
    }

    @NotNull
    public final File unzipFileToTempDir(@Nullable File zipFile, @Nullable OverwriteMode mode) {
        boolean bl;
        File file = zipFile;
        Intrinsics.checkNotNull((Object)file);
        Object path = file.getPath();
        String string = path;
        Intrinsics.checkNotNull((Object)string);
        path = StringsKt.endsWith$default((String)string, (String)".zip", (boolean)false, (int)2, null) ? StringUtils.removeEndIgnoreCase((String)path, (String)".zip") : (String)path + "-";
        File tmpDir = new File((String)path);
        if (tmpDir.getParentFile().canWrite()) {
            bl = tmpDir.mkdir();
        } else {
            tmpDir = File.createTempFile("JUnitDiff-", "");
            bl = tmpDir.delete();
        }
        tmpDir.deleteOnExit();
        this.unzipFileToDir(zipFile, tmpDir, (FileFilter)TEST_XML_FILTER, mode);
        return tmpDir;
    }

    public final boolean unzipFileToDir(@NotNull File zip, @NotNull File intoDir, @NotNull OverwriteMode mode) {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        Intrinsics.checkNotNullParameter((Object)intoDir, (String)"intoDir");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        if (intoDir.exists()) {
            switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                case 1: {
                    return false;
                }
                case 2: {
                    FileUtils.deleteDirectory((File)intoDir);
                }
            }
        }
        ZipUtil.unzipFileToDir$default(this, zip, intoDir, null, null, 12, null);
        return true;
    }

    @JvmOverloads
    public final void unzipFileToDir(@NotNull File zipFile, @NotNull File intoDir, @Nullable FileFilter fileFilter, @Nullable OverwriteMode mode) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)intoDir, (String)"intoDir");
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> enumeration = zip.entries();
        Intrinsics.checkNotNull(enumeration, (String)"null cannot be cast to non-null type java.util.Enumeration<out java.util.zip.ZipEntry>");
        Enumeration<? extends ZipEntry> entries = enumeration;
        byte[] buf = new byte[32768];
        try {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"..", (boolean)false, (int)2, null) || fileFilter != null && !fileFilter.accept(new File(entry.getName()))) continue;
                log.trace("  Extracting: " + entry);
                File f = new File(intoDir, entry.getName());
                if (!f.exists()) {
                    f.getParentFile().mkdirs();
                    f.createNewFile();
                }
                InputStream iStream = zip.getInputStream(entry);
                OutputStream os = Files.newOutputStream(f.toPath(), new OpenOption[0]);
                int r = 0;
                while (true) {
                    int n;
                    int it = n = iStream.read(buf);
                    boolean bl = false;
                    r = it;
                    if (n == -1) break;
                    os.write(buf, 0, r);
                }
                os.close();
                iStream.close();
            }
        }
        catch (Exception ex) {
            log.error(" Error when unzipping " + zipFile.getPath() + ": " + ex.getMessage());
        }
    }

    public static /* synthetic */ void unzipFileToDir$default(ZipUtil zipUtil, File file, File file2, FileFilter fileFilter, OverwriteMode overwriteMode, int n, Object object) {
        if ((n & 4) != 0) {
            fileFilter = null;
        }
        if ((n & 8) != 0) {
            overwriteMode = OverwriteMode.WRITE_INTO;
        }
        zipUtil.unzipFileToDir(file, file2, fileFilter, overwriteMode);
    }

    @JvmOverloads
    public final void unzipFileToDir(@NotNull File zipFile, @NotNull File intoDir, @Nullable FileFilter fileFilter) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)intoDir, (String)"intoDir");
        ZipUtil.unzipFileToDir$default(this, zipFile, intoDir, fileFilter, null, 8, null);
    }

    @JvmOverloads
    public final void unzipFileToDir(@NotNull File zipFile, @NotNull File intoDir) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)intoDir, (String)"intoDir");
        ZipUtil.unzipFileToDir$default(this, zipFile, intoDir, null, null, 12, null);
    }

    static {
        IOFileFilter[] iOFileFilterArray = new IOFileFilter[]{FileFilterUtils.prefixFileFilter((String)"TEST-"), FileFilterUtils.suffixFileFilter((String)".xml")};
        TEST_XML_FILTER = FileFilterUtils.and((IOFileFilter[])iOFileFilterArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lch/zizka/junitdiff/util/ZipUtil$OverwriteMode;", "", "<init>", "(Ljava/lang/String;I)V", "ONLY_NEW", "WRITE_INTO", "DELETE_FIRST", "JUnitDiff"})
    public static final class OverwriteMode
    extends Enum<OverwriteMode> {
        public static final /* enum */ OverwriteMode ONLY_NEW = new OverwriteMode();
        public static final /* enum */ OverwriteMode WRITE_INTO = new OverwriteMode();
        public static final /* enum */ OverwriteMode DELETE_FIRST = new OverwriteMode();
        private static final /* synthetic */ OverwriteMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OverwriteMode[] values() {
            return (OverwriteMode[])$VALUES.clone();
        }

        public static OverwriteMode valueOf(String value) {
            return Enum.valueOf(OverwriteMode.class, value);
        }

        @NotNull
        public static EnumEntries<OverwriteMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = overwriteModeArray = new OverwriteMode[]{OverwriteMode.ONLY_NEW, OverwriteMode.WRITE_INTO, OverwriteMode.DELETE_FIRST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OverwriteMode.values().length];
            try {
                nArray[OverwriteMode.ONLY_NEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverwriteMode.DELETE_FIRST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

