/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.mapper.entity;

import cn.lm.mybatis.mapper.MapperException;
import cn.lm.mybatis.mapper.entity.EntityColumn;
import cn.lm.mybatis.mapper.entity.EntityTable;
import cn.lm.mybatis.mapper.entity.IDynamicTableName;
import cn.lm.mybatis.mapper.entity.SqlsCriteria;
import cn.lm.mybatis.mapper.mapperhelper.EntityHelper;
import cn.lm.mybatis.mapper.util.LambdaUtils;
import cn.lm.mybatis.mapper.util.MetaObjectUtil;
import cn.lm.mybatis.mapper.util.Sqls;
import cn.lm.mybatis.mapper.util.StringUtil;
import cn.lm.mybatis.mapper.util.support.LambdaMeta;
import cn.lm.mybatis.mapper.util.support.SFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.property.PropertyNamer;

public class Condition<T>
implements IDynamicTableName {
    protected String orderByClause;
    protected boolean distinct;
    protected boolean exists;
    protected boolean notNull;
    protected boolean forUpdate;
    protected Set<String> selectColumns;
    protected Set<String> excludeColumns;
    protected String countColumn;
    protected List<Criteria<T>> oredCriteria;
    protected Class<T> entityClass;
    protected EntityTable table;
    protected Map<String, EntityColumn> propertyMap;
    protected String tableName;
    protected OrderBy<T> ORDERBY;

    public Condition(Class<T> entityClass) {
        this(entityClass, true);
    }

    public Condition(Class<T> entityClass, boolean exists) {
        this(entityClass, exists, false);
    }

    public Condition(Class<T> entityClass, boolean exists, boolean notNull) {
        this.exists = exists;
        this.notNull = notNull;
        this.oredCriteria = new ArrayList<Criteria<T>>();
        this.entityClass = entityClass;
        this.table = EntityHelper.getEntityTable(entityClass);
        this.propertyMap = this.table.getPropertyMap();
        this.ORDERBY = new OrderBy(this, this.propertyMap);
    }

    private Condition(Builder<T> builder) {
        this.exists = builder.exists;
        this.notNull = builder.notNull;
        this.distinct = builder.distinct;
        this.entityClass = builder.entityClass;
        this.propertyMap = builder.propertyMap;
        this.selectColumns = builder.selectColumns;
        this.excludeColumns = builder.excludeColumns;
        this.oredCriteria = builder.exampleCriterias;
        this.forUpdate = builder.forUpdate;
        this.tableName = builder.tableName;
        this.ORDERBY = new OrderBy(this, this.propertyMap);
        if (!StringUtil.isEmpty(builder.orderByClause.toString())) {
            this.orderByClause = builder.orderByClause.toString();
        }
    }

    public static <T1> Builder<T1> builder(Class<T1> entityClass) {
        return new Builder<T1>(entityClass);
    }

    public OrderBy<T> orderBy(SFunction<T, ?> column) {
        this.ORDERBY.orderBy(this.getColumnCache(column));
        return this.ORDERBY;
    }

    public OrderBy<T> orderBy(String property) {
        this.ORDERBY.orderBy(property);
        return this.ORDERBY;
    }

    public Condition<T> excludeProperties(SFunction<T, ?> ... columns) {
        if (Objects.isNull(columns)) {
            return this;
        }
        return this.excludeProperties((String[])Arrays.stream(columns).map(this::getColumnCache).toArray(String[]::new));
    }

    public Condition<T> excludeProperties(String ... properties) {
        if (properties != null && properties.length > 0) {
            if (this.excludeColumns == null) {
                this.excludeColumns = new LinkedHashSet<String>();
            }
            for (String property : properties) {
                if (!this.propertyMap.containsKey(property)) {
                    throw new MapperException("\u7c7b " + this.entityClass.getSimpleName() + " \u4e0d\u5305\u542b\u5c5e\u6027 '" + property + "'\uff0c\u6216\u8be5\u5c5e\u6027\u88ab@Transient\u6ce8\u91ca\uff01");
                }
                this.excludeColumns.add(this.propertyMap.get(property).getColumn());
            }
        }
        return this;
    }

    public Condition<T> selectProperties(SFunction<T, ?> ... columns) {
        if (Objects.isNull(columns)) {
            return this;
        }
        return this.selectProperties((String[])Arrays.stream(columns).map(this::getColumnCache).toArray(String[]::new));
    }

    public Condition<T> selectProperties(String ... properties) {
        if (properties != null && properties.length > 0) {
            if (this.selectColumns == null) {
                this.selectColumns = new LinkedHashSet<String>();
            }
            for (String property : properties) {
                if (!this.propertyMap.containsKey(property)) {
                    throw new MapperException("\u7c7b " + this.entityClass.getSimpleName() + " \u4e0d\u5305\u542b\u5c5e\u6027 '" + property + "'\uff0c\u6216\u8be5\u5c5e\u6027\u88ab@Transient\u6ce8\u91ca\uff01");
                }
                this.selectColumns.add(this.propertyMap.get(property).getColumn());
            }
        }
        return this;
    }

    public void or(Criteria<T> criteria) {
        criteria.setAndOr("or");
        this.oredCriteria.add(criteria);
    }

    public Criteria<T> or() {
        Criteria<T> criteria = this.createCriteriaInternal();
        criteria.setAndOr("or");
        this.oredCriteria.add(criteria);
        return criteria;
    }

    public void and(Criteria<T> criteria) {
        criteria.setAndOr("and");
        this.oredCriteria.add(criteria);
    }

    public Criteria<T> and() {
        Criteria<T> criteria = this.createCriteriaInternal();
        criteria.setAndOr("and");
        this.oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria<T> createCriteria() {
        Criteria<T> criteria = this.createCriteriaInternal();
        if (this.oredCriteria.isEmpty()) {
            criteria.setAndOr("and");
            this.oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria<T> createCriteriaInternal() {
        return new Criteria(this.propertyMap, this.exists, this.notNull);
    }

    public void clear() {
        this.oredCriteria.clear();
        this.orderByClause = null;
        this.distinct = false;
    }

    public Map<String, EntityColumn> getPropertyMap() {
        return this.propertyMap;
    }

    public String getCountColumn() {
        return this.countColumn;
    }

    @Override
    public String getDynamicTableName() {
        return this.tableName;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public List<Criteria<T>> getOredCriteria() {
        return this.oredCriteria;
    }

    public Set<String> getSelectColumns() {
        if ((this.selectColumns == null || this.selectColumns.size() <= 0) && this.excludeColumns != null && this.excludeColumns.size() > 0) {
            Collection<EntityColumn> entityColumns = this.propertyMap.values();
            this.selectColumns = new LinkedHashSet<String>(entityColumns.size() - this.excludeColumns.size());
            for (EntityColumn column : entityColumns) {
                if (this.excludeColumns.contains(column.getColumn())) continue;
                this.selectColumns.add(column.getColumn());
            }
        }
        return this.selectColumns;
    }

    protected String getColumnCache(SFunction<T, ?> column) {
        LambdaMeta meta = LambdaUtils.extract(column);
        return PropertyNamer.methodToProperty((String)meta.getImplMethodName());
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public void setCountProperty(SFunction<T, ?> column) {
        this.setCountProperty(this.getColumnCache(column));
    }

    public void setCountProperty(String property) {
        if (this.propertyMap.containsKey(property)) {
            this.countColumn = this.propertyMap.get(property).getColumn();
        }
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public static class OrderBy<T> {
        protected Map<String, EntityColumn> propertyMap;
        private Condition<T> example;
        private Boolean isProperty;

        public OrderBy(Condition<T> example, Map<String, EntityColumn> propertyMap) {
            this.example = example;
            this.propertyMap = propertyMap;
        }

        private String property(String property) {
            if (StringUtil.isEmpty(property) || StringUtil.isEmpty(property.trim())) {
                throw new MapperException("\u63a5\u6536\u7684property\u4e3a\u7a7a\uff01");
            }
            if (!this.propertyMap.containsKey(property = property.trim())) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return this.propertyMap.get(property).getColumn();
        }

        public OrderBy<T> orderBy(String property) {
            String column = this.property(property);
            if (column == null) {
                this.isProperty = false;
                return this;
            }
            if (StringUtil.isNotEmpty(this.example.getOrderByClause())) {
                this.example.setOrderByClause(this.example.getOrderByClause() + "," + column);
            } else {
                this.example.setOrderByClause(column);
            }
            this.isProperty = true;
            return this;
        }

        public OrderBy<T> desc() {
            if (this.isProperty.booleanValue()) {
                this.example.setOrderByClause(this.example.getOrderByClause() + " DESC");
                this.isProperty = false;
            }
            return this;
        }

        public OrderBy<T> asc() {
            if (this.isProperty.booleanValue()) {
                this.example.setOrderByClause(this.example.getOrderByClause() + " ASC");
                this.isProperty = false;
            }
            return this;
        }
    }

    public static class Builder<T> {
        private final Class<T> entityClass;
        protected EntityTable table;
        protected Map<String, EntityColumn> propertyMap;
        private StringBuilder orderByClause;
        private boolean distinct;
        private boolean exists;
        private boolean notNull;
        private boolean forUpdate;
        private Set<String> selectColumns;
        private Set<String> excludeColumns;
        private String countColumn;
        private List<Sqls.Criteria> sqlsCriteria;
        private List<Criteria<T>> exampleCriterias;
        private String tableName;

        public Builder(Class<T> entityClass) {
            this(entityClass, true);
        }

        public Builder(Class<T> entityClass, boolean exists) {
            this(entityClass, exists, false);
        }

        public Builder(Class<T> entityClass, boolean exists, boolean notNull) {
            this.entityClass = entityClass;
            this.exists = exists;
            this.notNull = notNull;
            this.orderByClause = new StringBuilder();
            this.table = EntityHelper.getEntityTable(entityClass);
            this.propertyMap = this.table.getPropertyMap();
            this.sqlsCriteria = new ArrayList<Sqls.Criteria>(2);
        }

        public Builder<T> distinct() {
            return this.setDistinct(true);
        }

        public Builder<T> forUpdate() {
            return this.setForUpdate(true);
        }

        public Builder<T> selectDistinct(String ... properties) {
            this.select(properties);
            this.distinct = true;
            return this;
        }

        public Builder<T> select(String ... properties) {
            if (properties != null && properties.length > 0) {
                if (this.selectColumns == null) {
                    this.selectColumns = new LinkedHashSet<String>();
                }
                for (String property : properties) {
                    if (!this.propertyMap.containsKey(property)) {
                        throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
                    }
                    this.selectColumns.add(this.propertyMap.get(property).getColumn());
                }
            }
            return this;
        }

        public Builder<T> notSelect(String ... properties) {
            if (properties != null && properties.length > 0) {
                if (this.excludeColumns == null) {
                    this.excludeColumns = new LinkedHashSet<String>();
                }
                for (String property : properties) {
                    if (!this.propertyMap.containsKey(property)) {
                        throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
                    }
                    this.excludeColumns.add(this.propertyMap.get(property).getColumn());
                }
            }
            return this;
        }

        public Builder<T> from(String tableName) {
            return this.setTableName(tableName);
        }

        public Builder<T> where(Sqls sqls) {
            Sqls.Criteria criteria = sqls.getCriteria();
            criteria.setAndOr("and");
            this.sqlsCriteria.add(criteria);
            return this;
        }

        public Builder<T> where(SqlsCriteria sqls) {
            Sqls.Criteria criteria = sqls.getCriteria();
            criteria.setAndOr("and");
            this.sqlsCriteria.add(criteria);
            return this;
        }

        public Builder<T> andWhere(Sqls sqls) {
            Sqls.Criteria criteria = sqls.getCriteria();
            criteria.setAndOr("and");
            this.sqlsCriteria.add(criteria);
            return this;
        }

        public Builder<T> andWhere(SqlsCriteria sqls) {
            Sqls.Criteria criteria = sqls.getCriteria();
            criteria.setAndOr("and");
            this.sqlsCriteria.add(criteria);
            return this;
        }

        public Builder<T> orWhere(Sqls sqls) {
            Sqls.Criteria criteria = sqls.getCriteria();
            criteria.setAndOr("or");
            this.sqlsCriteria.add(criteria);
            return this;
        }

        public Builder<T> orWhere(SqlsCriteria sqls) {
            Sqls.Criteria criteria = sqls.getCriteria();
            criteria.setAndOr("or");
            this.sqlsCriteria.add(criteria);
            return this;
        }

        public Builder<T> orderBy(String ... properties) {
            return this.orderByAsc(properties);
        }

        public Builder<T> orderByAsc(String ... properties) {
            this.contactOrderByClause(" Asc", properties);
            return this;
        }

        public Builder<T> orderByDesc(String ... properties) {
            this.contactOrderByClause(" Desc", properties);
            return this;
        }

        private void contactOrderByClause(String order, String ... properties) {
            StringBuilder columns = new StringBuilder();
            for (String property : properties) {
                String column = this.propertyforOderBy(property);
                if (column == null) continue;
                columns.append(",").append(column).append(order);
            }
            if (columns.length() > 0) {
                this.orderByClause.append((CharSequence)columns);
            }
        }

        public Condition<T> build() {
            this.exampleCriterias = new ArrayList<Criteria<T>>();
            for (Sqls.Criteria criteria : this.sqlsCriteria) {
                Criteria exampleCriteria = new Criteria(this.propertyMap, this.exists, this.notNull);
                exampleCriteria.setAndOr(criteria.getAndOr());
                for (Sqls.Criterion criterion : criteria.getCriterions()) {
                    String condition = criterion.getCondition();
                    String andOr = criterion.getAndOr();
                    String property = criterion.getProperty();
                    Object[] values = criterion.getValues();
                    this.transformCriterion(exampleCriteria, condition, property, values, andOr);
                }
                this.exampleCriterias.add(exampleCriteria);
            }
            if (this.orderByClause.length() > 0) {
                this.orderByClause = new StringBuilder(this.orderByClause.substring(1, this.orderByClause.length()));
            }
            return new Condition(this);
        }

        private void transformCriterion(Criteria<T> exampleCriteria, String condition, String property, Object[] values, String andOr) {
            if (values.length == 0) {
                if ("and".equals(andOr)) {
                    exampleCriteria.addCriterion(this.column(property) + " " + condition);
                } else {
                    exampleCriteria.addOrCriterion(this.column(property) + " " + condition);
                }
            } else if (values.length == 1) {
                if ("and".equals(andOr)) {
                    exampleCriteria.addCriterion(this.column(property) + " " + condition, values[0], this.property(property));
                } else {
                    exampleCriteria.addOrCriterion(this.column(property) + " " + condition, values[0], this.property(property));
                }
            } else if (values.length == 2) {
                if ("and".equals(andOr)) {
                    exampleCriteria.addCriterion(this.column(property) + " " + condition, values[0], values[1], this.property(property));
                } else {
                    exampleCriteria.addOrCriterion(this.column(property) + " " + condition, values[0], values[1], this.property(property));
                }
            }
        }

        private String column(String property) {
            if (this.propertyMap.containsKey(property)) {
                return this.propertyMap.get(property).getColumn();
            }
            if (this.exists) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return null;
        }

        private String property(String property) {
            if (this.propertyMap.containsKey(property)) {
                return property;
            }
            if (this.exists) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return null;
        }

        private String propertyforOderBy(String property) {
            if (StringUtil.isEmpty(property) || StringUtil.isEmpty(property.trim())) {
                throw new MapperException("\u63a5\u6536\u7684property\u4e3a\u7a7a\uff01");
            }
            if (!this.propertyMap.containsKey(property = property.trim())) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return this.propertyMap.get(property).getColumn();
        }

        public Builder<T> setDistinct(boolean distinct) {
            this.distinct = distinct;
            return this;
        }

        public Builder<T> setForUpdate(boolean forUpdate) {
            this.forUpdate = forUpdate;
            return this;
        }

        public Builder<T> setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }
    }

    public static class Criteria<T>
    extends GeneratedCriteria<T> {
        protected Criteria(Map<String, EntityColumn> propertyMap, boolean exists, boolean notNull) {
            super(propertyMap, exists, notNull);
        }
    }

    public static class Criterion {
        private String condition;
        private Object value;
        private Object secondValue;
        private String andOr;
        private boolean noValue;
        private boolean singleValue;
        private boolean betweenValue;
        private boolean listValue;
        private String typeHandler;

        protected Criterion(String condition) {
            this(condition, false);
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            this(condition, value, typeHandler, false);
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null, false);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            this(condition, value, secondValue, typeHandler, false);
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null, false);
        }

        protected Criterion(String condition, boolean isOr) {
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
            this.andOr = isOr ? "or" : "and";
        }

        protected Criterion(String condition, Object value, String typeHandler, boolean isOr) {
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            String string = this.andOr = isOr ? "or" : "and";
            if (value instanceof Collection) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value, boolean isOr) {
            this(condition, value, null, isOr);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler, boolean isOr) {
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
            this.andOr = isOr ? "or" : "and";
        }

        protected Criterion(String condition, Object value, Object secondValue, boolean isOr) {
            this(condition, value, secondValue, null, isOr);
        }

        public String getAndOr() {
            return this.andOr;
        }

        public void setAndOr(String andOr) {
            this.andOr = andOr;
        }

        public String getCondition() {
            return this.condition;
        }

        public Object getSecondValue() {
            return this.secondValue;
        }

        public String getTypeHandler() {
            return this.typeHandler;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isBetweenValue() {
            return this.betweenValue;
        }

        public boolean isListValue() {
            return this.listValue;
        }

        public boolean isNoValue() {
            return this.noValue;
        }

        public boolean isSingleValue() {
            return this.singleValue;
        }
    }

    protected static abstract class GeneratedCriteria<T> {
        protected List<Criterion> criteria;
        protected boolean exists;
        protected boolean notNull;
        protected String andOr;
        protected Map<String, EntityColumn> propertyMap;

        protected GeneratedCriteria(Map<String, EntityColumn> propertyMap, boolean exists, boolean notNull) {
            this.exists = exists;
            this.notNull = notNull;
            this.criteria = new ArrayList<Criterion>();
            this.propertyMap = propertyMap;
        }

        private String column(String property) {
            if (this.propertyMap.containsKey(property)) {
                return this.propertyMap.get(property).getColumn();
            }
            if (this.exists) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return null;
        }

        private String property(String property) {
            if (this.propertyMap.containsKey(property)) {
                return property;
            }
            if (this.exists) {
                throw new MapperException("\u5f53\u524d\u5b9e\u4f53\u7c7b\u4e0d\u5305\u542b\u540d\u4e3a" + property + "\u7684\u5c5e\u6027!");
            }
            return null;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new MapperException("Value for condition cannot be null");
            }
            if (condition.startsWith("null")) {
                return;
            }
            this.criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                if (this.notNull) {
                    throw new MapperException("Value for " + property + " cannot be null");
                }
                return;
            }
            if (property == null) {
                return;
            }
            this.criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                if (this.notNull) {
                    throw new MapperException("Between values for " + property + " cannot be null");
                }
                return;
            }
            if (property == null) {
                return;
            }
            this.criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addOrCriterion(String condition) {
            if (condition == null) {
                throw new MapperException("Value for condition cannot be null");
            }
            if (condition.startsWith("null")) {
                return;
            }
            this.criteria.add(new Criterion(condition, true));
        }

        protected void addOrCriterion(String condition, Object value, String property) {
            if (value == null) {
                if (this.notNull) {
                    throw new MapperException("Value for " + property + " cannot be null");
                }
                return;
            }
            if (property == null) {
                return;
            }
            this.criteria.add(new Criterion(condition, value, true));
        }

        protected void addOrCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                if (this.notNull) {
                    throw new MapperException("Between values for " + property + " cannot be null");
                }
                return;
            }
            if (property == null) {
                return;
            }
            this.criteria.add(new Criterion(condition, value1, value2, true));
        }

        protected String getColumnCache(SFunction<T, ?> column) {
            LambdaMeta meta = LambdaUtils.extract(column);
            return PropertyNamer.methodToProperty((String)meta.getImplMethodName());
        }

        public Criteria<T> andIsNull(SFunction<T, ?> column) {
            this.addCriterion(this.column(this.getColumnCache(column)) + " is null");
            return (Criteria)this;
        }

        public Criteria<T> andIsNotNull(SFunction<T, ?> column) {
            this.addCriterion(this.column(this.getColumnCache(column)) + " is not null");
            return (Criteria)this;
        }

        public Criteria<T> andEqualTo(SFunction<T, ?> column, Object value) {
            this.addCriterion(this.column(this.getColumnCache(column)) + " =", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> andNotEqualTo(SFunction<T, ?> column, Object value) {
            this.addCriterion(this.column(this.getColumnCache(column)) + " <>", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> andGreaterThan(SFunction<T, ?> column, Object value) {
            this.addCriterion(this.column(this.getColumnCache(column)) + " >", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> andGreaterThanOrEqualTo(SFunction<T, ?> column, Object value) {
            this.addCriterion(this.column(this.getColumnCache(column)) + " >=", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> andLessThan(SFunction<T, ?> column, Object value) {
            this.addCriterion(this.column(this.getColumnCache(column)) + " <", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> andLessThanOrEqualTo(SFunction<T, ?> column, Object value) {
            this.addCriterion(this.column(this.getColumnCache(column)) + " <=", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> andIn(SFunction<T, ?> column, Iterable<?> values) {
            this.addCriterion(this.column(this.getColumnCache(column)) + " in", values, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> andNotIn(SFunction<T, ?> column, Iterable<?> values) {
            this.addCriterion(this.column(this.getColumnCache(column)) + " not in", values, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> andBetween(SFunction<T, ?> column, Object value1, Object value2) {
            this.addCriterion(this.column(this.getColumnCache(column)) + " between", value1, value2, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> andNotBetween(SFunction<T, ?> column, Object value1, Object value2) {
            this.addCriterion(this.column(this.getColumnCache(column)) + " not between", value1, value2, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> andLike(SFunction<T, ?> column, String value) {
            this.addCriterion(this.column(this.getColumnCache(column)) + "  like", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> andNotLike(SFunction<T, ?> column, String value) {
            this.addCriterion(this.column(this.getColumnCache(column)) + "  not like", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> andIsNull(String property) {
            this.addCriterion(this.column(property) + " is null");
            return (Criteria)this;
        }

        public Criteria<T> andIsNotNull(String property) {
            this.addCriterion(this.column(property) + " is not null");
            return (Criteria)this;
        }

        public Criteria<T> andEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " =", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> andNotEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " <>", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> andGreaterThan(String property, Object value) {
            this.addCriterion(this.column(property) + " >", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> andGreaterThanOrEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " >=", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> andLessThan(String property, Object value) {
            this.addCriterion(this.column(property) + " <", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> andLessThanOrEqualTo(String property, Object value) {
            this.addCriterion(this.column(property) + " <=", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> andIn(String property, Iterable<?> values) {
            this.addCriterion(this.column(property) + " in", values, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> andNotIn(String property, Iterable<?> values) {
            this.addCriterion(this.column(property) + " not in", values, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> andBetween(String property, Object value1, Object value2) {
            this.addCriterion(this.column(property) + " between", value1, value2, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> andNotBetween(String property, Object value1, Object value2) {
            this.addCriterion(this.column(property) + " not between", value1, value2, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> andLike(String property, String value) {
            this.addCriterion(this.column(property) + "  like", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> andNotLike(String property, String value) {
            this.addCriterion(this.column(property) + "  not like", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> andCondition(String condition) {
            this.addCriterion(condition);
            return (Criteria)this;
        }

        public Criteria<T> andCondition(String condition, Object value) {
            this.criteria.add(new Criterion(condition, value));
            return (Criteria)this;
        }

        public Criteria<T> andEqualTo(Object param) {
            String[] properties;
            if (param == null) {
                return (Criteria)this;
            }
            MetaObject metaObject = MetaObjectUtil.forObject(param);
            for (String property : properties = metaObject.getGetterNames()) {
                Object value;
                if (this.propertyMap.get(property) == null || (value = metaObject.getValue(property)) == null) continue;
                this.andEqualTo(property, value);
            }
            return (Criteria)this;
        }

        public Criteria<T> andAllEqualTo(Object param) {
            String[] properties;
            MetaObject metaObject = MetaObjectUtil.forObject(param);
            for (String property : properties = metaObject.getGetterNames()) {
                if (this.propertyMap.get(property) == null) continue;
                Object value = metaObject.getValue(property);
                if (value != null) {
                    this.andEqualTo(property, value);
                    continue;
                }
                this.andIsNull(property);
            }
            return (Criteria)this;
        }

        public Criteria<T> orIsNull(SFunction<T, ?> column) {
            this.addOrCriterion(this.column(this.getColumnCache(column)) + " is null");
            return (Criteria)this;
        }

        public Criteria<T> orIsNotNull(SFunction<T, ?> column) {
            this.addOrCriterion(this.column(this.getColumnCache(column)) + " is not null");
            return (Criteria)this;
        }

        public Criteria<T> orEqualTo(SFunction<T, ?> column, Object value) {
            this.addOrCriterion(this.column(this.getColumnCache(column)) + " =", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> orNotEqualTo(SFunction<T, ?> column, Object value) {
            this.addOrCriterion(this.column(this.getColumnCache(column)) + " <>", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> orGreaterThan(SFunction<T, ?> column, Object value) {
            this.addOrCriterion(this.column(this.getColumnCache(column)) + " >", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> orGreaterThanOrEqualTo(SFunction<T, ?> column, Object value) {
            this.addOrCriterion(this.column(this.getColumnCache(column)) + " >=", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> orLessThan(SFunction<T, ?> column, Object value) {
            this.addOrCriterion(this.column(this.getColumnCache(column)) + " <", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> orLessThanOrEqualTo(SFunction<T, ?> column, Object value) {
            this.addOrCriterion(this.column(this.getColumnCache(column)) + " <=", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> orIn(SFunction<T, ?> column, Iterable<?> values) {
            this.addOrCriterion(this.column(this.getColumnCache(column)) + " in", values, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> orNotIn(SFunction<T, ?> column, Iterable<?> values) {
            this.addOrCriterion(this.column(this.getColumnCache(column)) + " not in", values, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> orBetween(SFunction<T, ?> column, Object value1, Object value2) {
            this.addOrCriterion(this.column(this.getColumnCache(column)) + " between", value1, value2, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> orNotBetween(SFunction<T, ?> column, Object value1, Object value2) {
            this.addOrCriterion(this.column(this.getColumnCache(column)) + " not between", value1, value2, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> orLike(SFunction<T, ?> column, String value) {
            this.addOrCriterion(this.column(this.getColumnCache(column)) + "  like", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> orNotLike(SFunction<T, ?> column, String value) {
            this.addOrCriterion(this.column(this.getColumnCache(column)) + "  not like", value, this.property(this.getColumnCache(column)));
            return (Criteria)this;
        }

        public Criteria<T> orIsNull(String property) {
            this.addOrCriterion(this.column(property) + " is null");
            return (Criteria)this;
        }

        public Criteria<T> orIsNotNull(String property) {
            this.addOrCriterion(this.column(property) + " is not null");
            return (Criteria)this;
        }

        public Criteria<T> orEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " =", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> orNotEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " <>", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> orGreaterThan(String property, Object value) {
            this.addOrCriterion(this.column(property) + " >", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> orGreaterThanOrEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " >=", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> orLessThan(String property, Object value) {
            this.addOrCriterion(this.column(property) + " <", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> orLessThanOrEqualTo(String property, Object value) {
            this.addOrCriterion(this.column(property) + " <=", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> orIn(String property, Iterable values) {
            this.addOrCriterion(this.column(property) + " in", values, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> orNotIn(String property, Iterable values) {
            this.addOrCriterion(this.column(property) + " not in", values, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> orBetween(String property, Object value1, Object value2) {
            this.addOrCriterion(this.column(property) + " between", value1, value2, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> orNotBetween(String property, Object value1, Object value2) {
            this.addOrCriterion(this.column(property) + " not between", value1, value2, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> orLike(String property, String value) {
            this.addOrCriterion(this.column(property) + "  like", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> orNotLike(String property, String value) {
            this.addOrCriterion(this.column(property) + "  not like", value, this.property(property));
            return (Criteria)this;
        }

        public Criteria<T> orCondition(String condition) {
            this.addOrCriterion(condition);
            return (Criteria)this;
        }

        public Criteria<T> orCondition(String condition, Object value) {
            this.criteria.add(new Criterion(condition, value, true));
            return (Criteria)this;
        }

        public Criteria<T> orEqualTo(Object param) {
            String[] properties;
            MetaObject metaObject = MetaObjectUtil.forObject(param);
            for (String property : properties = metaObject.getGetterNames()) {
                Object value;
                if (this.propertyMap.get(property) == null || (value = metaObject.getValue(property)) == null) continue;
                this.orEqualTo(property, value);
            }
            return (Criteria)this;
        }

        public Criteria<T> orAllEqualTo(Object param) {
            String[] properties;
            MetaObject metaObject = MetaObjectUtil.forObject(param);
            for (String property : properties = metaObject.getGetterNames()) {
                if (this.propertyMap.get(property) == null) continue;
                Object value = metaObject.getValue(property);
                if (value != null) {
                    this.orEqualTo(property, value);
                    continue;
                }
                this.orIsNull(property);
            }
            return (Criteria)this;
        }

        public List<Criterion> getAllCriteria() {
            return this.criteria;
        }

        public String getAndOr() {
            return this.andOr;
        }

        public void setAndOr(String andOr) {
            this.andOr = andOr;
        }

        public List<Criterion> getCriteria() {
            return this.criteria;
        }

        public boolean isValid() {
            return !this.criteria.isEmpty();
        }
    }
}

