/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.mapper.mapperhelper.resolve;

import cn.lm.mybatis.mapper.MapperException;
import cn.lm.mybatis.mapper.annotation.ColumnType;
import cn.lm.mybatis.mapper.annotation.KeySql;
import cn.lm.mybatis.mapper.annotation.NameStyle;
import cn.lm.mybatis.mapper.annotation.Order;
import cn.lm.mybatis.mapper.code.IdentityDialect;
import cn.lm.mybatis.mapper.code.ORDER;
import cn.lm.mybatis.mapper.code.Style;
import cn.lm.mybatis.mapper.entity.Config;
import cn.lm.mybatis.mapper.entity.EntityColumn;
import cn.lm.mybatis.mapper.entity.EntityField;
import cn.lm.mybatis.mapper.entity.EntityTable;
import cn.lm.mybatis.mapper.genid.GenId;
import cn.lm.mybatis.mapper.gensql.GenSql;
import cn.lm.mybatis.mapper.mapperhelper.FieldHelper;
import cn.lm.mybatis.mapper.mapperhelper.resolve.EntityResolve;
import cn.lm.mybatis.mapper.util.SimpleTypeUtil;
import cn.lm.mybatis.mapper.util.SqlReservedWords;
import cn.lm.mybatis.mapper.util.StringUtil;
import jakarta.persistence.Column;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.UnknownTypeHandler;

public class DefaultEntityResolve
implements EntityResolve {
    private final Log log = LogFactory.getLog(DefaultEntityResolve.class);

    @Override
    public EntityTable resolveEntity(Class<?> entityClass, Config config) {
        Table table;
        Style style = config.getStyle();
        if (entityClass.isAnnotationPresent(NameStyle.class)) {
            NameStyle nameStyle = entityClass.getAnnotation(NameStyle.class);
            style = nameStyle.value();
        }
        EntityTable entityTable = null;
        if (entityClass.isAnnotationPresent(Table.class) && !"".equals((table = entityClass.getAnnotation(Table.class)).name())) {
            entityTable = new EntityTable(entityClass);
            entityTable.setTable(table);
        }
        if (entityTable == null) {
            entityTable = new EntityTable(entityClass);
            String tableName = StringUtil.convertByStyle(entityClass.getSimpleName(), style);
            if (StringUtil.isNotEmpty(config.getWrapKeyword()) && SqlReservedWords.containsWord(tableName)) {
                tableName = MessageFormat.format(config.getWrapKeyword(), tableName);
            }
            entityTable.setName(tableName);
        }
        entityTable.setEntityClassColumns(new LinkedHashSet<EntityColumn>());
        entityTable.setEntityClassPKColumns(new LinkedHashSet<EntityColumn>());
        List<EntityField> fields = null;
        fields = config.isEnableMethodAnnotation() ? FieldHelper.getAll(entityClass) : FieldHelper.getFields(entityClass);
        for (EntityField field : fields) {
            if (config.isUseSimpleType() && (!config.isUseSimpleType() || !SimpleTypeUtil.isSimpleType(field.getJavaType())) && !field.isAnnotationPresent(Column.class) && !field.isAnnotationPresent(ColumnType.class) && (!config.isEnumAsSimpleType() || !Enum.class.isAssignableFrom(field.getJavaType()))) continue;
            this.processField(entityTable, field, config, style);
        }
        if (entityTable.getEntityClassPKColumns().size() == 0) {
            entityTable.setEntityClassPKColumns(entityTable.getEntityClassColumns());
        }
        entityTable.initPropertyMap();
        return entityTable;
    }

    protected void processField(EntityTable entityTable, EntityField field, Config config, Style style) {
        if (field.isAnnotationPresent(Transient.class)) {
            return;
        }
        EntityColumn entityColumn = new EntityColumn(entityTable);
        entityColumn.setUseJavaType(config.isUseJavaType());
        entityColumn.setEntityField(field);
        if (field.isAnnotationPresent(Id.class)) {
            entityColumn.setId(true);
        }
        String columnName = null;
        if (field.isAnnotationPresent(Column.class)) {
            Column column = field.getAnnotation(Column.class);
            columnName = column.name();
            entityColumn.setUpdatable(column.updatable());
            entityColumn.setInsertable(column.insertable());
        }
        if (field.isAnnotationPresent(ColumnType.class)) {
            ColumnType columnType = field.getAnnotation(ColumnType.class);
            entityColumn.setBlob(columnType.isBlob());
            if (StringUtil.isEmpty(columnName) && StringUtil.isNotEmpty(columnType.column())) {
                columnName = columnType.column();
            }
            if (columnType.jdbcType() != JdbcType.UNDEFINED) {
                entityColumn.setJdbcType(columnType.jdbcType());
            }
            if (columnType.typeHandler() != UnknownTypeHandler.class) {
                entityColumn.setTypeHandler(columnType.typeHandler());
            }
        }
        if (StringUtil.isEmpty(columnName)) {
            columnName = StringUtil.convertByStyle(field.getName(), style);
        }
        if (StringUtil.isNotEmpty(config.getWrapKeyword()) && SqlReservedWords.containsWord(columnName)) {
            columnName = MessageFormat.format(config.getWrapKeyword(), columnName);
        }
        entityColumn.setProperty(field.getName());
        entityColumn.setColumn(columnName);
        entityColumn.setJavaType(field.getJavaType());
        if (field.getJavaType().isPrimitive()) {
            this.log.warn("\u901a\u7528 Mapper \u8b66\u544a\u4fe1\u606f: <[" + entityColumn + "]> \u4f7f\u7528\u4e86\u57fa\u672c\u7c7b\u578b\uff0c\u57fa\u672c\u7c7b\u578b\u5728\u52a8\u6001 SQL \u4e2d\u7531\u4e8e\u5b58\u5728\u9ed8\u8ba4\u503c\uff0c\u56e0\u6b64\u4efb\u4f55\u65f6\u5019\u90fd\u4e0d\u7b49\u4e8e null\uff0c\u5efa\u8bae\u4fee\u6539\u57fa\u672c\u7c7b\u578b\u4e3a\u5bf9\u5e94\u7684\u5305\u88c5\u7c7b\u578b!");
        }
        this.processOrderBy(entityTable, field, entityColumn);
        this.processKeyGenerator(entityTable, field, entityColumn);
        entityTable.getEntityClassColumns().add(entityColumn);
        if (entityColumn.isId()) {
            entityTable.getEntityClassPKColumns().add(entityColumn);
        }
    }

    protected void processOrderBy(EntityTable entityTable, EntityField field, EntityColumn entityColumn) {
        String orderBy = "";
        if (field.isAnnotationPresent(OrderBy.class)) {
            orderBy = field.getAnnotation(OrderBy.class).value();
            if ("".equals(orderBy)) {
                orderBy = "ASC";
            }
            this.log.warn(OrderBy.class + " is outdated, use " + Order.class + " instead!");
        }
        if (field.isAnnotationPresent(Order.class)) {
            Order order = field.getAnnotation(Order.class);
            orderBy = "".equals(order.value()) && "".equals(orderBy) ? "ASC" : order.value();
            entityColumn.setOrderPriority(order.priority());
        }
        if (StringUtil.isNotEmpty(orderBy)) {
            entityColumn.setOrderBy(orderBy);
        }
    }

    protected void processKeyGenerator(EntityTable entityTable, EntityField field, EntityColumn entityColumn) {
        if (field.isAnnotationPresent(KeySql.class)) {
            this.processKeySql(entityTable, entityColumn, field.getAnnotation(KeySql.class));
        } else if (field.isAnnotationPresent(GeneratedValue.class)) {
            this.processGeneratedValue(entityTable, entityColumn, field.getAnnotation(GeneratedValue.class));
        }
    }

    protected void processGeneratedValue(EntityTable entityTable, EntityColumn entityColumn, GeneratedValue generatedValue) {
        if ("JDBC".equals(generatedValue.generator())) {
            entityColumn.setIdentity(true);
            entityColumn.setGenerator("JDBC");
            entityTable.setKeyProperties(entityColumn.getProperty());
            entityTable.setKeyColumns(entityColumn.getColumn());
        } else if (generatedValue.strategy() == GenerationType.IDENTITY) {
            entityColumn.setIdentity(true);
            if (!"".equals(generatedValue.generator())) {
                String generator = null;
                IdentityDialect identityDialect = IdentityDialect.getDatabaseDialect(generatedValue.generator());
                generator = identityDialect != null ? identityDialect.getIdentityRetrievalStatement() : generatedValue.generator();
                entityColumn.setGenerator(generator);
            }
        } else {
            throw new MapperException(entityColumn.getProperty() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u53ea\u5141\u8bb8\u4ee5\u4e0b\u51e0\u79cd\u5f62\u5f0f:\n1.useGeneratedKeys\u7684@GeneratedValue(generator=\\\"JDBC\\\")  \n2.\u7c7b\u4f3cmysql\u6570\u636e\u5e93\u7684@GeneratedValue(strategy=GenerationType.IDENTITY[,generator=\"Mysql\"])");
        }
    }

    protected void processKeySql(EntityTable entityTable, EntityColumn entityColumn, KeySql keySql) {
        if (keySql.useGeneratedKeys()) {
            entityColumn.setIdentity(true);
            entityColumn.setGenerator("JDBC");
            entityTable.setKeyProperties(entityColumn.getProperty());
            entityTable.setKeyColumns(entityColumn.getColumn());
        } else if (keySql.dialect() == IdentityDialect.DEFAULT) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(ORDER.AFTER);
        } else if (keySql.dialect() != IdentityDialect.NULL) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(ORDER.AFTER);
            entityColumn.setGenerator(keySql.dialect().getIdentityRetrievalStatement());
        } else if (StringUtil.isNotEmpty(keySql.sql())) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(keySql.order());
            entityColumn.setGenerator(keySql.sql());
        } else if (keySql.genSql() != GenSql.NULL.class) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(keySql.order());
            try {
                GenSql genSql = keySql.genSql().newInstance();
                entityColumn.setGenerator(genSql.genSql(entityTable, entityColumn));
            }
            catch (Exception e) {
                this.log.error("\u5b9e\u4f8b\u5316 GenSql \u5931\u8d25: " + e, (Throwable)e);
                throw new MapperException("\u5b9e\u4f8b\u5316 GenSql \u5931\u8d25: " + e, e);
            }
        } else if (keySql.genId() != GenId.NULL.class) {
            entityColumn.setIdentity(false);
            entityColumn.setGenIdClass(keySql.genId());
        } else {
            throw new MapperException(entityTable.getEntityClass().getName() + " \u7c7b\u4e2d\u7684 @KeySql \u6ce8\u89e3\u914d\u7f6e\u65e0\u6548!");
        }
    }
}

