/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.mapper.util;

import cn.lm.mybatis.mapper.code.Style;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static Pattern UNDERLINE_TO_CAMELHUMP_PATTERN = Pattern.compile("_[a-z]");
    public static final String SLASH = "/";
    public static final String DOT = ".";
    public static final String SEMICOLON = ";";
    public static final String AT = "@";

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtil.isBlank(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        if (cs != null) {
            int length = cs.length();
            for (int i = 0; i < length; ++i) {
                if (Character.isWhitespace(cs.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkValNull(Object object) {
        return !StringUtil.checkValNotNull(object);
    }

    public static boolean checkValNotNull(Object object) {
        if (object instanceof CharSequence) {
            return StringUtil.isNotEmpty((CharSequence)object);
        }
        return object != null;
    }

    public static String convertByStyle(String str, Style style) {
        switch (style) {
            case camelhump: {
                return StringUtil.camelhumpToUnderline(str);
            }
            case uppercase: {
                return str.toUpperCase();
            }
            case lowercase: {
                return str.toLowerCase();
            }
            case camelhumpAndLowercase: {
                return StringUtil.camelhumpToUnderline(str).toLowerCase();
            }
            case camelhumpAndUppercase: {
                return StringUtil.camelhumpToUnderline(str).toUpperCase();
            }
        }
        return str;
    }

    public static String camelhumpToUnderline(String str) {
        char[] chars = str.toCharArray();
        int size = chars.length;
        StringBuilder sb = new StringBuilder(size * 3 / 2 + 1);
        for (int i = 0; i < size; ++i) {
            char c = chars[i];
            if (StringUtil.isUppercaseAlpha(c)) {
                sb.append('_').append(StringUtil.toLowerAscii(c));
                continue;
            }
            sb.append(c);
        }
        return sb.charAt(0) == '_' ? sb.substring(1) : sb.toString();
    }

    public static String underlineToCamelhump(String str) {
        Matcher matcher = UNDERLINE_TO_CAMELHUMP_PATTERN.matcher(str);
        StringBuilder builder = new StringBuilder(str);
        int i = 0;
        while (matcher.find()) {
            builder.replace(matcher.start() - i, matcher.end() - i, matcher.group().substring(1).toUpperCase());
            ++i;
        }
        if (Character.isUpperCase(builder.charAt(0))) {
            builder.replace(0, 1, String.valueOf(Character.toLowerCase(builder.charAt(0))));
        }
        return builder.toString();
    }

    public static boolean isUppercaseAlpha(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLowercaseAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static char toUpperAscii(char c) {
        if (StringUtil.isLowercaseAlpha(c)) {
            c = (char)(c - 32);
        }
        return c;
    }

    public static char toLowerAscii(char c) {
        if (StringUtil.isUppercaseAlpha(c)) {
            c = (char)(c + 32);
        }
        return c;
    }
}

