/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.mapper.entity;

import cn.lm.mybatis.mapper.code.ORDER;
import cn.lm.mybatis.mapper.entity.EntityField;
import cn.lm.mybatis.mapper.entity.EntityTable;
import cn.lm.mybatis.mapper.genid.GenId;
import cn.lm.mybatis.mapper.util.StringUtil;
import java.util.Objects;
import org.apache.ibatis.type.JdbcType;

public class EntityColumn {
    private EntityTable table;
    private String property;
    private String column;
    private Class<?> javaType;
    private JdbcType jdbcType;
    private Class<?> typeHandler;
    private boolean id = false;
    private boolean identity = false;
    private Class<? extends GenId> genIdClass;
    private boolean blob;
    private String generator;
    private String orderBy;
    private int orderPriority;
    private boolean insertable = true;
    private boolean updatable = true;
    private ORDER order = ORDER.DEFAULT;
    private boolean useJavaType;
    private EntityField entityField;

    public EntityColumn() {
    }

    public EntityColumn(EntityTable table) {
        this.table = table;
    }

    public String getColumnEqualsHolder(String entityName) {
        return this.column + " = " + this.getColumnHolder(entityName);
    }

    public String getColumnHolder(String entityName) {
        return this.getColumnHolder(entityName, null);
    }

    public String getColumnHolder(String entityName, String suffix) {
        return this.getColumnHolder(entityName, null, null);
    }

    public String getColumnHolderWithComma(String entityName, String suffix) {
        return this.getColumnHolder(entityName, suffix, ",");
    }

    public String getColumnHolder(String entityName, String suffix, String separator) {
        StringBuffer sb = new StringBuffer("#{");
        if (StringUtil.isNotEmpty(entityName)) {
            sb.append(entityName);
            sb.append(".");
        }
        sb.append(this.property);
        if (StringUtil.isNotEmpty(suffix)) {
            sb.append(suffix);
        }
        if (this.jdbcType != null) {
            sb.append(", jdbcType=");
            sb.append(this.jdbcType.toString());
        }
        if (this.typeHandler != null) {
            sb.append(", typeHandler=");
            sb.append(this.typeHandler.getName());
        }
        if (this.useJavaType && !this.javaType.isArray()) {
            sb.append(", javaType=");
            sb.append(this.javaType.getName());
        }
        sb.append("}");
        if (StringUtil.isNotEmpty(separator)) {
            sb.append(separator);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityColumn that = (EntityColumn)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.identity != that.identity) {
            return false;
        }
        if (!Objects.equals(this.table, that.table)) {
            return false;
        }
        if (!Objects.equals(this.property, that.property)) {
            return false;
        }
        if (!Objects.equals(this.column, that.column)) {
            return false;
        }
        if (!Objects.equals(this.javaType, that.javaType)) {
            return false;
        }
        if (this.jdbcType != that.jdbcType) {
            return false;
        }
        if (!Objects.equals(this.typeHandler, that.typeHandler)) {
            return false;
        }
        if (!Objects.equals(this.generator, that.generator)) {
            return false;
        }
        return Objects.equals(this.orderBy, that.orderBy);
    }

    public int hashCode() {
        int result = this.table != null ? this.table.hashCode() : 0;
        result = 31 * result + (this.property != null ? this.property.hashCode() : 0);
        result = 31 * result + (this.column != null ? this.column.hashCode() : 0);
        result = 31 * result + (this.javaType != null ? this.javaType.hashCode() : 0);
        result = 31 * result + (this.jdbcType != null ? this.jdbcType.hashCode() : 0);
        result = 31 * result + (this.typeHandler != null ? this.typeHandler.hashCode() : 0);
        result = 31 * result + (this.id ? 1 : 0);
        result = 31 * result + (this.identity ? 1 : 0);
        result = 31 * result + (this.generator != null ? this.generator.hashCode() : 0);
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        return result;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getColumnEqualsHolder() {
        return this.getColumnEqualsHolder(null);
    }

    public String getColumnHolder() {
        return this.getColumnHolder(null);
    }

    public EntityField getEntityField() {
        return this.entityField;
    }

    public void setEntityField(EntityField entityField) {
        this.entityField = entityField;
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class<?> javaType) {
        this.javaType = javaType;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(JdbcType jdbcType) {
        this.jdbcType = jdbcType;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public EntityTable getTable() {
        return this.table;
    }

    public void setTable(EntityTable table) {
        this.table = table;
    }

    public Class<?> getTypeHandler() {
        return this.typeHandler;
    }

    public void setTypeHandler(Class<?> typeHandler) {
        this.typeHandler = typeHandler;
    }

    public boolean isId() {
        return this.id;
    }

    public void setId(boolean id) {
        this.id = id;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public void setIdentity(boolean identity) {
        this.identity = identity;
    }

    public Class<? extends GenId> getGenIdClass() {
        return this.genIdClass;
    }

    public void setGenIdClass(Class<? extends GenId> genIdClass) {
        this.genIdClass = genIdClass;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public ORDER getOrder() {
        return this.order;
    }

    public void setOrder(ORDER order) {
        this.order = order;
    }

    public boolean isBlob() {
        return this.blob;
    }

    public void setBlob(boolean blob) {
        this.blob = blob;
    }

    public boolean isUseJavaType() {
        return this.useJavaType;
    }

    public void setUseJavaType(boolean useJavaType) {
        this.useJavaType = useJavaType;
    }

    public int getOrderPriority() {
        return this.orderPriority;
    }

    public void setOrderPriority(int orderPriority) {
        this.orderPriority = orderPriority;
    }

    public String toString() {
        return "EntityColumn{table=" + this.table.getName() + ", property='" + this.property + "', column='" + this.column + "', javaType=" + this.javaType + ", jdbcType=" + this.jdbcType + ", typeHandler=" + this.typeHandler + ", id=" + this.id + ", identity=" + this.identity + ", blob=" + this.blob + ", generator='" + this.generator + "', orderBy='" + this.orderBy + "', orderPriority='" + this.orderPriority + "', insertable=" + this.insertable + ", updatable=" + this.updatable + ", order=" + this.order + "}";
    }
}

