/*
 * Decompiled with CFR 0.152.
 */
package cn.lm.mybatis.mapper.entity;

import cn.lm.mybatis.mapper.MapperException;
import cn.lm.mybatis.mapper.entity.EntityColumn;
import cn.lm.mybatis.mapper.util.StringUtil;
import jakarta.persistence.Table;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;

public class EntityTable {
    public static final Pattern DELIMITER = Pattern.compile("^[`\\[\"]?(.*?)[`\\]\"]?$");
    protected Map<String, EntityColumn> propertyMap;
    private String name;
    private String catalog;
    private String schema;
    private String orderByClause;
    private String baseSelect;
    private LinkedHashSet<EntityColumn> entityClassColumns;
    private LinkedHashSet<EntityColumn> entityClassPKColumns;
    private List<String> keyProperties;
    private List<String> keyColumns;
    private ResultMap resultMap;
    private Class<?> entityClass;

    public EntityTable(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public ResultMap getResultMap(Configuration configuration) {
        if (this.resultMap != null) {
            return this.resultMap;
        }
        if (this.entityClassColumns == null || this.entityClassColumns.size() == 0) {
            return null;
        }
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        for (EntityColumn entityColumn : this.entityClassColumns) {
            String column = entityColumn.getColumn();
            Matcher matcher = DELIMITER.matcher(column);
            if (matcher.find()) {
                column = matcher.group(1);
            }
            ResultMapping.Builder builder = new ResultMapping.Builder(configuration, entityColumn.getProperty(), column, entityColumn.getJavaType());
            if (entityColumn.getJdbcType() != null) {
                builder.jdbcType(entityColumn.getJdbcType());
            }
            if (entityColumn.getTypeHandler() != null) {
                try {
                    builder.typeHandler(this.getInstance(entityColumn.getJavaType(), entityColumn.getTypeHandler()));
                }
                catch (Exception e) {
                    throw new MapperException(e);
                }
            }
            ArrayList<ResultFlag> flags = new ArrayList<ResultFlag>();
            if (entityColumn.isId()) {
                flags.add(ResultFlag.ID);
            }
            builder.flags(flags);
            resultMappings.add(builder.build());
        }
        ResultMap.Builder builder = new ResultMap.Builder(configuration, "BaseMapperResultMap", this.entityClass, resultMappings, Boolean.valueOf(true));
        this.resultMap = builder.build();
        return this.resultMap;
    }

    public void initPropertyMap() {
        this.propertyMap = new HashMap<String, EntityColumn>(this.getEntityClassColumns().size());
        for (EntityColumn column : this.getEntityClassColumns()) {
            this.propertyMap.put(column.getProperty(), column);
        }
    }

    public <T> TypeHandler<T> getInstance(Class<?> javaTypeClass, Class<?> typeHandlerClass) {
        if (javaTypeClass != null) {
            try {
                Constructor<?> c = typeHandlerClass.getConstructor(Class.class);
                return (TypeHandler)c.newInstance(javaTypeClass);
            }
            catch (NoSuchMethodException c) {
            }
            catch (Exception e) {
                throw new TypeException("Failed invoking constructor for handler " + typeHandlerClass, (Throwable)e);
            }
        }
        try {
            Constructor<?> c = typeHandlerClass.getConstructor(new Class[0]);
            return (TypeHandler)c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new TypeException("Unable to find a usable constructor for " + typeHandlerClass, (Throwable)e);
        }
    }

    public String getBaseSelect() {
        return this.baseSelect;
    }

    public void setBaseSelect(String baseSelect) {
        this.baseSelect = baseSelect;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public LinkedHashSet<EntityColumn> getEntityClassColumns() {
        return this.entityClassColumns;
    }

    public void setEntityClassColumns(LinkedHashSet<EntityColumn> entityClassColumns) {
        this.entityClassColumns = entityClassColumns;
    }

    public LinkedHashSet<EntityColumn> getEntityClassPKColumns() {
        return this.entityClassPKColumns;
    }

    public void setEntityClassPKColumns(LinkedHashSet<EntityColumn> entityClassPKColumns) {
        this.entityClassPKColumns = entityClassPKColumns;
    }

    public String[] getKeyColumns() {
        if (this.keyColumns != null && this.keyColumns.size() > 0) {
            return this.keyColumns.toArray(new String[0]);
        }
        return new String[0];
    }

    public void setKeyColumns(String keyColumn) {
        if (this.keyColumns == null) {
            this.keyColumns = new ArrayList<String>();
            this.keyColumns.add(keyColumn);
        } else {
            this.keyColumns.add(keyColumn);
        }
    }

    public String[] getKeyProperties() {
        if (this.keyProperties != null && this.keyProperties.size() > 0) {
            return this.keyProperties.toArray(new String[0]);
        }
        return new String[0];
    }

    public void setKeyProperties(String keyProperty) {
        if (this.keyProperties == null) {
            this.keyProperties = new ArrayList<String>();
            this.keyProperties.add(keyProperty);
        } else {
            this.keyProperties.add(keyProperty);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getPrefix() {
        if (StringUtil.isNotEmpty(this.catalog)) {
            return this.catalog;
        }
        if (StringUtil.isNotEmpty(this.schema)) {
            return this.schema;
        }
        return "";
    }

    public Map<String, EntityColumn> getPropertyMap() {
        return this.propertyMap;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setKeyColumns(List<String> keyColumns) {
        this.keyColumns = keyColumns;
    }

    public void setKeyProperties(List<String> keyProperties) {
        this.keyProperties = keyProperties;
    }

    public void setTable(Table table) {
        this.name = table.name();
        this.catalog = table.catalog();
        this.schema = table.schema();
    }
}

