/*
 * Decompiled with CFR 0.152.
 */
package cn.zh54.json.repair;

import cn.zh54.json.repair.JsonContext;
import cn.zh54.json.repair.ObjectComparer;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JsonParser {
    private static final List<String> STRING_DELIMITERS = Arrays.asList("\"", "'");
    private static final Set<Character> NUMBER_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('e'), Character.valueOf('E'), Character.valueOf('/'), Character.valueOf(',')));
    private String jsonStr;
    private int index;
    private final JsonContext context;
    private final boolean logging;
    private final List<Map<String, String>> logger;
    private final boolean streamStable;

    public JsonParser(String jsonStr, Reader jsonFd, Boolean logging, int jsonFdChunkLength, boolean streamStable) {
        this.jsonStr = jsonStr;
        this.index = 0;
        this.context = new JsonContext();
        this.logging = logging != null && logging != false;
        this.logger = this.logging ? new ArrayList() : null;
        this.streamStable = streamStable;
    }

    public Object parse() {
        List<Object> json = this.parseJson();
        if (this.index < this.jsonStr.length()) {
            this.log("The parser returned early, checking if there's more json elements");
            ArrayList<Object> jsonArray = new ArrayList<Object>();
            jsonArray.add(json);
            while (this.index < this.jsonStr.length()) {
                Object j = this.parseJson();
                if ("".equals(j)) continue;
                if (ObjectComparer.isSameObject(jsonArray.get(jsonArray.size() - 1), j)) {
                    jsonArray.remove(jsonArray.size() - 1);
                }
                jsonArray.add(j);
            }
            if (jsonArray.size() == 1) {
                this.log("There were no more elements, returning the element without the array");
                json = jsonArray.get(0);
            } else {
                json = jsonArray;
            }
        }
        return this.logging ? Arrays.asList(json, this.logger) : json;
    }

    private Object parseJson() {
        Character ch;
        while ((ch = this.getCharAt()) != null) {
            if (ch.charValue() == '{') {
                ++this.index;
                return this.parseObject();
            }
            if (ch.charValue() == '[') {
                ++this.index;
                return this.parseArray();
            }
            if (this.context.getCurrent() == JsonContext.ContextValue.OBJECT_VALUE && ch.charValue() == '}') {
                this.log("At the end of an object we found a key with missing value, skipping");
                return "";
            }
            if (!this.context.isEmpty() && (STRING_DELIMITERS.contains(String.valueOf(ch)) || Character.isLetter(ch.charValue()))) {
                return this.parseString();
            }
            if (!this.context.isEmpty() && (Character.isDigit(ch.charValue()) || ch.charValue() == '-' || ch.charValue() == '.')) {
                return this.parseNumber();
            }
            if (ch.charValue() == '#' || ch.charValue() == '/') {
                return this.parseComment();
            }
            ++this.index;
        }
        return "";
    }

    private Map<String, Object> parseObject() {
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        while (this.getCharAt() != null && this.getCharAt().charValue() != '}') {
            this.skipWhitespacesAt();
            if (this.getCharAt() != null && this.getCharAt().charValue() == ':') {
                this.log("While parsing an object we found a : before a key, ignoring");
            }
            this.context.set(JsonContext.ContextValue.OBJECT_KEY);
            int rollbackIndex = ++this.index;
            String key = "";
            while (this.getCharAt() != null) {
                List<Object> newArray;
                String prevKey;
                rollbackIndex = this.index++;
                if (this.getCharAt().charValue() == '[' && key.isEmpty() && !obj.isEmpty() && obj.get(prevKey = (String)new ArrayList(obj.keySet()).get(obj.size() - 1)) instanceof List && (newArray = this.parseArray()) instanceof List) {
                    ((List)obj.get(prevKey)).addAll(newArray);
                    this.skipWhitespacesAt();
                    if (this.getCharAt() != null && this.getCharAt().charValue() == ',') {
                        ++this.index;
                    }
                    this.skipWhitespacesAt();
                    continue;
                }
                key = String.valueOf(this.parseString());
                if (key.isEmpty()) {
                    this.skipWhitespacesAt();
                }
                if (key.isEmpty() && (!key.isEmpty() || this.getCharAt().charValue() != ':' && this.getCharAt().charValue() != '}')) continue;
            }
            if (this.context.getContext().contains((Object)JsonContext.ContextValue.ARRAY) && obj.containsKey(key)) {
                this.log("While parsing an object we found a duplicate key, closing the object here and rolling back the index");
                this.index = rollbackIndex - 1;
                this.jsonStr = this.jsonStr.substring(0, this.index + 1) + "{" + this.jsonStr.substring(this.index + 1);
                break;
            }
            this.skipWhitespacesAt();
            if (this.getCharAt() == null || this.getCharAt().charValue() == '}') continue;
            if (this.getCharAt().charValue() != ':') {
                this.log("While parsing an object we missed a : after a key");
            }
            ++this.index;
            this.context.reset();
            this.context.set(JsonContext.ContextValue.OBJECT_VALUE);
            Object value = this.parseJson();
            this.context.reset();
            obj.put(key, value);
            if (this.getCharAt() != null && (this.getCharAt().charValue() == ',' || this.getCharAt().charValue() == '\'' || this.getCharAt().charValue() == '\"')) {
                ++this.index;
            }
            this.skipWhitespacesAt();
        }
        ++this.index;
        return obj;
    }

    private List<Object> parseArray() {
        ArrayList<Object> arr = new ArrayList<Object>();
        this.context.set(JsonContext.ContextValue.ARRAY);
        Character ch = this.getCharAt();
        while (ch != null && ch.charValue() != ']' && ch.charValue() != '}') {
            this.skipWhitespacesAt();
            Object value = "";
            if (STRING_DELIMITERS.contains(String.valueOf(ch))) {
                int i = 1;
                i = this.skipToCharacter(ch.charValue(), i);
                value = this.getCharAt(i = this.skipWhitespacesAt(i, false)).charValue() == ':' ? this.parseObject() : this.parseString();
            } else {
                value = this.parseJson();
            }
            if ("".equals(value)) {
                ++this.index;
            } else if ("...".equals(value) && this.getCharAt(-1).charValue() == '.') {
                this.log("While parsing an array, found a stray '...'; ignoring it");
            } else {
                arr.add(value);
            }
            ch = this.getCharAt();
            while (ch != null && ch.charValue() != ']' && (Character.isWhitespace(ch.charValue()) || ch.charValue() == ',')) {
                ++this.index;
                ch = this.getCharAt();
            }
        }
        if (ch != null && ch.charValue() != ']') {
            this.log("While parsing an array we missed the closing ], ignoring it");
        }
        ++this.index;
        this.context.reset();
        return arr;
    }

    private Object parseString() {
        boolean missingQuotes = false;
        boolean doubledQuotes = false;
        char lStringDelimiter = '\"';
        char rStringDelimiter = '\"';
        Character ch = this.getCharAt();
        if (ch.charValue() == '#' || ch.charValue() == '/') {
            return this.parseComment();
        }
        while (ch != null && !STRING_DELIMITERS.contains(String.valueOf(ch)) && !Character.isLetterOrDigit(ch.charValue())) {
            ++this.index;
            ch = this.getCharAt();
        }
        if (ch == null) {
            return "";
        }
        if (ch.charValue() == '\'') {
            rStringDelimiter = '\'';
            lStringDelimiter = '\'';
        } else if (ch.charValue() == '\"') {
            rStringDelimiter = '\"';
            lStringDelimiter = '\"';
        } else if (Character.isLetterOrDigit(ch.charValue())) {
            Object value;
            if (!(Character.toLowerCase(ch.charValue()) != 't' && Character.toLowerCase(ch.charValue()) != 'f' && Character.toLowerCase(ch.charValue()) != 'n' || "".equals(value = this.parseBooleanOrNull()))) {
                return value;
            }
            this.log("While parsing a string, we found a literal instead of a quote");
            missingQuotes = true;
        }
        if (!missingQuotes) {
            ++this.index;
        }
        StringBuilder stringAcc = new StringBuilder();
        boolean unmatchedDelimiter = false;
        boolean inValue = this.context.getCurrent() == JsonContext.ContextValue.OBJECT_VALUE;
        int quoteCount = 0;
        boolean hasStartedValue = false;
        while ((ch = this.getCharAt()) != null) {
            char nextCh;
            if (inValue) {
                if (ch.charValue() == '\"') {
                    Character nextCh2;
                    if (++quoteCount == 1) {
                        hasStartedValue = true;
                    } else if (hasStartedValue && quoteCount % 2 == 0 && ((nextCh2 = this.getCharAt(1)) == null || nextCh2.charValue() == ',' || nextCh2.charValue() == '}')) {
                        stringAcc.append(ch);
                        ++this.index;
                        break;
                    }
                }
                if (!hasStartedValue && !Character.isWhitespace(ch.charValue())) {
                    hasStartedValue = true;
                }
                stringAcc.append(ch);
                ++this.index;
                continue;
            }
            if (this.context.getCurrent() == JsonContext.ContextValue.OBJECT_KEY && (ch.charValue() == ':' || Character.isWhitespace(ch.charValue()))) break;
            if (ch.charValue() == '\\' && this.getCharAt() != null && ((nextCh = this.getCharAt().charValue()) == rStringDelimiter || nextCh == 't' || nextCh == 'n' || nextCh == 'r' || nextCh == 'b' || nextCh == '\\')) {
                stringAcc.append(ch).append(nextCh);
                this.index += 2;
                continue;
            }
            if (!missingQuotes && ch.charValue() == rStringDelimiter) {
                stringAcc.append(ch);
                ++this.index;
                break;
            }
            stringAcc.append(ch);
            ++this.index;
        }
        String result = stringAcc.toString();
        if (!this.streamStable && (missingQuotes || result.endsWith("\n"))) {
            result = result.trim();
        }
        return result;
    }

    private Object parseNumber() {
        boolean isArray;
        StringBuilder numberStr = new StringBuilder();
        Character ch = this.getCharAt();
        boolean bl = isArray = this.context.getCurrent() == JsonContext.ContextValue.ARRAY;
        while (ch != null && NUMBER_CHARS.contains(ch) && (!isArray || ch.charValue() != ',')) {
            numberStr.append(ch);
            ++this.index;
            ch = this.getCharAt();
        }
        if (numberStr.length() > 0 && "-eE/,".indexOf(numberStr.charAt(numberStr.length() - 1)) >= 0) {
            numberStr.setLength(numberStr.length() - 1);
            --this.index;
        } else if (this.getCharAt() != null && Character.isLetter(this.getCharAt().charValue())) {
            this.index -= numberStr.length();
            return this.parseString();
        }
        String numStr = numberStr.toString();
        try {
            if (numStr.contains(",")) {
                return numStr;
            }
            if (numStr.contains(".") || numStr.toLowerCase().contains("e")) {
                return Double.parseDouble(numStr);
            }
            return Long.parseLong(numStr);
        }
        catch (NumberFormatException e) {
            return numStr;
        }
    }

    private Object parseBooleanOrNull() {
        int startingIndex = this.index;
        Character ch = this.getCharAt();
        if (ch == null) {
            return "";
        }
        String value = null;
        Boolean result = null;
        char lowerCh = Character.toLowerCase(ch.charValue());
        if (lowerCh == 't') {
            value = "true";
            result = true;
        } else if (lowerCh == 'f') {
            value = "false";
            result = false;
        } else if (lowerCh == 'n') {
            value = "null";
            result = null;
        }
        if (value != null) {
            int i = 0;
            while (ch != null && i < value.length() && Character.toLowerCase(ch.charValue()) == value.charAt(i)) {
                ++i;
                ++this.index;
                ch = this.getCharAt();
            }
            if (i == value.length()) {
                return result;
            }
        }
        this.index = startingIndex;
        return "";
    }

    private String parseComment() {
        Character ch = this.getCharAt();
        ArrayList<Character> terminationCharacters = new ArrayList<Character>(Arrays.asList(Character.valueOf('\n'), Character.valueOf('\r')));
        if (this.context.getContext().contains((Object)JsonContext.ContextValue.ARRAY)) {
            terminationCharacters.add(Character.valueOf(']'));
        }
        if (this.context.getCurrent() == JsonContext.ContextValue.OBJECT_VALUE) {
            terminationCharacters.add(Character.valueOf('}'));
        }
        if (this.context.getCurrent() == JsonContext.ContextValue.OBJECT_KEY) {
            terminationCharacters.add(Character.valueOf(':'));
        }
        if (ch.charValue() == '#') {
            StringBuilder comment = new StringBuilder();
            while (ch != null && !terminationCharacters.contains(ch)) {
                comment.append(ch);
                ++this.index;
                ch = this.getCharAt();
            }
            this.log("Found line comment: " + comment);
            return "";
        }
        if (ch.charValue() == '/') {
            Character nextChar = this.getCharAt(1);
            if (nextChar.charValue() == '/') {
                StringBuilder comment = new StringBuilder("//");
                this.index += 2;
                ch = this.getCharAt();
                while (ch != null && !terminationCharacters.contains(ch)) {
                    comment.append(ch);
                    ++this.index;
                    ch = this.getCharAt();
                }
                this.log("Found line comment: " + comment);
                return "";
            }
            if (nextChar.charValue() == '*') {
                StringBuilder comment = new StringBuilder("/*");
                this.index += 2;
                do {
                    if ((ch = this.getCharAt()) == null) {
                        this.log("Reached end-of-string while parsing block comment; unclosed block comment.");
                        break;
                    }
                    comment.append(ch);
                    ++this.index;
                } while (!comment.toString().endsWith("*/"));
                this.log("Found block comment: " + comment);
                return "";
            }
            ++this.index;
        }
        return "";
    }

    private Character getCharAt() {
        return this.getCharAt(0);
    }

    private Character getCharAt(int count) {
        try {
            return Character.valueOf(this.jsonStr.charAt(this.index + count));
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
    }

    private int skipWhitespacesAt() {
        return this.skipWhitespacesAt(0, true);
    }

    private int skipWhitespacesAt(int idx, boolean moveMainIndex) {
        try {
            char ch = this.jsonStr.charAt(this.index + idx);
            while (Character.isWhitespace(ch)) {
                if (moveMainIndex) {
                    ++this.index;
                } else {
                    ++idx;
                }
                ch = this.jsonStr.charAt(this.index + idx);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            return idx;
        }
        return idx;
    }

    private int skipToCharacter(char character) {
        return this.skipToCharacter(character, 0);
    }

    private int skipToCharacter(char character, int idx) {
        try {
            char ch = this.jsonStr.charAt(this.index + idx);
            while (ch != character) {
                ch = this.jsonStr.charAt(this.index + ++idx);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            return idx;
        }
        return idx;
    }

    private void log(String text) {
        if (!this.logging) {
            return;
        }
        int window = 10;
        int start = Math.max(this.index - window, 0);
        int end = Math.min(this.index + window, this.jsonStr.length());
        String context = this.jsonStr.substring(start, end);
        HashMap<String, String> logEntry = new HashMap<String, String>();
        logEntry.put("text", text);
        logEntry.put("context", context);
        this.logger.add(logEntry);
    }
}

