/*
 * Decompiled with CFR 0.152.
 */
package cn.zh54.json.repair;

import cn.zh54.json.repair.JsonRepair;

public class MainTest {
    public static void main(String[] args) {
        MainTest.testCase("{'key': 'string', 'key2': false, \"key3\": null, \"key4\": unquoted}");
        MainTest.testCase("[1, 2, 3, 4");
        MainTest.testCase("\u6b22\u8fce\u8bbf\u95ee\u6211\u7684\u535a\u5ba254zh.cn,b\u7ad9\u8d26\u53f7:\u733f\u5927\u6656[]");
        MainTest.testCase("{");
        MainTest.testCase("[");
        MainTest.testCase("[]]");
        MainTest.testCase("\"");
        MainTest.testCase("\"\"\"");
        MainTest.testCase("{\"employees\":[\"John\", \"Anna\",");
        MainTest.testCase("{foo: [}");
        MainTest.testCase("{\"text\": \"The quick brown fox won\\'t jump\"}");
        MainTest.testCase("{\"value_1\": \"value_2\":data\"}");
        MainTest.testCase("{\"value_1\": true, COMMENT \"value_2\": \"data\"}");
        MainTest.testCase("- { \"test_key\": [\"test_value\", \"test_value2\"] }");
        MainTest.testCase("{ \"content\": \"[LINK](\"https://google.com\")\" }");
        MainTest.testCase("{ \"content\": \"[LINK](\", \"key\": true }");
        MainTest.testCase("{\"key\":\"\",}");
    }

    private static void testCase(String badJson) {
        System.out.println("------");
        System.out.println("bad_json: " + badJson);
        System.out.println("good_json: " + JsonRepair.repairJson(badJson));
    }
}

