/*
 * Decompiled with CFR 0.152.
 */
package cn.zh54.json.repair;

import cn.zh54.json.repair.JsonRepair;

public class TestCase {
    public void doTest(String[] args) {
        TestCase.testCase("{'key': 'string', 'key2': false, \"key3\": null, \"key4\": unquoted}");
        TestCase.testCase("[1, 2, 3, 4");
        TestCase.testCase("\u6b22\u8fce\u8bbf\u95ee\u6211\u7684\u535a\u5ba254zh.cn,b\u7ad9\u8d26\u53f7:\u733f\u5927\u6656[]");
        TestCase.testCase("{");
        TestCase.testCase("[");
        TestCase.testCase("[]]");
        TestCase.testCase("\"");
        TestCase.testCase("\"\"\"");
        TestCase.testCase("{\"employees\":[\"John\", \"Anna\",");
        TestCase.testCase("{foo: [}");
        TestCase.testCase("{\"text\": \"The quick brown fox won\\'t jump\"}");
        TestCase.testCase("{\"value_1\": \"value_2\":data\"}");
        TestCase.testCase("{\"value_1\": true, COMMENT \"value_2\": \"data\"}");
        TestCase.testCase("- { \"test_key\": [\"test_value\", \"test_value2\"] }");
        TestCase.testCase("{ \"content\": \"[LINK](\"https://google.com\")\" }");
        TestCase.testCase("{ \"content\": \"[LINK](\", \"key\": true }");
        TestCase.testCase("{\"key\":\"\",}");
    }

    private static void testCase(String badJson) {
        System.out.println("------");
        System.out.println("bad_json: " + badJson);
        System.out.println("good_json: " + JsonRepair.repairJson(badJson));
    }
}

