/*
 * Decompiled with CFR 0.152.
 */
package cn.zh54.json.repair;

import cn.zh54.json.repair.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class JsonRepair {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static Object repairJson(String jsonStr, boolean returnObjects, boolean skipJsonLoads, boolean logging, boolean ensureAscii, boolean streamStable) {
        Object parsedJson;
        JsonParser parser = new JsonParser(jsonStr, null, logging, 0, streamStable);
        if (skipJsonLoads) {
            parsedJson = parser.parse();
        } else {
            try {
                parsedJson = objectMapper.readValue(jsonStr, Object.class);
            }
            catch (IOException e) {
                parsedJson = parser.parse();
            }
        }
        if (returnObjects || logging) {
            return parsedJson;
        }
        if ("".equals(parsedJson)) {
            return "";
        }
        try {
            return objectMapper.writeValueAsString(parsedJson);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize JSON", e);
        }
    }

    public static String repairJson(String jsonStr) {
        return (String)JsonRepair.repairJson(jsonStr, false, false, false, true, false);
    }

    public static Object loads(String jsonStr, boolean skipJsonLoads, boolean logging, boolean streamStable) {
        return JsonRepair.repairJson(jsonStr, true, skipJsonLoads, logging, true, streamStable);
    }
}

